;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html
(in-package "CCL")

(eval-when (:load-toplevel :execute)
  (require-modules *sparc-compiler-modules*)
  (require-modules *ppc-xload-modules*)
  (require-modules *sparc-xload-modules*))

; Stuff for bootstrapping the SPARC port (cross-compiling).

; Compiled structure accessors have a nasty way of getting
; referenced as constants.  That's maybe ok some of the
; time (presumably cheaper than compiling them anew), but
; not what we want when cross-compiling (e.g., we don't want
; SPARC functions to reference PPC functions as immediates
; and vice versa.)
; We can't catch all possible cases of this, but we try to
; catch this common case with this vector (which
; SPARC2-XMAKE-FUNCTION uses when it sees a host functional
; constant form *STRUCT-REF-VECTOR*.

(defparameter *sparc-struct-ref-vector*
  (let* ((v (make-array 10)))
    (dotimes (i (length v) v)
      (setf (aref v i)
	    (compile-named-function
	     `(lambda (x) (declare (optimize (safety 3))) (struct-ref x ,i)) nil () () () () () () :sparc)))))

(defun update-sparc-host (host)
  (os-command (format nil
		      "rdist -onochkgroup -f ~~/ccldist ~a"
		      (string-downcase host))))

(defun xcompile (def &optional name)
  (compile-named-function def name () () () () () () :sparc))

(defun xdf (thing)
  (sparc-xdisassemble thing))

(defun sparc-xcompile-compiler (&optional force)
  (update-modules 'sparcenv force)
  (target-compile-modules 'sparcenv :sparc force)
  (update-modules 'nxenv force)
  (target-compile-modules 'nxenv :sparc force)
  (target-compile-modules *compiler-modules* :sparc force)
  (target-compile-modules *sparc-compiler-modules* :sparc force))

(defun sparc-xcompile-ccl (&optional force)
  (sparc-xcompile-compiler force)
  (update-modules *ppc-xload-modules* force)
  (update-modules *sparc-xload-modules* force)
  (target-compile-modules *sparc-xload-modules* :sparc force)
  (target-compile-modules (target-level-1-modules :sparc) :sparc force)
  (target-compile-modules (target-lib-modules :sparc) :sparc force)
  (target-compile-modules *code-modules* :sparc force)
  (target-compile-modules *aux-modules* :sparc force)
  (if (target-xcompile-level-0 :sparc (eq force :force))
    (target-xload-level-0 :sparc)))

