#!/bin/sh

if [ ! -f /usr/share/common-lisp/source/common-lisp-controller/common-lisp-controller.lisp ] ; then
  cat <<EOF
$0: cannot find the Common Lisp Controller source.
This can not happen. Please report the bug
EOF
  exit 0
fi

EXEC=/usr/bin/openmcl

case $1 in
    rebuild)
	    echo $0 Rebuilding...
	    shift
	    while [ ! -z "$1" ] ; do
		echo ...rebuilding $1
		$EXEC --batch --no-init <<EOF
(let ((*compile-print* nil)
      (*compile-verbose*  nil)
      (*load-verbose* nil) 
      (mk::*load-source-if-no-binary* nil)
      (mk::*bother-user-if-no-binary* nil)
      (mk::*compile-during-load* t))
   (handler-case
      (progn
         (c-l-c:compile-library (quote $1))
         (quit 0)
       )
    (error (e)
      (ignore-errors (format t "~&Build Error: ~A~%" e))
      (finish-output)
      (quit 1))))
EOF
		if [ "$?" != "0" ]; then
		    exit 1
		fi
		shift
 	    done 
	    ;;
	    
     install-clc)
	    echo $0 Installing clc...
	    # if there's no clean core, move the current one to the clean one.
	    if [ ! -f /usr/lib/openmcl/PPCCL-clean ];  then
              cp /usr/lib/openmcl/PPCCL /usr/lib/openmcl/PPCCL-clean
            fi
	    $EXEC --image-name /usr/lib/openmcl/PPCCL-clean --batch --no-init <<EOF
(load "/usr/lib/openmcl/install-clc.lisp")
(setq ccl:*save-doc-strings* t)
(setq ccl:*fasl-save-doc-strings* t)
(ccl::save-application "/usr/lib/openmcl/PPCCL" :init-file "/etc/openmclrc.lisp")
EOF
            ;;
     remove-clc)
            echo $0 Removing clc...
	    if [ -f /usr/lib/openmcl/PPCCL-clean ]; then
		mv /usr/lib/openmcl/PPCCL-clean /usr/lib/openmcl/PPCCL
	    else
		echo "Can't find PPCCL-clean, not removing CLC"
	    fi
            ;;
	    
     remove)
	    echo $0 Removing packages...
	    shift
	    while [ ! -z "$1" ] ; do
		rm -rf "/usr/lib/common-lisp/openmcl/$1"
		shift
 	    done
	    ;;
    make-user-image)
	if [ ! -f $2 ] ; then 
	    echo "Trying to make-user image, but can not find file $2" >&2
	    exit 1
	fi 
	$EXEC  --image-name /usr/lib/openmcl/PPCCL --batch --no-init <<EOF
(handler-case
  (progn
     (load "$2") 
     (ccl::save-application "/usr/lib/openmcl/PPCCL.new" :init-file "/etc/openmclrc.lisp")
     (quit 0))
    (error (e)
      (ignore-errors (format t "~&Build Error: ~A~%" e))
      (finish-output)
      (quit 1)))
EOF
	if [ ?$ = 0 ]; then 
  	  mv /usr/lib/openmcl/PPCCL.new /usr/lib/openmcl/PPCCL
	fi
	;;
    *)
	    echo $0 unknown command $1
	    echo known commands: install-clc, remove-clc, rebuild, make-user-image, and remove
	    exit 1
	    ;;
esac

exit 0
