(in-package "CCL")

(require "APPLE-OBJC")
(require "COCOA-WINDOW")



(require "COCOA-LISTENER")

(eval-when (:compile-toplevel :execute)
  (setq *readtable* *objc-readtable*))
  


;;; Maintain a list of all open documents.
(defparameter *open-editor-documents* ())

(def-ccl-pointers default-autorelease-pool ()		  
  (create-autorelease-pool))

;;; The application delegate gets notified of state changes in the
;;; application object.
(def-objc-class "lispapplicationdelegate" "NSObject")

;;; The application's been initialized and is about to enter its
;;; run loop.  Try to load some application-specific key bindings
;;; from the application's bundle and from the user's Library
;;; directory.
;;; This basically works by repeatedly merging a new dictionary
;;; into an old one (where the new dictionary's bindings replace
;;; any conflicting bindings in the old dictionary.)  The order
;;; in which this happens is:
;;; 1) Standard global bindings:
;;;   /System/Library/Frameworks/AppKit.framework/Resources/StandardKeyBindings.dict
;;; 2) User global bindings:
;;;   ~/Library/KeyBindings/DefaultKeyBinding.dict
;;; 3) Standard application bindings:
;;;   $OpenMCL.app/Contents/Resources/OpenMCLKeyBindings.dict
;;; 4) User application bindings:
;;;   ~/Library/KeyBindings/OpenMCLKeyBindings.dict
;;;
;;; This means that OpenMCL's "standard" bindings may override the user's
;;; global bindings.  The user does get the last laugh, but it may be
;;; worth inverting steps 2 and 3.
;;;
;;; The NSKeyBindingManager class doesn't seem to be documented, so I
;;; suppose that this could all break at some point.  Project Builder
;;; seems to use a similar mechanism to establish its application-specific
;;; key bindings, so I don't think that this is likely to break soon.
(define-objc-method ("applicationWillFinishLaunching:"
		     "lispapplicationdelegate")
    (:id notification :void)
  (declare (ignore notification))
  (let* ((standard-dict-path [[(@class "NSBundle") "mainBundle"]
			      "pathForResource:ofType:"
			      :address #@"OpenMCLKeyBindings"
			      :address #@"dict"])
	 (standard-dict [(@class "NSDictionary")
			 "dictionaryWithContentsOfFile:"
			 :address standard-dict-path])
	 (user-dict-path [#@"~/Library/KeyBindings/OpenMCLKeyBindings.dict"
			   "stringByExpandingTildeInPath"])
	 (user-dict [(@class "NSDictionary")
			 "dictionaryWithContentsOfFile:"
			 :address user-dict-path])
	 (manager [(@class "NSKeyBindingManager") "sharedKeyBindingManager"])
	 (installed-dict [manager "dictionary"]))
    (unless (%null-ptr-p standard-dict)
      [installed-dict "addEntriesFromDictionary:" :address standard-dict])
    (unless (%null-ptr-p user-dict)
      [installed-dict "addEntriesFromDictionary:" :address user-dict])
    ;; Not sure if this step is necessary (installed-dict is already
    ;; the shared manager's dictionary), but setDictionary: might
    ;; have some additional side-effects.
    [manager "setDictionary:" :address installed-dict]))

(define-objc-method ("newListener:" "lispapplicationdelegate")
    (:id mumble :void)
  (declare (ignore mumble))
  [[(@class "NSDocumentController") "sharedDocumentController"]
   "openUntitledDocumentOfType:display:"
   :address #@"Listener" :unsigned-byte #$YES])

(define-objc-method ("applicationOpenUntitledFile:" "lispapplicationdelegate")
    (:id app :<BOOL>)
  (if (zerop *cocoa-listener-count*)
    (progn
      [self "newListener:" :address app]
      #$YES)
    #$NO))


(start-cocoa-application)
