;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html


#+allow-in-package
(in-package "CCL")

(eval-when (:compile-toplevel :execute)
  (require "NUMBER-MACROS")
  (require :number-case-macro) 
  


  (defsparclapmacro int-to-single-freg (int imm freg)
    `(progn
      (dec 16 %sp)
      (unbox-fixnum ,int ,imm)
      (st ,imm (%sp 64))
      (ldf (%sp 64) ,freg)
      (inc 16 %sp)
      (fitos ,freg ,freg)
      (fmovs %fp-zero %fp-zero)))

  (defsparclapmacro int-to-double-freg (int imm freg)
    `(progn
      (dec 16 %sp)
      (unbox-fixnum ,int ,imm)
      (st ,imm (%sp 64))
      (ldf (%sp 64) ,freg)
      (inc 16 %sp)
      (fitod ,freg ,freg)
      (fmovs %fp-zero %fp-zero)))

  

)

(defsparclapfunction %double-float-zerop ((n %arg_z))
  (lddf (n arch::double-float.value) %f4)
  (fcmped %fp-zero %f4)
  (fmovs %fp-zero %fp-zero)
  (clr %imm0)
  (fbe.a @1)
    (mov arch::t-offset %imm0)
  @1
  (retl)
    (add %rnil %imm0 %arg_z))

(defsparclapfunction %short-float-zerop ((n %arg_z))
  (ldf (n arch::single-float.value) %f4)
  (fcmpes %fp-zero %f4)
  (fmovs %fp-zero %fp-zero)
  (clr %imm0)
  (fbe.a @1)
    (mov arch::t-offset %imm0)
  @1
  (retl)
    (add %rnil %imm0 %arg_z))

(defsparclapfunction %%double-float-abs ((n %arg_y)(val %arg_z))
  (get-double-float n %f4)
  (fabss %f4 %f6)
  (fmovs %f5 %f7)
  (retl)
    (put-double-float %f6 val))

; Likewise.
(defsparclapfunction %%short-float-abs ((n %arg_y) (val %arg_z))
  (get-single-float n %f4)
  (fabss %f4 %f6)
  (fmovs %fp-zero %fp-zero)
  (retl)
    (put-single-float %f6 val))

(defsparclapfunction %bignum-ref-to-ptr ((b %arg_x) (i %arg_y) (p %arg_z))
  (macptr-ptr p %imm1)
  (add i arch::misc-data-offset %imm0)
  (ld (b %imm0) %imm0)
  (retl)
    (st %imm0 (%imm1)))

(defsparclapfunction %bignum-set-from-ptr ((p %arg_x) (i %arg_y) (b %arg_z))
  (macptr-ptr p %imm1)
  (add i arch::misc-data-offset %imm0)
  (ld (%imm1) %imm1)
  (retl)
    (st %imm1 (b %imm0)))

;; Caller should pass rem-p, quo-p as NIL (not (%null-ptr)) if
;; the remainder (quotient) isn't required.
(defsparclapfunction %udiv64x32 ((quo-p 4)
				 (rem-p 0)
				 (high-p %arg_x)
				 (low-p %arg_y)
				 (divisor-p %arg_z))
  (let ((quo-p-reg %temp0)
	 (rem-p-reg %temp1)
	 (high %imm0)
	 (low %imm1)
	 (divisor %imm2)
	 (quo %imm3)
	 (rem %imm4))
    (macptr-ptr high-p high)
    (ld (high) high)
    (wry %rzero high)
    (macptr-ptr low-p low)
    (ld (low) low)
    (macptr-ptr divisor-p divisor)
    (ld (divisor) divisor)
    (udiv low divisor quo)
    (ld (%vsp quo-p) quo-p-reg)
    (ld (%vsp rem-p) rem-p-reg)
    (inc 8 %vsp)
    (cmp quo-p-reg %rnil)
    (be @noquo)
      (cmp rem-p-reg %rnil)
    (macptr-ptr quo-p-reg quo-p-reg)	;cool: it's word-aligned
    (st quo (quo-p-reg))
    @noquo
    (be @norem)
      (nop)
    (umul quo divisor rem)
    (sub low rem rem)
    (macptr-ptr rem-p-reg rem-p-reg)
    (st rem (rem-p-reg))
    @norem
    (retl)
      (mov %rnil %arg_z)))

; get xidx thing from x, yidx thing from y
; if same return #xffff #xffff
; otherwise get another thing from x and 1- xidx and do as %floor of xthing otherx ything
(defsparclapfunction %floor-99 ((x-stk 0)(xidx %arg_x)(yptr %arg_y)(yidx %arg_z))
  (let ((xptr %temp0)
        (a %imm1)
        (b %imm2)
        (y %imm3)
        (quo %imm0)) 
    (vpop xptr)
    (add xidx arch::misc-data-offset %imm4)
    (ld (xptr %imm4) a)
    (add yidx arch::misc-data-offset %imm4)
    (ld (yptr %imm4) y)
    (cmp a y)
    (set #.(ash #xffff arch::fixnumshift)  %imm4)
    (bne @more)
      (set-nargs 2)
    (vpush %imm4)
    (vpush %imm4)
    (jump-subprim .SPvalues)
      (add %vsp '2 %temp0)

    @MORE
    (wry %rzero a)
    (add xidx (- arch::misc-data-offset 4) %imm4)
    (ld (xptr %imm4) b)
    (nop)				;wait for %Y register
    (udiv b y quo)
    (srl quo 16 %imm4)
    (box-fixnum %imm4 %temp0)
    (sll quo 16 quo)
    (srl quo 16 quo)
    (box-fixnum quo %temp1)
    (vpush %temp0)
    (vpush %temp1)
    (jump-subprim .SPvalues)
      (add %vsp '2 %temp0)))


; for truncate-by-fixnum etal
; doesnt store quotient - just returns rem in 2 halves

(defun %floor-loop-no-quo (q yhi ylo)
  (rlet ((low-p :unsigned-long)
	 (divisor-p :unsigned-long)
	 (r :unsigned-long))
    (setf (%get-word divisor-p 0) yhi
	  (%get-word divisor-p 2) ylo
	  (%get-unsigned-long r 0) 0)
    (let* ((ndigits (uvsize q)))
      (declare (fixnum ndigits))
      (do* ((i (1- ndigits) (1- i)))
	   ((< i 0) (values (%get-unsigned-word r) (%get-unsigned-word r 2)))
	(%bignum-ref-to-ptr q i low-p)
	(%udiv64x32 nil r r low-p divisor-p)))))

(defun %floor-loop-quo (q dest yhi ylo)
  (rlet ((low-p :unsigned-long)
	 (quo-p :unsigned-long)
	 (divisor-p :unsigned-long)
	 (r :unsigned-long))
    (setf (%get-word divisor-p 0) yhi
	  (%get-word divisor-p 2) ylo
	  (%get-unsigned-long r 0) 0)
    (let* ((ndigits (uvsize q)))
      (declare (fixnum ndigits))
      (do* ((i (1- ndigits) (1- i)))
	   ((< i 0)
	    (values (%get-unsigned-word r) (%get-unsigned-word r 2)))
	(%bignum-ref-to-ptr q i low-p)
	(%udiv64x32 quo-p r r low-p divisor-p)
        (%bignum-set-from-ptr quo-p i dest)))))

(defsparclapfunction %int-to-sfloat ((int %arg_y) (sfloat %arg_z))
  (int-to-single-freg int %imm0 %f2)
  (retl)
    (stf %f2 (sfloat arch::single-float.value)))

(defsparclapfunction %int-to-dfloat ((int %arg_y) (dfloat %arg_z))
  (int-to-double-freg int %imm0 %f2)
  (retl)
    (stdf %f2 (dfloat arch::double-float.value)))

(defsparclapfunction %copy-double-float ((f1 %arg_y) (f2 %arg_z))
  (lddf (f1 arch::double-float.value) %f2)
  (retl)
    (stdf %f2 (f2 arch::double-float.value)))
                   
(defsparclapfunction %copy-short-float ((f1 %arg_y) (f2 %arg_z))
  (ldf (f1 arch::single-float.value) %f2)
  (retl)
    (stf %f2 (f2 arch::single-float.value)))


;; make a float from hi - high 24 bits mantissa (ignore implied higher bit)
;;                   lo -  low 28 bits mantissa
;;                   exp  - take low 11 bits
;;                   sign - sign(sign) => result
;; hi result - 1 bit sign: 11 bits exp: 20 hi bits of hi arg
;; lo result - 4 lo bits of hi arg: 28 lo bits of lo arg

;; no error checks, no tweaks, no nuthin 

(defsparclapfunction %make-float-from-fixnums ((float 4)(hi 0) (lo %arg_x) (exp %arg_y) (sign %arg_z))
  (sethi (ash #x80000000 -10) %imm0)
  (and sign %imm0 %imm0)  ; just leave sign bit
  (sethi (ash #x7ff80000 -10) %imm1)
  (sll exp (- 20 arch::fixnumshift) %imm2)
  (and %imm1 %imm2 %imm1)
  (or %imm0 %imm1 %imm0)
  (ld (%vsp hi) %imm1)
  (unbox-fixnum %imm1 %imm1)   ; fold into below? nah keep for later
  (srl %imm1 4 %imm3)
  (set #.(1- (ash 1 20)) %imm2)
  (and %imm3 %imm2 %imm2)
  (or %imm0 %imm2 %imm0)
  (sll %imm1 28 %imm1)  ; hi goes left 28 - keep 4 hi bits
  (unbox-fixnum lo %imm2)
  (sll %imm2 4 %imm2)
  (srl %imm2 4 %imm2)
  (or %imm1 %imm2 %imm1) ; stuff in 28 bits of lo
  (ld (%vsp float) %temp0)      ; the float
  (st %imm0 (%temp0 arch::double-float.value))
  (st %imm1 (%temp0 arch::double-float.val-low))
  (retl)
    (inc '2 %vsp))


(defsparclapfunction %make-short-float-from-fixnums ((float 0) (sig %arg_x) (exp %arg_y) (sign %arg_z))
  (sll sig (- 10 arch::fixnumshift) %imm0)
  (srl %imm0 10 %imm0)
  (sll exp (- 23 arch::fixnumshift) %imm1)
  (or %imm1 %imm0 %imm0)
  (sethi (ash #x80000000 -10) %imm1)
  (andn %imm0 %imm1 %imm0)
  (and sign %imm1 %imm1)
  (or %imm1 %imm0 %imm0)
  (vpop %arg_z)
  (retl)
    (st %imm0 (%arg_z arch::single-float.value)))

; t/nil - could as well be 1/0
(defsparclapfunction %double-float-sign ((n %arg_z))
  (ld (n arch::double-float.value) %imm1)
  (tst %imm1)
  (clr %imm1)
  (bl.a @ret)
    (mov arch::t-offset %imm1)
  @ret
  (retl)
    (add %rnil %imm1 %arg_z))

(defsparclapfunction %short-float-sign ((n %arg_z))
  (ld (n arch::single-float.value) %imm1)
  (tst %imm1)
  (clr %imm1)
  (bl.a @ret)
    (mov arch::t-offset %imm1)
  @ret
  (retl)
    (add %rnil %imm1 %arg_z))

; rets hi (25 bits) lo (28 bits) exp sign
(defsparclapfunction %integer-decode-double-float ((n %arg_z))
  (ld (n arch::double-float.value) %imm0)
  (srl %imm0 31 %imm1)
  (box-fixnum %imm1 %temp0)		; %temp0 = sign, boxed
  (add %temp0 %temp0 %temp0)
  (mov '1 %imm1)
  (sub %imm1 %temp0 %temp0)
  (sll %imm0 1 %imm2)
  (srl %imm2 (1+ 20) %imm2)
  (box-fixnum %imm2 %temp1)		; %temp1 = boxed unbiased exponent
  (tst %temp1)
  (sll %imm0 12 %imm0)			; 20 bits of hi float left 12
  (srl %imm0 6 %imm0)
  (set #.(ash 1 (+ 24 arch::fixnumshift)) %imm1)
  (bne.a @denorm)
    (or %imm0 %imm1 %imm0)		;  add implied 1
  @denorm
  (ld (n arch::double-float.val-low) %imm1)
  (srl %imm1 28 %imm2)
  (box-fixnum %imm2 %imm2)
  (or %imm2 %imm0 %imm0)
  (sll %imm1 4 %imm1)
  (srl %imm1 (- 4 arch::fixnumshift) %imm1)
  (vpush %imm0)   ; hi 25 bits of mantissa (includes implied 1)
  (vpush %imm1)   ; lo 28 bits of mantissa
  (vpush %temp1)  ; exp
  (vpush %temp0)  ; sign
  (set-nargs 4)
  (jump-subprim .SPvalues)
    (add %vsp '4 %temp0))

; hi is 25 bits lo is 28 bits
; big is 32 lo, 21 hi right justified
(defsparclapfunction make-big-53 ((hi %arg_x)(lo %arg_y)(big %arg_z))
  (sll lo 2 %imm0)
  (srl %imm0 4 %imm0)
  (sethi (ash #xf0000000 -10) %imm2)
  (sll hi (- 32 4 arch::fixnumshift) %imm1)
  (and %imm1 %imm2 %imm1)
  (or %imm1 %imm0 %imm0)
  (st %imm0 (big (+ arch::misc-data-offset 0)))
  (srl hi (+ 4 arch::fixnumshift) %imm1)
  (sethi (ash (ash (1- (ash 1 11)) 21) -10) %imm2)
  (andn %imm1 %imm2 %imm1)
  (retl)
    (st %imm1 (big (+ arch::misc-data-offset 4))))


(defsparclapfunction %double-float-exp ((n %arg_z))
  (ld (n arch::double-float.value) %imm1)
  (sll %imm1 1 %imm1)
  (srl %imm1 (+ 20 1) %imm1)
  (retl)
    (box-fixnum %imm1 %arg_z))

(defsparclapfunction set-%double-float-exp ((float %arg_y) (exp %arg_z))
  (sethi (ash (ash (1- (ash 1 11)) 20) -10) %imm0)
  (ld (float arch::double-float.value) %imm2)
  (andn %imm2 %imm0 %imm2)
  (sll exp (- 20 arch::fixnumshift) %imm1)
  (and %imm2 %imm1 %imm1)
  (or %imm1 %imm2 %imm2)
  (retl)
    (st %imm2 (float arch::double-float.value)))


(defsparclapfunction %short-float-exp ((n %arg_z))
  (ld (n arch::single-float.value) %imm1)
  (sll %imm1 1 %imm1)
  (srl %imm1 24 %imm1)
  (retl)
    (box-fixnum %imm1 %arg_z))


(defsparclapfunction set-%short-float-exp ((float %arg_y) (exp %arg_z))
  (sethi (ash (ash 255 23) -10) %imm0)
  (ld (float arch::single-float.value) %imm1)
  (andn %imm1 %imm0 %imm1)
  (sll exp (- 23 arch::fixnumshift) %imm2)
  (and %imm2 %imm0 %imm2)
  (or %imm2 %imm1 %imm1)
  (retl)
    (st %imm1 (float arch::single-float.value)))

(defsparclapfunction %short-float->double-float ((src %arg_y) (result %arg_z))
  (get-single-float src %f4)
  (fstod %f4 %f6)
  (fmovs %fp-zero %fp-zero)
  (retl)
    (put-double-float %f6 result))


(defsparclapfunction %double-float->short-float ((src %arg_y) (result %arg_z))
  (get-double-float src %f4)
  (fdtos %f4 %f6)
  (fmovs %fp-zero %fp-zero)
  (retl)
    (put-single-float %f6 result))

; Don't we already have about 20 versions of this ?
(defsparclapfunction %double-float-from-macptr! ((ptr %arg_x) (byte-offset %arg_y) (dest %arg_z))
  (macptr-ptr ptr %imm0)
  (unbox-fixnum byte-offset %imm1)
  (lddf (%imm0 %imm1) %f4)
  (retl)
    (put-double-float %f4 dest))

(defsparclapfunction %%scale-dfloat ((float %arg_x)(int %arg_y)(result %arg_z))
  (let ((fl.h 64)
        (fl.l 68)
        (sc.h 72)
        (sc.l 76))
    (ld (float arch::double-float.value) %imm0)
    (ld (float arch::double-float.val-low) %imm1)
    (sub %sp 16 %sp)
    (st %imm0 (%sp fl.h))
    (st %imm1 (%sp fl.l))
    (unbox-fixnum int %imm0)
    ;(addi imm0 imm0 1022)  ; bias exponent - we assume no ovf
    (sll %imm0 20 %imm0)     ; more important - get it in right place
    (st %imm0 (%sp sc.h))
    (st %rzero (%sp sc.l))
    (lddf (%sp fl.h) %f4)
    (lddf (%sp sc.h) %f6)
    (add %sp 16 %sp)
    (fmuld %f4 %f6 %f8)
    (fmovs %fp-zero %fp-zero)
    (retl)
      (put-double-float %f8 result)))

(defsparclapfunction %%scale-sfloat ((float %arg_x)(int %arg_y)(result %arg_z))
  (let ((sc.h 65))
    (get-single-float float %f4)
    (unbox-fixnum int %imm0)
    (sll %imm0 IEEE-single-float-mantissa-width %imm0)
    (sub %sp 8 %sp)
    (st %imm0 (%sp sc.h))
    (ldf (%sp sc.h) %f6)
    (fmuls %f4 %f6 %f8)
    (fmovs %fp-zero %fp-zero)
    (retl)
      (put-single-float %f8 result)))

#|


    
(defsparclapfunction dfloat-significand-zeros ((dfloat arg_z))
  (lwz imm1 arch::double-float.value dfloat)
  (rlwinm. imm1 imm1 12 0 19)
  (cntlzw imm1 imm1)
  (beq @golo)
  (box-fixnum arg_z imm1)
  (blr)
  @golo
  (lwz imm1 arch::double-float.val-low dfloat)
  (cntlzw imm1 imm1)
  (addi imm1 imm1 20)
  (box-fixnum arg_z imm1)
  (blr))

(defsparclapfunction sfloat-significand-zeros ((sfloat arg_z))
  (lwz imm1 arch::single-float.value sfloat)
  (rlwinm imm1 imm1 9 0 22)
  (cntlzw imm1 imm1)
  (box-fixnum arg_z imm1)
  (blr))






  

; Manipulating the FPSCR.
; This  returns the bottom 8 bits of the FPSCR
(defsparclapfunction %get-fpscr-control ()
  (mffs fp0)
  (stwu tsp -16 tsp)
  (stw tsp 4 tsp)
  (stfd fp0 8 tsp)
  (lbz imm0 (+ 8 7) tsp)
  (lwz tsp 0 tsp)
  (box-fixnum arg_z imm0)
  (blr))

; Returns the high 24 bits of the FPSCR
(defsparclapfunction %get-fpscr-status ()
  (mffs fp0)
  (stwu tsp -16 tsp)
  (stw tsp 4 tsp)
  (stfd fp0 8 tsp)
  (lwz imm0 12 tsp)
  (lwz tsp 0 tsp)
  (clrrwi imm0 imm0 8)
  (srwi arg_z imm0 (- 8 arch::fixnumshift))
  (blr))

; Set the high 24 bits of the FPSCR; leave the low 8 unchanged
(defsparclapfunction %set-fpscr-status ((new arg_z))
  (slwi imm0 new (- 8 arch::fixnumshift))
  (stwu tsp -16 tsp)
  (stw tsp 4 tsp)
  (stw imm0 12 tsp)
  (lfd fp0 8 tsp)
  (lwz tsp 0 tsp)
  (mtfsf #xfc fp0)                      ; set status fields [0-5]
  (blr))

; Set the low 8 bits of the FPSCR; leave the high 24 unchanged
(defsparclapfunction %set-fpscr-control ((new arg_z))
  (unbox-fixnum imm0 new)
  (stwu tsp -16 tsp)
  (stw tsp 4 tsp)
  (stw imm0 12 tsp)
  (lfd fp0 8 tsp)
  (lwz tsp 0 tsp)
  (mtfsf #x03 fp0)                      ; set control fields [6-7]
  (blr))


; See if the binary double-float operation OP set any enabled
; exception bits in the fpscr
(defun %df-check-exception-2 (operation op0 op1)
   (let* ((fp-status (logior (the fixnum (%get-fpscr-status)) (the fixnum (ash (the fixnum (%get-kernel-global 'ffi-exception)) -8)))))
     (declare (type (unsigned-byte 24) fp-status))
     (when (logbitp (- 23 ppc::fpscr-fex-bit) fp-status)
       (%set-fpscr-status 0)
       ; Ensure that operands are heap-consed
       (%fp-error-from-status fp-status 
                              (%get-fpscr-control)
                              operation 
                              (%copy-double-float op0 (%make-dfloat)) 
                              (%copy-double-float op1 (%make-dfloat))))))

(defun %df-check-exception-1 (operation op0)
   (let* ((fp-status (logior (the fixnum (%get-fpscr-status)) (the fixnum (ash (the fixnum (%get-kernel-global 'ffi-exception)) -8)))))
     (declare (type (unsigned-byte 24) fp-status))
     (when (logbitp (- 23 ppc::fpscr-fex-bit) fp-status)
       (%set-fpscr-status 0)
       ; Ensure that operands are heap-consed
       (%fp-error-from-status fp-status 
                              (%get-fpscr-control)
                              operation 
                              (%copy-double-float op0 (%make-dfloat))))))

(defun fp-condition-from-fpscr (status-bits control-bits)
  (cond 
   ((and (logbitp (- 23 ppc::fpscr-vx-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-ve-bit) control-bits)) 'invalid-operation)
   ((and (logbitp (- 23 ppc::fpscr-ox-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-oe-bit) control-bits)) 'floating-point-overflow)
   ((and (logbitp (- 23 ppc::fpscr-ux-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-ue-bit) control-bits)) 'floating-point-underflow)
   ((and (logbitp (- 23 ppc::fpscr-zx-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-ze-bit) control-bits)) 'division-by-zero)
   ((and (logbitp (- 23 ppc::fpscr-xx-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-xe-bit) control-bits)) 'inexact-result)))

; This assumes that the FEX and one of {VX OX UX ZX XX} is set.
; Ignore 
(defun %fp-error-from-status (status-bits control-bits operation &rest operands)
  (declare (type (unsigned-byte 16) status-bits))
  (let* ((condition-class (fp-condition-from-fpscr status-bits control-bits)))
    (if condition-class
      (error (make-instance condition-class
               :operation operation
               :operands operands)))))

(defun fp-minor-opcode-operation (minor-opcode)
  (case minor-opcode
    (25 '*)
    (18 '/)
    (20 '-)
    (21 '+)
    (t 'unknown)))




(defvar *rounding-mode-alist*
  '((:nearest . 0) (:zero . 1) (:positive . 2) (:negative . 3)))

(defun get-fpu-mode ()
  (let* ((flags (%get-fpscr-control)))
    `(:rounding-mode ,(car (nth (logand flags 3) *rounding-mode-alist*))
                     :overflow ,(logbitp 6 flags)
                     :underflow ,(logbitp 5 flags)
                     :division-by-zero ,(logbitp 4 flags)
                     :invalid ,(logbitp 7 flags)
                     :inexact ,(logbitp 2 flags))))

;; did we document this?
(defun set-fpu-mode (&key (rounding-mode :nearest rounding-p)
                          (overflow t overflow-p)
                          (underflow t underflow-p)
                          (division-by-zero t zero-p)
                          (invalid t invalid-p)
                          (inexact t inexact-p))
  (let* ((mask (logior (if rounding-p #x03 #x00)
                       (if invalid-p #x80 #x00)
                       (if overflow-p #x40 #x00)
                       (if underflow-p #x20 #x00)
                       (if zero-p #x10 #x00)
                       (if inexact-p #x08 #x00)))
         (new (logior (or (cdr (assoc rounding-mode *rounding-mode-alist*))
                          (error "Unknown rounding mode: ~s" rounding-mode))
                      (if invalid #x80 0)
                      (if overflow #x40 0)
                      (if underflow #x20 0)
                      (if division-by-zero #x10 0)
                      (if inexact #x08 0))))
    (declare (type (unsigned-byte 8) new mask))
    (%set-fpscr-control (logior (logand new mask)
                                (logandc2 (%get-fpscr-control) mask)))
    (get-fpu-mode)))
|#

(defun %df-check-exception-2 (operation op0 op1)
  (declare (ignore operation op0 op1)))

(defun %df-check-exception-1 (operation op0)
  (declare (ignore operation op0)))
