;;;-*-Mode: LISP; Package: ccl -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

; l1-ppc-stack-groups.lisp
; low-level support for PPC stack groups and stack-backtrace printing

(in-package :ccl)









(defppclapfunction %get-kernel-global-from-offset ((offset arg_z))
  (check-nargs 1)
  (unbox-fixnum imm0 offset)
  (lwzx arg_z imm0 rnil)
  (blr))

(defppclapfunction %set-kernel-global-from-offset ((offset arg_y) (new-value arg_z))
  (check-nargs 2)
  (unbox-fixnum imm0 offset)
  (stwx new-value imm0 rnil)
  (blr))

(defppclapfunction %get-kernel-global-ptr-from-offset ((offset arg_y)
						       (ptr arg_z))
  (check-nargs 2)
  (unbox-fixnum imm0 offset)
  (lwzx imm0 rnil imm0)
  (stw imm0 arch::macptr.address ptr)
  (blr))




(defppclapfunction %stack-group-trampoline ((arg arg_z))
  (check-nargs 1)
  (mr arg_y nfn)
  (set-nargs 2)
  (lwz temp0 2 nfn)
  (ba .SPfuncall))





(defppclapfunction %fixnum-ref ((fixnum arg_y) #| &optional |# (offset arg_z))
  (cmpi cr0 nargs '1)
  (check-nargs 1 2)
  (bne cr0 @2-args)
  (mr fixnum offset)
  (li offset 0)
  @2-args
  (unbox-fixnum imm0 offset)
  (lwzx arg_z imm0 fixnum)
  (blr))

(defppclapfunction %fixnum-set ((fixnum arg_x) (offset arg_y) #| &optional |# (new-value arg_z))
  (cmpi cr0 nargs '2)
  (check-nargs 2 3)
  (bne cr0 @3-args)
  (mr fixnum offset)
  (li offset 0)
  @3-args
  (unbox-fixnum imm0 offset)
  (stwx new-value imm0 fixnum)
  (mr arg_z new-value)
  (blr))

; Sure would be nice to have &optional in defppclapfunction arglists
(let ((bits (lfun-bits #'(lambda (x &optional y) (declare (ignore x y))))))
  (lfun-bits #'%fixnum-ref
             (dpb (ldb $lfbits-numreq bits)
                  $lfbits-numreq
                  (dpb (ldb $lfbits-numopt bits)
                       $lfbits-numopt
                       (lfun-bits #'%fixnum-ref)))))

(let ((bits (lfun-bits #'(lambda (x y &optional z) (declare (ignore x y z))))))
  (lfun-bits #'%fixnum-set
             (dpb (ldb $lfbits-numreq bits)
                  $lfbits-numreq
                  (dpb (ldb $lfbits-numopt bits)
                       $lfbits-numopt
                       (lfun-bits #'%fixnum-set)))))




; This version is in LAP so that it won't vpush anything
(defppclapfunction %db-link-chain-in-current-sg-area ((area arg_z))
  (check-nargs 1)
  (let ((db imm0)
        (high imm1)
        (low imm2))
    (lwz high arch::area.high area)
    (lwz low arch::area.low area)
    (ref-global db db-link)
    (cmpwi cr0 db 0)
    (b @test)
    @loop
    (cmplw cr1 db low)
    (cmplw cr2 db high)
    (lwz db 0 db)
    (cmpwi cr0 db 0)
    (blt cr1 @test)
    (bge cr2 @test)
    (la arg_z arch::t-offset rnil)
    (blr)
    @test
    (bne cr0 @loop)
    (mr arg_z rnil)
    (blr)))



; The UPP for callback to #'threadEntry below
(defvar threadEntry)

; The callback-transition-vector for the threadEntry UPP
; #_NewThread takes a transition vector, not a UPP
; Initialized by (def-ccl-pointers *initial-stack-group* ...) below.
(defvar *stack-group-startup-function*)

; Here's the function that starts up a stack group.
; It never returns. Instead, we kill the thread.
; Expects *next-stack-group* to contain the stack group being started.
; If you redefine this, remember to reevaluate the define-ppc-pascal-function
; form below.
(defppclapfunction threadEntry ((arg-ptr arg_z))
  (let ((sg arg_y)
        (temp arg_x))
    (set-global rzero catch-top)
    (set-global rzero db-link)
    (set-global rzero xframe)
    (lwz temp '*next-stack-group* nfn)
    (lwz sg arch::symbol.vcell temp)
    (stw rnil arch::symbol.vcell temp)
    (lwz temp '*current-stack-group* nfn)
    (la loc-g arch::symbol.vcell temp)
    (push loc-g memo)
    (stw sg 0 loc-g)
    (svref temp sg.cs-area sg)
    (set-global temp current-cs)
    (svref temp sg.vs-area sg)
    (set-global temp current-vs)
    (lwz vsp arch::area.high temp)
    (svref temp sg.ts-area sg)
    (set-global temp current-ts)
    (lwz tsp arch::area.high temp)
    ; Ensure that the stack pointer is tagged as a fixnum
    ; push a stack frame in the process.
    (mr imm0 sp)
    (rlwinm imm0 imm0 0 0 29)          ; fixnum tag it
    (subi imm0 imm0 16)
    (sub imm0 imm0 sp)
    (stwux sp sp imm0)
    (stw fn ppc::lisp-frame.savefn sp)
    (mflr loc-pc)
    (stw loc-pc ppc::lisp-frame.savelr sp)
    (stw vsp ppc::lisp-frame.savevsp sp)
    (mr fn nfn)
    (li imm0 #xd0)                      ; Overflow, invalid, divide-by-zero enabled.
    (stwu tsp -16 tsp)
    (stw tsp 4 tsp)
    (stw imm0 12 tsp)
    (lfd fp0 8 tsp)
    (lwz tsp 0 tsp)
    (mtfsf #xff fp0)
    (zero-fp-reg fp0)
    ; (%run-stack-group-function sg sp)
    (mr arg_z sp)
    (set-nargs 2)
    (lwz temp0 '%run-stack-group-function fn)
    (bla .SPfuncall)
    (lwz temp0 'error fn)
    (lwz arg_z '"%run-stack-group-function returned!" fn)
    (bla .SPfuncall)))
    
; This does (set 'threadEntry UPP)
(define-callback-function #'threadEntry)


(eval-when (:compile-toplevel :execute)
  (assert (eql ppc::lisp-frame.size 16)))

; This is called just before exiting lisp context to be sure that
; there is enough space on the VSP stack for ppc-ff-call (ffcalladdress) to
; vpush_saveregs.
(defppclapfunction %ensure-vsp-stack-space ()
  (vpush rzero)   ; 1
  (vpush rzero)   ; 2
  (vpush rzero)   ; 3
  (vpush rzero)   ; 4
  (vpush rzero)   ; 5
  (vpush rzero)   ; 6
  (vpush rzero)   ; 7
  (vpush rzero)   ; 8
  (la vsp 32 vsp)
  (blr))


; Reverse special bindings, but don't mess with *interrupt-level*
; A special binding is [link, symbol, value]
(defppclapfunction %reverse-special-bindings ((set-db-link-p arg_z))
  (let ((last-db imm0)
        (db imm1)
        (sym imm2)
        (next-db imm2)
        (value imm3)
        (sym-value imm4)
        (*interrupt-level*-sym temp0)
        (top-catch arg_y))
    (cmp cr1 set-db-link-p rnil)
    (lwz *interrupt-level*-sym '*interrupt-level* nfn)
    (la top-catch (+ 8 arch::fulltag-misc) tsp)
    (bne cr1 @dont-zero)
    (set-global rzero db-link)          ; Prevent interrupt from modifying wrong binding
  @dont-zero
    (svref db arch::catch-frame.db-link-cell top-catch)
    (li last-db 0)
    (b @test)

  @loop
    (lwz sym 4 db)
    (cmp cr0 sym *interrupt-level*-sym)
    (beq @skip)
    (lwz value 8 db)
    (lwz sym-value arch::symbol.vcell sym)
    (svset value arch::symbol.vcell-cell sym)
    (stw sym-value 8 db)
  @skip
    (lwz next-db 0 db)
    (stw last-db 0 db)
    (mr last-db db)
    (mr db next-db)
  @test
    (cmpwi cr0 db 0)
    (bne cr0 @loop)
  
    (svset last-db arch::catch-frame.db-link-cell top-catch t)
    (beq cr1 @return)
    (set-global last-db db-link))
  @return
  (blr))

; Save the global state in a stack group
; %normalize-areas has already done most of the work.
(defppclapfunction %save-stack-group-context ((sg arg_z))
  (let ((address imm0)
        (data imm1))

    ; Update active pointer for vsp area to include the 8 words pushed by .SPffcall
    (ref-global address current-vs)
    (la data (- (* 4 8)) vsp)           ; .SPffcall pushes the 8 saved registers on the VSP
    (stw data arch::area.active address)

    (ref-global data cs-overflow-limit)
    (svset data sg.cs-overflow-limit sg t)
    ; Prevent stack overflow when we reenter this code (may not be necessary)
    (set-global rzero cs-overflow-limit))
  (blr))

; Initialize the global vars from a stack group.
; This is the first thing that happens when a stack group switches in.
; Assumes that a catch frame is on the top of the tsp.
; The vsp has already been restored by .SPffcall
(defppclapfunction %restore-stack-group-context ((sg arg_z))
  (let ((temp imm0))
    (svref temp sg.cs-area sg)
    (set-global temp current-cs)
    (svref temp sg.vs-area sg)
    (set-global temp current-vs)
    (svref temp sg.ts-area sg)
    (set-global temp current-ts)
    (lwz tsp arch::area.active temp)
    (svref temp sg.cs-overflow-limit sg)
    (set-global temp cs-overflow-limit)
    (la temp (+ 8 arch::fulltag-misc) tsp)
    (set-global temp catch-top))
  (blr))





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;




(defppclapfunction %current-frame-ptr ()
  (check-nargs 0)
  (mr arg_z sp)
  (blr))

(defppclapfunction %current-vsp ()
  (check-nargs 0)
  (mr arg_z vsp)
  (blr))

(defppclapfunction %set-current-vsp ((new-vsp arg_z))
  (check-nargs 1)
  (mr vsp new-vsp)
  (blr))

(defppclapfunction %current-tsp ()
  (check-nargs 0)
  (mr arg_z tsp)
  (blr))

(defppclapfunction %set-current-tsp ((new-tsp arg_z))
  (check-nargs 1)
  (mr tsp new-tsp)
  (blr))

; This assumes that bit 0 being set in a back pointer can be ignored.
; I believe the system uses that to denote a mode change from
; PPC to/from 68K.
; It also assumes that if bit 1 is set we're at the bottom of the stack;
; it returns 0 in that case.
(defun %frame-backlink (p &optional (sg *current-stack-group*))
  (cond ((fake-stack-frame-p p)
         (%fake-stack-frame.next-sp p))
        ((fixnump p)
         (let ((backlink (%%frame-backlink p))
               (fake-frame (symbol-value-in-stack-group '*fake-stack-frames* sg)))
           (loop
             (when (null fake-frame) (return backlink))
             (when (eq backlink (%fake-stack-frame.sp fake-frame))
               (return fake-frame))
             (setq fake-frame (%fake-stack-frame.link fake-frame)))))
        (t (error "~s is not a valid stack frame" p))))

(defppclapfunction %%frame-backlink ((p arg_z))
  (check-nargs 1)
  (lwz arg_z ppc::lisp-frame.backlink arg_z)
  (rlwinm imm0 arg_z 30 0 0)            ; Bit 1 -> sign bit
  (srawi imm0 imm0 31)                  ; copy sign bit to rest of word
  (andc arg_z arg_z imm0)               ; arg_z = 0 if bit 1 was set
  (rlwinm arg_z arg_z 0 0 29)           ; clear low two bits
  (blr))



(defppclapfunction %%frame-savefn ((p arg_z))
  (check-nargs 1)
  (lwz arg_z ppc::lisp-frame.savefn arg_z)
  (blr))

(defppclapfunction %frame-savelr ((p arg_z))
  (check-nargs 1)
  (lwz arg_z ppc::lisp-frame.savelr arg_z)
  (blr))



(defppclapfunction %%frame-savevsp ((p arg_z))
  (check-nargs 1)
  (lwz imm0 ppc::lisp-frame.savevsp arg_z)
  (rlwinm imm0 imm0 0 0 30)             ; clear lsb
  (mr arg_z imm0)
  (blr))



(eval-when (:compile-toplevel :execute)
  (assert (eql arch::t-offset #x11)))

(defppclapfunction %uvector-data-fixnum ((uv arg_z))
  (check-nargs 1)
  (trap-unless-fulltag= arg_z arch::fulltag-misc)
  (la arg_z arch::misc-data-offset arg_z)
  (blr))



(defun lisp-frame-p (p stack-group)
  (or (fake-stack-frame-p p)
      (locally (declare (fixnum p))
        (let ((next-frame (%frame-backlink p stack-group)))
          (when (fake-stack-frame-p next-frame)
            (setq next-frame (%fake-stack-frame.sp next-frame)))
          (locally (declare (fixnum next-frame))
            (if (bottom-of-stack-p next-frame stack-group)
              (values nil t)
              (and
               (eql (ash ppc::lisp-frame.size (- arch::fixnum-shift))
                    (the fixnum (- next-frame p)))
               ;; EABI C functions keep their saved LRs where we save FN or 0
               ;; The saved LR of such a function would be fixnum-tagged and never 0.
               (let* ((fn (%fixnum-ref p ppc::lisp-frame.savefn)))
                 (or (eql fn 0) (typep fn 'function))))))))))

(defppclapfunction %catch-top ((stack-group arg_z))
  (check-nargs 1)
  (lwz temp0 '*current-stack-group* nfn)
  (lwz temp0 arch::symbol.vcell temp0)
  (cmp cr0 stack-group temp0)
  (bne cr0 @not-current)

  ; stack-group = *current-stack-group*
  (ref-global arg_z catch-top)
  (cmpwi cr0 arg_z 0)
  (bne @ret)
  (mr arg_z rnil)
 @ret
  (blr)

@not-current
  (svref imm0 sg.ts-area stack-group)
  (lwz imm0 arch::area.active imm0)
  (la arg_z (+ 8 arch::fulltag-misc) imm0)
  (blr))









; Same as %address-of, but doesn't cons any bignums
; It also left shift fixnums just like everything else.
(defppclapfunction %fixnum-address-of ((x arg_z))
  (check-nargs 1)
  (box-fixnum arg_z x)
  (blr))

(defppclapfunction %get-freeptr ()
  (check-nargs 0)
  (mr arg_z freeptr)
  (blr))

  





