;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html


(defconstant $numsparcsaveregs 6)
(defconstant $numsparcargregs 3)


(defconstant sparc-nonvolatile-registers-mask
  (logior (ash 1 sparc::%save0)
          (ash 1 sparc::%save1)
          (ash 1 sparc::%save2)
          (ash 1 sparc::%save3)
          (ash 1 sparc::%save4)
          (ash 1 sparc::%save5)))

(defconstant sparc-arg-registers-mask
  (logior (ash 1 sparc::%arg_z)
          (ash 1 sparc::%arg_y)
          (ash 1 sparc::%arg_x)))

(defconstant sparc-temp-registers-mask
  (logior (ash 1 sparc::%temp0)
          (ash 1 sparc::%temp1)
          (ash 1 sparc::%temp2)
          (ash 1 sparc::%temp3)))


(defconstant sparc-tagged-registers-mask
  (logior sparc-temp-registers-mask
          sparc-arg-registers-mask
          sparc-nonvolatile-registers-mask))

(defmacro make-mask (&rest weights)
  `(logior ,@(mapcar #'(lambda (w) `(ash 1 ,w)) weights)))

(defconstant sparc-temp-node-regs 
  (make-mask sparc::%temp0
             sparc::%temp1
             sparc::%temp2
             sparc::%temp3
             sparc::%arg_x
             sparc::%arg_y
             sparc::%arg_z))

(defconstant sparc-nonvolatile-node-regs
  (make-mask sparc::%save0
             sparc::%save1
             sparc::%save2
             sparc::%save3
             sparc::%save4
             sparc::%save5))


(defconstant sparc-node-regs (logior sparc-temp-node-regs sparc-nonvolatile-node-regs))

(defconstant sparc-imm-regs (make-mask
			     sparc::%imm0
			     sparc::%imm1
			     sparc::%imm2
			     sparc::%imm3
			     sparc::%imm4))

(defconstant sparc-temp-fp-regs (do* ((mask 0 (logior mask (ash 1 bit)))
				      (bit sparc::%f2 (+ bit 2)))
				     ((= bit 32) mask)))
                               




(defconstant $undo-sparc-c-frame 16)
(ccl::provide "SPARCENV")
