/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/

	include(lisp.s)

/* Frame needs room for backlink, lr, 18 GPRs, FPSCR, 18 FPRs, 12 VRs, the
	VSCR, and VRSAVE, and must be aligned on a 16-byte boundary */

define([QT_BACKLINK],[0])
ifdef([EABI],[
  define([QT_SAVElr],[4])
  define([QT_first_nvr],[r14])
  define([QT_SAVEr14],[8])
  define([QT_SAVEnvrs],[QT_SAVEr14])
])

ifdef([POWEROPENABI],[
  define([QT_SAVElr],[8])
  define([QT_first_nvr],[r13])
  define([QT_SAVEr13],[(68)])
  define([QT_SAVEnvrs],[(QT_SAVEr13)])
  define([QT_SAVEr14],[(QT_SAVEr13+4)])
])

define([QT_SAVEfpscr],[(QT_SAVEr14+((32-14)*4))])
define([QT_SAVEf14],[QT_SAVEfpscr+8])
define([QT_SAVEpad],[QT_SAVEf14+((32-14)*8)])
define([QT_SAVEv20],[QT_SAVEpad+8])
define([QT_SAVEvtemp],[QT_SAVEv20+((32-20)*16)])
define([QT_SAVEvrsave],[QT_SAVEvtemp+8])
define([QT_FRAMESIZE],[QT_SAVEvtemp+16])

ifelse(eval(QT_SAVEv20 & 0xf),eval(0),[],[
	errprint([Fix QT frame alignment.])
	m4exit(1)])
	
ifelse(eval(QT_FRAMESIZE  & 0xf),eval(0),[],[
	errprint([Fix QT frame size alignment.])
	m4exit(1)])
	 	
/*
	In general, a frame looks like:
+---------+
| backptr |	back link to previous frame
+---------+
| save lr |	slot for CALLEE to save lr in
+---------+
| save r14|	user function param 'pu'
+---------+
| save r15|	user function param 'pt'
+---------+
| save r16|	user function 'userf'
+---------+
| save r17|	'only'
+---------+
    ...
+---------+
| save r31|
+---------+
| fpscr   |	64 bits
|	  |
+---------+
| save f14|
|	  |
+---------+
   ...
+---------+
| save f31|
|	  |
+---------+
|  pad    |      64 bits
|         |
+---------+
| save v20|	128 bits
|         |
+---------+
   ...
+---------+
| save v31|
|         |
+---------+
| vrtemp  |  xxxx, xxxx, vrsave, vscr
|         |
+---------+
		When 'qt_start' runs, there should be a backlink
		and save_lr slot underneath the top frame.
*/

	_beginfile
	.globl C(altivec_present)
_exportfn(C(qt_block))
	__(andi. r0,sp,8)
	__(mflr r0)
	__(stw r0,(QT_SAVElr)(sp))
	__(bne 1f)
	__(stwu sp,-(QT_FRAMESIZE)(sp))
	__(b 2f)
1:
	__(stwu sp,-(QT_FRAMESIZE+8)(sp))
2:	
	__(stmw QT_first_nvr,(QT_SAVEnvrs)(sp))
	__(lis r15,HA(C(altivec_present)))
	__(lwz r15,LO(C(altivec_present))(r15))
	__(cmpwi r15,0)
	__(mffs f0)
	__(stfd f0,(QT_SAVEfpscr)(sp))
	__(stfd f14,QT_SAVEf14+(8*0)(sp))
	__(stfd f15,QT_SAVEf14+(8*1)(sp))
	__(stfd f16,QT_SAVEf14+(8*2)(sp))
	__(stfd f17,QT_SAVEf14+(8*3)(sp))
	__(stfd f18,QT_SAVEf14+(8*4)(sp))
	__(stfd f19,QT_SAVEf14+(8*5)(sp))
	__(stfd f20,QT_SAVEf14+(8*6)(sp))
	__(stfd f21,QT_SAVEf14+(8*7)(sp))
	__(stfd f22,QT_SAVEf14+(8*8)(sp))
	__(stfd f23,QT_SAVEf14+(8*9)(sp))
	__(stfd f24,QT_SAVEf14+(8*10)(sp))
	__(stfd f25,QT_SAVEf14+(8*11)(sp))
	__(stfd f26,QT_SAVEf14+(8*12)(sp))
	__(stfd f27,QT_SAVEf14+(8*13)(sp))
	__(stfd f28,QT_SAVEf14+(8*14)(sp))
	__(stfd f29,QT_SAVEf14+(8*15)(sp))
	__(stfd f30,QT_SAVEf14+(8*16)(sp))
	__(stfd f31,QT_SAVEf14+(8*17)(sp))
	__(beq 3f			/* branch if no Altivec */)
	__(li r14,QT_SAVEv20)
	__(STVX(20,r14,sp))
	__(li r14,QT_SAVEv20+(16*1))
	__(STVX(21,r14,sp))
	__(li r14,QT_SAVEv20+(16*2))
	__(STVX(22,r14,sp))
	__(li r14,QT_SAVEv20+(16*3))
	__(STVX(23,r14,sp))
	__(li r14,QT_SAVEv20+(16*4))
	__(STVX(24,r14,sp))
	__(li r14,QT_SAVEv20+(16*5))
	__(STVX(25,r14,sp))
	__(li r14,QT_SAVEv20+(16*6))
	__(STVX(26,r14,sp))
	__(li r14,QT_SAVEv20+(16*7))
	__(STVX(27,r14,sp))
	__(li r14,QT_SAVEv20+(16*8))
	__(STVX(28,r14,sp))
	__(li r14,QT_SAVEv20+(16*9))
	__(STVX(29,r14,sp))
	__(li r14,QT_SAVEv20+(16*10))
	__(STVX(30,r14,sp))
	__(li r14,QT_SAVEv20+(16*11))
	__(STVX(31,r14,sp))
	__(MFVSCR(31))
	__(li r14,QT_SAVEvtemp)
	__(STVX(31,r14,sp))
	__(mfspr r14,256)		/* VRSAVE */
	__(stw r14,(QT_SAVEvrsave)(sp))
3:
	__(mtctr r3)
	__(mr r3,sp)
	__(mr sp,r6)
	__(bctrl)
	__(lis r15,HA(C(altivec_present)))
	__(lwz r15,LO(C(altivec_present))(r15))
	__(cmpwi r15,0)
	__(lfd f0,(QT_SAVEfpscr)(sp))
	__(mtfsf 0xff,f0)
	__(lfd f14,QT_SAVEf14+(8*0)(sp))
	__(lfd f15,QT_SAVEf14+(8*1)(sp))
	__(lfd f16,QT_SAVEf14+(8*2)(sp))
	__(lfd f17,QT_SAVEf14+(8*3)(sp))
	__(lfd f18,QT_SAVEf14+(8*4)(sp))
	__(lfd f19,QT_SAVEf14+(8*5)(sp))
	__(lfd f20,QT_SAVEf14+(8*6)(sp))
	__(lfd f21,QT_SAVEf14+(8*7)(sp))
	__(lfd f22,QT_SAVEf14+(8*8)(sp))
	__(lfd f23,QT_SAVEf14+(8*9)(sp))
	__(lfd f24,QT_SAVEf14+(8*10)(sp))
	__(lfd f25,QT_SAVEf14+(8*11)(sp))
	__(lfd f26,QT_SAVEf14+(8*12)(sp))
	__(lfd f27,QT_SAVEf14+(8*13)(sp))
	__(lfd f28,QT_SAVEf14+(8*14)(sp))
	__(lfd f29,QT_SAVEf14+(8*15)(sp))
	__(lfd f30,QT_SAVEf14+(8*16)(sp))
	__(lfd f31,QT_SAVEf14+(8*17)(sp))
	__(beq 4f)
	__(li r14,QT_SAVEv20+(16*0))
	__(LVX(20,r14,sp))
	__(li r14,QT_SAVEv20+(16*1))
	__(LVX(21,r14,sp))
	__(li r14,QT_SAVEv20+(16*2))
	__(LVX(22,r14,sp))
	__(li r14,QT_SAVEv20+(16*3))
	__(LVX(23,r14,sp))
	__(li r14,QT_SAVEv20+(16*4))
	__(LVX(24,r14,sp))
	__(li r14,QT_SAVEv20+(16*5))
	__(LVX(25,r14,sp))
	__(li r14,QT_SAVEv20+(16*6))
	__(LVX(26,r14,sp))
	__(li r14,QT_SAVEv20+(16*7))
	__(LVX(27,r14,sp))
	__(li r14,QT_SAVEv20+(16*8))
	__(LVX(28,r14,sp))
	__(li r14,QT_SAVEv20+(16*9))
	__(LVX(29,r14,sp))
	__(li r14,QT_SAVEv20+(16*10))
	__(LVX(30,r14,sp))
	__(li r14,QT_SAVEv20+(16*11))
	__(LVX(31,r14,sp))
	__(li r14,QT_SAVEvtemp)
	__(LVX(0,r14,sp))
	__(MTVSCR(0))
	__(lwz r14,(QT_SAVEvrsave)(sp))
	__(mtspr 256,r14)
4:	
	__(lmw QT_first_nvr,(QT_SAVEnvrs)(sp))
	__(lwz sp,(QT_BACKLINK)(sp))
	__(lwz r0,(QT_SAVElr)(sp))
	__(mtlr r0)
	__(blr)
_endfn

_exportfn(C(qt_start))
	.globl C(qt_error)
	__(mtctr r17)		/* Ready to call 'only' */
	__(mr r3,r14)		/* Load up user function pu. */
	__(mr r4,r15)		/* ... user function pt */
	__(mr r5,r16)		/* ... user function userf */
	__(bctrl)		/* Call only(pu,pt,userf) */
	__(b C(qt_error))	/* should never get here */
_endfn
	_endfile
