/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/



/* Subprims for various flavors of function call, tail-recursion, etc. */


	include(lisp.s)
	_beginfile
	.globl funcall
	.globl jmpsym


/* Note: all the tXXXslide functions MUST use a variable other than VSP while pushing to the slid location. */
/* This causes do_vsp_overflow in "lisp-exceptions.c" to allocate a new segment for the overflow, ensuring */
/* that it won't overwrite the stuff being slid. */
/* (They have to do so anyway, so that the VSP protects everything during the slide, but someone may */
/* need to remember the do_vsp_overflow assumption sometime). */

/* Tail-recursively call the (known symbol) in fname. */
	/* In the general case, we don't know if any args were */
	/* vpushed or not.  If so, we have to "slide" them down */
	/* to the base of the frame.  If not, we can just restore */
	/* vsp, lr, fn from the saved lisp frame on the control stack. */
_spentry(tcallsymgen)
	__(cmpwi cr0,nargs,nargregs<<fixnumshift)
	__(ble cr0,._tcallsymvsp)
	/* b tcallsymslide */

	/* Some args were vpushed.  Slide them down to the base of */
	/* the current frame, then do funcall. */
_spentry(tcallsymslide)
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz imm0,lisp_frame.savevsp(sp))
	__(discard_lisp_frame())
	__(mtlr loc_pc)
	/* can use nfn (= temp2) as a temporary */
	__(subi imm1,nargs,nargregs<<fixnumshift)
	__(add imm1,imm1,vsp)
1:
	__(lwzu temp2,-4(imm1))
	__(cmpw cr0,imm1,vsp)
	__(push(temp2,imm0))
	__(bne cr0,1b)
	__(mr vsp,imm0)
	__(b jmpsym)

	/* No args were vpushed; recover saved context & call symbol */
_spentry(tcallsymvsp)
._tcallsymvsp:
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(discard_lisp_frame())
	__(mtlr loc_pc)
	/* b jmpsym */

_spentry(jmpsym)
	__(jump_fname())

/* Tail-recursively call the function in nfn. */
	/* Pretty much the same as the tcallsym* cases above. */
_spentry(tcallnfngen)
	__(cmpwi cr0,nargs,nargregs<<fixnumshift)
	__(ble cr0,.tcallnfnvsp)
	/* b tcallnfnslide */

	/* Some args were vpushed.  Slide them down to the base of */
	/* the current frame, then do funcall. */
_spentry(tcallnfnslide)
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz imm0,lisp_frame.savevsp(sp))
	__(discard_lisp_frame())
	__(mtlr loc_pc)
	/* Since we have a known function, can use fname as a temporary. */
	__(subi imm1,nargs,nargregs<<fixnumshift)
	__(add imm1,imm1,vsp)
1:
	__(lwzu fname,-4(imm1))
	__(cmpw cr0,imm1,vsp)
	__(push(fname,imm0))
	__(bne cr0,1b)
	__(mr vsp,imm0)
	__(b jmpnfn)

_spentry(tcallnfnvsp)
.tcallnfnvsp:
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(discard_lisp_frame())
	__(mtlr loc_pc)
	/* b jmpnfn */

_spentry(jmpnfn)
	__(jump_nfn())


/* Tail-recursively funcall temp0. */
	/* Pretty much the same as the tcallsym* cases above. */
_spentry(tfuncallgen)
	__(cmpwi cr0,nargs,nargregs<<fixnumshift)
	__(ble cr0,.tfuncallvsp)
	/* b tfuncallslide */

	/* Some args were vpushed.  Slide them down to the base of */
	/* the current frame, then do funcall. */
_spentry(tfuncallslide)
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz imm0,lisp_frame.savevsp(sp))
	__(discard_lisp_frame())
	__(mtlr loc_pc)
	/* can use nfn (= temp2) as a temporary */
	__(subi imm1,nargs,nargregs<<fixnumshift)
	__(add imm1,imm1,vsp)
1:
	__(lwzu temp2,-4(imm1))
	__(cmpw cr0,imm1,vsp)
	__(push(temp2,imm0))
	__(bne cr0,1b)
	__(mr vsp,imm0)
	__(b funcall)

	/* No args were vpushed; recover saved context & do funcall */
_spentry(tfuncallvsp)
.tfuncallvsp:
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(mtlr loc_pc)
	__(discard_lisp_frame())
	/* b funcall */

	/* Call temp0 if it's either a symbol or function */
_spentry(funcall)
	__(extract_lisptag(imm0,temp0))
	__(cmpwi imm0,tag_misc)
	__(mr fname,temp0)
	__(bne- 2f)
	__(extract_subtag(imm0,temp0))
	__(cmpwi imm0,subtag_symbol)
	__(cmpwi cr1,imm0,subtag_function)
	__(bne- cr0,1f)
	__(jump_fname())
1:
	__(mr nfn,temp0)
	__(bne- cr1,2f)
	__(jump_nfn())
2:
	__(uuo_interr(error_cant_call,temp0))

_spentry(reset)
	.globl _SPthrow
	__(nop)
/* rnil MUST be lisp_nil here.  When debugging, you */
/* should check that the low nibble of rnil (aka rtoc, */
/* aka r2) = #x5 or #xd.  You may be able to find */
/* the "real" value of lisp_nil from the pmcl-kernel */
/* debugger info file (pmcl-kernel.xcoff/pmcl-kernel.xsym); */
/* use some command named "show globals" or somesuch. */
	__(ref_nrs_value(temp0,toplcatch))
	__(li temp1,XSTKOVER)
	__(vpush(temp0))
	__(vpush(temp1))
	__(set_nargs(1))
	__(b _SPthrow)

/* the value of the nilreg-relative symbol %builtin-functions% should be */
/* a vector of symbols.  Funcall the symbol indexed by imm0 (boxed) and */
/* return a single value. */

_spentry(callbuiltin0)
	__(set_nargs(0))
	__(b callbuiltin)

_spentry(callbuiltin1)
	__(set_nargs(1))
	__(b callbuiltin)

_spentry(callbuiltin2)
	__(set_nargs(2))
	__(b callbuiltin)

_spentry(callbuiltin3)
	__(set_nargs(3))
_spentry(callbuiltin)
	__(ref_nrs_value(fname,builtin_functions))
	__(la imm0,misc_data_offset(imm0))
	__(lwzx fname,fname,imm0)
	__(jump_fname())

_spentry(popj)
	.globl .popj
.popj:
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(mtlr loc_pc)
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(discard_lisp_frame())
	__(blr)

_spentry(restorefullcontext)
	__(mflr loc_pc)
	__(mtctr loc_pc)
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(mtlr loc_pc)
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(discard_lisp_frame())
	__(bctr)

/* Like .SPrestorefullcontext, only the saved return address */
/* winds up in loc-pc instead of getting thrashed around ... */
_spentry(restorecontext)
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(discard_lisp_frame())
	__(blr)

_spentry(savecontextvsp)
	__(li imm0,0)
	/* b savecontext0 */

_spentry(savecontext0)
	__(create_lisp_frame())
	__(add imm0,vsp,imm0)
	__(stw fn,lisp_frame.savefn(sp))
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(stw imm0,lisp_frame.savevsp(sp))
	__(mr fn,nfn)
	__(ref_global(imm0,cs_overflow_limit))
	__(twllt sp,imm0)
	__(blr)

/* Nargs is valid; all arg regs, lexpr-count pushed by caller. */
/* imm0 = vsp to restore. */
/* Return all values returned by caller to its caller, hiding */
/* the variable-length arglist. */
/* If we can detect that the caller's caller didn't expect */
/* multiple values, then things are even simpler. */
_spentry(lexpr_entry)
	__(ref_global(imm1,ret1val_addr))
	__(cmpw cr0,imm1,loc_pc)
	__(create_lisp_frame())
	__(stw fn,lisp_frame.savefn(sp))
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(stw imm0,lisp_frame.savevsp(sp))
	__(bne cr0,1f)
	__(ref_global(imm0,lexpr_return))
	__(create_lisp_frame())
	__(stw rzero,lisp_frame.savefn(sp))
	__(stw imm0,lisp_frame.savelr(sp))
	__(stw vsp,lisp_frame.savevsp(sp))
	__(mr loc_pc,imm1)
	__(ref_global(imm0,cs_overflow_limit))
	__(twllt sp,imm0)
	__(li fn,0)
	__(blr)

/* The single-value case just needs to return to something that'll pop */
/* the variable-length frame off of the vstack. */
1:
	__(ref_global(loc_pc,lexpr_return1v))
	__(ref_global(imm0,cs_overflow_limit))
	__(twllt sp,imm0)
	__(li fn,0)
	__(blr)
	_endfile

