************************************************************************
* This file is part of OpenMolcas.                                     *
*                                                                      *
* OpenMolcas is free software; you can redistribute it and/or modify   *
* it under the terms of the GNU Lesser General Public License, v. 2.1. *
* OpenMolcas is distributed in the hope that it will be useful, but it *
* is provided "as is" and without any express or implied warranties.   *
* For more details see the full text of the license in the file        *
* LICENSE or in <http://www.gnu.org/licenses/>.                        *
************************************************************************

************************************************************************
* This file from SLATEC:                                               *
*   http://www.netlib.org/slatec                                       *
*                                                                      *
* To the best of our knowledge, the routines in SLATEC are public      *
* domain or freely distributable and modifiable.                       *
************************************************************************

c  ******************************
c  ** Random number generation **
c  ******************************
      REAL*8 function rand_cvb(r)
      implicit REAL*8 (a-h,o-z)
c***BEGIN PROLOGUE  RAND
c***DATE WRITTEN   770401   (YYMMDD)
c***REVISION DATE  820801   (YYMMDD)
c***CATEGORY NO.  L6A21
c***KEYWORDS  RANDOM NUMBER,SPECIAL FUNCTION,UNIFORM
c***AUTHOR  FULLERTON, W., (LANL)
c***PURPOSE  Generates a uniformly distributed random number.
c***DESCRIPTION
c
c      This pseudo-random number generator is portable among a wide
c variety of computers.  RAND(R) undoubtedly is not as good as many
c readily available installation dependent versions, and so this
c routine is not recommended for widespread usage.  Its redeeming
c feature is that the exact same random numbers (to within final round-
c off error) can be generated from machine to machine.  Thus, programs
c that make use of random numbers can be easily transported to and
c checked in a new environment.
c      The random numbers are generated by the linear congruential
c method described, e.g., by Knuth in Seminumerical Methods (p.9),
c Addison-Wesley, 1969.  Given the I-th number of a pseudo-random
c sequence, the I+1 -st number is generated from
c             X(I+1) = (A*X(I) + C) MOD M,
c where here M = 2**22 = 4194304, C = 1731 and several suitable values
c of the multiplier A are discussed below.  Both the multiplier A and
c random number X are represented in REAL*8 as two 11-bit
c words.  The constants are chosen so that the period is the maximum
c possible, 4194304.
c      In order that the same numbers be generated from machine to
c machine, it is necessary that 23-bit integers be reducible modulo
c 2**11 exactly, that 23-bit integers be added exactly, and that 11-bit
c integers be multiplied exactly.  Furthermore, if the restart option
c is used (where R is between 0 and 1), then the product R*2**22 =
c R*4194304 must be correct to the nearest integer.
c      The first four random numbers should be .0004127026,
c .6750836372, .1614754200, and .9086198807.  The tenth random number
c is .5527787209, and the hundredth is .3600893021 .  The thousandth
c number should be .2176990509 .
c      In order to generate several effectively independent sequences
c with the same generator, it is necessary to know the random number
c for several widely spaced calls.  The I-th random number times 2**22,
c where I=K*P/8 and P is the period of the sequence (P = 2**22), is
c still of the form L*P/8.  In particular we find the I-th random
c number multiplied by 2**22 is given by
c I   =  0  1*P/8  2*P/8  3*P/8  4*P/8  5*P/8  6*P/8  7*P/8  8*P/8
c RAND=  0  5*P/8  2*P/8  7*P/8  4*P/8  1*P/8  6*P/8  3*P/8  0
c Thus the 4*P/8 = 2097152 random number is 2097152/2**22.
c      Several multipliers have been subjected to the spectral test
c (see Knuth, p. 82).  Four suitable multipliers roughly in order of
c goodness according to the spectral test are
c    3146757 = 1536*2048 + 1029 = 2**21 + 2**20 + 2**10 + 5
c    2098181 = 1024*2048 + 1029 = 2**21 + 2**10 + 5
c    3146245 = 1536*2048 +  517 = 2**21 + 2**20 + 2**9 + 5
c    2776669 = 1355*2048 + 1629 = 5**9 + 7**7 + 1
c
c      In the table below LOG10(NU(I)) gives roughly the number of
c random decimal digits in the random numbers considered I at a time.
c C is the primary measure of goodness.  In both cases bigger is better.
c
c                   LOG10 NU(I)              C(I)
c       A       I=2  I=3  I=4  I=5    I=2  I=3  I=4  I=5
c
c    3146757    3.3  2.0  1.6  1.3    3.1  1.3  4.6  2.6
c    2098181    3.3  2.0  1.6  1.2    3.2  1.3  4.6  1.7
c    3146245    3.3  2.2  1.5  1.1    3.2  4.2  1.1  0.4
c    2776669    3.3  2.1  1.6  1.3    2.5  2.0  1.9  2.6
c   Best
c    Possible   3.3  2.3  1.7  1.4    3.6  5.9  9.7  14.9
c
c             Input Argument --
c R      If R=0., the next random number of the sequence is generated.
c        If R .LT. 0., the last generated number will be returned for
c          possible use in a restart procedure.
c        If R .GT. 0., the sequence of random numbers will start with
c          the seed R mod 1.  This seed is also returned as the value of
c          RAND provided the arithmetic is done exactly.
c
c             Output Value --
c RAND   a pseudo-random number between 0. and 1.
c***REFERENCES  (NONE)
c***ROUTINES CALLED  (NONE)
c***END PROLOGUE  RAND
      save ia1,ia0,ia1ma0,ic,ix1,ix0
      data ia1, ia0, ia1ma0 /1536, 1029, 507/
      data ic /1731/
      data ix1, ix0 /0, 0/
c***FIRST EXECUTABLE STATEMENT  RAND
      if (r.lt.0.d0) go to 10
      if (r.gt.0.d0) go to 20
c
c           A*X = 2**22*IA1*IX1 + 2**11*(IA1*IX1 + (IA1-IA0)*(IX0-IX1)
c                   + IA0*IX0) + IA0*IX0
c
      iy0 = ia0*ix0
      iy1 = ia1*ix1 + ia1ma0*(ix0-ix1) + iy0
      iy0 = iy0 + ic
      ix0 = mod (iy0, 2048)
      iy1 = iy1 + (iy0-ix0)/2048
      ix1 = mod (iy1, 2048)
c
 10   rand = dble(ix1*2048 + ix0)
      rand_cvb = rand / 4194304.d0
      return
c
 20   ix1 = int( dmod(r,1.d0)*4194304.d0 + 0.5d0 )
      ix0 = mod (ix1, 2048)
      ix1 = (ix1-ix0)/2048
      go to 10
c
      end
c  *************
c  ** Various **
c  *************
