#include "barmanager.h"


GLuint base;            // base display list for the font set.

int maxnumber=0;
int loadingdata=0;

// to store the selected node values
nodevalues sel;



void BarManager::BuildFont() 
{
    Display *dpy;
    XFontStruct *fontInfo;  // storage for our font.

    base = glGenLists(96);                      // storage for 96 characters.
    
    // load the font.  what fonts any of you have is going
    // to be system dependent, but on my system they are
    // in /usr/X11R6/lib/X11/fonts/*, with fonts.alias and
    // fonts.dir explaining what fonts the .pcf.gz files
    // are.  in any case, one of these 2 fonts should be
    // on your system...or you won't see any text.
    
    // get the current display.  This opens a second
    // connection to the display in the DISPLAY environment
    // value, and will be around only long enough to load 
    // the font. 
    dpy = XOpenDisplay(NULL); // default to DISPLAY env.   
    fontInfo = XLoadQueryFont(dpy, "-misc-fixed-medium-r-semicondensed--13-120-75-75-c-60-iso8859-1");
//    fontInfo = XLoadQueryFont(dpy, "-adobe-helvetica-medium-r-normal--10-*-*-*-p-*-iso8859-1");
	if (fontInfo == NULL) {
	    printf("no X font available?\n");
	    exit(-1);
	}

    
    // start at character 32 (space), get 96 characters (a few characters past z), and
    // store them starting at base.





// un-comment this line to get the text displayed. It is disabled
// here because it causes crashes on some libglut versions
//    glXUseXFont(fontInfo->fid, 32, 96, base);


	


    // free that font's info now that we've got the 
    // display lists.
    XFreeFont(dpy, fontInfo);

    // close down the 2nd display connection.
    XCloseDisplay(dpy);

}

void BarManager::KillFont()                         // delete the font.
{
    glDeleteLists(base, 96);                    // delete all 96 characters.
}

void BarManager::glPrint(char *text)                      // custom gl print routine.
{

    if (text == NULL) {                         // if there's no text, do nothing.
	return;
    }
    

    glPushAttrib(GL_LIST_BIT);                  // alert that we're about to offset the display lists with glListBase
    glListBase(base - 32);                      // sets the base character to 32.


    glCallLists(strlen(text), GL_UNSIGNED_BYTE, text); // draws the display list text.
    glPopAttrib();                              // undoes the glPushAttrib(GL_LIST_BIT);


}



void BarManager::nodeinfo()                      // draws the node ids
{ 

char updatestring[50];
char nodestring[10];
bar_record tmpbar;

int thisnode=0;
int gotcha=0;


glPushMatrix();

// if the selected node is too high
if (selectednode>maxnumber) {
  selectednode=1;
}
// if the selected node is too low
if (selectednode<=0) {
  selectednode=maxnumber;
}

maxnumber=0;


//  printf("nodesid1 = %d\n", read_data.real_node_number);
//  printf("nodesid2 = %d\n", read_data.mosix_number);

for (BarIter = BarList.begin(); BarIter != BarList.end(); BarIter++) {
    //	if(BarIter->mosix_number==read_data.real_node_number) {


 		tmpbar=*BarIter;

    thisnode=read_data.real_node_number;
    // printf("node %d\n", thisnode);

    // search the selected node
    if(thisnode==selectednode) {

      // debugging
      // printf("nodesid2 = %d\n", read_data.mosix_number);
  	  // printf("selected node %d\n", selectednode);
      // printf("realnodenumber = %d\n", read_data.real_node_number);
     	// printf("found node %d\n\n", BarIter->mosix_number);
    	// printf("X %d\n\n", GetXsquares());


      if(BarIter->mosix_number==read_data.real_node_number) {
         // load the material
         tmpbar.bar->loadMaterials(yellowMaterials);
         }  else {

         if (DISPLAYMODE == LOAD) {
           tmpbar.bar->loadMaterials(greenMaterials);
         }
         if (DISPLAYMODE == MEM) {
           tmpbar.bar->loadMaterials(blueMaterials);
         }
         if (DISPLAYMODE == UTIL) {
           tmpbar.bar->loadMaterials(redMaterials);
         }
       }

      // load the values
      sel.number=read_data.mosix_number;
      sel.load=read_data.mosix_info.load;
      sel.speed=read_data.mosix_info.speed;
      sel.availmem=read_data.mosix_info.tmem/1048576;
      sel.usemem=(read_data.mosix_info.tmem/1048576)-(read_data.mosix_info.rmem/1048576);
      sel.cpus=read_data.mosix_info.ncpus;
      sel.stat=read_data.mosix_info.status;
      sel.mosversion=read_data.openmosix;

    }

    // here we count the nodes to get the max nodenumber
    maxnumber++;


 }


	// here we update the nodes information
	glEnable(GL_COLOR_MATERIAL);


  	// write the view information
  	if (DISPLAYMODE == LOAD) {
  		glColor3f(0,1,0);
  		glRasterPos2f(5, +19);
  		glPrint("load view");
  	}

  // first we check if were are in "loading-data"
  if (loadingdata<=maxnumber) {
    loadingdata++;
		glColor3f(1,1,0);
		glRasterPos2f(4, +10);
		glPrint("loading univers...");

    } else {


  	if (DISPLAYMODE == MEM) {
  		glColor3f(0,0,1);
  		glRasterPos2f(5, +19);
  			glPrint("memory view");
  	}
  	if (DISPLAYMODE == UTIL) {
  		glColor3f(1,0,0);
  		glRasterPos2f(5, +19);
  		glPrint("utilization view");
  	}


    // when there is data available for the node
    if (sel.number>0) {

  		glColor3f(1,1,0);
  		// write the headline
  		glRasterPos2f(-24, +19);
  		glPrint("node informations");

  		// here we write the bar number
  		sprintf(nodestring, "%d", selectednode);
  		strcpy(updatestring, "selected node : ");
  		strcat(updatestring, nodestring);
  		glRasterPos2f(-24, +16);
  		glPrint(updatestring);

  		// here we write the node id text
  		sprintf(nodestring, "%d", sel.number);
  		strcpy(updatestring, "node ID : ");
  		strcat(updatestring, nodestring);
  		glRasterPos2f(-24, +14);
  		glPrint(updatestring);

  		// here we write the nodes load
  		sprintf(nodestring, "%d", sel.load);
  		strcpy(updatestring, "load : ");
  		strcat(updatestring, nodestring);
  		glRasterPos2f(-24, +12);
  		glPrint(updatestring);

  		// here we write the nodes speed
  		sprintf(nodestring, "%d", sel.speed);
  		strcpy(updatestring, "speed : ");
  		strcat(updatestring, nodestring);
  		glRasterPos2f(-24, +10);
  		glPrint(updatestring);

  		// here we write the nodes available memory
  		sprintf(nodestring, "%d", sel.availmem);
  		strcpy(updatestring, "avail. mem : ");
  		strcat(updatestring, nodestring);
  		strcat(updatestring, " MB");
  		glRasterPos2f(-24, +8);
  		glPrint(updatestring);

  		// here we write the nodes used memory
  		sprintf(nodestring, "%d", sel.usemem);
  		strcpy(updatestring, "used mem : ");
  		strcat(updatestring, nodestring);
  		strcat(updatestring, " MB");
  		glRasterPos2f(-24, +6);
  		glPrint(updatestring);

  		// here we write the nodes cpus
  		sprintf(nodestring, "%d", sel.cpus);
  		strcpy(updatestring, "cpu's : ");
  		strcat(updatestring, nodestring);
  		glRasterPos2f(-24, +4);
  		glPrint(updatestring);

  		// here we write the nodes status
  		strcpy(updatestring, "status : ");
  		if (sel.stat>=2) {
  			strcat(updatestring, "up");
  			} else {
  			strcat(updatestring, "down");
  		}
  		glRasterPos2f(-24, +2);
  		glPrint(updatestring);



  		glColor3f(1,1,0);
  		// write the right headline
  		glRasterPos2f(+30, +19);
  		glPrint("cluster informations");

  		// howmany we are
  		sprintf(nodestring, "%d", maxnumber);
  		strcpy(updatestring, "total nodes : ");
  		strcat(updatestring, nodestring);
  		glRasterPos2f(+30, +16);
  		glPrint(updatestring);

  		// who we are ;)
      if (sel.mosversion) {
    		strcpy(updatestring, "running openMosix");
        } else {
    		strcpy(updatestring, "running Mosix");
      }
  		glRasterPos2f(+30, +14);
  		glPrint(updatestring);




    }

  }

  glDisable(GL_COLOR_MATERIAL);
  glPopMatrix();
}


// #########################################################################################

BarManager :: BarManager()
{       
	NumBars = 0;
	size = sizeof(struct node_info);
  selectednode=1;

}

int BarManager :: init(char *server, char *port)
{
    ConnectToServer(server, port);
    ReadNumNodes();
    return 0;
}

int BarManager::GenerateGrid()
{
	
	TwoDRect *tile;
	
	for (int x = 0; x <GetXsquares(); x++)
	    for (int z = 0; z < GetZsquares(); z++)
	    {   
		tile = new TwoDRect(0 + x*gridsize,0  ,0 + z*gridsize, gridsize, gridsize);
		
		tile->setColor4v(Color[WHITE]);
		tile->loadMaterials(moonMaterials);
		AddObject(tile);
		tile->draw();
	    }
	
	srand(time(NULL));
	return 1;
}
int BarManager::AddObject(CObject *obj)
{
	//never hurts to double check;
	if (obj == NULL)
	{
		printf("ERROR! dont pass AddObjet NULL!\n");
		//getchar();
		return -1;
	}
	else
	{
		
		ObjectList.push_back(obj);
		glNewList(static_world_list_base + static_world_list_cnt , GL_COMPILE_AND_EXECUTE);
		    obj->draw();
		glEndList();
		
		
		return 0;
	}
}
/* this whole thing needs an overhault so that one function has
all the data and can be more intelligent the map class will handle
the positioning to users can set it up more intelligently

*/
void BarManager :: SetupBarBase(int node, struct CObject_struct &b)
{


    CRand r(1,4);
    int xpos;
    int zpos;
    b.type = BAR;
    xpos = 0;
    zpos = 0;
	
    for (int i =1; i < node; i++)
    {
	xpos++;
	if (xpos >= xsquares /2)
	{
	    zpos++;
	    xpos = 0;
	}
    }

    b.posX = xpos * 2 * gridsize;
    //b.posX = 0;
    //getchar();
    b.posY=0;
    b.posZ = zpos * gridsize * 2;
    //b.posZ = (xsquares % node)*gridsize*2;

//	b.obj_materials = greenMaterials;
//	b.color_r = 0;
//	b.color_g = 1;
//	b.color_b = 0;
//	b.color_a = 0.4;

}


int BarManager :: UpdateOrCreateBar(int node, int realnodeid, struct CBar_struct d)
{
    struct bar_record r;
    struct CObject_struct  base;
     for (BarIter = BarList.begin(); BarIter != BarList.end(); BarIter++)
	 {
	    if ( BarIter->mosix_number == node)
		{
		    
 		    // printf("found node. BarIter->MosixNumer is %d node is %d  real node-id %d\n",BarIter->mosix_number, node, realnodeid);
		    BarIter->bar->setData(d);
		    return 1;
		}
	}
	r.mosix_number = node;
	SetupBarBase(node, base);
	r.bar = new CBar(base, d);
	AddBar(r);  

}

int BarManager :: AddBar(struct bar_record bar)
{
    if (bar.bar == NULL)
	{
	    printf("Error. AddBar passed a null bar\n");
	    return -1;
	}
    BarList.push_back(bar);
    // printf("added bar : %d\n", bar.mosix_number);

    NumBars++;
    return 0;
}
int BarManager :: Show()
{
    ShowObjects();
    ShowBars();
    BuildFont();
    nodeinfo();
    KillFont();
    return 0;
}

int BarManager::ShowObjects()
{

	glPushMatrix();
	int i;        
	for(ObjectIter = ObjectList.begin(); ObjectIter != ObjectList.end(); ObjectIter++)
	    (*ObjectIter)->draw();
	glPopMatrix();
	glFlush();
	return 0;
}

int BarManager :: ShowBars()
{
    glPushMatrix();
    for (BarIter = BarList.begin(); BarIter != BarList.end(); BarIter++)
    {
	
	BarIter->bar->draw();
    }

    glPopMatrix();
    return 0;
}


void BarManager :: dealloc()
{

	 for(ObjectIter = ObjectList.begin(); ObjectIter != ObjectList.end(); ObjectIter++)
	 {
		 // printf("dealloc'd n object in manager::dealloc\n");
		 (*ObjectIter)->dealloc();
		
	 }
	 ObjectList.clear();
	 for (BarIter = BarList.begin(); BarIter != BarList.end(); BarIter++)
	 {
	    // printf("deallocating a bar..\n");
	    BarIter->bar->dealloc();
	}    
	BarList.clear();
}       
 BarManager :: ~BarManager()
{
	 dealloc();
}
/* this is where openMosix/Mosix data gets turned into gl data. lots of 
    interesting things to do here for the intrepid hacker
    color coded loads, etc
*/
void BarManager:: NodeToBar(struct node_info &node)
{
    //printf("in NodeTobar..displaying %d LOAD is %d\n", DISPLAYMODE, LOAD);
    struct CBar_struct bar_info;
    int usedmem=0;
    int tmem=0;
    int rmem=0;
    int load=0;
    int util=0;
    int usedmempercent=0;
   
    if (DISPLAYMODE == LOAD)
	{
	load=node.mosix_info.load / 20 + 2;
	if (load>0) {
		bar_info.height = load;
		// printf("load is %d\n", load);
		} else {
		bar_info.height = 0;
	}

    }

    else if (DISPLAYMODE == MEM) {

	tmem=node.mosix_info.tmem/1048576;
	rmem=node.mosix_info.rmem/1048576;

	usedmem=tmem-rmem;
	if ((usedmem>0) && (tmem>0) && (rmem>0)) {
		usedmempercent=(usedmem*100)/tmem;
		// printf("usedmem is %d\n", usedmem);
		// printf("mempercent is %d\n", usedmempercent);
		usedmempercent=usedmempercent/10;
		} else {
		usedmempercent=0;
	}
	bar_info.height = usedmempercent;

    }
    else if (DISPLAYMODE == UTIL) {
	util=node.mosix_info.util/10;
	if(util>0) {
		bar_info.height = util;
		// printf("util  is %d\n", util);
		} else {
		bar_info.height = 0;
	}
    }
	

    bar_info.width = gridsize;
    UpdateOrCreateBar(node.real_node_number,node.mosix_number, bar_info);

}




/* this makes us disregard a packet of data but thats OK because */
/* we will just read it again the next time it gets sent        */

int BarManager :: ReadNumNodes()
{
    if ( read(sd, &read_data, size) != size)
    {
	perror("error in ReadNumNodes.\n");
	perror("read");
	exit(-1);
    }
    // printf(" cluster contains %d nodes\n", read_data.num_nodes);
    NumNodes = read_data.num_nodes;
    
    fcntl(sd, F_SETFL, O_NONBLOCK);
    return read_data.num_nodes;
}


void BarManager :: GetMosixData(int a)
{
    int count = 0;
     BytesRead = 0;
   
     BytesRead = read(sd, &read_data, size); 
     while (BytesRead == size)
    {
	NodeToBar(read_data);
	BytesRead = read(sd, &read_data, size);

	// printnode(&read_data);
    }
   
}

void BarManager ::  quit()
{
    
	// printf("BarManager :: quit\n");      // exit calls the destructor above, dont do explicitly.
	//BarManager :: ~BarManager();
	
	exit(0);

}



/****************/

int BarManager :: ConnectToServer(char *addr, char *prt)
{
    struct hostent *he;
    struct sockaddr_in sockaddr;
    char string[1024];
    int port;
    port = atoi(prt);
    printf("connecting to server %s %d\n", addr, port);
    sd = socket(AF_INET, SOCK_STREAM, 0);
    if (sd < 0)
	{
	    perror("scoket failed: \n");
	    exit(-1);
	}
    he = (struct hostent *) gethostbyname(addr);
    if (!he)
	{
	    printf("couldnt resolve %s", addr);
	    return -1;
	}

    sockaddr.sin_family = AF_INET;
    sockaddr.sin_port = htons(port);
    sockaddr.sin_addr = *(( struct in_addr *)he->h_addr);
    memset(&(sockaddr.sin_zero), '\0', 8);
    if ( connect(sd, (struct sockaddr *) &sockaddr, sizeof(struct sockaddr)) == -1)
	{
	    perror("connect\n");
	    return -1;
	}
return 0;
    
}

    
void BarManager ::  printnode(struct node_info *info)
{
    printf("openMosix/Mosix number:%5d\n", info->mosix_number);
    printf("real number:%5d\n", info->real_node_number);
    printf("Total nodes :%5d\n", info->num_nodes);
    printf("load        :%5d\n", info->mosix_info.load);
    printf("cpus        :%5d\n", info->mosix_info.ncpus);
    printf("util        :%5d\n", info->mosix_info.util);
    printf("status      :%5d\n", info->mosix_info.status);
    printf("mem         :%5d\n", info->mosix_info.mem);
    printf("rmem        :%5d\n", info->mosix_info.rmem);
    printf("tmem        :%5d\n", info->mosix_info.tmem);
#ifdef CONFIG_MOSIX_RESEARCH
    printf("rio         :%5d\n", info->mosix_info.util);
    printf("wio         :%5d\n", info->mosix_info.util);
#endif
      printf("\n");
  
}

/****************/
