

#include "objects.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>


void CObject :: setMaterials()
{
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, base_data.obj_materials.ambient);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, base_data.obj_materials.diffuse);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, base_data.obj_materials.specular);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, &base_data.obj_materials.shininess);


} 



CDisk :: CDisk(struct CObject_struct &base, CDisk_struct &disk) : CObject(base),disk_data(disk) 
{

   disk_data.disk = gluNewQuadric();
      if (!disk_data.disk)
	{
	    printf("not enough memory..best error handling i can do is exit..\n");
	    exit(-1);
	}       
	 
//        base_data.FillStyle =  TheWorld.FillStyle();

//      gluQuadricDrawStyle(disk_data.disk, base_data.FillStyle);
     gluQuadricDrawStyle(disk_data.disk, GLU_FILL);

//        printf("funny file disk ctor..\n");
//      getchar();

}

CDisk :: CDisk(float finner_r, float foutter_r, float x, float y, float z, float fslices, float fstacks) : CObject(DISK, x, y, z)
{
    disk_data.inner_r  = finner_r;
    disk_data.outter_r = foutter_r;
    disk_data.slices = fslices;
    disk_data.stacks = fstacks;
    disk_data.disk = gluNewQuadric();
      if (!disk_data.disk)
	{
	    printf("CDisk :: CDisk not enough memory..best error handling i can do is exit..\n");
	    exit(-1);
	}       
	printf("CDisk :: CDisk\n");
	
//      base_data.FillStyle =  TheWorld.FillStyle();
 //   gluQuadricDrawStyle(disk_data.disk, base_data.FillStyle);
     gluQuadricDrawStyle(disk_data.disk, GLU_FILL);

	setAngle(90, 0.0, 0.0);
	setDir(1.0 ,0.0 ,0.0); 
	loadMaterials(whiteMaterials);
     
}    

void CDisk :: draw()
{
   // printf("CDisk :: draw\n");
    glPushMatrix();
    glColor4f(base_data.color_r, base_data.color_g, base_data.color_b, base_data.color_a);
    glTranslatef(base_data.posX, base_data.posY, base_data.posZ);
    glRotatef(base_data.angleX, base_data.dirX, 0.0, 0.0);
	glRotatef(base_data.angleY,  0.0, base_data.dirY, 0.0);
	glRotatef (base_data.angleZ, 0.0, 0.0, base_data.dirZ);
	setMaterials();
	gluDisk(disk_data.disk, disk_data.inner_r, disk_data.outter_r, (GLint) disk_data.slices, (GLint) disk_data.stacks);
    glLoadIdentity();
	glFlush();
    glEnd();
	glPopMatrix();

}

void CDisk :: dealloc()
{

    printf("CDisk :: dealloc\b");
//        CDisk::~CDisk();
    
}


CDisk :: ~CDisk()
{
  //  printf("CDisk :: ~CDisk\n");
   gluDeleteQuadric(disk_data.disk);
}

CSphere :: CSphere(struct CObject_struct &base, CSphere_struct &sphere) : CObject(base), sphere_data(sphere) 
{

   sphere_data.sphere = gluNewQuadric();
      if (!sphere_data.sphere)
	{
	    printf("not enough memory..best error handling i can do is exit..\n");
	    exit(-1);
	}       
      gluQuadricDrawStyle(sphere_data.sphere, GLU_FILL);
//      printf("funny file sphere ctor..\n");
//      getchar();

}
CSphere :: CSphere(float fradius, float x, float y, float z, float fslices, float fstacks) : CObject(SPHERE, x, y, z) 
{
    sphere_data.slices = fslices;
    sphere_data.stacks = fstacks;
    sphere_data.radius = fradius;
    sphere_data.sphere = NULL;
     sphere_data.sphere = gluNewQuadric();
      if (!sphere_data.sphere)
	{
	    printf("CSphere :: CSphere not enough memory..best error handling i can do is exit..\n");
	    exit(-1);
	}       
	printf("CSphere :: CSphere\n");
    gluQuadricDrawStyle(sphere_data.sphere, GLU_FILL);
	setAngle(90, 0.0, 0.0); /* i know this doesnt do much but i prefer consistency to efficency */ 
	setDir(1.0 ,0.0 ,0.0); 
	loadMaterials(whiteMaterials);     
}

void CSphere :: draw()
{
    glPushMatrix();
    glColor4f(base_data.color_r, base_data.color_g, base_data.color_b, base_data.color_a);
    glTranslatef(base_data.posX, base_data.posY, base_data.posZ);
    glRotatef(base_data.angleX, base_data.dirX, 0.0, 0.0);
	glRotatef(base_data.angleY,  0.0, base_data.dirY, 0.0);
	glRotatef (base_data.angleZ, 0.0, 0.0, base_data.dirZ);
	setMaterials();
	gluSphere(sphere_data.sphere, sphere_data.radius,(int)sphere_data.slices,(int)sphere_data.stacks);
    glLoadIdentity();
	glFlush();
    glEnd();
	glLoadIdentity();
    glPopMatrix();
}

void CSphere :: dealloc()
{
    printf("CSphere :: dealloc\n");
	gluDeleteQuadric(sphere_data.sphere);
	
     
}

CSphere :: ~CSphere()
{
    dealloc();
	//printf("CSphere :: ~CSphere\n");
	
       
}

CCylinder :: CCylinder(struct CObject_struct &base, CCylinder_struct &cyl) : CObject(base), cyl_data(cyl) 
{

   cyl_data.obj = gluNewQuadric();
      if (!cyl_data.obj)
	{
	    printf("not enough memory..best error handling i can do is exit..\n");
	    exit(-1);
	}       
	  

	  gluQuadricDrawStyle(cyl_data.obj, GLU_FILL);
	printf("funny file cyl ctor..\n");
	//getchar();
	//draw();
	//xgetchar();
}

CCylinder ::  CCylinder(float x , float y, float z, double dbase,  double dtop, float fheight, float fslices, float fstacks) : CObject(CYLINDER, x, y, z) 
{ 
    cyl_data.base = dbase; cyl_data.top = dtop; cyl_data.height = fheight; cyl_data.slices = fslices; cyl_data.stacks = fstacks;
    cyl_data.obj = NULL;
    cyl_data.obj = gluNewQuadric();
      if (!cyl_data.obj)
	{
	    printf("not enough memory..best error handling i can do is exit..\n");
	    exit(-1);
	}       
      gluQuadricDrawStyle(cyl_data.obj, GLU_FILL);
	  setAngle(90, 0.0, 0.0);
	  setDir(1.0 , 0.0  ,0.0);
	loadMaterials(whiteMaterials); 
 
}

void CCylinder :: draw()
{
    glPushMatrix();
    glColor4f(base_data.color_r, base_data.color_g, base_data.color_b, base_data.color_a);
    glTranslatef(base_data.posX, base_data.posY, base_data.posZ);
	glRotatef(base_data.angleY,  0.0, base_data.dirY, 0.0);
	glRotatef(base_data.angleX, base_data.dirX, 0.0, 0.0);
	glRotatef (base_data.angleZ, 0.0, 0.0, base_data.dirZ);
	setMaterials(); 
    gluCylinder(cyl_data.obj, cyl_data.base, cyl_data.top, cyl_data.height, (int)cyl_data.stacks, (int)cyl_data.slices);
  //  printf("just drew cylinder %f %f %f %f %f %f\n", cyl_data.base, cyl_data.top, cyl_data.height, cyl_data.stacks, cyl_data.slices);
//q     getchar();
	glFlush();
    glEnd();
    glLoadIdentity();
	glPopMatrix();
}

void CCylinder :: dealloc()
{
    printf("CCylinder :: dealloc\n");
//    getchar();
//        CCylinder :: ~CCylinder();
}
CCylinder :: ~CCylinder()
{
    printf("Cylinder dtor.\n");
    gluDeleteQuadric(cyl_data.obj);


}

void CBar :: draw()
{
    float right_corner;
    int mode;
    float ctmp[4];
    right_corner = base_data.posX + bar_data.width;
    
    glPushMatrix();
    glColor4f(base_data.color_r, base_data.color_g, base_data.color_b, base_data.color_a);
    setMaterials();
    getColor4v(ctmp);

    if (ctmp[3] != 1.0) glDepthMask(GL_FALSE);
	else glDepthMask(GL_TRUE);
	
	glBegin(GL_POLYGON);
		glVertex3f(base_data.posX, 0,  base_data.posZ);
		glVertex3f(base_data.posX + bar_data.width, 0,  base_data.posZ);
		glVertex3f(base_data.posX + bar_data.width, bar_data.height,  base_data.posZ);
		glVertex3f(base_data.posX, bar_data.height,  base_data.posZ);
	glEnd();                                                                                         

    glBegin(GL_POLYGON);
	glVertex3f(base_data.posX,0,base_data.posZ);
	glVertex3f(base_data.posX,0,base_data.posZ + bar_data.width);
	glVertex3f(base_data.posX, bar_data.height, base_data.posZ + bar_data.width);
	glVertex3f(base_data.posX, bar_data.height, base_data.posZ);
    glEnd();
    
    
    glBegin(GL_POLYGON);
	glVertex3f(right_corner, 0, base_data.posZ);
	glVertex3f(right_corner, 0, base_data.posZ + bar_data.width);
	glVertex3f(right_corner, bar_data.height, base_data.posZ +bar_data.width);
	glVertex3f(right_corner, bar_data.height, base_data.posZ);
	glEnd();

    glBegin(GL_POLYGON);
	glVertex3f(base_data.posX,0,base_data.posZ + bar_data.width);
	glVertex3f(right_corner,0,base_data.posZ + bar_data.width);
	glVertex3f(right_corner,bar_data.height, base_data.posZ + bar_data.width);
	glVertex3f(base_data.posX, bar_data.height, base_data.posZ + bar_data.width);
	
	
    glEnd();   
    glDepthMask(GL_TRUE);        
    glLoadIdentity();
    glPopMatrix();
    
}

void TwoDRect :: draw()
{
	float ctmp[4];
	glPushMatrix();
	glColor4f(base_data.color_r, base_data.color_g, base_data.color_b, base_data.color_a);
	setMaterials();
	glRotatef(base_data.angleY,  0.0, base_data.dirY, 0.0);
	glRotatef(base_data.angleX, base_data.dirX, 0.0, 0.0);
	glRotatef (base_data.angleZ, 0.0, 0.0, base_data.dirZ);
	getColor4v(ctmp);
	
	glBegin(GL_LINE_LOOP);
		glVertex3f(base_data.posX, 0,  base_data.posZ);
		glVertex3f(base_data.posX + rect_data.width, 0,  base_data.posZ);
		glVertex3f(base_data.posX + rect_data.width, 0,  base_data.posZ + rect_data.depth);
		glVertex3f(base_data.posX, 0, base_data.posZ + rect_data.depth);
	glEnd();                                                                                         
	glFlush();
	glLoadIdentity();
	glPopMatrix();                                                    
}

void CCone :: draw()
{
    glPushMatrix();
	glColor4f(base_data.color_r, base_data.color_g, base_data.color_b, base_data.color_a);
    glTranslatef(base_data.posX, base_data.posY, base_data.posZ);
    glRotatef(base_data.angleY,  0.0, base_data.dirY, 0.0);
	glRotatef(base_data.angleX, base_data.dirX, 0.0, 0.0);
	glRotatef (base_data.angleZ, 0.0, 0.0, base_data.dirZ);
	setMaterials();
	
	glutSolidCone(cone_data.base, cone_data.height, (int)cone_data.stacks, (int)cone_data.slices);
    
    glFlush();
//    glEnd();
    glLoadIdentity();
	glPopMatrix();
}
