#include "mosstat.h"

int num_nodes;
int file_exists(char *isfile);
int killmyself();
int writepidfile(int processid);
void printusage();
int init();
void printnode();
int get_num_nodes(const char* whichdir);
int openmosix();   // this checks if we are running on openMosix or Mosix
int daemonize();
int setupfd(); // This determines if were called from inetd or a user


// helper function
int file_exists(char *isfile) {
  FILE *testfile;
  if((testfile=fopen(isfile, "r")) == NULL) {
    // yep, the file exists
    return 0;
    } else {
    // no, there is no such file
    return 1;
    fclose(testfile);
  }
}


// read my own pid from pid-file and kill myself gracefully
int killmyself( ) {
  FILE *mosstatdpdifile;
  int mypid, kstatus, delpidfile;
  if((mosstatdpdifile=fopen(mpidfile, "r")) != NULL) {
    fscanf(mosstatdpdifile, "%d", &mypid);
    if(!mypid) {
      printf("No PID in pidfile %s\n", mpidfile);
      return 0;
    }
    kstatus=kill(mypid, SIGKILL);
    if(kstatus) {
      return 0;
      } else {
      // delete the pid-file
      delpidfile=unlink(mpidfile);
      if (delpidfile) {
        printf("Could not remove pidfile %s\n", mpidfile);
        } else {
        printf("Removed pidfile %s\n", mpidfile);
      }
      return 1;
    }

    } else {
    printf("Could not read from pidfile %s\n", mpidfile);
    return 0;
  }

}


// write my PID to /var/run/mosstatd.pid
int writepidfile(int processid) {
  FILE *mosstatdpdifile;
  if((mosstatdpdifile=fopen(mpidfile, "w")) != NULL) {
    fprintf(mosstatdpdifile, "%d\n", processid);
    return 1;
    } else {
    printf("Could not write to pidfile %s\n", mpidfile);
    return 0;
  }
}



// usage
void printusage() {
  printf("HOWTO use the mosstatd-daemon:\n");
  printf("mosstatd [-h,--h, -help, --help]       -> display this help screen\n");
  printf("mosstatd                               -> starts the mosstatd daemon\n");
  printf("mosstatd -k                            -> kills the mosstatd daemon\n");
}


// setup the communication socket
int setupfd()
{
   struct sockaddr_in sock;
   struct sockaddr_in remote;
   int addrlen;
   int son_of_inetd = 0;
   int ld; 
   int i;	
   int sd;
   if (  (ld = socket(AF_INET, SOCK_STREAM, 0)) < 0)
     {
       perror("socket:");
       exit(1);
    }
   /*
    * we do this so that we can figure out if we were called from inetd 
    * or we should run as a independent daemon, and behave accordingly. 
    */
   i = 1;
   if ( setsockopt(ld, SOL_SOCKET, SO_REUSEADDR, &i, sizeof(int)) < 0) 
      {
      perror("setsockopt:");
      exit(1);
    }

   sock.sin_family = AF_INET;
   sock.sin_addr.s_addr = INADDR_ANY;
   sock.sin_port = htons(LISTPORT);
   

	 if ( bind(ld, (struct sockaddr *)&sock, sizeof(sock)) < 0)
     {  
	if (errno == EADDRINUSE) {/* perhaps this needs a little explainin   */
   	   close(ld);             /* we can asumme that we were called from  */  
	   son_of_inetd = 1;      /* inetd if errno = EADDRINUSE therefore we*/
        }                         /* close ld, set son_of_inetd and continue*/
	if (!son_of_inetd) {
	perror("bind:");         
	   exit(1);              
        }                       
     }                             
                          
#ifdef DEBUG
if (!son_of_inetd) printf("I am a standalone server\n");
#endif



	if (son_of_inetd)
	return 1;
/* if we were called form inetd then someone aleady made the connection 
   otherwise we have to wait down here and accept */

	while (1) // loop forever serving connections as they come 
	{
 		#ifdef DEBUG
		printf("awaiting connection..\n");
		#endif
		if ( listen(ld, 3) < 0 )
   		   { 
			perror("listen:");
   		    	exit(1);
   	   		}
		#ifdef DEBUG
		printf("establishing connection..\n");
		#endif
   	 	 if ( (sd = accept(ld, (struct sockaddr *) &remote, &addrlen)) == -1 )
			{
   		     perror("accept");
			exit(1);
   		 }
		#ifdef DEBUG
			printf("connect established!\n");
		#endif
	
		if (fork()) // one of use serves the connectoin, one goes back to the
			return sd;   // top of the loop
	}
}

int get_num_nodes(const char* whichdir)
{
 DIR *dirhpc;
 struct dirent *dir_info;
 int howmany=0;
 if ((dirhpc=opendir(whichdir))!=NULL) {
  while ((dir_info = readdir(dirhpc))!=NULL) {
   howmany++;
  }
  closedir(dirhpc);
  howmany--;
  howmany--;
  return howmany;
 }
}


int openmosix() {
 DIR *dircluster;
 if ((dircluster=opendir(openmosixdir))!=NULL) {
  closedir(dircluster);
  // printf("openMosix deteteced!\n");
  return 1;
  } else if ((dircluster=opendir(mosixdir))!=NULL) {
  closedir(dircluster);
  // printf("Mosix deteteced!\n");
  return 0;
  } else {}
  printf("Neither openMosix nor Mosix deteteced!\n");
  exit(-1);
}



int initnodestruct(struct node_info *info)
{
    info->mosix_number = 0;
    info->real_node_number = 0;
    info->openmosix = 0;
    info->num_nodes = 0;
    info->mosix_info.load = 0;
    info->mosix_info.speed = 0;
    info->mosix_info.ncpus = 0;
    info->mosix_info.status = 0;
    info->mosix_info.util= 0;
    info->mosix_info.mem = 0;
    info->mosix_info.rmem = 0;
    info->mosix_info.tmem = 0;
#ifdef CONFIG_MOSIX_RESEARCH
    info->mosix_info.rio = 0;
    info->mosix_info.wio = 0;
#endif
}



int fillnodestruct(int node, int nodesequence, struct node_info *info, int whichmos)
{
    int ret;
    info->mosix_number = node;
    info->real_node_number = nodesequence;

    info->openmosix = whichmos;

    info->num_nodes = num_nodes;
    ret = msx_readnode(node, "load");

    if (ret >= 0)
    info->mosix_info.load = ret;

    ret = msx_readnode(node, "speed");
    if (ret >= 0)
    info->mosix_info.speed = ret;

    ret = msx_readnode(node, "cpus");
    if (ret >= 0)
	info->mosix_info.ncpus = ret;
		//       ^ inconsistent :(

    ret = msx_readnode(node, "util");
    if (ret >= 0)
	info->mosix_info.util = ret;
	

    ret = msx_readnode(node, "status");
    if (ret >= 0)
	info->mosix_info.status = ret;

    ret = msx_readnode(node, "mem");
    if (ret >= 0)
	info->mosix_info.mem = ret;

    ret = msx_readnode(node, "rmem");
    if (ret >= 0)
	info->mosix_info.rmem = ret;

    ret = msx_readnode(node, "tmem");
    if (ret >= 0)
	info->mosix_info.tmem = ret;
#ifdef CONFIG_MOSIX_RESEARCH
    ret = msx_readnode(node, "rio");
    if (ret >= 0)
	info->mosix_info.rio = ret;

    ret = msx_rPeadnode(node, "wio");
    if (ret >= 0)
	info->mosix_info.wio = ret;
#endif
	
}



void printnode(struct node_info *info)
{
    printf("Mosix number:%d\n", info->mosix_number);
    printf("real number:%d\n", info->real_node_number);
    printf("Total nodes :%d\n", info->num_nodes);
    printf("load        :%d\n", info->mosix_info.load);
    printf("cpus        :%d\n", info->mosix_info.ncpus);
    printf("util        :%d\n", info->mosix_info.util);
    printf("status      :%d\n", info->mosix_info.status);
    printf("mem         :%d\n", info->mosix_info.mem);
    printf("rmem        :%d\n", info->mosix_info.rmem);
    printf("tmem        :%d\n", info->mosix_info.tmem);
#ifdef CONFIG_MOSIX_RESEARCH
    printf("rio         :%d\n", info->mosix_info.util);
    printf("wio         :%d\n", info->mosix_info.util);
#endif
    printf("\n");

}



int daemonize() {
        int pid=0;
        int success=0;

        if(file_exists(mpidfile)) {
                printf("mosstatd PID file exists!\n");
                printf("Trying to stop old mosstatd-instance...\n");
                success = killmyself();
                if (!success) {
                  printf("Could not stop old mosstatd-instance!\n");
                  } else {
                  printf("Successfully stopped old mosstatd-instance!\n");
                }
        }


        if ((pid = fork()) == -1) {
                printf("mosstatd dameon not started.\n");
                printf("Problems during fork!\n");
                return -1;
                } else {
                if (pid) {
                        printf("mosstatd dameon succesfull started PID %d\n", pid);
                        if(!writepidfile(pid)) {
                                return -1;
                        }
                        exit(0);
                }
        return 1;
        }
}




int main(int argc, char *argv[]) {
    const char *name = "mosstatd";
    const char *author = "johnycsh";
    struct node_info info;
    int node=0;
    DIR *dirhpc;
    struct dirent *dir_info;
    int nodeseq;
    int thisisopenmosix=1;
    int writefd;



    // check the commandline
    if(argc != 1) {


      if((!strcmp(argv[1], "-h")) || (!strcmp(argv[1], "--h")) || (!strcmp(argv[1], "-help")) || (!strcmp(argv[1], "--help"))) {
        printusage();
        exit(0);
        } else if (!strcmp(argv[1], "-k")) {
        // here we stop the mosstatd
        if (!killmyself()) {
          printf("Could not stop mosstatd-instance!\n");


          // } else if (!strcmp(argv[1], "-yourcommandline-option")) {
          // add your commandline options here ;)



          } else {
          printf("Successfully stopped mosstatd-instance!\n");
         }
        exit(0);
        } else {
        printf("No such option!\n");
        printusage();
        exit(0);
        }
      } else {
      // daemonize
      daemonize();
    }


    // check who called us
    writefd = setupfd();
    #ifdef DEBUG
     printf("after setupfd..\n");
    #endif



    // here we check if we run on openMosix or Mosix
    thisisopenmosix = openmosix();
    if(thisisopenmosix) {
// ################ openMosix ###################################
      num_nodes = get_num_nodes(openmosixdir);
      while(1) {
       nodeseq=1;
       if ((dirhpc=opendir(openmosixdir))!=NULL) {
         while ((dir_info = readdir(dirhpc))!=NULL) {
           if (!strchr(dir_info->d_name, '.')) {
              node=atoi(dir_info->d_name);
              initnodestruct(&info);
              fillnodestruct(node, nodeseq, &info, thisisopenmosix);
//            printnode(&info);
              write(writefd, &info, sizeof(struct node_info));
              usleep(100*read_delay);
              nodeseq++;
           }
          }
         closedir(dirhpc);
         } // end of dir loop
        }
// ###########################################################
      } else {
// ################# Mosix ###################################
      num_nodes = get_num_nodes(mosixdir);
      while(1) {
       nodeseq=1;
       if ((dirhpc=opendir(mosixdir))!=NULL) {
         while ((dir_info = readdir(dirhpc))!=NULL) {
           if (!strchr(dir_info->d_name, '.')) {
              node=atoi(dir_info->d_name);
              initnodestruct(&info);
              fillnodestruct(node, nodeseq, &info, thisisopenmosix);
//            printnode(&info);
              write(writefd, &info, sizeof(struct node_info));
              usleep(100*read_delay);
              nodeseq++;
           }
          }
         closedir(dirhpc);
         } // end of dir loop
        }
// ###########################################################

    }
   return 0;
}


