/***************************************************************************
                          nodeinfo.cpp  -  description
                             -------------------
    begin                : Thu Aug 1 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "nodeinfo.h"
#include "ende.xpm"
#include "white.xpm"

nodeinfo::nodeinfo(QWidget *parent, const char *name ) : QWidget(parent,name) {

	const char *nodefilename;
	nodefilename = this->name();

	string nodeid;
	string tmpstr;
	string endstr;
	int i;

	nodeid.erase();
	tmpstr.erase();
	endstr.erase();
	tmpstr = tmpstr + nodefilename;
	typedef string::size_type ST;
	ST beginname=tmpstr.find_last_of("/");
	string::iterator p = tmpstr.begin();
	for(i=0; i<(int)beginname; i++) {
		p++;
	}
	p++;
	for (;p!=tmpstr.end(); p++) {
		endstr = *p;
		nodeid = nodeid + endstr;
	}
	string nodetitle;
	nodetitle.erase();
	nodetitle = nodetitle + "Informations about node ";
	nodetitle = nodetitle + nodeid;

	QPixmap end;
	end = QPixmap(ende);

	title_cluster_info= new QLabel(this,"title");
	title_cluster_info->setGeometry(0,0,180,20);
	title_cluster_info->setMinimumSize(0,0);
	title_cluster_info->setText(nodetitle.c_str());
	title_cluster_info->setMargin(0);
	title_cluster_info->setAlignment( AlignVCenter | AlignCenter );

	close= new QPushButton(end, "close", this);
	close->setGeometry(300,140,60,20);
	close->setMinimumSize(0,0);
	close->setText("quit");
	QObject::connect(close, SIGNAL(clicked()), this, SLOT(close()) );
}

nodeinfo::~nodeinfo(){
}



// helping functions

inline int min(int eins, int zwei) {
	if(eins>zwei) {
		return zwei;
		} else {
		return eins;
	}
}

inline int max(int eins, int zwei) {
 	if(eins<zwei) {
		return zwei;
		} else {
		return eins;
	}
}

inline int string2int(const string s) {
        if (s.length() == 0) {
                return -1;
        } else {
                return(atoi(s.c_str()));
        }
}

inline string int2string(const int i) {
        char buf[12];
        sprintf(buf,"%d",i);
        return(string(buf));
}

// #########################

void nodeinfo::paintEvent(QPaintEvent *) {

	int oload, ospeed, oallmem, ousedmem, cpus;
	FILE *readfile;
	char *when;
	when = new char[50];
	int j=0;
	QPainter p(this);
	const char *nodefilename;
	nodefilename = this->name();
	string startdate;
	string enddate;
	int allload = 0;
	int allmem = 0;
	int allusedmem = 0;
	int maxload = 0;
	int minload = 200;
	int maxmem = 0;
	int minmem = 1000000;
	int maxusedmem = 0;
	int minusedmem = 1000000;
	int allcpus = 0;
	int mincpus = 10000;
	int maxcpus = 0;
	int allspeed = 0;
	int minspeed = 100;
	int maxspeed = 0;
	string ram;

	QPixmap white_pix;
	white_pix= QPixmap(white_xpm);

	startdate.erase();
	enddate.erase();

	p.setWindow(0, 20, 365, 116);
	p.setPen(Qt::black);

	p.moveTo(0, 50);
	for(int i=0;i<=365; i++) {
		p.lineTo(i, 50);
	}
	p.moveTo(0, 69);
	for(int i=0;i<=190; i++) {
		p.lineTo(i, 69);
	}
	p.moveTo(0, 115);
	for(int i=0;i<=365; i++) {
		p.lineTo(i, 115);
	}

	if((readfile=fopen(nodefilename, "r")) == NULL) {
		cout << "could not open openMosix data information file" << nodefilename << endl;
		} else {
		while  ((!feof(readfile))&&(j<4320)) {
			fscanf(readfile, "%s %d %d %d %d %d", when, &oload, &ospeed, &oallmem, &ousedmem, &cpus);

			if(oload==-999) {
				// it is a checkpoint or we are reading the last end of the logfile
				} else {
				// calculate the values

				// date
				if (j==0) {
            	startdate = startdate + when;
				}
				enddate.erase();
				enddate = enddate + when;
			
				// load
				oload = (oload *45)/100;
				allload = allload + oload;
				minload = min(minload, oload);
				maxload = max(maxload, oload);

				// speed
				allspeed = allspeed + ospeed;
				minspeed = min(minspeed, ospeed);
				maxspeed = max(maxspeed, ospeed);

				// memory
				ousedmem = (ousedmem * 45)/100;
				allmem = allmem + oallmem;
				allusedmem = allusedmem + ousedmem;
				minmem = min(minmem, oallmem);
				maxmem = max(maxmem, oallmem);
				minusedmem = min(minusedmem, ousedmem);
				maxusedmem = max(maxusedmem, ousedmem);

				// cpus
				allcpus = allcpus + cpus;
				maxcpus = max(maxcpus, cpus);
				mincpus = min(mincpus, cpus);

				j++;
				// check if we are really reading from file
				oload = -999;

			}
		}
		fclose(readfile);

		// calculate all values

		if (j>1) {
			allload = allload/j;
			allmem = allmem/j;
			allusedmem = allusedmem/j;
			allspeed = allspeed/j;
			allcpus = allcpus/j;
			} else {
      	allload = 0;
			maxload = 0;
			minload = 0;
			allmem = 0;
			maxmem = 0;
			minmem = 0;
			allusedmem = 0;
			maxusedmem = 0;
			minusedmem = 0;
			allspeed = 0;
			maxspeed = 0;
			minspeed = 0;
			allcpus = 0;
			maxcpus = 0;
			mincpus = 0;
		}

		// draw the widgets
		QLabel_startdate1= new QLabel(this,"startdate");
		QLabel_startdate1->setGeometry(0,20,60,20);
		QLabel_startdate1->setMinimumSize(0,0);
		QLabel_startdate1->setText("from	:");
		QLabel_startdate1->setMargin(0);
		QLabel_startdate1->setAlignment( AlignVCenter | AlignCenter );
		QWhatsThis::add(QLabel_startdate1 ,"This is the date/time when the openMosixcollector started gathering the cluster informations.");
		QLabel_startdate1->show();

		// startdate
		QLabel_startdate2= new QLabel(this,"start-date");
		QLabel_startdate2->setGeometry(60,20,120,20);
		QLabel_startdate2->setMinimumSize(0,0);
		QLabel_startdate2->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_startdate2->setText(startdate.c_str());
		QLabel_startdate2->setMargin(0);
		QLabel_startdate2->setAlignment( AlignVCenter | AlignCenter );
		QLabel_startdate2->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_startdate2 ,"This is the date/time when the openMosixcollector started gathering the cluster informations.");
		QLabel_startdate2->show();

		// endate
		QLabel_enddate1= new QLabel(this,"enddate");
		QLabel_enddate1->setGeometry(180,20,60,20);
		QLabel_enddate1->setMinimumSize(0,0);
		QLabel_enddate1->setText("to	:");
		QLabel_enddate1->setMargin(0);
		QLabel_enddate1->setAlignment( AlignVCenter | AlignCenter );
		QWhatsThis::add(QLabel_enddate1 ,"This is the date/time when the openMosixcollector finished gathering the cluster informations.");
		QLabel_enddate1->show();

		// endate
		QLabel_enddate2= new QLabel(this,"enddate");
		QLabel_enddate2->setGeometry(240,20,120,20);
		QLabel_enddate2->setMinimumSize(0,0);
		QLabel_enddate2->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_enddate2->setText(enddate.c_str());
		QLabel_enddate2->setMargin(0);
		QLabel_enddate2->setAlignment( AlignVCenter | AlignCenter );
		QLabel_enddate2->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_enddate2 ,"This is the date/time when the openMosixcollector finished gathering the cluster informations.");
		QLabel_enddate2->show();



		// the load diagram
		QLabel_load_top1= new QLabel(this,"Load");
		QLabel_load_top1->setGeometry(35,50,60,20);
		QLabel_load_top1->setMinimumSize(0,0);
		QLabel_load_top1->setMargin(0);
		QLabel_load_top1->setText("Load");
		QLabel_load_top1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_load_top1 ,"The diagram above shows an load-overview of the cluster.");
		QLabel_load_top1->show();

		QBrush brushwhite(white);
		p.setBrush(brushwhite);
		p.drawRect(10, 115-minload, 25, minload);

		QBrush brushblue(blue);
		p.setBrush(brushblue);
		p.drawRect(35, 115-maxload, 25, maxload);

		QBrush brushgreen(green);
		p.setBrush(brushgreen);
		p.drawRect(60, 115-allload, 25, allload);

		// load label
		QLabel_load1= new QLabel(this,"load");
		QLabel_load1->setGeometry(10,140,80,20);
		QLabel_load1->setMinimumSize(0,0);
		QLabel_load1->setText("min/max/mean");
		QLabel_load1->setMargin(0);
		QLabel_load1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_load1 ,"The diagram above shows the min/max/mean balancing values of the cluster.");
		QLabel_load1->show();

		// the memory diagram
		QLabel_mem_top1= new QLabel(this,"Memory");
		QLabel_mem_top1->setGeometry(130,50,100,20);
		QLabel_mem_top1->setMinimumSize(0,0);
		QLabel_mem_top1->setMargin(0);
		QLabel_mem_top1->setText("Memory");
		QLabel_mem_top1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_mem_top1 ,"The diagram above shows the memory overview of the cluster.");
		QLabel_mem_top1->show();

		p.setBrush(brushwhite);
		p.drawRect(110, 115-minusedmem, 25, minusedmem);

		p.setBrush(brushblue);
		p.drawRect(135, 115-maxusedmem, 25, maxusedmem);

		p.setBrush(brushgreen);
		p.drawRect(160, 115-allusedmem, 25, allusedmem);


 		// memory label
		QLabel_mem1= new QLabel(this,"balancing");
		QLabel_mem1->setGeometry(110,140,80,20);
		QLabel_mem1->setMinimumSize(0,0);
		QLabel_mem1->setText("min/max/mean");
		QLabel_mem1->setMargin(0);
		QLabel_mem1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_mem1 ,"The diagram above shows the min/max/mean memory values of the cluster.");
		QLabel_mem1->show();

		// top label
		QLabel_header= new QLabel(this,"header");
		QLabel_header->setGeometry(290,50,100,20);
		QLabel_header->setMinimumSize(0,0);
		QLabel_header->setText("static data");
		QLabel_header->setMargin(0);
		QLabel_header->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_header ,"The diagram above shows the min/max/mean values of one node.");
		QLabel_header->show();

		// cpu label
		QLabel_node_cpus= new QLabel(this,"cpu");
		QLabel_node_cpus->setGeometry(205,70,70,20);
		QLabel_node_cpus->setMinimumSize(0,0);
		QLabel_node_cpus->setText("CPUs :");
		QLabel_node_cpus->setMargin(0);
		QLabel_node_cpus->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_node_cpus ,"This row displays how many CPUs this node has.");
		QLabel_node_cpus->show();

		// aivailable mem label
		QLabel_node_mem= new QLabel(this,"mem");
		QLabel_node_mem->setGeometry(205,90,70,20);
		QLabel_node_mem->setMinimumSize(0,0);
		QLabel_node_mem->setText("Avail.mem :");
		QLabel_node_mem->setMargin(0);
		QLabel_node_mem->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_node_mem ,"This row displays how much memory this node has.");
		QLabel_node_mem->show();

		// speed label
		QLabel_node_speed= new QLabel(this,"speed");
		QLabel_node_speed->setGeometry(205,110,70,20);
		QLabel_node_speed->setMinimumSize(0,0);
		QLabel_node_speed->setText("Speed :");
		QLabel_node_speed->setMargin(0);
		QLabel_node_speed->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_node_speed ,"This row displays the openMosix-speed of this node.");
		QLabel_node_speed->show();

	
		// draw the table
		// the first row
   	QLabel_table_1_1= new QLabel(this,"table");
		QLabel_table_1_1->setGeometry(270,70,90,20);
		QLabel_table_1_1->setMinimumSize(0,0);
		QLabel_table_1_1->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_1_1->setNum(maxcpus);
		QLabel_table_1_1->setMargin(0);
		QLabel_table_1_1->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_1_1->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_1_1 ,"This row displays how many CPUs this node has.");
		QLabel_table_1_1->show();


		// the second row
		ram.erase();
		ram = ram + int2string(maxmem);
		ram = ram + " MB";
		QLabel_table_2_1= new QLabel(this,"table");
		QLabel_table_2_1->setGeometry(270,90,90,20);
		QLabel_table_2_1->setMinimumSize(0,0);
		QLabel_table_2_1->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_2_1->setText(ram.c_str());
		QLabel_table_2_1->setMargin(0);
		QLabel_table_2_1->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_2_1->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_2_1 ,"This row displays how much memory this node has.");
		QLabel_table_2_1->show();


		// the third row
		QLabel_table_3_1= new QLabel(this,"table");
		QLabel_table_3_1->setGeometry(270,110,90,20);
		QLabel_table_3_1->setMinimumSize(0,0);
		QLabel_table_3_1->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_3_1->setNum(maxspeed);
		QLabel_table_3_1->setMargin(0);
		QLabel_table_3_1->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_3_1->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_3_1 ,"This row displays the openMosix-speed of this node.");
		QLabel_table_3_1->show();


		}
	}













