/***************************************************************************
                          openmosixanalyzer.h  -  description
                             -------------------
    begin                : Mon Jul 29 17:10:18 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPENMOSIXANALYZER_H
#define OPENMOSIXANALYZER_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qscrollbar.h>
#include <qpushbutton.h>
#include <qtabdialog.h>
#include <qcheckbox.h>
#include <qtimer.h>
#include <qpen.h>
#include <qregexp.h>
#include <qspinbox.h>
#include <qfont.h>

#include <string>
#include <iostream>
#include <fstream>
#include <list>


// application specific includes
#include "openmosixanalyzerview.h"
#include "openmosixanalyzerdoc.h"
#include "loadanalyzer.h"
#include "memanalyzer.h"
#include "clusterload.h"
#include "clustermem.h"
#include "clusterinfo.h"
#include "nodeinfo.h"

#define VERSION "1.5"

using namespace std;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class OpenMosixAnalyzerView is
  * created which creates your view.
  */
class OpenMosixAnalyzerApp : public QMainWindow
{
  Q_OBJECT
  
  public:
	/** construtor */
	OpenMosixAnalyzerApp();
	/** destructor */
	~OpenMosixAnalyzerApp();
	/** initializes all QActions of the application */
	void initActions();
	/** initMenuBar creates the menu_bar and inserts the menuitems */
	void initMenuBar();
	/** setup the statusbar */
	void initStatusBar();
	// draws the cluster
	void drawcluster(string logdirectory);

	// print clusterload
	void print_clusterload(const  char *filename);

	// print clustermem
	void print_clustermem(const  char *filename);

	// print loadanalyzer
	void print_loadanalyzer(const  char *filename);

	// print memanalyzer
	void print_memanalyzer(const  char *filename);

	QTimer *proctimer;
	
	// the nodelist
	list<string> nodelist;

	// the logdirectory
	string logg;

  public slots:

	/** open a document */
	void slotFileOpen();

	/** shows an about dlg*/
	void slotHelpAbout();

	/** the Help */
	void slotHelp();

	// to scroll
	void scroll_view(int value);
	void right_left(int value);

	// shows the memory view
	void showMemView();

	// shows the load view
	void showLoadView();

	// enter what's this mode
	void slot_whatisthis();

	// displays information about the cluster and logfile
	void showallinfo();

	// displays information about one node in the cluster
	void showsingleinfo();

	// autorefresh the view
	void refreshit();

	// print cluster logs
	void print_cluster();

	// print node logs
	void print_nodes();

	// sets the logg variable
	void setlogdirectory(string name);

	// open openMosixhistory
	void openhistory();

	// check if the logdirectory + logfile exists
	void checklogdirectory(string logdir);

	// to adjust the timer by the qspinbox
	void adjusttimer(int val);

	
	protected:
		QGroupBox *QGroupBox_1;
		QGroupBox *QGroupBox_2;
		QScrollBar *QScrollBar_1;
		QScrollBar *QScrollBar_2;
		clusterload *allload;
		clustermem *allmem;
		loadanalyzer *loadlog[1000];
		memanalyzer *memlog[1000];
		QLabel *QLabel_top;
		QLabel *QLabel_left;
		QLabel *QLabel_clusterbar;
		QLabel *QLabel_cluster_all;
		QLabel *QLabel_cluster_node;
		QToolButton *showMem;
		QToolButton *showLoad;
		QToolButton *helpme;
		QToolButton *fileOpen;
		QToolButton *whatisthis;
		QToolButton *showclusterinfo;
		QToolButton *printcluster;
		QToolButton *shownodeinfo;
		QToolButton *printnode;
		QToolButton *openprochistory;
		QCheckBox *QCheckBox_autorefresh;
		QSpinBox *refreshtimeoutbox;
		QLabel *label_refresh2;
				
		QLabel *QLabel_display;
		QLabel *QLabel_tux;

		virtual void resizeEvent(QResizeEvent* ev) {
			QGroupBox_1->setGeometry(0,180,ev->size().width(),QGroupBox_1->height());
			QGroupBox_2->setGeometry(0,180,ev->size().width(),QGroupBox_2->height());
			QScrollBar_1->setGeometry(ev->size().width()-20,180, 20, ev->size().height()-220);
			QScrollBar_2->setGeometry(30,ev->size().height()-40,ev->size().width()-50, 20);
			QLabel_tux->setGeometry(ev->size().width()-20,ev->size().height()-40,20,20);
			}

  private:

    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    OpenMosixAnalyzerView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    OpenMosixAnalyzerDoc *doc;
  
    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
     QPopupMenu *helpMenu;
    /** the main toolbar */

	QAction *fileClose;
   QAction *filePrint;
   QAction *fileQuit;
   QAction *helpAboutApp;
};
#endif 

