/***************************************************************************
                          openmosixhistory.cpp  -  description
                             -------------------
    begin                : Don Aug  8 10:07:58 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qaccel.h>
#include "openmosixhistory.h"
#include "white.xpm"
#include "proc.xpm"
#include "proc_remote.xpm"
#include "refresh.xpm"
#include "ende.xpm"
#include "proc_cant.xpm"
#include "whatis.xpm"


OpenMosixHistoryApp::OpenMosixHistoryApp(string name)
{
  setCaption(tr("openMosixHistory " VERSION));

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts

	setlogdirectory(name);		
	initStatusBar();
	initActions();
}

OpenMosixHistoryApp::~OpenMosixHistoryApp()
{
}



// ################################# helping functions ############################

  int file_exist(string filename)
{
	std::ifstream readfilename(filename.c_str());
	if (readfilename) {
		readfilename.close();
		return 1;
		} else {
		return 0;
	}
}


int string2int(const string s) {
        if (s.length() == 0) {
                return -1;
        } else {
                return(atoi(s.c_str()));
        }
}

string int2string(const int i) {
        char buf[12];
        sprintf(buf,"%d",i);
        return(string(buf));
}







/** initializes all QActions of the application */
void OpenMosixHistoryApp::initActions(){

	string username;
	char zeile[201];
	typedef string::size_type where;
	where whereitis;

	QPixmap white_pix, fresh, end, what;
	white_pix= QPixmap(white_xpm);
	fresh = QPixmap(refresh);
	end = QPixmap(ende);
	what = QPixmap(whatis);

	userbox = new QComboBox(this);
	userbox->setGeometry(220,5,90,20);
	userbox->setMinimumSize(0,0);
	userbox->resize(90, 20);
	QObject::connect(userbox, SIGNAL(activated(int)), this, SLOT(sync_user(int)) );
	QWhatsThis::add(userbox,"Select the user (or all) for a more selective view\n.");

	userbox->insertItem("all", -1);
	std::ifstream readpasswd("/etc/passwd");
	if (readpasswd) {
		while(readpasswd.getline(zeile, 200)) {
			username.erase();
			username= username+zeile;
			whereitis = username.find_first_of(":");
			username = username.substr(0, whereitis);
			userbox->insertItem(username.c_str(), -1);
		}
		readpasswd.close();
		} else {
		cout << "could not open /etc/passwd for reading" << endl;
	}

	user_select_label= new QLabel(this,"NoName");
	user_select_label->setGeometry(15,110,70,20);
	user_select_label->setMinimumSize(0,0);
	user_select_label->setText("all");

	QLabel_userbox= new QLabel(this,"NoName");
	QLabel_userbox->setGeometry(310,5,50,20);
	QLabel_userbox->setMinimumSize(0,0);
	QLabel_userbox->setMargin(1);
	QLabel_userbox->setText("procs");
	QWhatsThis::add(QLabel_userbox,"Select the user (or all) for a more selective view\n.");

	processbox = new QListView(this);
	processbox->setGeometry(5,85,50,100);
	processbox->setMinimumSize(0,0);
	processbox->setAllColumnsShowFocus(1);
	processbox->addColumn("pid");
	processbox->addColumn("n#");
	processbox->addColumn("lock");
	processbox->addColumn("nmigs");
	processbox->addColumn("stat");
	processbox->addColumn("cmdline");
	processbox->addColumn("nice");
	processbox->addColumn("UID");
	processbox->setSorting(2, TRUE);
	processbox->setColumnAlignment (0, AlignLeft);
	processbox->setColumnAlignment (1, AlignLeft);
	processbox->setColumnAlignment (2, AlignLeft);
	processbox->setItemMargin(2);
	processbox->resize(190, 300);
	QWhatsThis::add(processbox,"This box displays the\nprocesses on this node.");

	what_this_button = new QToolButton(this, "whatsthis");
	what_this_button->setGeometry(0,0,25,25);
	what_this_button->setPixmap(what);
	connect(what_this_button, SIGNAL(clicked()), this, SLOT(slot_whatisthis()));

	QLabel_start_time_label= new QLabel(this,"time");
	QLabel_start_time_label->setGeometry(30,5,40,20);
	QLabel_start_time_label->setMinimumSize(0,0);
	QLabel_start_time_label->setMargin(1);
	QLabel_start_time_label->setText("time:");
	QWhatsThis::add(QLabel_start_time_label,"This box displays the time of this process-history.");

	QLabel_start_time= new QLabel(this,"time");
	QLabel_start_time->setGeometry(70,5,140,20);
	QLabel_start_time->setMinimumSize(0,0);
	QLabel_start_time->setMargin(0);
	QLabel_start_time->setAlignment( AlignVCenter | AlignCenter );
	QLabel_start_time->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	QLabel_start_time->setText("");
	QLabel_start_time->setBackgroundPixmap(QPixmap(white_pix));
	QWhatsThis::add(QLabel_start_time,"This box displays the time of this process-history.");


	QSlider_timeline= new QSlider(this,"time-line");
	QSlider_timeline->setGeometry(5,30,340,30);
	QSlider_timeline->setMinimumSize(0,0);
	QSlider_timeline->setTracking(false);
	QSlider_timeline->setValue(0);
	QSlider_timeline->setRange(1,4320);
	QSlider_timeline->setTickInterval (360);
	QSlider_timeline->setTickmarks (QSlider::Below);
	QSlider_timeline->setPageStep(1);
	QSlider_timeline->setOrientation(QSlider::Horizontal);
	QWhatsThis::add(QSlider_timeline,"Use this slider to go on in the time-line of the process-history.");
	QObject::connect(QSlider_timeline, SIGNAL(valueChanged(int)), this, SLOT(fill_procbox(int)) );

	QLabel_time_label= new QLabel(this,"time");
	QLabel_time_label->setGeometry(10,60,60,20);
	QLabel_time_label->setMinimumSize(0,0);
	QLabel_time_label->setMargin(1);
	QLabel_time_label->setText("hours ->");
	QWhatsThis::add(QLabel_time_label,"This timeslider shows the process at the current tim (+hour).");

	QPushButton_1= new QPushButton(end, "quit", this);
	QPushButton_1->setGeometry(280,380,60,20);
	QPushButton_1->setMinimumSize(0,0);
	QPushButton_1->setText("quit");
	QObject::connect(QPushButton_1, SIGNAL(clicked()), qApp, SLOT(quit()) );
	QWhatsThis::add(QPushButton_1,"Close the the processbox.");

//#####################################################################
 	fill_procbox(1);
//#####################################################################

}


void OpenMosixHistoryApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(tr("Ready."), 2000);
}



void OpenMosixHistoryApp::slot_whatisthis()
{
QWhatsThis::enterWhatsThisMode();
}



// fills the processbox with data from /tmp/openmosixcollector/*
void OpenMosixHistoryApp::fill_procbox(int which) {

	FILE *readfile;
	char *when;
	when = new char[50];
	char *where;
	where = new char[50];
	char *locks;
	locks = new char[50];
	char *nmigs;
	nmigs = new char[50];
	char *pid;
	pid = new char[50];
	char *stat;
	stat = new char[50];
	char *cannotmove;
	cannotmove = new char[50];
	char *userid;
	userid = new char[50];
	char *prio;
	prio = new char[50];
	char *cmdline;
	cmdline = new char[1000];
	int h=0;

	string filename;
 	QPixmap procicon, remoteprocicon, cantprocicon;
	procicon= QPixmap(proc);
	remoteprocicon= QPixmap(proc_remote);
	cantprocicon= QPixmap(proc_cant);

	processbox->clear();

	filename.erase();
	filename = filename + logg;
	filename = filename + "phist/";
	filename = filename + int2string(which);
	filename = filename + "tsecs.dat";

	if((readfile=fopen(filename.c_str(), "r")) == NULL) {
		QListViewItem *i1;
		i1 = new QListViewItem(processbox, "No data available!");
		} else {
		while  (!feof(readfile)) {
			fscanf(readfile, "%s %s %s %s %s %s %s %s %s %s", when, pid, where, locks, nmigs, stat, cannotmove, prio, userid, cmdline);
			if(h==0) {
         	QLabel_start_time->setText(when);
			}
			if ((!strcmp(user_select_label->text(), userid)) || (!strcmp(user_select_label->text(), "all"))) {
				QListViewItem *i1;
				i1 = new QListViewItem(processbox, pid, where, locks, nmigs, stat, cmdline, prio, userid);
				if (string2int(where)==0) {
					if (strstr(cannotmove, "M")) {
						i1->setPixmap(0, procicon);
						} else {
						i1->setPixmap(0, cantprocicon);
					}
			      } else {
					i1->setPixmap(0, remoteprocicon);
				}
			} //stcmp if
			h++;
		}
		statusBar()->message(filename.c_str());
	}
	delete [] when;
	delete [] where;
	delete [] stat;
	delete [] prio;
	delete [] userid;
	delete [] cmdline;
	delete [] cannotmove;
}



void OpenMosixHistoryApp::sync_user(int index) {
	char *sub_string;
	sub_string = new char[50];
	char *temp1;
	temp1 = new char[200];
	char *temp2;
	temp2 = new char[200];
	FILE *fp;
	index=index;
	if ((fp=fopen("/etc/passwd", "r"))!=NULL) {
		while(!feof(fp)) {
			if ((fgets(temp1, 190, fp))!=NULL) {
				sub_string=strtok(temp1, ":");
				strcpy(temp2, "");
				strcpy(temp2, sub_string);
				sub_string=strtok(NULL, ":");
				sub_string=strtok(NULL, ":");
				if(!strcmp(userbox->currentText(), temp2)) {
				  user_select_label->setText(sub_string);
				}
				while ( (sub_string=strtok(NULL, ":")) != NULL) {
			}
		}
	}
	fclose(fp);
	}
	if(!strcmp(userbox->currentText(), "all")) {
	  user_select_label->setText("all");
	}

	//refresh
 	fill_procbox(QSlider_timeline->value());

	delete [] temp1;
	delete [] temp2;
	delete [] sub_string;
}


// set the logdirectory variable to the current logdir
void OpenMosixHistoryApp::setlogdirectory(string logdir) {
	logg=logdir;
}

