/***************************************************************************
                          procwidget.h  -  description
                             -------------------
    begin                : Mon Jan 6 2003
    copyright            : (C) 2003 by Matt
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROCWIDGET_H
#define PROCWIDGET_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qdragobject.h>

#include <string>
#include <iostream>
#include <fstream>

#define MAXMIGGROUPS 1000

using namespace std;

/**
  *@author Matt
  */

class procwidget : public QLabel  {
   Q_OBJECT
public: 
	procwidget(QWidget *parent=0, const char *name=0);
	~procwidget();

  string getmyname();

  void toggle_selected();
  bool is_selected();
  void setmiggroup(int pg);
  void applymiggroup();
  int getmiggroup();

protected:

  virtual void mousePressEvent(QMouseEvent *event) {
    if (event->button() == LeftButton) {
      dragStartPos=event->pos();
      } else if (event->button() == RightButton) {

      // start selection
      string tmpname = this->getmyname();
      QObject *tmpparent = this->parent();

      // if selected
      if(selected == 0 ) {
        // get the active processgroup
        QString apg = tmpparent->name();

        // check which color we should have
        setmiggroup(apg.toInt());

        } else {
        // unselect
        setmiggroup(0);
      }
     // toggle the selected variable
     toggle_selected();

    }
    QLabel::mousePressEvent(event);
  }




  virtual void mouseMoveEvent(QMouseEvent *event) {
    if (event->state() & ddButton) {
      if(abs(event->pos().x() - dragStartPos.x()) >=3 || abs(event->pos().y() - dragStartPos.y()) >=3 ) {
        string tmpname = this->getmyname();
        // create + fill list into drag'n drop text object
        QTextDrag *dragText = new QTextDrag(tmpname.c_str(), this);
        // start the drag ... ;)
        dragText->dragCopy();
      }
      QLabel::mouseMoveEvent(event);
    }
  }


  virtual void dragEnterEvent(QDragEnterEvent *event) {
    if (QTextDrag::canDecode(event)) {
      event->accept();
    }
  }



  // to send home by doubleclick
  virtual void mouseDoubleClickEvent(QMouseEvent *event) {

    string tmpname = this->getmyname();
    string migcommand1;
    migcommand1.erase();
    migcommand1 = migcommand1 + "migrate ";
    migcommand1 = migcommand1 +  tmpname;
    migcommand1 = migcommand1 + " home";
    cout << migcommand1 << endl;
    system(migcommand1.c_str());

    QLabel::mouseDoubleClickEvent(event);
  }




private:

  int ddButton;
  int selButton;
  QPoint dragStartPos;
  string myname;
  int selected;
  int processgroup;


};

#endif
