/*  AudioFileQT.H
 *
 *  Copyright (C) 2005 Richard Spindler <richard.spindler AT gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _AUDIO_FILE_QT_H_
#define _AUDIO_FILE_QT_H_

#include <stdint.h>

#include <lqt.h>

#include "global_includes.H"
#include "IAudioFile.H"
#include "globals.H"

namespace nle
{

class AudioFileQT : public IAudioFile
{
	public:
		AudioFileQT( string filename );
		~AudioFileQT();
		void seek( int64_t sample );
		int fillBuffer( float* output, unsigned long frames );
			// sizof(output) == frames * 2
			// File Format: 48000 stereo interleaved
	private:
		quicktime_t* m_qt;
		bool m_oneShot;
};

}

#endif /* _AUDIO_FILE_QT_H_ */

