/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/
package help;

import java.util.Hashtable;

public class Text {
	
	private static Hashtable<String,String> text = new Hashtable<String,String>();
	
	public Text()
	{
		text.put("error_NoParameter", "Invalid parameter number: no parameters are given. Please start this program with \"vtsetup\". ");
		text.put("error_NoCorrectPathes", "Invalid file paths: Some of the files are not found. Please check that the file paths in the parameters are correct.");
		
		text.put("left_Menu_headline", "Configuration Steps:");
		text.put("left_Menu_fltGrp_General", "  Step 1 General Setup");
		text.put("left_Menu_fltGrp_Grouping", "  Step 2 Group Setup");
		text.put("left_Menu_fltGrp_Filtering", "  Step 3 Filter Setup");
	
		text.put("left_Menu_fltGrp_General_title", "");
		text.put("left_Menu_fltGrp_Grouping_title", "");
		text.put("left_Menu_fltGrp_Filtering_title", "");
		
		text.put("misc_yes","yes");
		text.put("misc_no","no");
		text.put("misc_save","save");
		text.put("misc_dont_save","don't save");
		text.put("misc_cancel","cancel");
		
		text.put("dialog_use_env","Some enviromentals are already set, do you want to take them over?");
		text.put("dialog_use_env_title","Enviromentals are already set!");
		text.put("dialog_save_changes","Do you want to save the changes you made?");
		text.put("dialog_save_changes_title","Do you want to save the changes you made?");
		text.put("dialog_chanches_lost","All changes get lost. Do you want to continue?");
		text.put("dialog_chanches_lost_title","Warning");
		text.put("dialog_chanche_exec","<html><body>VTSetup got some simbols from another executable. Do you want to merge symbols from both execuatbles, just use the setted simbols or use the symbols from the new executable?</body></html>");
		text.put("dialog_chanche_exec_title","Warning");
		text.put("dialog_chanche_exec_takeold","Don't Generate New Symbols");
		text.put("dialog_chanche_exec_merge","Merge");
		text.put("dialog_chanche_exec_takenew","Use New Once.");
		
		//Tooltip
		text.put("tooltip_default_title","Information");
		text.put("tooltip_default","The <div style=\"font-style:italic;\">&quot;Tool Tip&quot;</div> area shows you information about settings, and guides you through the configuration of your program.<br/>");
		//Menubar
		text.put("launch_menuBar_FILE","File");
		text.put("launch_menuBar_FILE_quit","Quit");
		text.put("launch_menuBar_FILE_new","New Config");
		text.put("launch_menuBar_FILE_open","Open Config...");
		text.put("launch_menuBar_FILE_save","Save Config");
		text.put("launch_menuBar_FILE_saveas","Save Config as...");
		
		text.put("launch_menuBar_Generate","Generate");
		text.put("launch_menuBar_Generate_generate","Generate...");
		text.put("launch_menuBar_Generate_generateas","Generate as");
		text.put("launch_menuBar_Generate_bash","As bash...");
		text.put("launch_menuBar_Generate_csh","As csh...");
		text.put("launch_menuBar_Generate_batch","As batch...");
				
		text.put("launch_menuBar_View","View");
		text.put("launch_menuBar_View_advanced","Show Advanced Options.");
		
		text.put("launch_menuBar_Help","Help");
		text.put("launch_menuBar_Help_About","About");
		
		
		//Toolbar
		text.put("launch_toolBar_new_title","New Configuration");
		text.put("launch_toolBar_new","Start a new configuration project.");
		text.put("launch_toolBar_load_title","Load");
		text.put("launch_toolBar_load","Load an existing configuration project.");
		text.put("launch_toolBar_save_title","Save");
		text.put("launch_toolBar_save","Save the configuration project.");
		text.put("launch_toolBar_generate_title","Generate");
		text.put("launch_toolBar_generate","Generate a script that is used to apply the configured VampirTrace settings.");
		text.put("launch_toolBar_advanced_title","Advanced View");
		text.put("launch_toolBar_advanced","Show/Hide advanced options.");
		text.put("launch_toolBar_magic_title","Execute");
		text.put("launch_toolBar_magic","Execute executable with settings.");
		
		
		//Grouping & Filtering
		
		//noSymbols
		text.put("nSymbols_label","<HTML><BODY>Grouping/Filtering is unavailable as long as no symbols are specified. Please go back to &quot;"+text.get("left_Menu_fltGrp_General").trim()+"&quot; to import symbols:</BODY></HTML>");
		text.put("nSymbols_button","Step 1 General Setup");
		//General
		text.put("General_imp_grpFile_title","Optional: Import existing group file");
		text.put("General_imp_grpFile", "Before you start with the grouping of your symbols, you may import an existing VampirTrace group file to use a set of pre-defined group definitions."); 
		text.put("General_imp_filtFile_title","Optional: Import existing filter file");
		text.put("General_imp_filtFile","Before you start with filtering your symbols, you may import an existing VampirTrace filter file to use a set of pre-defined filter rules.");
		text.put("General_search_title","Search");
		text.put("General_search","Use this field to have a case-insensitive live search for symbols in the symbol list below. You will get search results during keying. You may specify an exact name as well as wild-card expressions, e.g. &quot;MPI_*&quot;.");
		text.put("General_symbTable_title","Symbol Table");
		text.put("General_symbTable","This table shows all application symbols, as well as any symbols that you added manually or from further shared libraries used by your application.");
		text.put("General_addSymb_title","Add symbols");
		text.put("General_addSymb","You can add application symbols manually. Coming usage case is, if you use manual instrumentation.");
		text.put("General_imp_exec_title","Import From Executable");
		text.put("General_imp_bin_title","Add Symbols From Binary");
		text.put("General_imp_bin","If the symbol list is blank you can use this function to add symbols from a user defined binary.");
		text.put("General_imp_bin_nonm","You can import further symbols from shared libraries or executables.<br/><h3>nm is not available!</h3>");
		text.put("General_imp_exec","You can import further symbols from a specified executable.");
		text.put("General_imp_exec_nonm","You can import further symbols from a specified executable.<br/><h3>nm is not available!</h3>");
		text.put("General_autoGrp_title","Auto Grouping");
		text.put("General_autoGrp","You may enable or disable an automatic prefix grouping of your symbols.");
		
		text.put("General_imp_grpFilt_title", "Optional: Load Existing Group and Filter Definition");
		text.put("General_ApplSymFunc_title", "Application Symbols and Functions");
		text.put("General_grp_Label", "Group file:");
		text.put("Import_Label", "Import");
		
		//Grouping
		text.put("Grouping_groupList_title","Groups");
		text.put("Grouping_groupList","List of all symbol groups. The &quot;All&quot; item contains all symbols, whereas the &quot;no Group&quot; item lists all symbols that are in no group. The symbols in the table to the right are restricted to the currently selected group.");
		text.put("Grouping_groupList_adv","List of all symbol groups. The italic groups are VampirTrace default groups. The &quot;All&quot; item contains all symbols, whereas the &quot;no Group&quot; item lists all symbols that are in no group. The symbols in the table to the right are restricted to the currently selected group.");
		text.put("Grouping_search_title","Search");
		text.put("Grouping_search","Use this field to have a case-insensitive live search for symbols in the symbol list below. You will get search results during keying. You may specify an exact name as well as wild-card expressions, e.g. &quot;MPI_*&quot;.");
		text.put("Grouping_symbols_title","List of groups");
		text.put("Grouping_symbols","List of symbols in the currently selected group(s). Use the &quot;Find&quot; function to find specific symbols, usually you want to use wild-card expressions for that.");
		text.put("Grouping_addGroup_title","Add Group");
		text.put("Grouping_addGroup","Add a group with the entered name.");
		text.put("Grouping_removeGroup_title","Remove Selected Groups");
		text.put("Grouping_removeGroup_adv","Remove all selected groups. Any symbols that belong to a deleted group are added to the &quot;no Group&quot; item again. Any italic groups are default groups that are used by VampirTrace.");
		text.put("Grouping_removeGroup","Remove all selected groups. Any symbols that belong to a deleted group are added to the &quot;no Group&quot; item again.");
		text.put("Grouping_renameGroup_title","Rename selected group");
		text.put("Grouping_renameGroup","Rename the selected group.");
		text.put("Grouping_moveSymb_title","Move Selected Symbols");
		text.put("Grouping_moveSymb","Move selected symbols from the symbol table into the group that can be selected.");
		text.put("Grouping_list_title","List of groups");
		text.put("Grouping_table_title","Symbols in selected group(s)");
		text.put("Grouping_Search_For","Search for ");
		
		//Filtering
		text.put("Filtering_addProcFilter_title","Add Process Filter");
		text.put("Filtering_addProcFilter_btn","Add Process-Specific Filter");
		text.put("Filtering_addProcFilter","You may specify multiple filters for VampirTrace, while there is always a global filter that is applied to all processes, you may add filters that are only applied to processes with certain ranks. You may specify ranges from rank X to rank Y with &quot;X-Y&quot;, e.g.: &quot;1&quot; or &quot;1,2,3&quot; or &quot;1-100&quot; or &quot;1-100,5&quot;.");
		text.put("Filtering_remProcFilter_title","Remove Process Filter");
		text.put("Filtering_remProcFilter","Remove the process specific filter definition.");
		text.put("Filtering_moveBackward_title","Move Filter Backward");
		text.put("Filtering_moveBackward","Move the filter definitions backward to give them a higher rank.");
		text.put("Filtering_moveForward_title","Move Filter Forward");
		text.put("Filtering_moveForward","Move the filter definitions forward to give them a lower rank.");
		text.put("Filtering_filterType_title","Filter type ");
		text.put("Filtering_filterType","Set the type of this filter. If you use \"Use rules\" you can set the filter definitions manually for each symbol, otherwise no symbol will be traced for these specified rank(s).");
		text.put("Filtering_procRange_title","Process range");
		text.put("Filtering_procRange","Set the rank(s) for which this filter is valid. (e.g. 1 ; 1,2,3 ; 0-4)");
		text.put("Filtering_search_title","Search");
		text.put("Filtering_search","Use this field to have a case-insensitive live search for symbols in the symbol list below. You will get search results during keying. You may specify an exact name as well as wild-card expressions, e.g. &quot;MPI_*&quot;.");
		text.put("Filtering_symbTable_title","SymbolTable");
		text.put("Filtering_symbTable","This table shows you all symbols on which you can generate filter and group files.");
		text.put("Filtering_setFilter_title","Set Filter");
		text.put("Filtering_setFilter","Use one of the radio buttons to set the filter rules for the selected symbol(s).<br><ul><li><i>region(s) denied</i> - symbol is not traced</li><li><i>region(s) unlimited</i> - symbol is traced</li><li><i>filter after calls</i> - symbol is traced for the given number of cores.</li><li><i>filter off</i> - no filter is set.</li></ul> ");
		text.put("Filtering_collapse_title","Expand/Collapse All");
		text.put("Filtering_collapse","Expands or collapse all groups in this table.");
		text.put("Filtering_not_traced","Not traced");
		text.put("Filtering_after_calls","Filter after calls:");
		text.put("Filtering_filter_off","Filter off");
		text.put("Filtering_always_traced","Always traced");
		
		//Symbol Group Table
		text.put("symTab_Col_system", "Element Type");
		text.put("symTab_Col_name", "Symbol List");
		text.put("symTab_Col_type", "Type");
		text.put("symTab_Col_group", "Group");
		text.put("symTab_Col_call", "Filter Rule");
	}
	
	
	public String getText(String key)
	{
		try {

			if(!text.containsKey(key))
			{
				throw new Exception("Text not found! Key: "+key);
			}
			String output = text.get(key);
			
			
			return output; 
		}catch(Exception e)
		{
			Config.errorHandler(e);
		}
		return "";
	}
}
