// $Id: DummyDevice.cc,v 1.36 2005/01/15 12:55:38 m9710797 Exp $

#include <cassert>
#include "DummyDevice.hh"
#include "EmuTime.hh"
#include "XMLElement.hh"
#include "FileContext.hh"

namespace openmsx {

DummyDevice::DummyDevice(const XMLElement& config, const EmuTime& time) 
	: MSXDevice(config, time)
{
}

DummyDevice::~DummyDevice()
{
}

DummyDevice& DummyDevice::instance()
{
	static bool init = false;
	static XMLElement deviceElem("Dummy");
	if (!init) {
		init = true;
		deviceElem.addAttribute("id", "empty");
		deviceElem.setFileContext(std::auto_ptr<FileContext>(
		                                 new SystemFileContext()));
	}
	static DummyDevice oneInstance(deviceElem, EmuTime::zero);
	return oneInstance;
}


// Block usage of the following methods

void DummyDevice::reset(const EmuTime& /*time*/)
{
	assert(false);
}

} // namespace openmsx
