// $Id: EmptyDiskPatch.cc,v 1.3 2005/03/11 16:22:59 m9710797 Exp $

#include "EmptyDiskPatch.hh"
#include "SectorBasedDisk.hh"
#include <cassert>

namespace openmsx {

EmptyDiskPatch::EmptyDiskPatch(SectorBasedDisk& disk_)
	: disk(disk_)
{
}

void EmptyDiskPatch::copyBlock(unsigned src, byte* dst, unsigned num) const
{
	if (num); // avoid warning
	assert(num == SectorBasedDisk::SECTOR_SIZE);
	disk.readLogicalSector(src / SectorBasedDisk::SECTOR_SIZE, dst);
}

unsigned EmptyDiskPatch::getSize() const
{
	return disk.getNbSectors() * SectorBasedDisk::SECTOR_SIZE;
}

} // namespace openmsx

