// $Id: MidiOutConnector.hh,v 1.11 2005/03/10 20:15:45 m9710797 Exp $

#ifndef MIDIOUTCONNECTOR_HH
#define MIDIOUTCONNECTOR_HH

#include "Connector.hh"
#include "SerialDataInterface.hh"
#include "MidiOutDevice.hh"

namespace openmsx {

class MidiOutConnector : public Connector, public SerialDataInterface
{
public:
	MidiOutConnector(const std::string& name);
	virtual ~MidiOutConnector();

	// Connector
	virtual const std::string& getDescription() const;
	virtual const std::string& getClass() const;
	virtual MidiOutDevice& getPlugged() const;

	// SerialDataInterface
	virtual void setDataBits(DataBits bits);
	virtual void setStopBits(StopBits bits);
	virtual void setParityBit(bool enable, ParityBit parity);
	virtual void recvByte(byte value, const EmuTime& time);
};

} // namespace openmsx

#endif
