// $Id: StringSetting.hh,v 1.10 2005/03/10 20:15:46 m9710797 Exp $

#ifndef STRINGSETTING_HH
#define STRINGSETTING_HH

#include "SettingPolicy.hh"
#include "SettingImpl.hh"

namespace openmsx {

class StringSettingPolicy : public SettingPolicy<std::string>
{
protected:
	const std::string& toString(const std::string& value) const;
	const std::string& fromString(const std::string& str) const;
};

class StringSetting : public SettingImpl<StringSettingPolicy>
{
public:
	StringSetting(const std::string& name, const std::string& description,
	              const std::string& initialValue);
};

} // namespace openmsx

#endif
