// $Id: MSXPSG.hh,v 1.20 2005/04/02 21:25:37 mthuurne Exp $

#ifndef MSXPSG_HH
#define MSXPSG_HH

#include <memory>
#include "MSXDevice.hh"
#include "AY8910.hh"
#include "AY8910Periphery.hh"

namespace openmsx {

class CassettePortInterface;
class JoystickPort;

class MSXPSG : public MSXDevice, public AY8910Periphery
{
public:
	MSXPSG(const XMLElement& config, const EmuTime& time);
	virtual ~MSXPSG();

	virtual void reset(const EmuTime& time);
	virtual void powerDown(const EmuTime& time);
	virtual byte readIO(byte port, const EmuTime& time);
	virtual byte peekIO(byte port, const EmuTime& time) const;
	virtual void writeIO(byte port, byte value, const EmuTime& time);

private:
	// AY8910Periphery: port A input, port B output
	virtual byte readA(const EmuTime& time);
	virtual void writeB(byte value, const EmuTime& time);

	std::auto_ptr<AY8910> ay8910;
	std::auto_ptr<JoystickPort> ports[2];
	CassettePortInterface& cassette;

	int registerLatch;
	int selectedPort;
	byte prev;
	bool keyLayoutBit;
};

} // namespace openmsx

#endif
