// $Id: Semaphore.hh,v 1.6 2005/03/10 20:15:48 m9710797 Exp $

#ifndef SEMAPHORE_HH
#define SEMAPHORE_HH

#include <SDL.h>

namespace openmsx {

class Semaphore
{
public:
	Semaphore(unsigned value);
	~Semaphore();
	void up();
	void down();

private:
	SDL_sem* semaphore;
};

class ScopedLock
{
public:
	ScopedLock(Semaphore& lock_)
		: lock(lock_)
	{
		lock.down();
	}

	~ScopedLock()
	{
		lock.up();
	}

private:
	Semaphore& lock;
};

} // namespace openmsx

#endif
