// $Id: DeinterlacedFrame.hh 5740 2006-10-03 16:51:29Z m9710797 $

#ifndef DEINTERLACEDFRAME_HH
#define DEINTERLACEDFRAME_HH

#include "FrameSource.hh"

namespace openmsx {

/** Produces a deinterlaced video frame based on two other FrameSources
  * (typically two RawFrames) containing the even and odd field.
  * This class does not copy the data from the input FrameSources.
  */
class DeinterlacedFrame : public FrameSource
{
public:
	explicit DeinterlacedFrame(const SDL_PixelFormat* format);

	void init(FrameSource* evenField, FrameSource* oddField);

	virtual unsigned getLineBufferSize() const;
	virtual unsigned getLineWidth(unsigned line);

protected:
	virtual void* getLinePtrImpl(unsigned line);

private:
	/** The original frames whose data will be deinterlaced.
	  * The even frame is at index 0, the odd frame at index 1.
	  */
	FrameSource* fields[2];
};

} // namespace openmsx

#endif // DEINTERLACEDFRAME_HH
