// $Id: V9990VRAM.cc 5621 2006-09-11 21:31:38Z m9710797 $

#include "V9990.hh"
#include "V9990VRAM.hh"

namespace openmsx {

V9990VRAM::V9990VRAM(V9990& vdp_, const EmuTime& /*time*/)
	: vdp(vdp_), cmdEngine(0)
	, data(vdp.getMotherBoard(), vdp.getName() + " VRAM",
	       "V9990 Video RAM", VRAM_SIZE)
{
	memset(&data[0], 0, data.getSize());
}

unsigned V9990VRAM::mapAddress(unsigned address)
{
	address &= 0x7FFFF; // change to assert?
	switch (vdp.getDisplayMode()) {
		case P1:
			return transformP1(address);
		case P2:
			return transformP2(address);
		default /* Bx */:
			return transformBx(address);
	}
}

byte V9990VRAM::readVRAMCPU(unsigned address, const EmuTime& time)
{
	sync(time);
	return data[mapAddress(address)];
}

void V9990VRAM::writeVRAMCPU(unsigned address, byte value, const EmuTime& time)
{
	sync(time);
	data[mapAddress(address)] = value;
}

void V9990VRAM::setCmdEngine(V9990CmdEngine& cmdEngine_)
{
	cmdEngine = &cmdEngine_;
}

} // namespace openmsx
