/*************************************************************************
 *
 *  $RCSfile: ilstitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_CROSSREFERENCE_HPP_
#include <com/sun/star/ucb/CrossReference.hpp>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif

#ifndef _CNTXREF_HXX
#include <cntxref.hxx>
#endif

#define _ILSTITEM_CXX
#include <ilstitem.hxx>

using namespace chaos;

//=========================================================================

TYPEINIT1_AUTOFACTORY( CntItemListItem, SfxPoolItem );
SV_IMPL_PTRARR( SfxPoolItemArr, SfxPoolItem* );

//=========================================================================

CntItemListItem::CntItemListItem( USHORT nWhich, SfxItemPool* pPool )
: SfxPoolItem( nWhich ),
  _pPool( pPool )
{
}

//-------------------------------------------------------------------------
CntItemListItem::CntItemListItem( USHORT nWhich, const SfxItemSet &rSet )
: SfxPoolItem( nWhich ),
  _pPool( rSet.GetPool() )
{
	SfxItemIter aIter( rSet );
	for ( const SfxPoolItem *pItem = aIter.FirstItem();
		  pItem;
		  pItem = aIter.NextItem() )
	{
		if ( !IsInvalidItem( pItem ) )
			Append( pItem->Clone() );
	}
}

//-------------------------------------------------------------------------

#define DONT_PUT ((SfxItemPool*)-1)

CntItemListItem::CntItemListItem( USHORT nWhich,
								  SfxItemPool* pPool, SvStream &rStream )
: SfxPoolItem( nWhich ),
  _pPool( pPool )
{
	USHORT nCount = 0;
	rStream >> nCount;

	for (USHORT n = 0; n < nCount; ++n)
	{
		const SfxPoolItem* pItem = _pPool->LoadItem (rStream, TRUE, DONT_PUT);
		Append( pItem );
	}
}

//-------------------------------------------------------------------------
CntItemListItem::CntItemListItem( const CntItemListItem &rOrig,
								  SfxItemPool* pPool )
: SfxPoolItem( rOrig ),
  _pPool( pPool )
{
	for ( USHORT n = 0; n < rOrig.Count(); ++n )
		Append( rOrig[ n ].Clone() );
}

//-------------------------------------------------------------------------
// virtual
CntItemListItem::~CntItemListItem()
{
	while ( Count() )
		Remove( 0 );
}

//-------------------------------------------------------------------------
// virtual
int CntItemListItem::operator==( const SfxPoolItem &rItem ) const
{
	const CntItemListItem& rOther = (const CntItemListItem&)rItem;
	if ( Count() != rOther.Count() )
		return FALSE;

	for ( USHORT n = 0; n < Count(); ++n )
	{
		// Items are not sorted!
		const SfxPoolItem& rCurr = operator[]( n );
		const SfxPoolItem* pCurr = rOther.Get( rCurr.Which() );

		if ( !pCurr )
			return FALSE;

		if ( *pCurr != rCurr )
			return FALSE;
	}
	return TRUE;
}

//-------------------------------------------------------------------------
// virtual
SfxPoolItem* CntItemListItem::Clone( SfxItemPool* pPool ) const
{
	return new CntItemListItem( *this, pPool ? pPool : _pPool );
}

//-------------------------------------------------------------------------
// virtual
SfxPoolItem* CntItemListItem::Create( SvStream &rStream,
									  USHORT nItemVersion) const
{
	return new CntItemListItem( Which(), _pPool, rStream );
}

//-------------------------------------------------------------------------
// virtual
SvStream& CntItemListItem::Store( SvStream &rStream,
								  USHORT nItemVersion ) const
{
	rStream << Count();
	for ( USHORT n = 0; n < Count(); ++n )
		_pPool->StoreItem( rStream, *_aItems[ n ], TRUE );

	return rStream;
}

//-------------------------------------------------------------------------
const SfxPoolItem* CntItemListItem::Get( USHORT nWhich ) const
{
	for ( USHORT n = 0; n < Count(); ++n )
	{
		const SfxPoolItem *pItem = &operator[]( n );
		if ( pItem->Which() == nWhich )
			return pItem;
	}
	return NULL;
}

//----------------------------------------------------------------------------
void CntItemListItem::Remove( USHORT nPos )
{
	delete _aItems[ nPos ];
 	_aItems.Remove( nPos, 1 );
}

//----------------------------------------------------------------------------
// virtual
BOOL CntItemListItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		BYTE nMemberId )
{
	switch ( Which() )
	{
		case WID_NEWS_XREFLIST:
		{
			// Note: An ItemListItem with this WID always transports a
			//       list of CntCrossReferenceItem's. This behavior has
			//       historical reasons. The better way would be to have
			//       a special CntCrossReferenceListItem...
			com::sun::star::uno::Sequence<
					com::sun::star::ucb::CrossReference > aValue;
			if ( rVal >>= aValue )
			{
				// Destroy old info.
				while ( Count() )
					Remove( 0 );

				sal_uInt32 nCount = aValue.getLength();
				const com::sun::star::ucb::CrossReference* pValues =
														aValue.getConstArray();
				for ( sal_uInt32 n = 0; n < nCount; ++n )
				{
					const com::sun::star::ucb::CrossReference& rInfo =
																pValues[ n ];
					Append( new CntCrossReferenceItem(
								WID_NEWS_XREF,
								rInfo.Group.getStr(),
								rInfo.Id ) );
				}
				return TRUE;
			}
			DBG_ERROR( "CntItemListItem::PutValue - Wrong type!" );
			break;
		}

		default:
			break;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntItemListItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  BYTE nMemberId ) const
{
	switch ( Which() )
	{
		case WID_NEWS_XREFLIST:
		{
			USHORT nCount = Count();
			com::sun::star::uno::Sequence<
					com::sun::star::ucb::CrossReference > aValue( nCount );
			com::sun::star::ucb::CrossReference* pValues = aValue.getArray();

			for ( USHORT n = 0; n < nCount; ++n )
			{
				DBG_ASSERT(
					_aItems[ n ]->ISA( CntCrossReferenceItem ),
					"Not a CntCrossReferenceItem in WID_NEWS_XREFLIST!" );

				const CntCrossReferenceItem* pItem =
								(const CntCrossReferenceItem*)_aItems[ n ];
				com::sun::star::ucb::CrossReference aInfo(
						pItem->GetGroup(), pItem->GetIndex() );

				pValues[ n ] = aInfo;
			}
			rVal <<= aValue;
			return TRUE;
		}

		default:
			break;
	}

	return FALSE;
}
