/*************************************************************************
 *
 *  $RCSfile: accessiblekeybindinghelper.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/24 17:27:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// includes --------------------------------------------------------------

#ifndef COMPHELPER_ACCESSIBLE_KEYBINDING_HELPER_HXX
#include <comphelper/accessiblekeybindinghelper.hxx>
#endif


//..............................................................................
namespace comphelper
{
//..............................................................................

	using namespace ::com::sun::star; // MT 04/2003: was ::drafts::com::sun::star - otherwise to many changes
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::accessibility;

	//==============================================================================
	// OAccessibleKeyBindingHelper
	//==============================================================================

	OAccessibleKeyBindingHelper::OAccessibleKeyBindingHelper()
	{
	}

	// -----------------------------------------------------------------------------
		
	OAccessibleKeyBindingHelper::OAccessibleKeyBindingHelper( const OAccessibleKeyBindingHelper& rHelper )
		:m_aKeyBindings( rHelper.m_aKeyBindings )
	{
	}

	// -----------------------------------------------------------------------------

	OAccessibleKeyBindingHelper::~OAccessibleKeyBindingHelper()
	{
	}

	// -----------------------------------------------------------------------------

	void OAccessibleKeyBindingHelper::AddKeyBinding( const Sequence< awt::KeyStroke >& rKeyBinding ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );

		m_aKeyBindings.push_back( rKeyBinding );
	}

	// -----------------------------------------------------------------------------

	void OAccessibleKeyBindingHelper::AddKeyBinding( const awt::KeyStroke& rKeyStroke ) throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );

		Sequence< awt::KeyStroke > aSeq(1);
		aSeq[0] = rKeyStroke;
		m_aKeyBindings.push_back( aSeq );
	}

	// -----------------------------------------------------------------------------
	// XAccessibleKeyBinding
	// -----------------------------------------------------------------------------

	sal_Int32 OAccessibleKeyBindingHelper::getAccessibleKeyBindingCount() throw (RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );

		return m_aKeyBindings.size();
	}

	// -----------------------------------------------------------------------------

	Sequence< awt::KeyStroke > OAccessibleKeyBindingHelper::getAccessibleKeyBinding( sal_Int32 nIndex ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		::osl::MutexGuard aGuard( m_aMutex );

		if ( nIndex < 0 || nIndex >= (sal_Int32)m_aKeyBindings.size() )
			throw IndexOutOfBoundsException();

		return m_aKeyBindings[nIndex];
	}

	// -----------------------------------------------------------------------------

//..............................................................................
}	// namespace comphelper
//..............................................................................
