/*************************************************************************
 *
 *  $RCSfile: dsntypes.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_DSNTYPES_HXX_
#include "dsntypes.hxx"
#endif
#ifndef _SVTOOLS_LOCALRESACCESS_HXX_
#include <svtools/localresaccess.hxx>
#endif
#ifndef _EXTENSIONS_DBIRESID_HRC_
#include "dbiresid.hrc"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SVTOOLS_LOCALRESACCESS_HXX_
#include <svtools/localresaccess.hxx>
#endif
#ifndef _EXTENSIONS_DBIRESID_HRC_
#include "dbiresid.hrc"
#endif
#ifndef _EXTENSIONS_COMPONENT_MODULE_HXX_
#include "componentmodule.hxx"
#endif
#ifndef _URLOBJ_HXX 
#include <tools/urlobj.hxx>
#endif
#ifndef _OSL_FILE_H_ 
#include <osl/file.h>
#endif


//.........................................................................
namespace dbi
{
//.........................................................................

	using namespace ::svt;
	//=====================================================================
	//= ODSNTypeInfo
	//=====================================================================
	//------------------------------------------------------------------------------
	ODSNTypeInfo::ODSNTypeInfo(sal_uInt16 _nLogical)
		:m_nLogical(_nLogical)
	{
	}

	//------------------------------------------------------------------------------
	ODSNTypeInfo::ODSNTypeInfo(const String& _rSdbDatabaseType)
		:m_nLogical(0)
	{
		if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("ODBC"))
			m_nLogical = RID_LOC_ODBC;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("DB2"))
			m_nLogical = RID_LOC_DB2;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("ORCL7"))
			m_nLogical = RID_LOC_ORACLE;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("DAO"))
			m_nLogical = RID_LOC_DAO;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("ADO"))
			m_nLogical = RID_LOC_ADO;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("StarBase"))
			m_nLogical = RID_LOC_OTERRO;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("ADABAS"))
			m_nLogical = RID_LOC_ADABAS;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("JDBC"))
			m_nLogical = RID_LOC_JDBC;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("DBF"))
			m_nLogical = RID_LOC_DBASE;
		else if (0 == _rSdbDatabaseType.CompareIgnoreCaseToAscii("TXT"))
			m_nLogical = RID_LOC_TEXT;
		else
		{
			// TODO: error handling
			DBG_ERROR("ODSNTypeInfo::ODSNTypeInfo: unknown type!");
		}
	}

	//------------------------------------------------------------------------------
	sal_Bool ODSNTypeInfo::isAvailable() const
	{
		switch (getId())
		{
			case TYPE_ADABAS:
			case TYPE_ODBC:
			case TYPE_DAO:
			case TYPE_ADO:
			case TYPE_JDBC:
			case TYPE_DBASE:
			case TYPE_TEXT:
				return sal_True;
		}

		return sal_False;
	}

	//------------------------------------------------------------------------------
	sal_Bool ODSNTypeInfo::isAvailableOnPlatform() const
	{
		switch (getId())
		{
#if defined( WIN ) || defined( WNT ) || ( defined( SOLARIS ) && defined( SPARC ) ) || defined( LINUX )
			case TYPE_ADABAS:
#endif
#if defined( WIN ) || defined( WNT )
			case TYPE_DAO:
			case TYPE_ADO:
#endif
			case TYPE_ODBC:
			case TYPE_JDBC:
			case TYPE_DBASE:
			case TYPE_TEXT:
				return sal_True;
		}

		return sal_False;
	}

	//------------------------------------------------------------------------------
	void ODSNTypeInfo::filterDSN(String& _rDSN)
	{
		switch (getId())
		{
			case TYPE_DAO:
			{
				String sTranslated(ModuleRes(RID_STR_DAODSNTRANSLATION));
				sTranslated.SearchAndReplaceAscii("$daodsn$", _rDSN);
				_rDSN = sTranslated;
			}
			break;
			case TYPE_ADABAS:
				if (STRING_NOTFOUND == _rDSN.Search(':'))
					_rDSN = (String::CreateFromAscii(":") += _rDSN);
				break;
			case TYPE_DBASE:
			case TYPE_TEXT:
			{
				_rDSN.SearchAndReplaceAscii("$(USER)", String::CreateFromAscii("$(USERURL)"));
				_rDSN.SearchAndReplaceAscii("$(INST)", String::CreateFromAscii("$(INSTURL)"));

				// check if it is a system path
				INetURLObject aParser( _rDSN );
				if ( INET_PROT_NOT_VALID == aParser.GetProtocol() )
				{
					::rtl::OUString sDSN( _rDSN );
					::rtl::OUString sURL;
					if ( osl_File_E_None == osl_getFileURLFromSystemPath( sDSN.pData, &sURL.pData ) )
					{
						_rDSN = sURL;
					}
					else
					{
						if ( _rDSN.Len() )
						{
							INetURLObject aSmartParser;
							aSmartParser.SetSmartProtocol( INET_PROT_FILE );
							if ( aSmartParser.SetSmartURL( _rDSN ) )
								_rDSN = aSmartParser.GetMainURL( INetURLObject::NO_DECODE );
						}
					}
				}
			}
			break;
		}
	}

	//------------------------------------------------------------------------------
	String ODSNTypeInfo::getURLPrefix() const
	{
		DBG_ASSERT(isAvailable(), "ODSNTypeInfo::getURLPrefix: can't translate this type!");
		String sPrefix;
		if (isAvailable())
		{
			ModuleRes aModuleRes(RID_RSC_DSTYPES_DSNPREFIX);
            OLocalResourceAccess aTypes(aModuleRes, RSC_RESOURCE);
			sPrefix = String(ResId(getId()));
		}
		return sPrefix;
	}

	//------------------------------------------------------------------------------
	String ODSNTypeInfo::getDisplayName() const
	{
		String sDisplayName;
		if (m_nLogical)
		{
			ModuleRes aModuleRes(RID_RSC_DATASOURCE_TYPES_DISPLAY);
            OLocalResourceAccess aTypes(aModuleRes, RSC_RESOURCE);
			sDisplayName = String(ResId(m_nLogical));
		}

		return sDisplayName;
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

