/*************************************************************************
 *
 *  $RCSfile: collator_icu.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 10:47:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <collator_icu.hxx>
#include <com/sun/star/i18n/CollatorOptions.hpp>
#include <unicode/locid.h>

using namespace ::com::sun::star;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::rtl;

namespace com { namespace sun { namespace star { namespace i18n {

Collator_ICU::Collator_ICU()
{
	implementationName = "com.sun.star.i18n.Collator_ICU";
	collator = NULL;
}

Collator_ICU::~Collator_ICU()
{
	if (collator) delete collator;
}

sal_Int32 SAL_CALL
Collator_ICU::compareString( const OUString& str1, const OUString& str2) throw(RuntimeException)
{
	return compareSubstring(str1, 0, str1.getLength(), str2, 0, str2.getLength());
}

sal_Int32 SAL_CALL
Collator_ICU::compareSubstring( const OUString& str1, sal_Int32 off1, sal_Int32 len1,
	const OUString& str2, sal_Int32 off2, sal_Int32 len2) throw(RuntimeException)
{
	if (collator) {
	    if (tranModules & TransliterationModules_IGNORE_KANA) {
		const OUString& s1 = ignore->transliterateString2String(str1, off1, len1);
		const OUString& s2 = ignore->transliterateString2String(str2, off2, len2);
		return collator->compare(s1.getStr(), s1.getLength(), s2.getStr(), s2.getLength());
	    }
	    else
		return collator->compare(str1.getStr() + off1, len1, str2.getStr() + off2, len2);
	}
	else
	    return Collator_Unicode::compareSubstring(str1, off1, len1, str2, off2, len2);
}


sal_Int32 SAL_CALL
Collator_ICU::loadCollatorAlgorithm(const OUString& rAlgorithm, const lang::Locale& rLocale, sal_Int32 options)
	throw(RuntimeException)
{
    //! The rAlgorithm parameter is not used here!
    // The pure algorithm name (no locale contained) has to be passed using
    // rLocale.Variant

	if (options & CollatorOptions::CollatorOptions_IGNORE_KANA) {
	    if (ignore == NULL)
		ignore = new ignoreKana();
	    tranModules = TransliterationModules_IGNORE_KANA;
	}
	else 
	    tranModules = TransliterationModules_END_OF_MODULE;

	// load ICU collator
	icu::Locale icuLocale(OUStringToOString(rLocale.Language, RTL_TEXTENCODING_ASCII_US).getStr(),
			OUStringToOString(rLocale.Country, RTL_TEXTENCODING_ASCII_US).getStr(),
			OUStringToOString(rLocale.Variant, RTL_TEXTENCODING_ASCII_US).getStr());
	if (collator)
	    delete collator;

	UErrorCode status = U_ZERO_ERROR;
	collator = icu::Collator::createInstance(icuLocale, status);
	if (! U_SUCCESS(status))
	    throw RuntimeException();

	if (options & CollatorOptions::CollatorOptions_IGNORE_CASE)
	    collator->setStrength(Collator::PRIMARY);
	else
	    collator->setStrength(Collator::TERTIARY);

	return(0);
}

sal_Int32 SAL_CALL
Collator_de_phonebook::loadCollatorAlgorithm(const OUString& rAlgorithm, const lang::Locale& rLocale, sal_Int32 options)
	throw(RuntimeException)
{
    /** ICU collators are loaded using a locale only.
        ICU uses Variant as phonebook collation algorithm name (de__PHONEBOOK
        locale), note the empty territory (Country) designator in this special
        case here. The icu::Locale contructor changes the algorithm name to
        uppercase itself, so we don't have to bother with that.
     */
	lang::Locale aLocale;
    sal_Int32 nPos = rAlgorithm.indexOf( '_' );
    if ( nPos < 0 )
    {   // algorithm name doesn't contain any locale information
        aLocale.Language = rLocale.Language;
        aLocale.Country = rLocale.Country;
	    aLocale.Variant = rAlgorithm;
    }
    else
    {
        aLocale.Language = rAlgorithm.copy( 0, nPos );
        sal_Int32 nSec = rAlgorithm.indexOf( '_', nPos+1 );
        if ( nPos < nSec )
        {   // language and territory in algorithm name
            aLocale.Country = rAlgorithm.copy( nPos+1, nSec-nPos-1 );
            nPos = nSec;
        }
        aLocale.Variant = rAlgorithm.copy( nPos+1 );
    }
    return Collator_ICU::loadCollatorAlgorithm(rAlgorithm, aLocale, options);
}

} } } }
