/*************************************************************************
 *
 *  $RCSfile: Singleton.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tra $ $Date: 2000/10/19 08:51:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SINGLETON_HXX_
#define _SINGLETON_HXX_


//------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------

#include <systools/win32/SyncObjects.hxx>

//------------------------------------------------------------------------
// defines
//------------------------------------------------------------------------

//------------------------------------------------------------------------
// deklarations
//------------------------------------------------------------------------

// TYPE  - the singleton class
// PARAM - an abitrary parameter
// LOCK  - a sync object
template< class TYPE, class PARAM, class LOCK >
class TSingleton
{
public:
	//---------------------------------------------------------
	// creates the one and only instance of the singleton
	// applying the double checked locking pattern to avoid
	// unneccessary locking ( Doug Schmidt )
	//---------------------------------------------------------
	
	static TYPE* createInstance( PARAM aParam /*= NULL*/ )
	{
		if ( NULL == s_pSingleton )
		{
			SyncObjLockGuard_t aGuard( &s_aLock );

			if ( NULL == s_pSingleton )
				s_pSingleton = new TYPE( aParam );
		}

		return s_pSingleton;
	}

	//----------------------------------------------------------
	// dtor
	// in many cases it may not be useful to make the dtor
	// public, but in this case it's ok
	// in other cases we may need an SingletonDestroyer or so
	//----------------------------------------------------------

	virtual ~TSingleton( ) 
	{ 
		s_pSingleton = NULL;
	}

private:
	//----------------------------------------------------------
	// constructor is protocted in order to force usage of the
	// create function
	//----------------------------------------------------------

	TSingleton( );

	//----------------------------------------------------------
	// prevent copy and assignement
	//----------------------------------------------------------

	TSingleton( const TSingleton& theOther );
	TSingleton& operator=( const TSingleton& theOther );

private:		
	static TYPE* s_pSingleton;
	static LOCK	 s_aLock;
};

// this way static members of templates have to be defined
template< class TYPE, class PARAM, class LOCK > TYPE* TSingleton< TYPE, PARAM, LOCK >::s_pSingleton = NULL;
template< class TYPE, class PARAM, class LOCK > LOCK  TSingleton< TYPE, PARAM, LOCK >::s_aLock;

#endif