/*************************************************************************
 *
 *  $RCSfile: sdlib.cxx,v $
 *
 *  $Revision: 1.31.106.2 $
 *
 *  last change: $Author: vg $ $Date: 2005/07/01 13:12:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#if SUPD <= 611
#include <svtools/libcall.hxx>
#endif

#include <tools/urlobj.hxx>
#include <so3/clsids.hxx>
#include <svx/svxids.hrc>
#include <svx/impgrf.hxx>
#include <svtools/inettype.hxx>

#ifndef _SFX_DOCFILT_HACK_HXX //autogen
#include <sfx2/docfilt.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_FCONTNR_HXX //autogen
#include <sfx2/fcontnr.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <sfx2/docfile.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SFXECODE_HXX //autogen
#include <svtools/sfxecode.hxx>
#endif
#ifndef _FILTER_CONFIG_ITEM_HXX_
#include <svtools/FilterConfigItem.hxx>
#endif
#ifndef _SOT_FORMATS_HXX //autogen
#include <sot/formats.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SFX_DOCFILT_HACK_HXX
#include <sfx2/docfilt.hxx>
#endif

#ifndef _COM_SUN_STAR_UTIL_XARCHIVER_HPP_
#include <com/sun/star/util/XArchiver.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
using namespace ::rtl;
using namespace ::com::sun::star;


#pragma hdrstop

#include "sddll.hxx"

#ifdef UNX
#define DLL_NAME SVLIBRARY( "sd" )
#else
#include "sddll0.hxx"         // wird durchs Makefile generiert
#endif

#include "docshell.hxx"
#include "grdocsh.hxx"
#include "res_bmp.hrc"
#include "strings.hrc"
#include "app.hrc"
#include "strmname.h"

#ifndef _OFF_RESID_HXX
#include <offmgr/resid.hxx>
#endif

#ifndef _OFF_OFAIDS_HRC
#include <offmgr/ofaids.hrc>
#endif

#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif

TYPEINIT1( SdModuleDummy, SfxModule );

SFX_IMPL_MODULE_LIB(Sd, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( DLL_NAME ) ) )

/*************************************************************************
|*
|* Impress-ObjectFactory registrieren
|*
\************************************************************************/

SFX_IMPL_OBJECTFACTORY_MOD(SdDrawDocShell, SFXOBJECTSHELL_STD_NORMAL, simpress,
						   SvGlobalName(SO3_SIMPRESS_CLASSID_60), Sd, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( DLL_NAME ) ) )
{
	SdDrawDocShell::Factory().SetCreateNewSlotId( SID_SD_AUTOPILOT );
	SdDrawDocShell::Factory().SetDocumentServiceName( OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.presentation.PresentationDocument" ) ) );
	SdDrawDocShell::Factory().GetFilterContainer()->SetDetectFilter( &SdDLL::DetectFilter );
}



/*************************************************************************
|*
|* Draw-ObjectFactory registrieren
|*
\************************************************************************/

SFX_IMPL_OBJECTFACTORY_MOD(SdGraphicDocShell, SFXOBJECTSHELL_STD_NORMAL, sdraw,
						   SvGlobalName(SO3_SDRAW_CLASSID_60), Sd, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( DLL_NAME ) ) )
{
	SdGraphicDocShell::Factory().SetDocumentServiceName( OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.drawing.DrawingDocument" ) ) );
	SdGraphicDocShell::Factory().GetFilterContainer()->SetDetectFilter( &SdDLL::DetectFilter );
}


/*************************************************************************
|*
|* Ctor
|* the ctor is called at the beginning of SfxApplication-subclass::Main()
|* do whatever you want, but no calls to Sd-DLL-code!
|*
\************************************************************************/

SdDLL::SdDLL()
{
}



/*************************************************************************
|*
|* Dtor
|* the dtor is called at the end of SfxApplication-subclass::Main()
|* do whatever you want, but no calls to Sd-DLL-code!
|*
\************************************************************************/

SdDLL::~SdDLL()
{
}



/*************************************************************************
|*
|* LibInit
|* method is called before Application::Execute()
|* do whatever you want, but no calls to Sd-DLL-code!
|*
\************************************************************************/

void SdDLL::LibInit()
{
	// in most cases you must initialize your document-factory here
	SfxApplication* pApp = SFX_APP();

	// create a dummy-module for Object-Factory-Pointer
	SfxObjectFactory *p1 = NULL;
	if(SvtModuleOptions().IsImpress())
	{
		SdDrawDocShell::RegisterFactory(SDT_SD_DOCFACTPRIO);
		p1 = &SdDrawDocShell::Factory();
	}

	SfxObjectFactory *p2 = NULL;
	if(SvtModuleOptions().IsDraw())
	{
		SdGraphicDocShell::RegisterFactory(SDT_SD_DOCFACTPRIO);
		p2 = &SdGraphicDocShell::Factory();
	}

    SD_MOD() = new SdModuleDummy( NULL, TRUE, p1, p2 );
}



/*************************************************************************
|*
|* LibExit
|* this method is called after Application::Execute()
|* do whatever you want, but no calls to Sd-DLL-code!
|*
\************************************************************************/

void SdDLL::LibExit()
{
	// Innerhalb von FreeLibSd wird Exit() gerufen
	FreeLibSd();

	// destroy the dummy-module with Object-Factory-Pointer
	DELETEZ( SD_MOD() );
}


/*************************************************************************
|*
|* Filter bestimmen
|* (wird fuer normales Laden eines Dokuments mit nClass == USHRT_MAX gerufen)
|*
\************************************************************************/

ULONG __EXPORT SdDLL::DetectFilter(SfxMedium& rMedium, const SfxFilter** pFilter,
						  SfxFilterFlags nMust, SfxFilterFlags nDont)
{
	ULONG nReturn = ERRCODE_ABORT;  // Erkennung fehlgeschlagen, Filter ungueltig
	BOOL bStorage = FALSE;

	if( *pFilter && (*pFilter)->GetFilterFlags() & SFX_FILTER_PACKED )
	{
		uno::Reference< lang::XMultiServiceFactory > xSMgr( ::comphelper::getProcessServiceFactory() );
		uno::Reference< util::XArchiver > xPacker( xSMgr->createInstance( OUString::createFromAscii( "com.sun.star.util.Archiver" ) ), uno::UNO_QUERY );
		if( xPacker.is() )
		{
			// extract extra data
			OUString aPath( rMedium.GetOrigURL() );
			OUString aExtraData( xPacker->getExtraData( aPath ) );
			const OUString aSig1= OUString::createFromAscii( "private:" );
			String aTmp;
			aTmp += sal_Unicode( '?' );
			aTmp += (*pFilter)->GetFilterContainer()->GetName();
			const OUString aSig2( aTmp );
			INT32 nIndex1 = aExtraData.indexOf( aSig1 );
			INT32 nIndex2 = aExtraData.indexOf( aSig2 );
			if( nIndex1 == 0 && nIndex2 != -1 )
				return ERRCODE_NONE;
		}
	}
	else if (rMedium.GetError() == SVSTREAM_OK)
	{
		if (rMedium.IsStorage())
		{
			bStorage = TRUE;
			// Storage
			SvStorage* pStorage = rMedium.GetStorage();
			if ( pStorage == NULL ) return ULONG_MAX;


			// Erkennung ueber contained streams (StarDraw 3.0)
			if( ( pStorage->IsContained( pStarDrawDoc ) && pStorage->IsStream( pStarDrawDoc ) )	||
				( pStorage->IsContained( pStarDrawDoc3 ) && pStorage->IsStream( pStarDrawDoc3 ) ) )
			{
				const SfxFilter* pFilt = NULL;
				SfxFilterMatcher& rMatcher = SFX_APP()->GetFilterMatcher();
				SfxFilterContainer *pDraw = rMatcher.GetContainer(
					                        UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "sdraw" ) ) ); // Name kennt ihr besser
				SfxFilterContainer *pImpr = rMatcher.GetContainer(
					                        UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "simpress" ) )); // dito
				ULONG nStorFmt = pStorage->GetFormat();
				if (*pFilter)
				{
					if ( (*pFilter)->GetFilterContainer() == pDraw)
					{
						if(SvtModuleOptions().IsDraw())
						{
							pFilt = pDraw->GetFilter4ClipBoardId( nStorFmt );
							nReturn = ERRCODE_SFX_FORCEQUIET;
						}
						else
						{
							pFilt = pImpr->GetFilter4ClipBoardId( nStorFmt );
							nReturn = ERRCODE_SFX_FORCEQUIET;
						}
					}
					else if ( (*pFilter)->GetFilterContainer() == pImpr)
					{
						if(SvtModuleOptions().IsImpress())
						{
							pFilt = pImpr->GetFilter4ClipBoardId( nStorFmt );
							nReturn = ERRCODE_SFX_FORCEQUIET;
						}
						else
						{
							pFilt = pDraw->GetFilter4ClipBoardId( nStorFmt );
							nReturn = ERRCODE_SFX_FORCEQUIET;
						}
					}
				}
				else if(SvtModuleOptions().IsImpress())
				{
					pFilt = pImpr->GetFilter4ClipBoardId( nStorFmt );
					nReturn = ERRCODE_NONE;
				}
				else if(SvtModuleOptions().IsDraw())
				{
					pFilt = pDraw->GetFilter4ClipBoardId( nStorFmt );
					nReturn = ERRCODE_NONE;
				}

				if (pFilt &&
					(pFilt->GetFilterFlags() & nMust) == nMust &&
					(pFilt->GetFilterFlags() & nDont) == 0)
				{
					*pFilter = pFilt;
				}
				else
				{
					*pFilter = NULL;
					nReturn = ERRCODE_NONE;
				}
			}
			else if(SvtModuleOptions().IsImpress())
			{
				// Erkennung ueber contained streams (PowerPoint 97-Filter)
				String aStreamName = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "PowerPoint Document" ) );

				if (pStorage->IsContained( aStreamName ) &&	pStorage->IsStream( aStreamName ) )
				{
					String aFileName(rMedium.GetName());
					aFileName.ToUpperAscii();

					if( aFileName.SearchAscii( ".POT" ) == STRING_NOTFOUND )
						*pFilter = SFX_APP()->GetFilter(SdDrawDocShell::Factory(), pFilterPowerPoint97);
					else
						*pFilter = SFX_APP()->GetFilter(SdDrawDocShell::Factory(), pFilterPowerPoint97Template);

					return ERRCODE_NONE;
				}
			}
		}

		// XML filter(s)
		if( *pFilter )
		{
			::rtl::OUString aName = (*pFilter)->GetFilterName();

			bool bOOoDrawXML = false;
			bool bOOoImpressXML = false;
			bool bOasisDrawXML = false;
			bool bOasisImpressXML = false;

			if(	aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("StarOffice XML (Draw)")) ||		// application/vnd.sun.xml.draw
				aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("draw_StarOffice_XML_Impress")) ||
				aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("draw_StarOffice_XML_Draw_Template")) ||
				aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("draw_StarOffice_XML_Draw")) )
			{
				bOOoDrawXML = true;
			}
			else if( aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("StarOffice XML (Impress)")) ||	// application/vnd.sun.xml.impress
					aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("impress_StarOffice_XML_Impress_Template")) ||
					aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("impress_StarOffice_XML_Draw")) ||
					aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("impress_StarOffice_XML_Impress") ) )
			{
				bOOoImpressXML = true;
			}
			else if(	aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("impress8")) ||		// application/vnd.oasis.opendocument.presentation
						aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("impress8_template")) ||	// application/vnd.oasis.opendocument.presentation-template
						aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("impress8_draw")) )
			{
				bOasisImpressXML = true;
			}
			else if( 	aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("draw8")) ||			// application/vnd.oasis.opendocument.graphics
						aName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("draw8_template")) )	// application/vnd.oasis.opendocument.graphics-template
			{
				bOasisDrawXML = true;
			}
			
			if( bOOoDrawXML || bOOoImpressXML || bOasisImpressXML || bOasisDrawXML )
			{
				if( rMedium.IsStorage() )
				{
					SvStorage* pStorage = rMedium.GetStorage();


					nReturn = ERRCODE_ABORT;

					if( pStorage && ( pStorage->IsStream( pStarDrawXMLContent ) || pStorage->IsStream( pStarDrawOldXMLContent ) ) )
					{
						const ULONG nStorageFormat = pStorage->GetFormat();
						if(	nStorageFormat == 0 ||
							nStorageFormat == SOT_FORMATSTR_ID_STARIMPRESS_60 ||
							nStorageFormat == SOT_FORMATSTR_ID_STARDRAW_60  )
						{

							String aPropName( RTL_CONSTASCII_USTRINGPARAM( "MediaType" ) );
							::com::sun::star::uno::Any aValue;
							rtl::OUString aMediaType;
							BOOL bRet = pStorage->GetProperty( aPropName, aValue );
							if( bRet && (aValue >>= aMediaType ) )
							{
								if( 
									(bOOoDrawXML && aMediaType.matchAsciiL( RTL_CONSTASCII_STRINGPARAM( "application/vnd.sun.xml.draw" ) ) ) ||
									(bOOoImpressXML && aMediaType.matchAsciiL( RTL_CONSTASCII_STRINGPARAM( "application/vnd.sun.xml.impress" ) ) ) ||
									(bOasisImpressXML && aMediaType.matchAsciiL( RTL_CONSTASCII_STRINGPARAM( "application/vnd.oasis.opendocument.presentation" ) ) ) ||
									(bOasisDrawXML && aMediaType.matchAsciiL( RTL_CONSTASCII_STRINGPARAM( "application/vnd.oasis.opendocument.graphics" ) ) ) )
								{
									nReturn = ERRCODE_NONE;
								}	
							}
							else
							{
								// should not happen but play safe here
								nReturn = ERRCODE_NONE;
							}
						}
					}
				}
			}
		}

		String aFileName(rMedium.GetName());
		aFileName.ToUpperAscii();

		if (nReturn == ERRCODE_ABORT)
		{
			if( bStorage )         // aber keine Clipboard-Id #55337#
			{
				*pFilter = NULL;
			}
			else
			{
				// Vektorgraphik?
				SvStream* pStm = rMedium.GetInStream();

				if( !pStm )
					nReturn = ERRCODE_IO_GENERAL;
				else
				{
					pStm->Seek( STREAM_SEEK_TO_BEGIN );

					const String		aFileName( rMedium.GetURLObject().GetMainURL( INetURLObject::NO_DECODE ) );
					GraphicDescriptor	aDesc( *pStm, &aFileName );
					GraphicFilter*		pGrfFilter = GetGrfFilter();

					if( !aDesc.Detect( FALSE ) )
					{
						*pFilter = NULL;
						nReturn = ERRCODE_ABORT;
						INetURLObject aURL( aFileName );
						if( aURL.getExtension().EqualsIgnoreCaseAscii( "cgm" ) )
						{
							sal_uInt8 n8;
							pStm->Seek( STREAM_SEEK_TO_BEGIN );
							*pStm >> n8;
							if ( ( n8 & 0xf0 ) == 0 )		// we are supporting binary cgm format only, so
							{								// this is a small test to exclude cgm text
								const String aName = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "CGM - Computer Graphics Metafile" ) );
								*pFilter = SFX_APP()->GetFilter( SdDrawDocShell::Factory(), aName );
								nReturn = ERRCODE_NONE;
							}
						}
					}
					else
					{
						if( SvtModuleOptions().IsDraw() )
						{
							String aShortName( aDesc.GetImportFormatShortName( aDesc.GetFileFormat() ) );
							const String aName( pGrfFilter->GetImportFormatTypeName( pGrfFilter->GetImportFormatNumberForShortName( aShortName ) ) );

                            if ( *pFilter && aShortName.EqualsIgnoreCaseAscii( "PCD" ) )    // there is a multiple pcd selection possible
                            {
                                sal_Int32 nBase = 2;    // default Base0
                                String aFilterTypeName( (*pFilter)->GetRealTypeName() );
                                if ( aFilterTypeName.CompareToAscii( "pcd_Photo_CD_Base4" ) == COMPARE_EQUAL )
                                    nBase = 1;
                                else if ( aFilterTypeName.CompareToAscii( "pcd_Photo_CD_Base16" ) == COMPARE_EQUAL )
                                    nBase = 0;
		                        String aFilterConfigPath( RTL_CONSTASCII_USTRINGPARAM( "Office.Common/Filter/Graphic/Import/PCD" ) );
                                FilterConfigItem aFilterConfigItem( aFilterConfigPath );
                                aFilterConfigItem.WriteInt32( String( RTL_CONSTASCII_USTRINGPARAM( "Resolution" ) ), nBase );
                            }

							*pFilter = SFX_APP()->GetFilter( SdGraphicDocShell::Factory(), aName );
							nReturn = ERRCODE_NONE;
						}
						else
						{
							nReturn = ERRCODE_ABORT;
							*pFilter = NULL;
						}
					}
				}
			}
		}
	}
	else
	{
		nReturn = rMedium.GetError();
	}

	return nReturn;
}



/*************************************************************************
|*
|* Modul laden
|*
\************************************************************************/

SfxModule* SdModuleDummy::Load()
{
	return (LoadLibSd() ? SD_MOD() : NULL);
}




/*************************************************************************
|*
|* GetID(), ID zu einer Fileformat-Version liefern
|*
\************************************************************************/

SvGlobalName SdModuleDummy::GetID(USHORT nFileFormat)
{
	SvGlobalName aName;

	switch (nFileFormat)
	{
		case SOFFICE_FILEFORMAT_60:
		{
			aName = SvGlobalName(SO3_SIMPRESS_CLASSID_60);
		}
		break;

		case SOFFICE_FILEFORMAT_50:
		{
			aName = SvGlobalName(SO3_SIMPRESS_CLASSID_50);
		}
		break;

		case SOFFICE_FILEFORMAT_40:
		{
			aName = SvGlobalName(SO3_SIMPRESS_CLASSID_40);
		}
		break;

		case SOFFICE_FILEFORMAT_31:
		{
			aName = SvGlobalName(SO3_SIMPRESS_CLASSID_30);
		}
		break;

		default:
		{
			DBG_ASSERT(FALSE, "Unbekanntes Fileformat!");
		}
		break;
	}

	return aName;
}


/*************************************************************************
|*
|* HasID(), zu einer ID die Fileformat-Version liefern
|*
\************************************************************************/

USHORT SdModuleDummy::HasID(const SvGlobalName& rName)
{
	USHORT nRet = 0;

	if (GetID(SOFFICE_FILEFORMAT_31) == rName)
	{
		// Draw 3.1
		nRet = SOFFICE_FILEFORMAT_31;
	}
	else if (GetID(SOFFICE_FILEFORMAT_40) == rName)
	{
		// Impress 4.0
		nRet = SOFFICE_FILEFORMAT_40;
	}
	else if (GetID(SOFFICE_FILEFORMAT_50) == rName)
	{
		// Impress 5.0
		nRet = SOFFICE_FILEFORMAT_50;
	}
	else if (SvGlobalName(SO3_SDRAW_CLASSID_50) == rName)
	{
		// Draw 5.0
		nRet = SOFFICE_FILEFORMAT_50;
	}
	else if (GetID(SOFFICE_FILEFORMAT_60) == rName)
	{
		// Impress 6.0
		nRet = SOFFICE_FILEFORMAT_60;
	}
	else if (SvGlobalName(SO3_SDRAW_CLASSID_60) == rName)
	{
		// Draw 6.0
		nRet = SOFFICE_FILEFORMAT_60;
	}

	return(nRet);
}
