/*************************************************************************
 *
 *  $RCSfile: install.cxx,v $
 *
 *  $Revision: 1.49.34.3.2.2 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/16 14:50:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#include "agenda.hxx"

#include "action.hxx"
#include "webaction.hxx"

#include "script.hxx"
#include "fields.hxx"
#include "os.hxx"
#include "zipfile.hxx"
#include "sihelp.hxx"

#include "service.hxx"

#ifndef _L2TXTENC_HXX
#include <tools/l2txtenc.hxx>
#endif

///////////////////////////////////////////////////////////////////////////////
//
//		Install SiFile
//

void SiAgenda::AddAllInstalledHelpFiles(SiDoneList& aDoneList, SiCompiledScript& rCS, SiModule* pMod)
{
	const SiFileList& rFileList = pMod->GetFileList();
	for( USHORT i = 0; i < rFileList.Count(); i++ )
	{
		SiFile* pFile = rFileList.GetObject(i);
		if( pFile->IsHelpFile() && pMod->IsInstalled() )
			Install( pFile, aDoneList, rCS );
	}
	SiModuleList const* pModuleList = pMod->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		AddAllInstalledHelpFiles( aDoneList, rCS, pModuleList->GetObject(x) );
}

// ----------------------------------------------------------------------------

void SiAgenda::DoCompleteHelpReorg(SiFile *pFile, SiDoneList& aDoneList, SiCompiledScript& rCS)
{
	SiDirEntry aSHelpDAT( GetDestDir(pFile) );
	SiDirEntry aSHelpDIR;

	aSHelpDAT += pFile->GetName();
	aSHelpDAT.ToAbs();

	aSHelpDIR = aSHelpDAT;
	aSHelpDIR.SetExtension(UniString::CreateFromAscii("DIR"));
	aSHelpDAT.SetExtension(UniString::CreateFromAscii("DAT"));

	if( !aSHelpDIR.Exists() || !aSHelpDAT.Exists() )
	{
		m_bCompleteHelpReorg = TRUE;
		AddAllInstalledHelpFiles( aDoneList, rCS, rCS.GetRootModule() );

		aSHelpDIR.Kill();
		aSHelpDAT.Kill();
	}
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::AddHelpFileList(SiFile* pFile, BOOL bInsert)
{
	if( !pFile->IsHelpFile() )
		return FALSE;

	ByteString aExtension( pFile->GetName().Copy( pFile->GetName().Len()-3, 3) );
	if( aExtension.CompareIgnoreCaseToAscii("DAT") == COMPARE_EQUAL )
	{
		HelpFileEntry* pNew = new HelpFileEntry;
		pNew->pFile = pFile;
		pNew->bInsert = bInsert;

		m_HelpFileList.Insert( pNew );
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::InstallShortcut( SiFile *pFile )
{
	const SiShortcutList* pLst = pFile->GetShortcutList();

	for( USHORT i = 0; i < pLst->Count(); ++i )
	{
		SiShortcut* pSCut = pLst->GetObject(i);
		ByteString aSName( pSCut->GetName() );

		BOOL bNetwork = pSCut->RunAtNetwork();
        BOOL bStandalone = pSCut->RunAtStandalone();
        BOOL bWorkstation = pSCut->RunAtWorkstation();

        if ( !bWorkstation )
            bStandalone = TRUE;

		if( (GetInstallMode() == IM_STANDALONE  && bStandalone) ||
			(GetInstallMode() == IM_PATCH       && bStandalone)	||
			(GetInstallMode() == IM_NETWORK     && bNetwork)    ||
			(GetInstallMode() == IM_APPSERVER   && bNetwork)    ||
			(GetInstallMode() == IM_WORKSTATION && bWorkstation) )
		{
			if( !m_bWebMode )
			{
				ByteString aDName = pSCut->GetFile()?
									pSCut->GetFile()->GetName() :
									pSCut->GetShortcut()->GetName();


				#ifdef WNT
				if( !pSCut->GetFile() )
					aDName += ".lnk";
				aSName += ".lnk";
				#endif

				SiDirEntry aSource( m_pEnv->GetProgPath(GetInstallMode()) );
				SiDirEntry aDestination( m_pEnv->GetDestPath() );

				aDestination += pSCut->GetDirectory()->GetName();
				aDestination += aSName;
				aDestination.ToAbs();

                if( pSCut->GetFile() )
                    aSource += GetDestDir(pFile);
                else
                    aSource += pSCut->GetShortcut()->GetDirectory()->GetName();

                aSource += aDName;
                aSource.ToAbs();

                // relative links don't work well with windows
#ifndef WNT
                if( pSCut->IsRelative() )
                {
					aSource.ToRel( aDestination );
                    // because ToRel might change the writing ( case ) of the name, we have to set the 
                    // name again.
                    aSource.SetName( UniString( aDName, osl_getThreadTextEncoding() ) );
                }
#endif
                UniString aIconFileStr;
                UniString aWorkDirStr;
                UniString aParameter = UniString( pSCut->GetParameter(), osl_getThreadTextEncoding() );
                UniString aDescription = UniString( pSCut->GetDescription(), osl_getThreadTextEncoding() );

                if ( pSCut->GetIconFile() )
                {
                    SiDirEntry aIconFile = m_pEnv->GetProgPath( GetInstallMode() );
                    aIconFile += pSCut->GetIconFile()->GetDirectory()->GetName();
                    aIconFile += pSCut->GetIconFile()->GetName();
                    aIconFile.ToAbs();
                    aIconFileStr = aIconFile.GetFullUni();
                }

                if ( pSCut->GetWorkDir() )
                {
                    SiDirEntry aWorkDir = m_pEnv->GetProgPath( GetInstallMode() );
                    aWorkDir += pSCut->GetWorkDir()->GetName();
                    aWorkDir.ToAbs();
                    aWorkDirStr = aWorkDir.GetFullUni();
                }

				Add( new SiShortcutAction(this, aSource.GetFull(), aDestination.GetFull(),
                                          aParameter, aDescription, aWorkDirStr,
                                          aIconFileStr, pSCut->GetIconIndex() ) );
			}
			else
			{
				char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';

				UniString aSource = UniString( GetDestDir(pFile, TRUE), osl_getThreadTextEncoding() );
				aSource += cOSDelim;
				aSource += UniString( pFile->GetName(), osl_getThreadTextEncoding() );

				UniString aDestination = UniString( pSCut->GetDirectory()->GetWebName(), osl_getThreadTextEncoding() );
				aDestination += cOSDelim;
				aDestination += UniString( aSName, osl_getThreadTextEncoding() );

				#ifdef UNX
				aSource.SearchAndReplaceAll( '/', cOSDelim );
				aDestination.SearchAndReplaceAll( '/', cOSDelim );
				#else
				aSource.SearchAndReplaceAll( '\\', cOSDelim );
				aDestination.SearchAndReplaceAll( '/', cOSDelim );
				#endif

				SiWebMakeShortcutAction* pNew = new SiWebMakeShortcutAction( this,
											aSource,
											aDestination,
											UniString::CreateFromAscii(""),
											UniString::CreateFromAscii("") );
				Add( pNew );
			}
		}
	}

	return TRUE;
}

BOOL SiAgenda::Install(SiFile *pFile, SiDoneList& aDoneList, SiCompiledScript& rCS )
{
	if( !pFile->GetPackedName().Len() || pFile->DontInstall() ) return TRUE;

	if( m_bWebMode ) return InstallWeb( pFile, aDoneList, rCS );
	if( m_pEnv->IsInUpdate() && pFile->IsNoUpdate() ) return TRUE;

	SiInstallMode aInstMode = GetInstallMode();

	if( InstallFromNet() && pFile->IsCompHelpFile() &&
		aInstMode != IM_STANDALONE )
		return TRUE;

    SiDirectory* pDir;
	if ( ( GetInstallMode() == IM_NETWORK ) || ( GetOldInstallMode() == IM_NETWORK ) )
		pDir = (SiDirectory*) pFile->GetNetDirectory();
	else
		pDir = (SiDirectory*) pFile->GetDirectory();

	SiDirectory* pDirLangRef = (SiDirectory*) pDir->GetLangRef( pFile->GetLanguage() );
	if( pDirLangRef )
		pDirLangRef->JoinWithParent();

	if( pFile->IsWebOnly() ) return TRUE;
	if( pFile->DeleteOnly() )
	{
		if( GetInstallMode() == IM_PATCH )
			Uninstall( pFile, aDoneList );
		return TRUE;
	}

	if( pFile->IsAgentLoader() || pFile->IsProcessGuard() )
		return TRUE;

	if( (m_pEnv->IsUpdateOldVersion() || m_pEnv->IsUpgradeOldVersion()) &&
		(pFile->GetName().CompareIgnoreCaseToAscii("so5dbt.dll") == COMPARE_EQUAL) )
		return TRUE;

	if( aInstMode == IM_WORKSTATION		&&
		!pFile->InstallOnWorkstation()	&&
		!pFile->IsWorkstationOnly()		&&
		!pFile->IsFont() )
	{
		InstallShortcut( pFile );
		return TRUE;
	}
	else
	if( aInstMode == IM_WORKSTATION		&&
		m_pEnv->IsAutoWorkstation()		&&
		pFile->GetBlankNetDirectory() )
		return TRUE;
	else
	if( pFile->IsWorkstationOnly()		&&
		aInstMode != IM_WORKSTATION		&&
		aInstMode != IM_NETWORK )
		return TRUE;

	if( DoRecoverOnly() )
		if( pFile->IsDontRecover() ) // #57951# || pFile->IsSetupZip() )
			return TRUE;
		else if( pFile->IsCompHelpFile() )
		{
			DoCompleteHelpReorg( pFile, aDoneList, rCS );
			return TRUE;
		}
		else if( pFile->IsHelpFile() && !m_bCompleteHelpReorg )
		{
			if( pFile->GetName().Len() < 3 )
				return TRUE;
			ByteString aExtension( pFile->GetName().Copy(pFile->GetName().Len() - 3) );
			if( aExtension.CompareIgnoreCaseToAscii( "SVH" ) != COMPARE_EQUAL )
				return TRUE;
		}

	if( aDoneList.Find(pFile->GetID()) != 0 )
		return TRUE;
	else
		aDoneList.Insert( pFile->GetID(), 1 );

	ByteString aSourceDir	= GetSourceDir(pFile);
	ByteString aDestDir	 	= GetDestDir(pFile);

	if( InstallLocal() && pFile->IsFont() )
	{
#ifdef WNT
        static BOOL bCreatedFolder = FALSE;

        if ( !OS::MayInstallFonts() )
            if ( m_pEnv->GetInstallMode() == IM_WORKSTATION )
                return TRUE;
            else
            {
                aDestDir = m_pEnv->GetDestPath();
                aDestDir += ByteString( LOCAL_FONT_PATH );

                if ( !bCreatedFolder )
                {
                    bCreatedFolder = TRUE;
                    Add( new SiMakeDirAction(this, aDestDir) );
                }
            }
        else
            aDestDir = OS::GetSystemFontPath();
#else
#ifdef UNX
        SiDirEntry aFontDir( m_pEnv->GetDestPath() );
        aFontDir += aDestDir;
        aFontDir.ToAbs();
        UnixOS::ExportFontPath( aFontDir.GetFull() );
#else
        aDestDir = OS::GetSystemFontPath();
#endif
#endif
		#ifdef MAC
		if (OS::IsFontInstalled(pFile->GetName(),pFile->GetFontName()))
			return TRUE;
		#endif
	}

	SiAction* pBaseAction = NULL;
	if( !InstallFromNet() && pFile->GetPartList().Count() != 0 )
	{
		pBaseAction = InstallMultiVolumeFile(pFile);
	}
	else if( aInstMode == IM_WORKSTATION &&
			 pFile->IsSoftLinkPrefered() && !pFile->IsArchive() )
	{
		Add(new SiUnixCreateSoftLinkAction(
					this,
					aSourceDir,
					pFile->GetName(),
					aDestDir));
	}
	else if( pFile->IsPacked() && !InstallFromNet() &&
             ( !pFile->IsSetupZip() || pFile->IsArchive() || DoRecoverOnly() ) )
	{
		AddHelpFileList(pFile, TRUE);
		SiUnzipAction *pUnzipAction = new SiUnzipAction(
					this,
					pFile->GetDataCarrier(),
					pFile->GetDataCarrier()->GetArchive(),
					aSourceDir,
					pFile->GetPackedName(),
					aDestDir,
					pFile->GetName(),
					pFile->GetDate(),
					pFile->GetTime(),
					pFile->GetFlags(),
					pFile->GetUnixRights(),
					pFile,
					pFile->GetOs2Creator() );
		Add(pUnzipAction);

		if( pFile->IsArchive() )
			m_lBytesToUnzip += (ULONG)pFile->GetArchiveSize();
		else
			m_lBytesToUnzip += (ULONG)pFile->GetSize();

		pBaseAction = pUnzipAction;
	}
	else
	{
		Install( pDirLangRef? pDirLangRef : pDir, aDoneList );

		if( !pFile->IsArchive() )
		{
			if( m_pEnv->GetInstallType() == IT_CHANGE && pFile->IsSetupZip() )
			{
				SiUnzipAction *pUnzipAction = new SiUnzipAction(
						this,
						pFile->GetDataCarrier(),
						pFile->GetDataCarrier()->GetArchive(),
						aSourceDir,
						pFile->GetPackedName(),
						aDestDir,
						pFile->GetName(),
						pFile->GetDate(),
						pFile->GetTime(),
						pFile->GetFlags(),
						pFile->GetUnixRights(),
						pFile,
						pFile->GetOs2Creator() );
				Add(pUnzipAction);
			}
			else
			{
				if( InstallFromNet() && GetInstallMode() == IM_STANDALONE &&
					pFile->IsCompHelpFile() )
				{
					ByteString aDAT( pFile->GetName() );
					ByteString aDIR( pFile->GetName() );
					aDAT += ".dat";
					aDIR += ".dir";

					Add( new SiCopyAction(this, pFile->GetDataCarrier(), aSourceDir,
						aDAT, aDestDir, aDAT, pFile->GetDate(), pFile->GetTime(), pFile->GetFlags(),
						pFile->GetUnixRights(), pFile, pFile->GetOs2Creator()) );

					Add( new SiCopyAction(this, pFile->GetDataCarrier(), aSourceDir,
						aDIR, aDestDir, aDIR, pFile->GetDate(), pFile->GetTime(), pFile->GetFlags(),
						pFile->GetUnixRights(), pFile, pFile->GetOs2Creator()) );


					SiDirEntry aEntry( m_pEnv->GetSourcePath() );
					aEntry += aSourceDir;
					aEntry += aDAT;
					aEntry.ToAbs();

					FileStat aStat(aEntry);
					m_lBytesToCopy += aStat.GetSize();

					aEntry = m_pEnv->GetSourcePath();
					aEntry += aSourceDir;
					aEntry += aDIR;
					aEntry.ToAbs();

					aStat = aEntry;
					m_lBytesToCopy += aStat.GetSize();
				}
				else
				{
					if( pFile->IsCompHelpFile() )
						return TRUE;

					if( InstallFromNet() && GetInstallMode() == IM_STANDALONE &&
						pFile->IsHelpFile() )
					{
						ByteString aExtension( pFile->GetName().Copy( pFile->GetName().Len()-3, 3) );
						if( aExtension.CompareIgnoreCaseToAscii("SVH") != COMPARE_EQUAL )
							return TRUE;
					}
					else
						AddHelpFileList(pFile, TRUE);

					SiCopyAction *pCopyAction
						= new SiCopyAction(
								this,
								pFile->GetDataCarrier(),
								aSourceDir,
								GetSourceName(pFile),
								aDestDir,
								pFile->GetName(),
								pFile->GetDate(),
								pFile->GetTime(),
								pFile->GetFlags(),
								pFile->GetUnixRights(),
								pFile,
								pFile->GetOs2Creator());
					Add(pCopyAction);
					pBaseAction = pCopyAction;
				}
			}
		}
		else
		{
			char cSysDelim = (char)SiDirEntry::GetAccessDelimiter().GetChar(0);

			for (USHORT i=0; i<pFile->GetSubfileList().Count(); i++)
			{
				ByteString  	aFile = (pFile->GetSubfileList().GetObject(i))->aFilename;
				SiDirEntry	aEntry(aDestDir);

				aEntry += aFile;
				ByteString aFullFileName = aEntry.GetFull();

				if( aFile.Len() &&
					aFile.GetChar(aFile.Len()-1) == cSysDelim ||
					aFile.GetChar(aFile.Len()-1) == '/' )
				{
				#ifdef MAC
					aFullFileName.Erase( aFullFileName.Len() - 1 );
				#endif
					Add(new SiMakeDirAction(this, aFullFileName));
				}
				else
				{
					USHORT nPos = aFullFileName.Len() - 1;
					while( nPos > 0 && aFullFileName.GetChar(nPos) != cSysDelim )
						--nPos;
					ByteString aCopy = aFullFileName.Copy( 0, nPos );
					if( aFullFileName.Len() ) {
						Add(new SiMakeDirAction(this, aCopy));
					}

					if( pFile->IsSoftLinkPrefered() )
						Add(new SiUnixCreateSoftLinkAction(
								this,
								aSourceDir,
								aFile,
								aDestDir));
					else
							Add(new SiCopyAction(
								this,
								pFile->GetDataCarrier(),
								aSourceDir,
								aFile,
								aDestDir,
								aFile,
								pFile->GetDate(),
								pFile->GetTime(),
								pFile->GetFlags(),
								pFile->GetUnixRights(),
								pFile,
								pFile->GetOs2Creator()));
				}
			}
		}
		if( pFile->IsArchive() )
			m_lBytesToCopy += (ULONG)pFile->GetArchiveSize();
		else
			m_lBytesToCopy += (ULONG)pFile->GetSize();
	}

	if( pFile->IsActiveX() ) Add( new SiActiveXAction(this, pFile, TRUE) );

    if( pFile->IsFont() && InstallLocal() && OS::MayInstallFonts() )
	{
		ByteString aFontFilename = pFile->GetName();

		if( OS::IsFontInstalled(pFile->GetName(), pFile->GetFontName()) && !pFile->IsFontWarnIfExists() )
		{
			SiUninstallFontAction *pAction = new SiUninstallFontAction(
						this, pFile->GetFontName(), aFontFilename );
			Add( pAction );
			pAction->SetDependence( pBaseAction );
		}

		SiInstallFontAction *pAction = new SiInstallFontAction(
					this, pFile->GetFontName(), aFontFilename );
		Add(pAction);
		pAction->SetDependence(pBaseAction);
	}

	if (pFile->GetOs2EAFile() != NULL)
	{
		SiOs2JoinEAsAction *pAction
			= new SiOs2JoinEAsAction(this,
					aDestDir,
					pFile->GetName(),
					GetDestDir(pFile->GetOs2EAFile()),
					pFile->GetOs2EAFile()->GetName());

		Add(pAction);
		pAction->SetDependence(pBaseAction);
	}

	if( InstallLocal() && pFile->GetMacCreator().Len() != 0 )
	{
		Add (new SiMacAddApplicationAction(this,
					aDestDir,
					pFile->GetName(),
					pFile->GetMacCreator()));
	}

	InstallShortcut( pFile );

	if( !Install(pDirLangRef? pDirLangRef : pDir, aDoneList) )
		return FALSE;

	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::InstallWeb(SiFile *pFile, SiDoneList& aDoneList, SiCompiledScript& rCS )
{
	if( pFile->DeleteOnly() || pFile->IsNoWeb() )
		return TRUE;
	if( m_pEnv->IsInUpdate() && pFile->IsNoUpdate() ) return TRUE;

	char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';

	SiDirectory* pDir			= (SiDirectory*) pFile->GetDirectory();
	SiDirectory* pDirLangRef	= (SiDirectory*) pDir->GetLangRef( pFile->GetLanguage() );
	if( pDirLangRef )
		pDirLangRef->JoinWithParent();

	pDir = pDirLangRef? pDirLangRef : pDir;

	UniString aFilename( pFile->GetPackedName(), osl_getThreadTextEncoding() );
	UniString aPattern ( UniString::CreateFromAscii("*") );

	com::sun::star::util::DateTime aDateTime;
	if( pFile->IsNoTimeStamp() )
		aDateTime = com::sun::star::util::DateTime( 0, 0, 0, 0, 17, 2, 1969 );
	else
		aDateTime = com::sun::star::util::DateTime( 0, pFile->GetTime().GetSec(), pFile->GetTime().GetMin(),
					pFile->GetTime().GetHour(), pFile->GetDate().GetDay(), pFile->GetDate().GetMonth(),
					pFile->GetDate().GetYear() );

	if( pFile->IsSetupZip() )
	{
		const SiSlideList& rLst = rCS.GetSlideList();
		for( USHORT xx = 0; xx < rLst.Count(); ++xx )
			if( rLst.GetObject(xx)->GetBmpFileName().CompareIgnoreCaseToAscii(pFile->GetName()) == COMPARE_EQUAL )
				return TRUE;
	}

	if( !pFile->IsPacked() )
	{
		aFilename = UniString( pFile->GetName(), osl_getThreadTextEncoding() );
		UniString aDestination( pDir->GetWebName(), osl_getThreadTextEncoding() );
		aDestination += cOSDelim;
		aDestination += aFilename;

		if( m_bSwitchMode  ) ((SiWebAgenda*)this)->_addDownload( pFile, aDoneList );

		SiWebCopyFileAction* pNew = new SiWebCopyFileAction( this,
										aFilename,
										aDestination,
										aDateTime,
										pFile->GetUnixRights(),
										pFile->IsUnoComponent(),
										pFile->IsActiveX() );

		Add( pNew );
		return TRUE;
	}


	UniString aSubFile;
	if( pDir->IsSystemObject() || pDir->IsThisSystem() )
	{
		aSubFile = '<';
		aSubFile += UniString( pDir->GetID(), osl_getThreadTextEncoding() );
		aSubFile += '>';
	}
	else
		aSubFile = UniString( pDir->GetWebName(), osl_getThreadTextEncoding() );

	#ifdef UNX
	aSubFile.SearchAndReplaceAll( '/', cOSDelim );
	#else
	aSubFile.SearchAndReplaceAll( '\\', cOSDelim );
	#endif

	if( m_bSwitchMode  ) ((SiWebAgenda*)this)->_addDownload( pFile, aDoneList );

	SiWebUnzipAction* pNew = new SiWebUnzipAction( this,
								aFilename,
								aSubFile,
								aPattern,
								aDateTime,
								pFile->GetUnixRights(),
								pFile->IsUnoComponent(),
								pFile->IsActiveX() );

	aSubFile += cOSDelim;
	if( !pFile->IsArchive() )
	{
		aSubFile += UniString(pFile->GetName(), osl_getThreadTextEncoding());
		pNew->AddSubFile( aSubFile );
	}
	else
	{
		const SiSubfileList& rProofLst = pFile->GetSubfileList();
		if( !rProofLst.Count() )
		{
			SiDirEntry aEntry( ((SiWebAgenda*)this)->GetCachedConfig()->aScriptLocation );

			SiDirEntry temp = aEntry.GetPath();
			ByteString aSourceStr( temp.GetFull() );
			#ifdef UNX
			aSourceStr += '/';
			#else
			aSourceStr += '\\';
			#endif
			aSourceStr += pFile->GetPackedName();

			SiZipFile aZipFile;
			aZipFile.AddSubfileListTo( aSourceStr, pFile, "*" );
		}

		const SiSubfileList& rLst = pFile->GetSubfileList();
		for( USHORT x = 0; x < rLst.Count(); x++ )
		{
			SiSubfile* pSubFile = rLst.GetObject( x );
			UniString aSubSubFile = aSubFile;

			if( pSubFile->aFilename.GetChar(pSubFile->aFilename.Len()-1) == '/' )
			{
				UniString aZipPath = aSubFile;
				aZipPath += UniString( cOSDelim );
				aZipPath += UniString(pSubFile->aFilename, osl_getThreadTextEncoding());

				Add( new SiWebMakeDirAction(this,
					 aZipPath,
					 pDir->GetUnixRights()) );
			}
			else
			{
				aSubSubFile += UniString( pSubFile->aFilename, osl_getThreadTextEncoding() );

				#ifdef UNX
				aSubSubFile.SearchAndReplaceAll( '/', cOSDelim );
				#else
				aSubSubFile.SearchAndReplaceAll( '\\', cOSDelim );
				#endif
				pNew->AddSubFile( aSubSubFile );
			}
		}
	}

	pNew->SetOverwrite( pFile->DontOverwrite()? FALSE : TRUE );
	Add( pNew );

	if( pFile->IsUnoComponent() )
	{
		ByteString aFilename = "<PREDEFINED_PROGDIR>";
		aFilename += cOSDelim;
		aFilename += "program";
		aFilename += cOSDelim;
		aFilename += "initialize.ini";

		#ifdef UNX
		aFilename.SearchAndReplaceAll( '/', cOSDelim );
		#else
		aFilename.SearchAndReplaceAll( '\\', cOSDelim );
		#endif

		SiWebProfileItemAction* pNewProf = new SiWebProfileItemAction( this,
				UniString( aFilename, osl_getThreadTextEncoding()),
				UniString::CreateFromAscii("UnoComponents"),
    			UniString( pFile->GetName(), osl_getThreadTextEncoding() ),
				UniString::CreateFromAscii("1"), 0,
				TRUE );
		Add( pNewProf );
	}

	if( pFile->IsFont() )
	{
		SiWebFontAction* pNewFont = new SiWebFontAction( this,
			UniString(pFile->GetName(), osl_getThreadTextEncoding()),
			UniString(pFile->GetFontName(), osl_getThreadTextEncoding()), TRUE );
		Add( pNewFont );
	}

	InstallShortcut( pFile );

	return TRUE;
}

// ----------------------------------------------------------------------------

SiAction* SiAgenda::InstallMultiVolumeFile(SiFile *pFile)
{
	if( m_bWebMode ) return FALSE;

	ULONG nToCopy = 0;

	SiAction		 *pDepAction  = NULL;
	SiTransferAction *pBaseAction = NULL;

	if (pFile->IsPacked() && !pFile->IsSetupZip())
	{
		pBaseAction
			= new SiUnzipAction(this,
					NULL,
					ByteString(),
					GetDestDir(pFile),
					pFile->GetPackedName(),
					GetDestDir(pFile),
					pFile->GetName(),
					pFile->GetDate(),
					pFile->GetTime(),
					pFile->GetFlags(),
					pFile->GetUnixRights(),
					pFile,
					pFile->GetOs2Creator());
		Add(pBaseAction);
	}

	pDepAction
		 = new SiCopyAction(this,
					pFile->GetDataCarrier(),
					GetSourceDir(pFile),
					pFile->GetPackedName(),
					GetDestDir(pFile),
					pFile->IsPacked()
						? pFile->GetPackedName()
						: pFile->GetName(),
					pFile->GetDate(),
					pFile->GetTime(),
					pFile->GetFlags(),
					pFile->GetUnixRights(),
					pFile,
					pFile->GetOs2Creator());

	Add((SiCopyAction*)pDepAction);
	nToCopy += pFile->GetSize();

	if (!pFile->IsPacked())
		pBaseAction = (SiCopyAction*)pDepAction;
	else
		pDepAction->SetDependence(pBaseAction);

	if (pFile->IsPacked())
	{
		pDepAction = new SiDeleteFileAction(this,
							pFile,
							GetDestDir(pFile),
							pFile->GetPackedName(),
							pFile->GetDate(),
							pFile->GetTime() );

		Add((SiDeleteFileAction*)pDepAction);
		pDepAction->SetDependence(pBaseAction);
	}

	for (USHORT i=0; i<pFile->GetPartList().Count(); i++)
	{
		SiFile *pPart = pFile->GetPartList().GetObject(i);

		pDepAction
			= new SiCopyAction(this,
					pPart->GetDataCarrier(),
					GetSourceDir(pPart),
					GetSourceName(pPart),
					GetDestDir(pPart),
					pPart->GetName(),
					pPart->GetDate(),
					pPart->GetTime(),
					pPart->GetFlags(),
					pPart->GetUnixRights(),
					pPart,
					pFile->GetOs2Creator());

		Add((SiCopyAction*)pDepAction);
		pDepAction->SetDependence(pBaseAction);
		nToCopy += pPart->GetSize();
		pFile->AddToSize(pPart->GetSize());
		pPart->AddToSize(-pPart->GetSize());

		pDepAction
			= new SiAppendAction(this,
					GetDestDir(pPart),
					pPart->GetName(),
					GetDestDir(pFile),
					pFile->IsPacked()
						? pFile->GetPackedName()
						: pFile->GetName(),
					pFile,
					pPart->GetPart());

		Add((SiAppendAction*)pDepAction);
		pDepAction->SetDependence(pBaseAction);

		pDepAction
			= new SiDeleteFileAction(this,
									 NULL,
									 GetDestDir(pPart),
									 pPart->GetName(),
									 pPart->GetDate(),
									 pPart->GetTime() );

		Add((SiDeleteFileAction*)pDepAction);
		pDepAction->SetDependence(pBaseAction);
	}

	m_lBytesToCopy  += nToCopy;

	if( pFile->IsPacked() )
		m_lBytesToUnzip += nToCopy;

	return pBaseAction;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install( SiFileList const& aFileList, SiDoneList& aDoneList, SiCompiledScript& rCS )
{
	for( USHORT x = 0; x < aFileList.Count(); x++ )
	{
		SiFile* pFile = (SiFile*) aFileList.GetObject(x);

		if( pFile->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiFile* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pFile;
					else
						pLangRef = (SiFile*) pFile->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( GetInstallMode() != IM_NETWORK && pLangRef->IsDocLang() && !pCtx->isDoc )
							continue;
						if( !m_bWebMode )
							Install( pLangRef, aDoneList, rCS );
						else
							InstallWeb( pLangRef, aDoneList, rCS );
					}
					else
					{
						if( !m_bWebMode )
							Install( pFile, aDoneList, rCS );
						else
							InstallWeb( pFile, aDoneList, rCS );
					}
				}
			}
		}
		else
		{
			if( !m_bWebMode )
				Install( pFile, aDoneList, rCS );
			else
				InstallWeb( pFile, aDoneList, rCS );
		}
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Install SiDirectory
//

BOOL SiAgenda::Install(SiDirectory const* pDir, SiDoneList &aDoneList)
{
	if( pDir->IsThisSystem() && ( pDir->GetID() != "PREDEFINED_KDEHOME" ) )
		return TRUE;

	if( aDoneList.Find(pDir->GetID()) == 0 )
	{
		aDoneList.Insert( pDir->GetID(), 1 );

		if( m_bWebMode )
		{
			UniString aPath( pDir->GetWebName(), osl_getThreadTextEncoding() );
			char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';

			#ifdef UNX
			aPath.SearchAndReplaceAll( '/', cOSDelim );
			#else
			aPath.SearchAndReplaceAll( '\\', cOSDelim );
			#endif

			Add( new SiWebMakeDirAction(this,
				 aPath,
				 pDir->GetUnixRights()) );
		}
		else
			Add( new SiMakeDirAction(this, pDir->GetName(), pDir->GetUnixRights()) );

		if( pDir->GetParent() &&
			(aDoneList.Find(pDir->GetParent()->GetID()) == 0) )
			Install( pDir->GetParent(), aDoneList );
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install(SiDirectoryList const& aDirList, SiDoneList &aDoneList)
{
	for( USHORT x = 0; x < aDirList.Count(); x++ )
	{
		SiDirectory* pDir = (SiDirectory*) aDirList.GetObject(x);
		if( pDir->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiDirectory* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pDir;
					else
						pLangRef = (SiDirectory*) pDir->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( pLangRef->DoCreate() )
							Install( pLangRef, aDoneList );
						Install( pLangRef->GetSubDirList(), aDoneList );
					}
					else
					{
						if( pDir->DoCreate() )
							Install( pDir, aDoneList );
						Install( pDir->GetSubDirList(), aDoneList );
					}
				}
			}
		}
		else
		{
			if( pDir->DoCreate() )
				Install( pDir, aDoneList );
			Install( pDir->GetSubDirList(), aDoneList );
		}
	}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
//
//		Install SiProfileItem
//

BOOL SiAgenda::Install(const SiProfileItem* pItem, SiDoneList& aDoneList)
{
   BOOL bNetwork = pItem->GetProfile()->InstallOnNetwork();

	if ( GetInstallMode() == IM_STANDALONE
	||   GetInstallMode() == IM_PATCH
	||  (GetInstallMode() == IM_NETWORK	    && bNetwork)
	||  (GetInstallMode() == IM_APPSERVER   && bNetwork)
	||  (GetInstallMode() == IM_WORKSTATION && !bNetwork))
	{
		if( aDoneList.Find(pItem->GetID()) == 0 )
		{
			aDoneList.Insert(pItem->GetID(), 1);
			SiDirectory *pDir = pItem->GetProfile()->GetDirectory();

			if (!Install(pDir, aDoneList))
				return FALSE;

			if( !m_bWebMode )
			{
				Add( new SiProfileItemAction(this, PIA_CREATE, pItem->GetProfile(),
					pItem->GetSection(), pItem->GetKey(),
					pItem->GetValue(), pItem->GetWorkstationValue(),
                    pItem->GetStandaloneValue(), pItem->GetOrder(),
                    pItem->IsInstallInfo(), pItem->DontOverwrite(),
                    (SiProfileItem*)pItem) );
			}
			else
			{
				char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';
				UniString aFilename;
				if( pItem->GetProfile()->GetDirectory()->IsSystemObject() ||
					pItem->GetProfile()->GetDirectory()->IsThisSystem() )
				{
					aFilename = '<';
					aFilename += UniString( pItem->GetProfile()->GetDirectory()->GetID(), osl_getThreadTextEncoding() );
					aFilename += '>';
				}
				else
					aFilename = UniString( pItem->GetProfile()->GetDirectory()->GetWebName(), osl_getThreadTextEncoding() );

				#ifdef UNX
				aFilename.SearchAndReplaceAll( '/', cOSDelim );
				#else
				aFilename.SearchAndReplaceAll( '\\', cOSDelim );
				#endif

				aFilename += cOSDelim;
				aFilename += UniString( pItem->GetProfile()->GetName(), osl_getThreadTextEncoding() );

				ByteString aValue = pItem->GetValue();
				((SiWebAgenda*)this)->SubstituteTemplates( aValue );

				SiWebProfileItemAction* pNew = new SiWebProfileItemAction( this,
					aFilename,
					UniString(pItem->GetSection(), osl_getThreadTextEncoding()),
    				UniString(pItem->GetKey(), osl_getThreadTextEncoding()),
   			 		UniString(aValue, osl_getThreadTextEncoding()), pItem->GetOrder(),
					TRUE );
				Add( pNew );
			}
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install(SiProfileItemList const& aItemList, SiDoneList& aDoneList)
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiProfileItem* pItem = (SiProfileItem*)aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiProfileItem* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiProfileItem*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( ( GetInstallMode() != IM_NETWORK ) && !pCtx->isDoc )
							continue;
						Install( pLangRef, aDoneList );
					}
					else Install( pItem, aDoneList );
				}
			}
		}
		else
		{
			Install( pItem, aDoneList );
		}
	}
	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
//
//		Install SiProcedure
//

BOOL SiAgenda::Install( const SiProcedure* pProc, SiDoneList& aDoneList, SiCompiledScript& rCS )
{
	if( m_bWebMode ) return FALSE;

	if( pProc->IsPreSelectProc() )
		return TRUE;

	if (pProc->RunAtInstall() &&
		((pProc->RunAtStandalone()  && (GetInstallMode() == IM_STANDALONE || GetInstallMode() == IM_PATCH))	||
		 (pProc->RunAtNetwork()     &&  GetInstallMode() == IM_NETWORK)		||
		 (pProc->RunAtWorkstation() &&  GetInstallMode() == IM_WORKSTATION)))
	{
		if( aDoneList.Find(pProc->GetID()) == 0 )
		{
			aDoneList.Insert(pProc->GetID(), 1);
			BOOL bIns = TRUE;
			if( m_pEnv->GetInstallType() == IT_RECOVER && !pProc->IsRepairable() )
				bIns = FALSE;
			if( bIns )
				Add( new SiRunProcedureAction(this, pProc->GetProcName(), pProc->GetCode(), &rCS), pProc->ExecuteBefore() );
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install( SiProcedureList const& aProcList, SiDoneList& aDoneList, SiCompiledScript& rCS )
{
	for( USHORT x = 0; x < aProcList.Count(); x++ )
	{
		SiProcedure* pProc = aProcList.GetObject(x);
		if( pProc->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiProcedure* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pProc;
					else
						pLangRef = (SiProcedure*) pProc->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( ( GetInstallMode() != IM_NETWORK ) && !pCtx->isDoc )
							continue;
						Install( pLangRef, aDoneList, rCS );
					}
					else
						Install( pProc, aDoneList, rCS );
				}
			}
		}
		else
		{
			Install( pProc, aDoneList, rCS );
		}
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Install SiStarRegistryItem
//

BOOL SiAgenda::Install( const SiStarRegistryItem* pItem, SiDoneList& aDoneList, SiCompiledScript &rCS )
{
	if( m_bWebMode ) return FALSE;

	if( aDoneList.Find(pItem->GetID()) )
		return TRUE;
	aDoneList.Insert(pItem->GetID(), 1);

	BOOL bNetwork = pItem->InstallOnNetwork();
	if(  GetInstallMode() == IM_STANDALONE ||
		 GetInstallMode() == IM_PATCH ||
		(GetInstallMode() == IM_NETWORK	    && bNetwork) ||
		(GetInstallMode() == IM_APPSERVER   && bNetwork) ||
		(GetInstallMode() == IM_WORKSTATION && !bNetwork) )
	{
		Add(new SiStarRegistryAction(this, PIA_CREATE, pItem));
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install( const SiStarRegistryItemList& rRegLst, SiDoneList& aDoneList, SiCompiledScript &rCS )
{
	for( USHORT x = 0; x < rRegLst.Count(); ++x )
	{
		SiStarRegistryItem* pItem = rRegLst.GetObject(x);
		if( pItem->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiStarRegistryItem* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiStarRegistryItem*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( ( GetInstallMode() != IM_NETWORK ) && !pCtx->isDoc )
							continue;
						Install( pLangRef, aDoneList, rCS );
					}
					else
						Install( pItem, aDoneList, rCS );
				}
			}
		}
		else
		{
			Install( pItem, aDoneList, rCS );
		}
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Install SiRegistryItem
//

BOOL SiAgenda::Install( const SiRegistryItem* pItem,
                        SiDoneList& aDoneList )
{
    return Install( pItem, aDoneList, GetAppLanguage() );
}

BOOL SiAgenda::Install( const SiRegistryItem* pItem,
                        SiDoneList& aDoneList,
                        USHORT nLanguage )
{
	if ( pItem->IsSystemObject() )
        return TRUE;

	if (aDoneList.Find(pItem->GetID()) == 0)
	{
		aDoneList.Insert(pItem->GetID(), 1); // wird bearbeitet

        if( !m_bWebMode )
		{
            Add(new SiRegistryItemAction(this, RIA_CREATE,
                    nLanguage, pItem->GetKey(),
					pItem->GetSubkey(), pItem->GetName(),
                    pItem->GetValue(), pItem->IsHexValue()));
		}
		else
		{
			ByteString aValue = pItem->GetValue();
			((SiWebAgenda*)this)->SubstituteTemplates( aValue );

			SiWebWindowsRegistryAction* pNew = new SiWebWindowsRegistryAction( this,
					UniString( pItem->GetKey(), osl_getThreadTextEncoding() ),
					UniString( pItem->GetSubkey(), osl_getThreadTextEncoding() ),
					UniString( pItem->GetName(), osl_getThreadTextEncoding() ),
					UniString( aValue, Langcode2TextEncoding( nLanguage ) ),
					TRUE,
					pItem->IsHexValue(),
					FALSE );
			Add( pNew );
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install( SiRegistryItemList const& aItemList,
                        SiDoneList& aDoneList,
                        SiCompiledScript &rCS )
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiRegistryItem* pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiRegistryItem* pLangRef = NULL;
            		USHORT nLang = pCtx->nLanguage;

					if( pCtx->nLanguage == LANG_DEFAULT )
                    {
						pLangRef = pItem;
                        nLang = (USHORT)rCS.GetInstallation()->GetDefLanguage().ToInt32();
                    }
					else
						pLangRef = (SiRegistryItem*) pItem->GetLangRef( nLang );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( ( GetInstallMode() != IM_NETWORK ) && !pCtx->isDoc )
							continue;
						Install( pLangRef, aDoneList, nLang );
					}
					else
						Install( pItem, aDoneList, GetAppLanguage() );
				}
			}
		}
		else
		{
			Install( pItem, aDoneList, GetAppLanguage() );
		}
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Install SiFolder
//

BOOL SiAgenda::Install( SiFolder const* pFolder, SiDoneList& aDoneList )
{
	if( aDoneList.Find(pFolder->GetID()) == 0 && !pFolder->IsSystemObject() )
	{
		aDoneList.Insert( pFolder->GetID(), 1 );
		if( !m_bWebMode )
			Add( new SiMakeFolderAction(this, ByteString(pFolder->GetName(), osl_getThreadTextEncoding()) ));
		else
		{
			SiWebMakeFolderAction* pNew = new SiWebMakeFolderAction( this,
				pFolder->GetName(),
				TRUE );
			Add( pNew );
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install(SiFolderItem const* pItem, SiDoneList& aDoneList)
{
	if( Install(pItem->GetFolder(), aDoneList) )
	{
		if( aDoneList.Find(pItem->GetID()) == 0 )
		{
			aDoneList.Insert( pItem->GetID(), 1 );

			SiFile   const* pFile   = pItem->GetFile();
			SiFolder	  * pFolder = pItem->GetFolder();

			if( !m_bWebMode )
			{
				if( pItem->IsWebOnly() ) return TRUE;

                UniString aIconFileStr;
                if ( pItem->GetIconFile() )
                {
                    SiDirEntry aIconFile = m_pEnv->GetProgPath( GetInstallMode() );
                    aIconFile += pItem->GetIconFile()->GetDirectory()->GetName();
                    aIconFile += pItem->GetIconFile()->GetName();
                    aIconFile.ToAbs();
                    aIconFileStr = aIconFile.GetFullUni();
                }

				Add(new SiMakeFolderItemAction( this,
					pFolder->GetName(),
					pItem->GetName(),
					!pFile->InstallOnWorkstation(),
					pFile->GetDirectory()->GetName(),
					pFile->GetName(),
					pItem->GetParameter(),
                    aIconFileStr, pItem->GetIconIndex(),
                    (SiFolderItem*)pItem) );
				pFolder->AddItemCount();
			}
			else
			{
				if( pItem->IsNoWeb() ) return TRUE;
				SiWebMakeFolderItemAction* pNew = new SiWebMakeFolderItemAction( this,
					pFolder->GetName(),
					UniString( pItem->GetName(), osl_getThreadTextEncoding() ),
					UniString( pFile->GetDirectory()->GetWebName(), osl_getThreadTextEncoding() ),
					UniString( pFile->GetName(), osl_getThreadTextEncoding() ),
					UniString( pItem->GetParameter(), osl_getThreadTextEncoding() ) );
				Add( pNew );
			}
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install(SiFolderItemList const& aFolderItemList, SiDoneList& aDoneList)
{
	BOOL bSuccess = TRUE;
	for( USHORT x = 0; x < aFolderItemList.Count(); x++)
	{
		SiFolderItem* pFolderItem = aFolderItemList.GetObject(x);

		if( pFolderItem->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiFolderItem* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pFolderItem;
					else
						pLangRef = (SiFolderItem*) pFolderItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( ( GetInstallMode() != IM_NETWORK ) && !pCtx->isDoc )
							continue;
						if( !Install(pLangRef, aDoneList) )
							bSuccess = FALSE;
					}
					else
					{
						if( !Install(pFolderItem, aDoneList) )
							bSuccess = FALSE;
					}
				}
			}
		}
		else
		{
			if( !Install(pFolderItem, aDoneList) )
				bSuccess = FALSE;
		}
	}
	return bSuccess;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Install SiOs2Class
//

BOOL SiAgenda::Install(const SiOs2Class* pClass, SiDoneList& aDoneList)
{
	if( m_bWebMode ) return FALSE;

	if( pClass->GetName().CompareIgnoreCaseToAscii("WPProgram") == COMPARE_EQUAL )
		return TRUE;

	if( aDoneList.Find(pClass->GetID()) == 0 )
	{
		aDoneList.Insert(pClass->GetID(), 1);
		Add( new SiOs2RegisterClassAction(this,
					pClass->GetName(),
					!pClass->GetDLL()->InstallOnWorkstation(),
					pClass->GetDLL()->GetDirectory()->GetName(),
					pClass->GetDLL()->GetName()) );
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install(SiOs2ClassList const& aItemList, SiDoneList& aDoneList)
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiOs2Class *pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiOs2Class* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiOs2Class*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Install(pLangRef, aDoneList);
					}
					else
						Install(pItem, aDoneList);
				}
			}
		}
		else
		{
			Install(pItem, aDoneList);
		}
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Install SiOs2Template
//

BOOL SiAgenda::Install(const SiOs2Template* pItem, SiDoneList& aDoneList)
{
	if( m_bWebMode ) return FALSE;

	if( aDoneList.Find(pItem->GetID()) == 0 )
	{
		aDoneList.Insert(pItem->GetID(), 1);
		Add( new SiOs2CreateTemplateAction(
						this,
						pItem->GetID(),
						TRUE, // !pItem->GetIcon()->InstallOnWorkstation(),
						"", // pItem->GetIcon()->GetDirectory()->GetName(),
						"", // pItem->GetIcon()->GetName(),
						(SiOs2Class*)pItem->GetClass()) );
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Install(SiOs2TemplateList const& aItemList, SiDoneList& aDoneList)
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiOs2Template* pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < pLst->Count(); ++i )
			{
				LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiOs2Template* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiOs2Template*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Install(pLangRef, aDoneList);
					}
					else
						Install(pItem, aDoneList);
				}
			}
		}
		else
		{
			Install(pItem, aDoneList);
		}
	}
	return TRUE;
}

BOOL SiAgenda::Install( const SiConfigurationItem* pItem, SiDoneList& aDoneList, SiCompiledScript &rCS )
{
    return Install( pItem, aDoneList, rCS, GetAppLanguage() );
}

BOOL SiAgenda::Install( const SiConfigurationItem* pItem,
                        SiDoneList& aDoneList,
                        SiCompiledScript &rCS,
                        USHORT nLanguage )
{
	BOOL bIsWorkstation = pItem->IsWorkstation();   // will be true only when the WORKSTATION flag is set
	BOOL bIsNetwork		= pItem->IsNetwork();       // will be true when the NETWORK flag is set or no flag is set

	if( ( GetInstallMode() == IM_WORKSTATION && !bIsWorkstation ) ||
		( GetInstallMode() == IM_NETWORK && !bIsNetwork ) ||
		( GetInstallMode() == IM_APPSERVER && !bIsNetwork ) )
		return TRUE;

	if( aDoneList.Find(pItem->GetID()) == 0 )
	{
		aDoneList.Insert( pItem->GetID(), 1 );
		if( !pItem->GetValue().Len() && !pItem->GetKey().Len() ) return TRUE;

		if( !m_bWebMode )
		{
			Add( new SiConfigurationAction(this, PIA_CREATE, pItem, nLanguage) );
		}
		else
		{
			char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';
			ByteString aFilename = "<PREDEFINED_PROGDIR>";
			aFilename += cOSDelim;
			aFilename += "program";
			aFilename += cOSDelim;
			aFilename += "initialize.ini";

			#ifdef UNX
			aFilename.SearchAndReplaceAll( '/', cOSDelim );
			#else
			aFilename.SearchAndReplaceAll( '\\', cOSDelim );
			#endif

			ByteString aValue = pItem->GetValue();
			((SiWebAgenda*)this)->SubstituteTemplates( aValue );

			UniString aKey( pItem->GetPath(), osl_getThreadTextEncoding() );
			aKey += UniString::CreateFromAscii( "|" );
			aKey += UniString( pItem->GetKey(), osl_getThreadTextEncoding() );
			aKey += UniString::CreateFromAscii( "|" );
			switch( pItem->GetValueType() )
			{
				case SiConfigurationItem::BOOLEAN: 		aKey += UniString::CreateFromAscii( "BOOLEAN" );	break;
				case SiConfigurationItem::STRING:		aKey += UniString::CreateFromAscii( "STRING" ); 	break;
				case SiConfigurationItem::NUMERIC:		aKey += UniString::CreateFromAscii( "NUMERIC" ); 	break;
				case SiConfigurationItem::STRINGLIST: 	aKey += UniString::CreateFromAscii( "STRINGLIST" ); break;
				case SiConfigurationItem::BINARY:		aKey += UniString::CreateFromAscii( "BINARY" ); 	break;
			}

			SiWebProfileItemAction* pNew = new SiWebProfileItemAction( this,
				UniString( aFilename, osl_getThreadTextEncoding()),
				UniString::CreateFromAscii("configuration"),
    			aKey,
				UniString( aValue, Langcode2TextEncoding( nLanguage ) ),
				0, TRUE );
			Add( pNew );
		}
	}
	return TRUE;
}

BOOL SiAgenda::Install( const SiConfigurationItemList& aItemList, SiDoneList& aDoneList, SiCompiledScript& rCS )
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiConfigurationItem* pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			const SiLangCtxList *pLst = m_pEnv->GetLanguageContext();
			for( USHORT i = pLst->Count(); i > 0; /* i will be decremented next line */ )
			{
				i -= 1;
                LanguageContext* pCtx = pLst->GetObject(i);
				if( pCtx )
				{
					SiConfigurationItem* pLangRef = NULL;
            		USHORT nLang = pCtx->nLanguage;

					if( pCtx->nLanguage == LANG_DEFAULT )
                    {
						pLangRef = pItem;
                        nLang = (USHORT)rCS.GetInstallation()->GetDefLanguage().ToInt32();
                    }
					else
						pLangRef = (SiConfigurationItem*) pItem->GetLangRef( nLang );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( ( GetInstallMode() != IM_NETWORK ) && !pCtx->isDoc )
							continue;
						Install(pLangRef, aDoneList, rCS, nLang);
					}
					else
						Install(pItem, aDoneList, rCS, GetAppLanguage());
				}
			}
		}
		else
		{
			Install(pItem, aDoneList, rCS, GetAppLanguage());
		}
	}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
//
//		Install
//

BOOL SiAgenda::Install(SiModule const* pModule, SiDoneList &aDoneList, SiCompiledScript& rCS)
{
	if( !m_pEnv->GetResponseStep() || m_pEnv->GetResponseStep() == 1 )
	{
		Install(pModule->GetFileList(), 				aDoneList, rCS);
		Install(pModule->GetDirList(),					aDoneList);
		Install(pModule->GetProfileItemList(),			aDoneList);
		Install(pModule->GetProcedureList(),			aDoneList, rCS);
		Install(pModule->GetStarRegistryItemList(),		aDoneList, rCS);

		if( m_pEnv->GetResponseStep() != 1 )
			Install(pModule->GetConfigurationItemList(),aDoneList, rCS);

        if( ( !m_pEnv->IsNoRegistration() && InstallLocal() ) ||
            ( rCS.GetInstallation()->GetInstallMode() == IM_APPSERVER ) ||
            ( m_pEnv->IsLocal() && ( GetInstallMode() == IM_PATCH ) ) )
        {
            Install(pModule->GetRegistryItemList(), aDoneList, rCS);
        }

		if( InstallLocal() )
		{
			Install(pModule->GetFolderItemList(),   aDoneList);
			Install(pModule->GetOs2ClassList(),     aDoneList);
			Install(pModule->GetOs2TemplateList(),  aDoneList);
		}
	}
	else
		Install(pModule->GetConfigurationItemList(),aDoneList, rCS);

	return TRUE;
}

