/*************************************************************************
 *
 *  $RCSfile: respfile.cxx,v $
 *
 *  $Revision: 1.23.74.3.2.1 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/16 14:51:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdlib.h>

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _TOOLS_INTN_HXX //autogen
#include <tools/intn.hxx>
#endif
#ifndef _DATETIME_HXX //autogen
#include <tools/datetime.hxx>
#endif
#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#ifndef _VOS_SECURITY_HXX_
#include <vos/security.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include "action.hxx"
#include "decltor.hxx"
#include "environ.hxx"
#include "script.hxx"
#include "event.hxx"
#include "sihelp.hxx"
#include "fields.hxx"

#include "critical.hxx"
#include "respfile.hxx"

const char RESPSEC_ENVIRONMENT[]				= "ENVIRONMENT";
const char RESPSEC_MODULE_SPECIFY[]				= "MODULE_SPECIFY";
const char RESPSEC_PROCEDURES[]					= "[PROCEDURES]";
const char RESPSEC_RESPONSE_ONLY[]				= "RESPONSE_ONLY";

const char RESPKEY_INSTALLMODE[] 				= "INSTALLATIONMODE";
const char RESPKEY_INSTALLTYPE[] 				= "INSTALLATIONTYPE";
const char RESPKEY_DESTINATIONPATH[] 		   	= "DESTINATIONPATH";
const char RESPKEY_OUTERPATH[] 		   			= "OUTERPATH";
const char RESPKEY_SERVERUSER[] 		   		= "SERVERUSER";
const char RESPKEY_SERVERPOSTFIX[] 		   		= "SERVERPOSTFIX";
const char RESPKEY_SERVERUSERROOT[] 		   	= "SERVERUSERROOT";
const char RESPKEY_STARTPROCEDURE[] 		   	= "STARTPROCEDURE";
const char RESPKEY_ENDPROCEDURE[] 			   	= "ENDPROCEDURE";
const char RESPKEY_INSTALLMODULESET[] 		   	= "INSTALLMODULESET";
const char RESPKEY_DEINSTALLMODULESET[]  	   	= "DEINSTALLMODULESET";
const char RESPKEY_INSTALLPROCEDURE[] 		   	= "INSTALLPROCEDURE";
const char RESPKEY_DEINSTALLPROCEDURE[]		   	= "DEINSTALLPROCEDURE";
const char RESPKEY_LOGFILE[]   				   	= "LOGFILE";
const char RESPKEY_MIGRATION[] 				   	= "MIGRATION";
const char RESPKEY_LANGUAGELIST[]			   	= "LANGUAGELIST";
const char RESPKEY_UPDATEMODE[]                 = "UPDATEMODE";
const char RESPKEY_REDO[]						= "REDO";

const char RESPVAL_INSTALL_NORMAL[]		  		= "INSTALL_NORMAL";
const char RESPVAL_INSTALL_NETWORK[]			= "INSTALL_NETWORK";
const char RESPVAL_INSTALL_SERVER[]		   		= "INSTALL_SERVER";
const char RESPVAL_INSTALL_WORKSTATION[] 		= "INSTALL_WORKSTATION";
const char RESPVAL_DEINSTALL[]		 	 		= "DEINSTALL";
const char RESPVAL_REPAIR[]			 			= "REPAIR";
const char RESPVAL_REINSTALL[]  		 		= "REINSTALL";
const char RESPVAL_RESPONSE_ONLY[] 	 			= "RESPONSE_ONLY";
const char RESPVAL_PATCH[]                      = "PATCH";
const char RESPVAL_STANDARD[] 	 	 			= "STANDARD";
const char RESPVAL_SPECIFY[] 	 				= "SPECIFY";
const char RESPVAL_MINIMUM[] 	 				= "MINIMUM";
const char RESPVAL_WORKSTATION[] 				= "WORKSTATION";
const char RESPVAL_UPDATE_NEVER[]		  		= "NEVER";
const char RESPVAL_UPDATE_IF_AVAIL[]			= "IF_AVAILABLE";
const char RESPVAL_UPDATE_ALWAYS[]		   		= "ALWAYS";

using namespace ::osl;

ResponseFile::ResponseFile(SiEnvironment* pE, SiCompiledScript* pC)
{
	pEnv 		= pE;
	pCScript	= pC;
	bPreModuleSet = FALSE;
	bRedoInstallation = FALSE;
    eUpdate     = NEVER;

	pEnv->SetMigration( FALSE );
}

ResponseFile::~ResponseFile()
{
	USHORT nIdx;
	for( nIdx = 0; nIdx < aProcedureList.Count(); nIdx++ )
		delete aProcedureList.GetObject(nIdx);
	aProcedureList.Clear();
}

void ResponseFile::Write( const ByteString& rFilename )
{
	// We will delete the any old response file first before we write
    // the keys
    SiDirEntry aFile( rFilename );
//    aFile.Kill();

    Config aRspFile( UniString(rFilename, osl_getThreadTextEncoding()) );

	//////////////////////////////////////
	// SECTION_ENVIRONMENT
 	aRspFile.SetGroup( RESPSEC_ENVIRONMENT );

	aRspFile.WriteKey( RESPKEY_INSTALLMODE, GetStrInstalltionMode() );
	aRspFile.WriteKey( RESPKEY_INSTALLTYPE, GetStrInstalltionType() );

	aRspFile.WriteKey( RESPKEY_MIGRATION, pEnv->DoMigration()? "YES" : "NO" );
	aRspFile.WriteKey( RESPKEY_UPDATEMODE, GetStrUpdateMode() );

	aRspFile.WriteKey( RESPKEY_DESTINATIONPATH, aDestinationPath );
	aRspFile.WriteKey( RESPKEY_OUTERPATH, pEnv->GetOuterDestPath() );
	aRspFile.WriteKey( RESPKEY_LOGFILE, aLogFile );

	aRspFile.ReadKey( RESPKEY_STARTPROCEDURE, aStartProcedure );
	aRspFile.ReadKey( RESPKEY_ENDPROCEDURE, aEndProcedure );

	ByteString aLanguageList;
	const SiLangCtxList *pUILst = pEnv->GetUILanguageContext();
	for( USHORT i = 0; i < pUILst->Count(); ++i )
	{
		LanguageContext* pAct = pUILst->GetObject(i);
		if( pAct->isProg )
		{
			if( aLanguageList.Len() ) aLanguageList += ",";
			aLanguageList += ByteString::CreateFromInt32( pAct->nLanguage );
		}
	}

	if( !aLanguageList.Len() )
		aLanguageList = pCScript->GetInstallation()->GetDefLanguage();
	aRspFile.WriteKey( RESPKEY_LANGUAGELIST, aLanguageList );

	//////////////////////////////////////
	// SECTION_MODULE_SPECIFY
	aRspFile.SetGroup( RESPSEC_MODULE_SPECIFY );
	SiModuleSetList& rLst = pEnv->GetModuleSetList();
	for( i = 0; i < rLst.Count(); ++i )
	{
		SiModuleSet* pSet = rLst.GetObject(i);
		ModList&	 rModLst = pSet->GetModList();
		ByteString 	 aValue;

		for( USHORT x = 0; x < rModLst.Count(); ++x )
		{
			SiModule* pMod = rModLst.GetObject(x);
			if( x ) aValue += ",";
			aValue += pMod->GetID();
		}
		aRspFile.WriteKey( pSet->Name(), aValue );
	}
}

BOOL ResponseFile::Read( const ByteString& rFilename )
{
	SiDirEntry aEntry( rFilename );
	if( !aEntry.Exists() ) return FALSE;

	//////////////////////////////////////
	// SECTION_PROCEDURES
	ReadProcedureSection( rFilename );

	Config aFile( UniString::CreateFromAscii(rFilename.GetBuffer()) );
	ByteString aValue;

	//////////////////////////////////////
	// SECTION_ENVIRONMENT
 	aFile.SetGroup( RESPSEC_ENVIRONMENT );

	aValue = aFile.ReadKey(RESPKEY_INSTALLMODE, RESPVAL_RESPONSE_ONLY);
	ReadInstalltionMode( aValue );

	aValue = aFile.ReadKey(RESPKEY_INSTALLTYPE, RESPVAL_SPECIFY);
	ReadInstalltionType( aValue );

    aValue = aFile.ReadKey( RESPKEY_UPDATEMODE, RESPVAL_UPDATE_NEVER );
    ReadUpdateMode( aValue );

	aValue = aFile.ReadKey( RESPKEY_REDO, "no" );
	if( ( aValue.CompareIgnoreCaseToAscii("yes") == COMPARE_EQUAL ) &&
		( eMode == WORKSTATION ) )
	{
		bRedoInstallation = TRUE;
		aDestinationPath = pEnv->GetDestPath();
		pEnv->SetIgnoreRunningOffice();
		pEnv->SetFirstInstallation();
	}

	if( !aDestinationPath.Len() )
	{
		aDestinationPath = aFile.ReadKey( RESPKEY_DESTINATIONPATH, "" );
        
        if ( !aDestinationPath.Len() && ( eMode == PATCH ) )
            aDestinationPath = pEnv->GetDestPath();

        if( !aDestinationPath.Len() )
            Critical_Error( ERR_INVALID_DESTPATH, "" );
	}

	aLogFile = aFile.ReadKey( RESPKEY_LOGFILE, "" );

	aValue = aFile.ReadKey( RESPKEY_OUTERPATH, "" );
	pEnv->SetOuterDestPath( aValue );
	SiDirectory* pOuterDir = (SiDirectory*) pCScript->Find( "PREDEFINED_OUTERPATH" );
	if( pOuterDir ) pOuterDir->SetProperty( PROPERTY_HOSTNAME, aValue );

	aStartProcedure	= aFile.ReadKey( RESPKEY_STARTPROCEDURE, "" );
	aEndProcedure	= aFile.ReadKey( RESPKEY_ENDPROCEDURE, "" );

	ByteString aLanguageList	= aFile.ReadKey( RESPKEY_LANGUAGELIST, "" );
    aLanguageList.SearchAndReplaceAll( "<LANGUAGE>", pCScript->GetInstallation()->GetDefLanguage() );
	USHORT nDelimTok			= 0;
	USHORT nTokCount			= aLanguageList.GetTokenCount(',');
	USHORT nDefLang				= (USHORT) pCScript->GetInstallation()->GetDefLanguage().ToInt32();

	for( USHORT x = 0; x < nTokCount; ++x )
	{
		USHORT nLang = (USHORT) ByteString(aLanguageList.GetToken(0, ',', nDelimTok)).ToInt32();

		LanguageContext* pCtx = new LanguageContext;
		pCtx->nLanguage	= nLang == nDefLang? LANG_DEFAULT : nLang;
		pCtx->isProg   	= TRUE;
		pCtx->isDoc		= x? FALSE : TRUE;

		pEnv->AddLanguageContext( pCtx );
	}

	aValue = aFile.ReadKey( RESPKEY_MIGRATION, "no" );
	if( aValue.CompareIgnoreCaseToAscii("yes") == COMPARE_EQUAL )
	{
		SiHelp::InitMigration( pCScript, pEnv );
		pEnv->SetMigration( TRUE );
	}
	else
		pEnv->SetMigration( FALSE );

	//////////////////////////////////////
	// SECTION_MODULE_SPECIFY
	aFile.SetGroup( RESPSEC_MODULE_SPECIFY );
	for( USHORT i = 0; i < aFile.GetKeyCount(); ++i )
	{
		ByteString aKeyName = aFile.GetKeyName( i );
		if( aKeyName.CompareIgnoreCaseToAscii(RESPKEY_INSTALLMODULESET) == COMPARE_EQUAL )
			aInstallModuleSet = aFile.ReadKey( RESPKEY_INSTALLMODULESET, "" );
		else
		if( aKeyName.CompareIgnoreCaseToAscii(RESPKEY_DEINSTALLMODULESET) == COMPARE_EQUAL )
			aDeInstallModuleSet = aFile.ReadKey( RESPKEY_DEINSTALLMODULESET, "" );
		else
		if( aKeyName.CompareIgnoreCaseToAscii(RESPKEY_INSTALLPROCEDURE) == COMPARE_EQUAL )
			aInstallProcedure = aFile.ReadKey( RESPKEY_INSTALLPROCEDURE, "" );
		else
		if( aKeyName.CompareIgnoreCaseToAscii(RESPKEY_DEINSTALLPROCEDURE) == COMPARE_EQUAL )
			aDeInstallProcedure = aFile.ReadKey( RESPKEY_DEINSTALLPROCEDURE, "" );
		else
		{
			aValue = aFile.ReadKey( aKeyName, "" );
			if( !aValue.Len() )
				continue;

			SiModuleSet* pNew = new SiModuleSet( aKeyName );

			USHORT nDelimTok = 0;
			USHORT nTokCount = aValue.GetTokenCount(',');
			for( USHORT x = 0; x < nTokCount; ++x )
			{
				ByteString aModID(aValue.GetToken(0, ',', nDelimTok));
				aModID.EraseTrailingChars( '\t' );	aModID.EraseTrailingChars( ' ' );
				aModID.EraseLeadingChars( '\t' );	aModID.EraseLeadingChars( ' ' );

				SiModule* pModule = SiHelp::FindModuleByID(pCScript->GetRootModule(), aModID);
				if( !pModule )
					Critical_Error( ERR_MODULENOTFOUND, "" );
				pNew->Add( pModule );
			}
			pEnv->AddModuleSet( pNew );
		}
	}
	return TRUE;
}

void ResponseFile::ReadProcedureSection( const ByteString& rFilename )
{
	enum ScannerState { SEARCH_SECTION, SEARCH_PROC_START, SCAN_CODE };

	SvFileStream aStrm( UniString::CreateFromAscii(rFilename.GetBuffer()), STREAM_READ );
	if( !aStrm.IsOpen() )
		Critical_Error( ERR_RESPONSEFILE_NOTFOUND, "" );

	ByteString aLine;
	ByteString aProcName;
	ByteString aProcCode;

	ScannerState eState = SEARCH_SECTION;
	while( aStrm.ReadLine( aLine ) )
	{
		aLine.EraseTrailingChars( '\t' );		aLine.EraseTrailingChars( ' ' );
		aLine.EraseLeadingChars( '\t' );		aLine.EraseLeadingChars( ' ' );

		switch( eState )
		{
			case SEARCH_SECTION :
				if( aLine.CompareIgnoreCaseToAscii(RESPSEC_PROCEDURES) == COMPARE_EQUAL )
					eState = SEARCH_PROC_START;
				break;
			case SEARCH_PROC_START :
				if( aLine.CompareIgnoreCaseToAscii("SUB", 3) == COMPARE_EQUAL )
				{
					aProcName = aLine.Copy( 3 );
					aProcName.EraseLeadingChars( '\t' );
					aProcName.EraseLeadingChars( ' ' );
					aProcCode = aLine;
					eState = SCAN_CODE;
				}
				break;
			case SCAN_CODE :
				aProcCode += '\n';
				aProcCode += aLine;
				if( aLine.CompareIgnoreCaseToAscii("END SUB", 7) == COMPARE_EQUAL )
				{
					SimpleProcedureAction* pNew = new SimpleProcedureAction( aProcName, aProcCode );
					aProcedureList.Insert( pNew, LIST_APPEND );
					eState = SEARCH_PROC_START;
				}
				break;
		}
	}
	if( eState == SCAN_CODE )
		Critical_Error( ERR_WHILEREADINGPROCEDURES, "" );
}

SimpleProcedureAction* ResponseFile::FindProc( const ByteString& rProcname )
{
	for( USHORT nIdx = 0; nIdx < aProcedureList.Count(); nIdx++ )
		if( aProcedureList.GetObject(nIdx)->GetProcname().CompareIgnoreCaseToAscii(rProcname) == COMPARE_EQUAL )
			return aProcedureList.GetObject(nIdx);
	return NULL;
}

void ResponseFile::ExecStartProcedure()
{
	SimpleProcedureAction* pProc = FindProc( aStartProcedure );
	if( pProc && eMode != RESPONSE_ONLY )
		pProc->Execute( pCScript, *pEnv );
}

void ResponseFile::ExecEndProcedure()
{
	SimpleProcedureAction* pProc = FindProc( aEndProcedure );
	if( pProc && eMode != RESPONSE_ONLY )
		pProc->Execute( pCScript, *pEnv );
}

void ResponseFile::ReadInstalltionMode( const ByteString& rValue )
{
	if( rValue == RESPVAL_INSTALL_NORMAL )
		eMode = INSTALL_NORMAL;
	else if( rValue == RESPVAL_INSTALL_NETWORK )
		eMode = INSTALL_NETWORK;
	else if( rValue == RESPVAL_INSTALL_SERVER )
		eMode = INSTALL_SERVER;
	else if( rValue == RESPVAL_INSTALL_WORKSTATION )
		eMode = INSTALL_WORKSTATION;
	else if( rValue == RESPVAL_DEINSTALL )
		eMode = DEINSTALL;
	else if( rValue == RESPVAL_REPAIR )
		eMode = REPAIR;
	else if( rValue == RESPVAL_REINSTALL )
		eMode = REINSTALL;
	else if( rValue == RESPVAL_RESPONSE_ONLY )
		eMode = RESPONSE_ONLY;
	else if ( rValue == RESPVAL_PATCH )
        eMode = PATCH;
	else
		Critical_Error( ERR_WRONG_INSATALLATIONMODE, "" );
}

void ResponseFile::ReadInstalltionType( const ByteString& rValue )
{
	if( rValue == RESPVAL_STANDARD )
		eType = STANDARD;
	else if( rValue == RESPVAL_SPECIFY )
		eType = SPECIFY;
	else if( rValue == RESPVAL_MINIMUM )
		eType = MINIMUM;
	else if( rValue == RESPVAL_WORKSTATION )
		eType = WORKSTATION;
	else
		Critical_Error( ERR_WRONG_INSATALLATIONTYPE, "" );
}

void ResponseFile::ReadUpdateMode( const ByteString& rValue )
{
    if( rValue == RESPVAL_UPDATE_NEVER )
		eUpdate = NEVER;
	else if( rValue == RESPVAL_UPDATE_IF_AVAIL )
		eUpdate = IF_AVAILABLE;
	else if( rValue == RESPVAL_UPDATE_ALWAYS )
		eUpdate = ALWAYS;
	else
		Critical_Error( ERR_WRONG_UPDATEMODE, "" );
}

ByteString ResponseFile::GetStrInstalltionMode()
{
	if( eMode == INSTALL_NORMAL )
		return RESPVAL_INSTALL_NORMAL;
	else if( eMode == INSTALL_NETWORK )
		return RESPVAL_INSTALL_NETWORK;
	else if( eMode == INSTALL_SERVER )
		return RESPVAL_INSTALL_SERVER;
	else if( eMode == INSTALL_WORKSTATION )
		return RESPVAL_INSTALL_WORKSTATION;
	else if( eMode == DEINSTALL )
		return RESPVAL_DEINSTALL;
	else if( eMode == REPAIR )
		return RESPVAL_REPAIR;
	else if( eMode == REINSTALL )
		return RESPVAL_REINSTALL;
	else if( eMode == RESPONSE_ONLY )
		return RESPVAL_RESPONSE_ONLY;
    else if ( eMode == PATCH )
        return RESPVAL_PATCH;
	return "";
}

ByteString ResponseFile::GetStrInstalltionType()
{
	if( eType == STANDARD )
		return RESPVAL_STANDARD;
	else if( eType == SPECIFY )
		return RESPVAL_SPECIFY;
	else if( eType == MINIMUM )
		return RESPVAL_MINIMUM;
	else if( eType == WORKSTATION )
		return RESPVAL_WORKSTATION;
	return "";
}

ByteString ResponseFile::GetStrUpdateMode() const
{
    if( eUpdate == NEVER )
        return RESPVAL_UPDATE_NEVER;
    else if( eUpdate == IF_AVAILABLE )
        return RESPVAL_UPDATE_IF_AVAIL;
    else if( eUpdate == ALWAYS )
        return RESPVAL_UPDATE_ALWAYS;
    else
        return "";
}


USHORT ResponseFile::ProcessEvents()
{
	SiModule*	pRoot        = pCScript->GetRootModule();
    BOOL        bIsUpdate    = pEnv->IsUpdateOldVersion();
	USHORT		nReturnEvent = EVT_NULL;

	// we had to call CheckForUpdate() quite early now, so we can check here if an
    // update is available. The status in the environment should only be set when
    // installing, so we reset the status here and set it only, when needed again

    pEnv->SetUpdateOldVersion( FALSE );

    switch( eMode )
	{
		case INSTALL_NORMAL :
		case INSTALL_NETWORK :
		case INSTALL_SERVER :
		case INSTALL_WORKSTATION :
		{
            BOOL bDoUpdate = FALSE;

            switch( eUpdate )
            {
                case NEVER:
                    break;
                case IF_AVAILABLE:
                    if ( bIsUpdate )
                        bDoUpdate = TRUE;
                    break;
                case ALWAYS:
                    if ( bIsUpdate )
                        bDoUpdate = TRUE;
                    else
                        Critical_Error( ERR_NOUPDATEVERSIONFOUND, "" );
                    break;
            }

			if( eMode == INSTALL_NETWORK )
				pEnv->SetLocal( FALSE );

			if ( ! bRedoInstallation )
			{
				ByteString aInstalledPath;
				if( SiHelp::IsVersionAlreadyInstalled(aInstalledPath, pCScript, pEnv) )
					Critical_Error( ERR_VERSIONALLREADYINSTALLED, "" );
			}

            if ( bDoUpdate )
            {
                if ( pEnv->IsUpdateOldVersionNoRights() )
                    Critical_Error( ERR_UPDATE_NO_RIGHTS, "" );
                if ( pEnv->IsUpdateOldVersionWrongLanguage() )
                    Critical_Error( ERR_UPDATE_WRONG_LANGUAGE, "" );
                
                pEnv->SetUpdateOldVersion( TRUE );
                nReturnEvent = EVT_START_UPDATE_OLD_VERSION;
                break;
            }

			if( eMode == INSTALL_WORKSTATION )
			{
				if ( !bRedoInstallation )
				{
					if ( pCScript->GetInstallation()->GetInstallMode() == IM_WORKSTATION )
					{
						Critical_Error( ERR_VERSIONALLREADYINSTALLED, "" );
					}
					else if( pCScript->GetInstallation()->GetInstallMode() != IM_NETWORK )
					{
						Critical_Error( ERR_NONETWORKINSTALLTION, "" );
					}
				}

				if( eType == WORKSTATION )
				{
					pRoot->Select( SiModule::ALL_SEL );
					pEnv->SetInstallType( IT_WORKSTATION );
				}
				else
				{
					pRoot->Select( SiModule::ALL_DEFAULT );
					pEnv->SetInstallType( IT_MAXIMAL );
				}
			}
			else
			{
				if( eType == SPECIFY )
				{
					if( !bPreModuleSet )
					{
						pCScript->GetRootModule()->Select(SiModule::ALL_UNSEL);
						pCScript->GetRootModule()->Select(SiModule::ALL_DEFAULT);
					}

					if( aInstallProcedure.Len() )
					{
						SimpleProcedureAction* pProc = FindProc( aInstallProcedure );
						if( pProc )
							pProc->Execute( pCScript, *pEnv );
						else
							Critical_Error( ERR_INSTALLPROCEDURE_NOTFOUND, "" );
					}
					else if( aInstallModuleSet.Len() )
					{
						SiModuleSet* pSet = SiHelp::FindModuleSetByName(pEnv, aInstallModuleSet);
						if( pSet )
                        {
                            pCScript->GetRootModule()->Select(SiModule::ALL_UNSEL);
							pSet->Select();
                        }
						else
							Critical_Error( ERR_INSTALLMODULESET_NOTFOUND, "" );
					}
				}
				else
					if( eType == MINIMUM )
					{
						pRoot->Select( SiModule::ALL_MINIMAL );
						pEnv->SetInstallType( IT_MINIMAL );
					}
					else
					{
						pRoot->Select( SiModule::ALL_DEFAULT );
						pEnv->SetInstallType( IT_MAXIMAL );
					}
			}

			if( aDestinationPath.CompareIgnoreCaseToAscii("<firstfree>", 11) == COMPARE_EQUAL )
				#if defined(WIN) || defined(OS2) || defined(WNT)
				{
					aDestinationPath.Erase( 0, 11 );
					aDestinationPath.Insert( "c:", 0 );

					pEnv->SetDestPath( aDestinationPath );
					SiHelp::CorrectToFirstFreeVolume( pCScript, pEnv );
				}
				#else
				{Critical_Error( ERR_NOFIRSTFREE, "" );}
				#endif
			else
            if( aDestinationPath.CompareIgnoreCaseToAscii("<home>", 6) == COMPARE_EQUAL )
            {
                ByteString aMyHome;
                rtl::OUString suMyHomeURL;
                rtl::OUString suMyHome;
                NAMESPACE_VOS(OSecurity) aSecurity;

                aSecurity.getHomeDir( suMyHomeURL );

                if ( suMyHomeURL.getLength() )
                {
                    FileBase::getSystemPathFromFileURL( suMyHomeURL, suMyHome );
                    aMyHome = ByteString( UniString( suMyHome ), osl_getThreadTextEncoding() );
                    aDestinationPath.Erase( 0, 6 );
                    aDestinationPath.Insert( aMyHome, 0 );
                    pEnv->SetDestPath( aDestinationPath );
                }
                else
                    Critical_Error( ERR_NOHOME, "" );
            }
            else if( aDestinationPath.CompareIgnoreCaseToAscii("<application>", 13) == COMPARE_EQUAL )
            {
                ByteString aAppPath;
                rtl::OUString suAppPathURL;
                rtl::OUString suAppPath;
                NAMESPACE_VOS(OSecurity) aSecurity;

                aSecurity.getConfigDir( suAppPathURL );

                if ( suAppPathURL.getLength() )
                {
                    FileBase::getSystemPathFromFileURL( suAppPathURL, suAppPath );
                    aAppPath = ByteString( UniString( suAppPath ), osl_getThreadTextEncoding() );
                    aDestinationPath.Erase( 0, 13 );
                    aDestinationPath.Insert( aAppPath, 0 );
                    pEnv->SetDestPath( aDestinationPath );
                }
                else
                    Critical_Error( ERR_INVALID_DESTPATH, "" );
            }
            else
                pEnv->SetDestPath( aDestinationPath );

			SiDirEntry aDestPath( aDestinationPath );
			if( !aDestPath.IsValid() )
				Critical_Error( ERR_INVALID_DESTPATH, "" );

			if( !SiHelp::CheckInstallationSize(pCScript, pEnv, aDestPath) )
				Critical_Error( ERR_DISK_FULL, "" );

			nReturnEvent = EVT_START_INSTALL;
		} break;


		case REINSTALL :
		{
			if( pEnv->IsFirstInstallation() )
				{ Critical_Error(ERR_VERSIONNOTINSTALLED, ""); }

			if( aInstallProcedure.Len() )
			{
				SimpleProcedureAction* pProc = FindProc( aInstallProcedure );
				if( pProc )
					pProc->Execute( pCScript, *pEnv );
				else
					{ Critical_Error( ERR_INSTALLPROCEDURE_NOTFOUND, "" ); }
			}
			else if( aInstallModuleSet.Len() )
			{
				SiModuleSet* pSet = SiHelp::FindModuleSetByName(pEnv, aInstallModuleSet);
				if( pSet )
					pSet->Select();
				else
					{ Critical_Error( ERR_INSTALLMODULESET_NOTFOUND, "" ); }
			}

			if( aDeInstallProcedure.Len() )
			{
				SimpleProcedureAction* pProc = FindProc( aDeInstallProcedure );
				if( pProc )
					pProc->Execute( pCScript, *pEnv );
				else
					{ Critical_Error( ERR_DEINSTALLPROCEDURE_NOTFOUND, "" ); }
			}
			else if( aDeInstallModuleSet.Len() )
			{
				SiModuleSet* pSet = SiHelp::FindModuleSetByName(pEnv, aDeInstallModuleSet);
				if( pSet )
					pSet->DeSelect();
				else
					{ Critical_Error( ERR_DEINSTALLMODULESET_NOTFOUND, "" ); }
			}
            pEnv->SetInstallType( IT_CHANGE );
            nReturnEvent = EVT_REINST_CHANGE;
		} break;


		case DEINSTALL :
		{
			if( pEnv->IsFirstInstallation() )
				{ Critical_Error( ERR_VERSIONNOTINSTALLED, "" ); }

            pEnv->SetInstallType( IT_UNINSTALL );
			nReturnEvent = EVT_REINST_UNINSTALL;
		} break;

		case REPAIR :
		{
			if( pEnv->IsFirstInstallation() )
				{ Critical_Error( ERR_VERSIONNOTINSTALLED, "" ); }

            pEnv->SetInstallType( IT_RECOVER );
			nReturnEvent = EVT_REINST_RECOVER;
		} break;

		case RESPONSE_ONLY :
		{
		} break;
        case PATCH :
        {
            nReturnEvent = EVT_START_PATCH;
        } break;

	}

	if( aLogFile.Len() )
	{
		if( aLogFile.CompareIgnoreCaseToAscii("<instpath>", 10) == COMPARE_EQUAL )
		{
			aLogFile.Erase( 0, 10 );
			aLogFile.Insert( pEnv->GetDestPath(), 0 );
		}
		if( Critical::GetStaticInstance() )
		{
			SiDirEntry aEntry( aLogFile );
			aEntry.GetPath().MakeDir();
			Critical::GetStaticInstance()->SetLogFile( aLogFile );

			DateTime aDateTime;
			International aInternational;
			ByteString aDate( aInternational.GetDate(aDateTime).GetBuffer(), osl_getThreadTextEncoding() );
			ByteString aTime( aInternational.GetTime(aDateTime).GetBuffer(), osl_getThreadTextEncoding() );

			ByteString aMsg( "==========\nResponsFile Session\nstarted at " );
			aMsg += aDate;
			aMsg += ' ';
			aMsg += aTime;
			aMsg += "\n";

			Critical::GetStaticInstance()->WriteLog( aMsg );
		}
	}

	return nReturnEvent;
}


