/*************************************************************************
 *
 *  $RCSfile: phavefun.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/10 13:21:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "main.hxx"
#include "maindlg.hxx"
#include "script.hxx"
#include "environ.hxx"

#include "phavefun.hxx"
#include "phavefun.hrc"

PageHaveFun::PageHaveFun( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage			( pParent, rResId ),
	aFTInfo1	 		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2	  		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFTReboot	  		( this, ResId(FT_REBOOT, rResId.GetResMgr()) ),
	aFTRspWizard		( this, ResId(FT_RSPWIZARD, rResId.GetResMgr()) ),
	aFTReboot2	  		( this, ResId(FT_REBOOT2, rResId.GetResMgr()) ),
	aFTLogout			( this, ResId(FT_LOGOUT, rResId.GetResMgr()) ),
	aFTLogout2			( this, ResId(FT_LOGOUT2, rResId.GetResMgr()) ),
	aFTChange	  		( this, ResId(FT_CHANGE, rResId.GetResMgr()) ),
	aFTRecover	  		( this, ResId(FT_RECOVER, rResId.GetResMgr()) ),
	aFTUnInstall   		( this, ResId(FT_UNINSTALL, rResId.GetResMgr()) ),
	aFTUnInstall2   	( this, ResId(FT_UNINSTALL2, rResId.GetResMgr()) ),
	aFTUnInstallReboot	( this, ResId(FT_UNINSTALL_REBOOT, rResId.GetResMgr()) ),
	aFILogo		   		( this, ResId(IMG_STARLOGO, rResId.GetResMgr()) ),
	aFTPatch	   		( this, ResId(FT_PATCH, rResId.GetResMgr()) ),
	aStrRebootYes  	 	( ResId(STR_RESTART_BTN_YES, rResId.GetResMgr()) ),
	aStrRebootNo   		( ResId(STR_RESTART_BTN_NO, rResId.GetResMgr()) ),
	aStrLogoutYes		( ResId(STR_LOGOUT_BTN_YES, rResId.GetResMgr()) ),
	aStrLogoutNo		( ResId(STR_LOGOUT_BTN_NO, rResId.GetResMgr()) )
{
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );

	if( GETDLG()->GetEnv()->IsResponsefileWizardMode() )
		aText.SearchAndReplace( UniString::CreateFromAscii("%1"), String(ResId(STR_RSPWIZARD, rResId.GetResMgr())) );
	else if( GETDLG()->GetEnv()->GetInstallType() == IT_UNINSTALL )
		aText.SearchAndReplace( UniString::CreateFromAscii("%1"), String(ResId(STR_DEINST, rResId.GetResMgr())) );
	else if( GETDLG()->GetEnv()->GetInstallType() == IT_RECOVER )
		aText.SearchAndReplace( UniString::CreateFromAscii("%1"), String(ResId(STR_RECOVER, rResId.GetResMgr())) );
	else
		aText.SearchAndReplace( UniString::CreateFromAscii("%1"), String(ResId(STR_INST, rResId.GetResMgr())) );

	pParent->SetTitleStr( aText );

	aText = aFTRspWizard.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), GetAgentDlg()->GetNextText() );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), String(ResId(STR_RSPWIZARD, rResId.GetResMgr())) );
	aFTRspWizard.SetText( aText );

	FreeResource();

	GETDLG()->SetAskOnExit( FALSE );

	aText = aFTPatch.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), GETDLG()->GetNextText() );
	aFTPatch.SetText( aText );

	aText = aFTInfo1.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );

    if ( GETDLG()->GetEnv()->GetVendorName().Len() )
    {
        aText.SearchAndReplace( UniString::CreateFromAscii( "Sun Microsystems" ), 
                                UniString::CreateFromAscii( GETDLG()->GetEnv()->GetVendorName().GetBuffer() ) );
    }
	aFTInfo1.SetText( aText );

	aText = aFTInfo2.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), GetAgentDlg()->GetNextText() );
	aFTInfo2.SetText( aText );

	aText = aFTUnInstall.GetText();
	while( aText.SearchAndReplace(UniString::CreateFromAscii("%1"),
		   UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer())) != STRING_NOTFOUND ) {}
	aFTUnInstall.SetText( aText );

	aText = aFTUnInstall2.GetText();
	while( aText.SearchAndReplace(UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer())) != STRING_NOTFOUND ) {}
	aFTUnInstall2.SetText( aText );

	aFTReboot.Hide();
	aFTReboot2.Hide();
	aFTLogout.Hide();
	aFTLogout2.Hide();
	aFTRspWizard.Hide();

	aFTChange.Hide();
	aFTRecover.Hide();
	aFTUnInstall.Hide();
	aFTUnInstall2.Hide();
	aFTUnInstallReboot.Hide();
	aFTPatch.Hide();

	Size aSz( aFILogo.GetSizePixel() );
	aFILogo.SetPosPixel( Point(0, GetSizePixel().Height() - aSz.Height()) );
	aFILogo.Hide();

	bReboot = FALSE;
}

PageHaveFun::~PageHaveFun()
{
}

SvAgentPage* PageHaveFun::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageHaveFun( pParent, rResId );
}

void PageHaveFun::InitProperty(ULONG nProp)
{
	if( GETDLG()->GetEnv()->IsResponsefileWizardMode() )
		Application::PostUserEvent( EVT_START_RESPONSE_WIZARD );
}

BOOL PageHaveFun::AllowNext()
{
	if( bReboot && !GETDLG()->GetEnv()->IsDefuseRestart() )
	{
		QueryBox aBox( this, WB_YES_NO | WB_DEF_YES, UniString::CreateFromAscii("") );

		BOOL bLogout = GETDLG()->GetEnv()->IsLogout() && !GETDLG()->GetEnv()->IsReboot();
		if( bLogout )
		{
			String aText( aFTLogout2.GetText() );
			aText.SearchAndReplace( UniString::CreateFromAscii("%1"), aStrLogoutYes );
			aText.SearchAndReplace( UniString::CreateFromAscii("%2"), aStrLogoutNo );

			aBox.SetMessText( aText );
			aBox.SetButtonText( BUTTONID_YES, aStrLogoutYes );
			aBox.SetButtonText( BUTTONID_NO, aStrLogoutNo );
		}
		else
		{
			String aText( aFTReboot2.GetText() );
			aText.SearchAndReplace( UniString::CreateFromAscii("%1"), aStrRebootYes );
			aText.SearchAndReplace( UniString::CreateFromAscii("%2"), aStrRebootNo );

			aBox.SetMessText( aText );
			aBox.SetButtonText( BUTTONID_YES, aStrRebootYes );
			aBox.SetButtonText( BUTTONID_NO, aStrRebootNo );
		}

		if( aBox.Execute() == RET_NO )
		{
			GetAgentDlg()->EndAgentDlg(FALSE);
			return FALSE;
		}
	}
	return TRUE;
}

BOOL PageHaveFun::NotifyBack() const
{
/*	if( bReboot )
	{
		GetAgentDlg()->EndAgentDlg(FALSE);
		return FALSE;
	}
*/	return TRUE;
}

void PageHaveFun::ShowResponsfileWizard()
{
	aFTInfo1.Hide();
	aFTInfo2.Hide();
	aFTRspWizard.Show();
}

void PageHaveFun::ShowPatch()
{
	aFTInfo1.Hide();
	aFTPatch.Show();
}

void PageHaveFun::ShowChange()
{
	aFTInfo1.Hide();
	aFTChange.Show();
}

void PageHaveFun::ShowRecover()
{
	aFTInfo1.Hide();
	aFTRecover.Show();
}

void PageHaveFun::ShowUnInstall(BOOL Reboot)
{
	aFTInfo1.Hide();
	aFTInfo2.Hide();
	aFTUnInstall.Show();

	if( GETDLG()->GetEnv()->IsTimeCheck() )
		aFTUnInstall2.Show();

	if( Reboot )
	{
		aFTUnInstallReboot.Show();
		bReboot = TRUE;
	}
}

void PageHaveFun::ShowReboot()
{
/*	GetAgentDlg()->SetNextText( GetNextText() );
	GetAgentDlg()->SetBackText( GetBackText() );
*/
	BOOL bLogout = GETDLG()->GetEnv()->IsLogout() && !GETDLG()->GetEnv()->IsReboot();
	if( bLogout )
	{
		String aText = aFTLogout.GetText();
		aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
				UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
		aFTLogout.SetText( aText );
		aFTLogout.Show();
	}
	else
	{
		String aText = aFTReboot.GetText();
		aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
				UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );

		aFTReboot.SetText( aText );
		aFTReboot.Show();
	}

	aFTReboot2.Hide();
	aFTInfo2.Hide();

	bReboot = TRUE;
}

