/*************************************************************************
 *
 *  $RCSfile: intfrm.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:29:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#pragma hdrstop

#include "intfrm.hxx"
#include "sfxtypes.hxx"
#include "minarray.hxx"
#include "bitset.hxx"
#include "objsh.hxx"
#include "docfac.hxx"
#include "viewfac.hxx"
#include "viewsh.hxx"
#include "bindings.hxx"
#include "dispatch.hxx"
#include "request.hxx"
#include "sfxresid.hxx"
#include "docfile.hxx"
#include "fsetvwsh.hxx"
#include "urlframe.hxx"
#include "objitem.hxx"
#include "splitwin.hxx"
#include "topfrm.hxx"
#include "contenv.hxx"
#include <objshimp.hxx>

#include "sfx.hrc"

// STATIC DATA -----------------------------------------------------------

DECL_PTRARRAY( SfxInternalFrameArray_Impl, SfxInternalFrame *, 2, 1);

#define SfxInternalFrame
#include "sfxslots.hxx"

DBG_NAME(SfxInternalFrame);

class SfxInternalWin_Impl : public Window
{
friend class SfxInternalFrame;

	BOOL				bActive;
	SfxInternalFrame*	pFrame;

public:
						SfxInternalWin_Impl( SfxInternalFrame* p,
								Window *pParent, WinBits nBits=0 ) :
							Window( pParent, nBits | WB_BORDER | WB_CLIPCHILDREN ),
							pFrame( p ),
							bActive( FALSE )
						{
							SetBorderStyle( WINDOW_BORDER_NOBORDER );
						}

	virtual void		Resize();
};

//--------------------------------------------------------------------
void SfxInternalWin_Impl::Resize()
{
    pFrame->Resize();
}

//--------------------------------------------------------------------
TYPEINIT1(SfxInternalFrame,SfxViewFrame);

SFX_IMPL_INTERFACE(SfxInternalFrame,SfxViewFrame,SfxResId(0))
{
}

//--------------------------------------------------------------------
void SfxInternalFrame::Exec_Impl(SfxRequest &rReq)
{
	DBG_CHKTHIS(SfxInternalFrame, 0);
	switch ( rReq.GetSlot() )
	{
		case SID_CLOSEWIN:
		{
			GetFrame()->DoClose();
			rReq.Done();
			break;
		}

		case SID_ACTIVATE:
		{
			if ( GetObjectShell() )
			{
                MakeActive_Impl( TRUE );
                rReq.SetReturnValue( SfxObjectItem( 0, this ) );
			}

			break;
		}

		case SID_FRAME_NAME:
		case SID_FRAME_CONTENT:
		{
			rReq.AppendItem( SfxUInt16Item( SID_MODIFY_FRAME, GetFrame()->GetFrameId_Impl() ) );
			GetParentViewFrame()->GetViewShell()->ExecuteSlot( rReq );
			rReq.Done();
			break;
		}

		case SID_NEWWINDOW:
		{
			if ( GetParentViewFrame() &&
                ( GetParentViewFrame()->GetViewShell()->IsImplementedAsFrameset_Impl() ||
                    GetParentViewFrame()->GetFrame()->HasComponent() ) )
			{
				GetParentViewFrame()->ExecuteSlot( rReq );
				break;
			}

			SfxFrame *pFrame = GetFrame();
			SfxFrameDescriptor *pDescriptor = GetFrame()->GetDescriptor();

			// Gew"unschtes Dokument
			String aFileName( pDescriptor->GetActualURL().GetMainURL( INetURLObject::NO_DECODE ) );
			if ( !aFileName.Len() )
				break;

			SfxStringItem aName( SID_FILE_NAME, aFileName );
			SfxBoolItem aReadOnly( SID_DOC_READONLY, TRUE );
			SfxBoolItem aEdit( SID_EDITDOC, pDescriptor->IsEditable() );
			SfxAllItemSet aSet( SFX_APP()->GetPool() );
			SfxItemSet* pSet = pDescriptor->GetArgs();

			// Itemset des Descriptors kopieren
			aSet.Put( *pSet );

			// Readonly nur, wenn explizit gesetzt
			if ( aReadOnly.GetValue() )
				aSet.Put( aReadOnly );

			// Editable nur, wenn explizit ausgeschlossen
			if ( !aEdit.GetValue() )
				aSet.Put( aEdit );

			// und eigene Parameter hinzuf"ugen
			aSet.Put( aName, aName.Which() );

			// Falls noch kein Referer gesetzt: das Frameset nehmen
			SfxObjectShell *pParentDoc = pFrame->GetParentFrame()->GetCurrentDocument();
			SFX_ITEMSET_ARG( &aSet, pRefererItem, SfxStringItem,
							 SID_REFERER, FALSE );
			if ( !pRefererItem || !pRefererItem->GetValue().Len() )
				aSet.Put( SfxStringItem( SID_REFERER,
				pParentDoc->GetMedium()->GetName() ) );

			GetDispatcher()->Execute(
					SID_OPENDOC, SFX_CALLMODE_ASYNCHRON, aSet );
			break;
		}
		
		case SID_NEWDOCDIRECT:
		{
			if ( GetParentViewFrame() )
				GetParentViewFrame()->ExecuteSlot( rReq );
			break;
		}
	}
}

//--------------------------------------------------------------------
void SfxInternalFrame::GetState_Impl(SfxItemSet &rSet)
{
	DBG_CHKTHIS(SfxInternalFrame, 0);

	const USHORT *pRanges = rSet.GetRanges();
	DBG_ASSERT(pRanges, "Set ohne Bereich");
	while ( *pRanges )
	{
		for ( USHORT nWhich = *pRanges++; nWhich <= *pRanges; ++nWhich )
		{
			switch(nWhich)
			{
				case SID_WIN_FULLSCREEN:
					rSet.DisableItem( SID_WIN_FULLSCREEN );
					break;

				case SID_FRAME_NAME:
					rSet.Put( SfxStringItem( SID_FRAME_NAME, GetFrame()->GetFrameName() ) );
					break;

				case SID_FRAME_CONTENT:
					if ( GetObjectShell() )
						rSet.Put( SfxStringItem( SID_FRAME_CONTENT, GetObjectShell()->GetMedium()->GetName() ) );
					else
						rSet.Put( SfxStringItem( SID_FRAME_CONTENT, String() ) );
					break;
				case SID_NEWWINDOW:
					if ( GetParentViewFrame() &&
						GetParentViewFrame()->GetViewShell()->IsImplementedAsFrameset_Impl() )
						GetParentViewFrame()->GetSlotState( nWhich, 0, &rSet );
					break;

				case SID_NEWDOCDIRECT:
					if ( GetParentViewFrame() )
						GetParentViewFrame()->GetSlotState( nWhich, 0, &rSet );
					break;
			}
		}
	}
}

//--------------------------------------------------------------------
void SfxInternalFrame::INetExecute_Impl(SfxRequest &rReq)
{
	DBG_CHKTHIS(SfxInternalFrame, 0);
}

//--------------------------------------------------------------------
void SfxInternalFrame::INetState_Impl(SfxItemSet &rSet)
{
	DBG_CHKTHIS(SfxInternalFrame, 0);
}

//--------------------------------------------------------------------
void SfxInternalFrame::SetZoomFactor( const Fraction &rZoomX,
									 const Fraction &rZoomY )
{
	GetViewShell()->SetZoomFactor( rZoomX, rZoomY );
}

//--------------------------------------------------------------------
String SfxInternalFrame::UpdateTitle()

/*	[Beschreibung]

	SfxInternalFrames haben einen fest zugeordneten Namen und bekommen
	NICHT den des Dokuments mit angeh"angter Nummer. Daher wird die
	Basismethode <SfxViewFrame::UpdataeTitle()> abgefangen.
*/

{
	String aSbxName;
	if ( GetFrame() )
		aSbxName = String( GetFrame()->GetFrameName() );

	String aRet;
	if ( GetObjectShell() )
	{
		aRet = SfxViewFrame::UpdateTitle();
		if ( aSbxName.Len() )
			SetName( aSbxName );
	}
	else
	{
		if ( aSbxName.Len() )
			SetName( aSbxName );
		else if ( GetParentViewFrame() )
		{
			String aParentName( GetParentViewFrame()->GetName() );
			aParentName += '/';
			aParentName += String::CreateFromInt32( GetFrame()->GetFrameId_Impl() );
			SetName( aParentName );
		}
	}

	if ( aSbxName.Len() )
		return aSbxName;
	else
		return aRet;
}

//--------------------------------------------------------------------
BOOL SfxInternalFrame::Close()
{
	{DBG_CHKTHIS(SfxInternalFrame, 0);}

	if ( !SfxViewFrame::Close() )
		return FALSE;

	// Da das Fenster selbst hier nicht geclosed wird, mu\s das Deactivate
	// selbst erzeugt werden
    SfxViewFrame* pParent = GetParentViewFrame();

	// Wieso nicht bei FloatingFrames ?? Wird nicht der active frame
	// zur"uckgesetzt, -> GPF in Draw bei Ende der Presentation, wenn Focus
	// im Frame war!
	if ( /* ( pTop->GetFrameType() & SFXFRAME_FRAMESET ) && */
        pParent->GetActiveChildFrame_Impl() == this )
        pParent->SetActiveChildFrame_Impl( NULL );

	SfxApplication *pSfxApp = SFX_APP();
	if ( pSfxApp->GetViewFrame() == this )
	{
        if ( pParent->GetFrame()->IsClosing_Impl() )
            // ParentFrame auch aktivieren, wenn der gerade in SwitchToViewShell ist, sonst droht GPF
			// sollte ja auch kein Problem sein, denn w"ahrend SwitchToViewShell ist ein aktiver
			// ViewFrame ohne ViewShell ja v"ollig normal
			SFX_APP()->SetViewFrame( NULL );
		else
            pParent->MakeActive_Impl( pWin->HasChildPathFocus( TRUE ) );
	}
	delete this;
	return TRUE;
}

//--------------------------------------------------------------------
void SfxInternalFrame::Activate( BOOL bMDI )
{
	DBG_CHKTHIS(SfxInternalFrame, 0);
	DBG_ASSERT(GetViewShell(), "Keine Shell");
	if ( bMDI && !pWin->bActive )
		pWin->bActive = TRUE;
}

//--------------------------------------------------------------------
void SfxInternalFrame::Deactivate( BOOL bMDI )
{
	DBG_CHKTHIS(SfxInternalFrame, 0);
	pWin->bActive = FALSE;
}

// CTOR / DTOR -----------------------------------------------------------
SfxInternalFrame::SfxInternalFrame( Window *pWindow, SfxFrame *pFrame,
		SfxInternalFrameData_Impl *pData, SfxObjectShell *pDoc )
	: SfxViewFrame( pData->bHasToolSpace ? *(new SfxBindings) :
		pFrame->GetParentFrame()->GetCurrentViewFrame()->GetBindings(),
		pFrame, pDoc )
{
	DBG_CTOR(SfxInternalFrame, 0);

	if ( pData->bHasToolSpace )
	{
		GetFrame()->SetOwnsBindings_Impl(TRUE);
		GetFrame()->CreateWorkWindow_Impl();
	}

	GetFrame()->SetFrameType_Impl( GetFrameType() | SFXFRAME_INTERNAL | SFXFRAME_OWNSDOCUMENT );
	SetMargin_Impl( pData->aMargin );

	// Internes Window erh"alt "ubergebenen parent
	pWin = new SfxInternalWin_Impl( this, pWindow /*, pData->bHasToolSpace ? WB_BORDER : 0 */ );
	SetWindow_Impl( pWin );
	pWin->SetPosPixel( pData->aWinPos );
	pWin->bActive = FALSE;

	// Nicht die Gr"o\se direkt abholen, denn pWindow malt seinen Border selbst!
	pWindow->Resize();
	Show();

	// View laden bzw. erzeugen
	if ( pDoc )
	{
		CreateView_Impl( pData->nViewId, pData );

		if ( pData->eScrollingMode != SCROLLING_DEFAULT )
		{
			DoAdjustPosSizePixel(GetViewShell(), Point(),
				GetWindow().GetOutputSizePixel());
		}

		// Name setzen (l"ost Broadcast SFX_HINT_TITLE_CHANGED aus)
		pDoc->SetNamedVisibility_Impl();
	}

	if ( pData->bHasToolSpace )
		GetBindings().SetDispatcher( GetDispatcher() );

	if ( !pData->bHasUI )
		GetDispatcher()->HideUI( TRUE );
}

//-------------------------------------------------------------------------
SfxInternalFrame::~SfxInternalFrame()
{
	DBG_DTOR(SfxInternalFrame, 0);

	if ( GetObjectShell() )
		SfxViewFrame::ReleaseObjectShell_Impl();
	delete pWin;
}

//--------------------------------------------------------------------
SfxViewShell* SfxInternalFrame::CreateView_Impl( USHORT nViewId,
	SfxInternalFrameData_Impl *pData )

/*	[Beschreibung]

	Erzeugt eine (die erste und einzige) SfxViewShell f"ur diesen
	SfxInternalFrame.
*/

{
	// per Factory erzeugen
	DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );

	SwitchToViewShell_Impl( nViewId );
	SfxViewShell *pViewShell = GetViewShell();
	pViewShell->SetScrollingMode( pData->eScrollingMode );
	return pViewShell;
}

//------------------------------------------------------------------------
void SfxInternalFrame::InvalidateBorderImpl( const SfxViewShell* pViewSh )
{
	if ( pViewSh && GetWindow().IsVisible() )
		DoAdjustPosSizePixel( (SfxViewShell*)pViewSh, Point(), GetWindow().GetOutputSizePixel() );
}

//------------------------------------------------------------------------
BOOL SfxInternalFrame::SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder )
{
	if( SfxViewFrame::SetBorderPixelImpl( pSh, rBorder ) )
	{
		Point aDefPoint;
		Rectangle aEditArea( aDefPoint, GetWindow().GetOutputSizePixel() );
		aEditArea.Left() += rBorder.Left();
		aEditArea.Right() -= rBorder.Right();
		aEditArea.Top() += rBorder.Top();
		aEditArea.Bottom() -= rBorder.Bottom();
		pSh->GetWindow()->SetPosSizePixel( aEditArea.TopLeft(), aEditArea.GetSize() );
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------
void SfxInternalFrame::Resize()
{
	SfxViewShell *pViewShell = GetViewShell();
	if ( pViewShell )
	{
		if ( pViewShell->UseObjectSize() )
			ForceOuterResize_Impl(TRUE);
		DoAdjustPosSizePixel( pViewShell, Point(),
							GetWindow().GetOutputSizePixel() );
		if ( pViewShell->UseObjectSize() )
			ForceOuterResize_Impl(FALSE);
	}
}

//--------------------------------------------------------------------
void SfxInternalFrame::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	// we know only SimpleHints
	BOOL bHandled = FALSE;
	if ( rHint.IsA(TYPE(SfxSimpleHint)) )
	{
		switch( ( (SfxSimpleHint&) rHint ).GetId() )
		{
            case SFX_HINT_DEINITIALIZING:
				// on all other changes force repaint
				GetFrame()->DoClose();
				bHandled = TRUE;
				break;
		}
	}

	if ( !bHandled )
		SfxViewFrame::Notify( rBC, rHint );
}

//--------------------------------------------------------------------
void SfxInternalFrame::TakeFrameData_Impl( SfxInternalFrameData_Impl *pData )
{
	SfxViewShell *pOldSh = GetViewShell();
	SfxInternalWin_Impl *pOldWin = pWin;

	DBG_ASSERT( pOldWin, "Das Fenster ist weg!" );

	if ( !pOldSh )
	{
		if ( GetObjectShell() )
		{
			// Neues Fenster und neue ViewShell erzeugen
			pWin = new SfxInternalWin_Impl( this, pOldWin->GetParent() );
			pWin->bActive = pOldWin->bActive;
			pWin->SetSizePixel( pOldWin->GetSizePixel() );
			Show();
			CreateView_Impl( pData->nViewId, pData );
		}
	}
	else
	{
		// Kein neues Fenster, also Parameter einzeln checken
		BOOL bScrollingModeChanged =
			( pOldSh->GetScrollingMode() != pData->eScrollingMode );
		BOOL bMarginChanged =
			( pOldSh->GetMargin() != pData->aMargin );
		if ( bScrollingModeChanged )
		{
			GetViewShell()->SetScrollingMode( pData->eScrollingMode );
			DoAdjustPosSizePixel(GetViewShell(), Point(),
				GetWindow().GetOutputSizePixel());
		}

		if ( bMarginChanged )
		{
			SetMargin_Impl( pData->aMargin );
			GetViewShell()->SetMargin( pData->aMargin );
		}
	}

	GetDispatcher()->HideUI( !pData->bHasUI );

	// Altes Window l"oschen
	if ( pWin != pOldWin )
	{
		pOldWin->Hide();
		delete pOldWin;
	}
}


