/*************************************************************************
 *
 *  $RCSfile: Test10.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: kz $ $Date: 2003/05/13 10:28:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// __________ Imports __________

import com.sun.star.beans.*;
import com.sun.star.frame.*;
import com.sun.star.lang.*;
import com.sun.star.uno.*;
import java.lang.*;
import java.util.*;

// __________ Implementation __________

/** implements the new 10erTest for an office.
 *
 *  @author     Andreas Schlns
 *  @created    14.04.2003 06:40
 */
public class Test10
{
    //_________________________________
    // const

    //_________________________________
    // member

    /** provides access to the remote office. */
    private OfficeConnect m_aOffice;

    //_________________________________
    // main

    public static void main(java.lang.String[] lArguments)
    {
        // open connection to an office or start it automaticly
        // Use given command line parameters doing so.
        try
        {
            OfficeConnect.createConnection(lArguments);
        }
        catch(java.net.ConnectException exConnect)
        {
            System.out.println("Could not connect to office ...");
            System.exit(-1);
        }

        // analyze additional command line parameters.
        String sTestSXW = new String("");

        for(int i=0; i<lArguments.length; ++i)
        {
            if(lArguments[i].startsWith("testsxw=")==true)
                sTestSXW = lArguments[i].substring(8);
        }

        if (sTestSXW.length()<1)
        {
            System.out.println("Miss argument for 10erTest file ...");
            System.exit(-2);
        }

        // start test case
        try
        {
            System.out.println("start 10er test ...");

            OfficeConnect aOffice = OfficeConnect.getDefaultConnection();
            Test10        aTest   = new Test10(aOffice);
            aTest.test(sTestSXW);

            System.out.println("... test finished");
        }
        catch(java.lang.Throwable exBrokenTest)
        {
            System.out.println("... test failed");
            // don't call exist here!
            // Because the office is already in use and an exist can
            // damage it! It's better to terminate() it ...
        }

        // cancel the connection
        // It stops an external office (if it was started by ourself) too.
        System.out.println("disconnect");
        OfficeConnect.disconnect();

        System.out.println("exit normal!");
        System.exit(0);
    }

    //_________________________________
    // ctor

    public Test10(OfficeConnect aOffice)
    {
        m_aOffice = aOffice;
    }

    //_________________________________

    /** loads the test document and executes the macro.
     *
     *  It returns normaly for success - but throws exceptions for failed operations.
     *
     *  @param sSXW
     *          an absolute URL, which points to the test sxw document.
     */
    public void test(java.lang.String sSXW)
        throws java.lang.Exception
    {
        // try to load test document
        com.sun.star.beans.PropertyValue[] lArgs = new com.sun.star.beans.PropertyValue[1];
        lArgs[0] = new com.sun.star.beans.PropertyValue();
        lArgs[0].Name  = "MacroExecutionMode";
        lArgs[0].Value = new Short((short)2);

        com.sun.star.frame.XFrame xFrame = loadDocumentIntoNewFrame(sSXW, lArgs);
        if (xFrame==null)
            throw new java.lang.Exception("loading test doc \""+sSXW+"\" failed ...");

        // execute the macro
        DispatchListener aListener = new DispatchListener();
        executeWithNotification(xFrame, "macro://./Standard.Global.StartTestWithDefaultOptions", lArgs, aListener);

        // wait till the macro was finished
        synchronized(aListener.m_bFinished)
        {
            while (!aListener.m_bFinished.booleanValue())
            {
                System.out.println("waits for macro ..." +aListener.m_bFinished.booleanValue() );
                aListener.m_bFinished.wait(1000);
            }
        }
        System.out.println("macro finished ...");

        /* Attention:
         * May the broadcaster notified us to early ...
         * and basic needs eome time to release it's own structures,
         * then it would not be a good idea to finish this test and
         * terminate the office explicitly. It can crash.
         * It seems to be better to wait some seconds here ... */
        java.lang.Thread.sleep(5000);

        if (!closeFrame(xFrame))
            throw new java.lang.Exception("frame could not be closed ...");

        boolean bOK = false;
        if (aListener.m_aResult.State != com.sun.star.frame.DispatchResultState.SUCCESS)
            throw new java.lang.Exception("execution of macro failed ...");
    }

    //_________________________________

    /** load the specified document into the a new created frame.
     *
     *  This frame will be part of the global frame tree of the office
     *  and will be recognized on Desktop.terminate() too.
     *
     *  @param sURL
     *          the absolute document URL for loading.
     *
     *  @param lProperties
     *          optional arguments for loading.
     *
     *  @param A valid frame referenceif loading was successfully - otherwhise NULL.
     */
    public com.sun.star.frame.XFrame loadDocumentIntoNewFrame(java.lang.String                   sURL       ,
                                                              com.sun.star.beans.PropertyValue[] lProperties)
    {
        com.sun.star.frame.XFrame xFrame = null;
        try
        {
            com.sun.star.frame.XFrame xDesktop = null;
            synchronized(this)
            {
                xDesktop = (com.sun.star.frame.XFrame)m_aOffice.createRemoteInstance(
                            com.sun.star.frame.XFrame.class,
                            "com.sun.star.frame.Desktop");
            }
            // create an empty frame
            xFrame = xDesktop.findFrame("_blank", 0);
            com.sun.star.frame.XComponentLoader xLoader = (com.sun.star.frame.XComponentLoader)UnoRuntime.queryInterface(
                                                            com.sun.star.frame.XComponentLoader.class,
                                                            xFrame);
            // load the document into this frame
            com.sun.star.lang.XComponent xDoc = xLoader.loadComponentFromURL(sURL, "_self", 0, lProperties);

            // of loading failed - don't forget to remove the frame!
            if (xDoc==null)
            {
                closeFrame(xFrame);
                xFrame = null;
            }
        }
        catch(java.lang.Throwable exAny)
        {
            if (xFrame!=null)
            {
                closeFrame(xFrame);
                xFrame = null;
            }
        }
        return xFrame;
    }

    //_________________________________

    /** close a frame right.
     *
     *  Because there exist more then one possible interfaces
     *  we must used in a defined order.
     *
     *  @param xFrame
     *          the frame, which should be closed.
     *
     *  @return TRUE if closing was successfully - FALSE otherwhise.
     */
    public boolean closeFrame(com.sun.star.frame.XFrame xFrame)
    {
        boolean bClosed = false;
        try
        {
            // first try the new way: use new interface XCloseable
            // It replace the deprecated XComponent::dispose() and should be preferred ... if it can be queried.
            com.sun.star.util.XCloseable xCloseable = (com.sun.star.util.XCloseable)UnoRuntime.queryInterface(
                                                       com.sun.star.util.XCloseable.class,
                                                       xFrame);
            if (xCloseable!=null)
            {
                // We deliver the owner ship of this frame not to the (possible) source
                // which throw a CloseVetoException. We whish to have it under our own control.
                try
                {
                    xCloseable.close(false);
                    bClosed = true;
                }
                catch(com.sun.star.util.CloseVetoException exVeto)
                {
                    bClosed = false;
                }
            }
            else
            {
                // OK: the new way isn't possible. Try the old one.
                com.sun.star.lang.XComponent xDisposeable = (com.sun.star.lang.XComponent)UnoRuntime.queryInterface(
                    com.sun.star.lang.XComponent.class,
                    xFrame);
                if (xDisposeable!=null)
                {
                    // return value doesn't interest here. Because
                    // we forget this frame ...
                    try
                    {
                        xDisposeable.dispose();
                        bClosed = true;
                    }
                    catch(com.sun.star.lang.DisposedException exDisposed)
                    {
                        // disposed + disposed = disposed!
                        bClosed = true;
                    }
                }
            }
        }
        catch(java.lang.Throwable exAny)
        {
            // ???
            bClosed = false;
        }

        return bClosed;
    }

    //_________________________________

    /** dispatch an URL to given frame and listen for it's notifications.
     *
     *  Caller can register himself for following result events for dispatched
     *  URL too. Notifications are guaranteed (instead of dispatch())
     *  Returning of the dispatch object isn't neccessary.
     *  Nobody must hold it alive longer the dispatch needs.
     *
     *  @param xFrame
     *          frame wich should be ued as target of this dispatch.
     *
     *  @param sURL
     *          URL for this dispatch (will be parsed internaly!)
     *
     *  @param lProperties
     *          optional arguments for dispatch
     *
     *  @param xListener
     *          optional listener which is registered automaticly for status events
     *          (Note: Deregistration is done automaticly.)
     */
    public void executeWithNotification(com.sun.star.frame.XFrame                  xFrame     ,
                                        java.lang.String                           sURL       ,
                                        com.sun.star.beans.PropertyValue[]         lProperties,
                                        com.sun.star.frame.XDispatchResultListener xListener  )
    {
        try
        {
            // Query the frame for right interface which provides access to all available dispatch objects.
            com.sun.star.frame.XDispatchProvider xProvider = (com.sun.star.frame.XDispatchProvider)UnoRuntime.queryInterface(
                com.sun.star.frame.XDispatchProvider.class,
                xFrame);

            // Ask himn for right dispatch object for given URL.
            // Force THIS frame as target for following dispatch.
            // Attention: The interface XNotifyingDispatch is an optional one!
            com.sun.star.util.URL        aURL        = parseURL(sURL);
            com.sun.star.frame.XDispatch xDispatcher = xProvider.queryDispatch(aURL,"",0);
            com.sun.star.frame.XNotifyingDispatch xNotifyingDispatcher = (com.sun.star.frame.XNotifyingDispatch)UnoRuntime.queryInterface(
                com.sun.star.frame.XNotifyingDispatch.class,
                xDispatcher);

            // Dispatch the URL.
            xNotifyingDispatcher.dispatchWithNotification(aURL,lProperties,xListener);
        }
        catch(java.lang.Throwable exAny)
        {
            if (xListener!=null)
            {
                com.sun.star.frame.DispatchResultEvent aResult = new com.sun.star.frame.DispatchResultEvent();
                aResult.State = com.sun.star.frame.DispatchResultState.DONTKNOW;
                xListener.dispatchFinished(aResult);
            }
        }
    }

    //_________________________________

    /** this convert an URL (formated as a string) to a struct com.sun.star.util.URL.
     *
     *  It use a special service to do that: the URLTransformer.
     *  Because some API calls need it and it's not allowed to set "Complete"
     *  part of the util struct only. The URL must be parsed.
     *
     *  @param sURL
     *          URL for parsing in string notation
     *
     *  @return [com.sun.star.util.URL]
     *              URL in UNO struct notation, or NULL if operation failed.
     */
    public com.sun.star.util.URL parseURL(java.lang.String sURL)
    {
        com.sun.star.util.URL aURL = null;
        try
        {
            // Because it's an in/out parameter we must use an array of URL objects.
            com.sun.star.util.URL[] aParseURL = new com.sun.star.util.URL[1];
            aParseURL[0] = new com.sun.star.util.URL();
            aParseURL[0].Complete = sURL;

            // Create special service for parsing of given URL.
            com.sun.star.util.XURLTransformer xParser = null;
            synchronized(this)
            {
                xParser = (com.sun.star.util.XURLTransformer)m_aOffice.createRemoteInstance(
                           com.sun.star.util.XURLTransformer.class,
                           "com.sun.star.util.URLTransformer");
            }

            // Parse the URL
            xParser.parseStrict(aParseURL);
            aURL = aParseURL[0];
        }
        catch(java.lang.Throwable exAny)
        {
            aURL = null;
        }

        return aURL;
    }

    //_________________________________

    /** inner class to implement a listener for DispatchResultEvents.
     */
    private class DispatchListener implements com.sun.star.frame.XDispatchResultListener
    {
        public Boolean                                m_bFinished = Boolean.FALSE;
        public com.sun.star.frame.DispatchResultEvent m_aResult   = null;

        //-----------------------------
        public DispatchListener()
        {
            m_bFinished = Boolean.FALSE;
        }

        //-----------------------------
        public void dispatchFinished(com.sun.star.frame.DispatchResultEvent aResult)
        {
            synchronized(m_bFinished)
            {
                m_aResult   = aResult;
                m_bFinished = Boolean.TRUE;
                m_bFinished.notifyAll();
            }
        }

        //-----------------------------
        public void disposing(com.sun.star.lang.EventObject aSource )
        {
            synchronized(m_bFinished)
            {
                m_bFinished = Boolean.TRUE;
                m_bFinished.notifyAll();
            }
        }
    }
}
