:
eval 'exec perl -wS $0 ${1+"$@"}'
    if 0;
#*************************************************************************
#
#   $RCSfile: setsolar.pl,v $
#
#   $Revision: 1.17.64.2 $
#
#   last change: $Author: rt $ $Date: 2004/04/08 15:45:01 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

#
# setsolar.pl - set solar environment
# getsolar.pl - get product information
#

# TODO: clean up command line argument handling. The current ad hoc way 
#       of handling command line arguments which are needed before 
#       calling parse_setsolar_args() should be generalized

use FindBin qw($Bin);

use lib "$Bin/modules";
use GenInfoParser;
use File::Basename;
use File::Copy;
use File::Path;

#### script id #####

( $script_name = $0 ) =~ s/^.*\b(\w+)\.pl$/$1/; 

$id_str = ' $Revision: 1.17.64.2 $ ';
$id_str =~ /Revision:\s+(\S+)\s+\$/
  ? ($script_rev = $1) : ($script_rev = "-");

print "$script_name -- version: $script_rev\n";

#### hard coded paths ####

# default env_localini
$b_server_wnt   = 'r:/b_server/config';                     
$b_server_wnt   = "$Bin/../config" if ! -d $b_server_wnt;
$b_server_unx   = $ENV{ENV_ROOT} . '/b_server/config';
$b_server_unx   = '/so/env/b_server/config'
                        if ! -d $b_server_unx;
$b_server_unx   = '/net/jumbo.germany/cvs/buildenv/b_server/config' 
                        if ! -d $b_server_unx;
$b_server_unx   = "$Bin/../config" if ! -d $b_server_unx;
$ssolarcmn      = 'ssolar.cmn';
$standlst       = 'stand.lst';
# log directories, for Hamburg use only
$log_dir_wnt   = 'r:/b_server/sslog';
$log_dir_unx   = $ENV{ENV_ROOT} . '/b_server/sslog';
$log_dir_unx   = '/so/env/b_server/sslog'
                        if ! -d $log_dir_unx;
$log_dir_unx   = '/net/jumbo.germany/cvs/buildenv/b_server/sslog'
                        if ! -d $log_dir_unx;

#### globals ####

# Note: variables with "$format_" prefix are reserved for
# formatted output. They have to be global.

$is_debug           = 0;    # debug flag
$localini           = 0;    # place where all the databases are held

# setsolar globals
$setsolar::platform  = 0;   # selected platform
$setsolar::shell     = 0;   # issue commands for this shell
$setsolar::scriptdir = 0;   # where scripts are stored in 'product' mode
# command line args which are always valid, a colon indicates a required value
@setsolar::fixed_args = qw(file: log map product: shell: ver:);

#### main ####

common::update_localini();

my ($mode, $product) = common::get_mode();
if ( $mode eq 'getsolar' ) {
    getsolar::getsolar();
} 
else {
    setsolar::setsolar($mode, $product);
}

exit(0);

#### setsolar subroutines #####

package setsolar;
# subroutines for 'setsolar' mode
        
sub setsolar
{
    my $mode    = shift;
    my $product = shift;

    # This script uses something what I would call 'dynamic'
    # command line arguments.
    
    # 'classic' mode: First search the command line for an argument 
    # which looks like workstamp. Search for this workstamp in 'stand.lst'.
    
    # 'product' mode: First determine all workstamps belonging to the product,
    # then verify the args against the workstamp like in the 'classic' mode


    local $workstamp_db = GenInfoParser->new();
    common::load_database($workstamp_db, "$main::localini/$main::standlst");
    my @workstamps = $workstamp_db->get_keys();

    # ### check for responsefile in arguments
    response_argv( \@ARGV );

    # initialize shell
    init_shell(\@ARGV);
    
    if ( $mode eq 'product' ) {
        # 'product' mode
        my ($login, $temp, $shell_pid) = get_prerequisites();
        my $cache_dir = "$temp/buildcache.$login";
        cleanup_script_cache($cache_dir);

        if ( ! -d $cache_dir ) {
            if ( -e $cache_dir ) {
                common::print_error("'$cache_dir' is not a directory", 1);
            }
            else {
                main::mkpath($cache_dir, 0, 0755);
            }
        }

        my $products_hash_ref = common::get_products($workstamp_db);
        my $product_key = common::normalize_pr_key($product);
        # sanity check
        if ( !exists $$products_hash_ref{$product_key} ) {
            common::print_error("there is no such product '$product'!", 2);
        }
        my $entry_ref = $$products_hash_ref{$product_key};
        my $main_workstamp = $$entry_ref[1];
        
        # collect all base workstamps
        my @bases = ();
        get_bases(\@bases, $$entry_ref[3], $products_hash_ref);
        
        # create the directory where the scripts will be stored
        $scriptdir = "$cache_dir/$shell_pid";
        main::mkpath($scriptdir, 0, 0755);
        my $ext = batch_ext();

        # do setsolar mechanism for $main_workstamp
        # patch argument vector before invoking setsolar mechanism
        my @argv = @ARGV;
        my $save_file = patch_argv(\@argv, 'file', "$scriptdir/$main_workstamp$ext");
        if ( !defined($save_file) ) {
            common::print_error("obligatory '-file' command line argument is missing or incomplete!", 4);
        }
        my @source_scripts = ();
        my $ca_mode = get_local_environment(\@argv);
        if ($ca_mode eq 'ca' ) {
            # horrible hack to support local environments
            my @argv_ca = @argv;
            patch_argv(\@argv_ca, 'file', "$scriptdir/$main_workstamp.ca$ext");
            parse_setsolar_args(\@argv_ca, $main_workstamp, $mode, $product);
            # replace any -ca switch with -cax
            foreach (@argv) {
                s/^-ca$/-cax/;
            }
        }
        parse_setsolar_args(\@argv, $main_workstamp, $mode, $product);
        # push this script on the list of scripts to be sourced
        push (@source_scripts, "$scriptdir/$main_workstamp$ext");
        
        # Collect all workstamp, minor pairs in a hash. This hash will be dumped
        # to the initial source script. Note that for UDK??? workspaces we don't pass
        # the minor to the parse_setsolar_args(), thus we have to keep them seperate.
        my $main_minor = get_main_workstamp_minor();
        my %workstamps_envset_minors = ();
        $workstamp_envset_minors{$main_workstamp} = $main_minor;
        # do setsolar mechanism for @bases
        foreach my $workstamp (@bases) {
            print "\n";
            my @argv = @ARGV;
            my $minor = get_base_workstamp_minor($workstamp, $main_workstamp, $main_minor);
            if ( defined($main_minor) && !defined($minor) ) {
                print("NOTE: can't determine minor for '$workstamp', will use flat ...\n");
                print("NOTE: the probable cause is that minor '$main_minor' of '$main_workstamp'\n");
                print("NOTE: has not been copied back yet!\n");
            }

            $workstamp_envset_minors{$workstamp} = $minor;
            # UDK workspaces don't have minors on solver, special handling
            $minor = undef if $workstamp =~ /UDK/i;

            if ( $ca_mode eq 'ca' ) {
                # horrible hack to support local environments
                # patch argument vector
                my @argv_ca = @argv;
                patch_argv(\@argv_ca, 'file', "$scriptdir/$workstamp.ca$ext");
                patch_argv(\@argv_ca, 'ver', $minor);
                parse_setsolar_args(\@argv_ca, $workstamp, $mode, $product);
                # replace any -ca switch with -cax
                foreach (@argv) {
                    s/^-ca$/-cax/;
                }
            }
            push (@source_scripts, "$scriptdir/$workstamp$ext");
            # patch argument vector
            patch_argv(\@argv, 'file', "$scriptdir/$workstamp$ext");
            patch_argv(\@argv, 'ver', $minor);
            parse_setsolar_args(\@argv, $workstamp, $mode, $product);
        }

        # write out one time source script
        dump_source_script($save_file, $ca_mode, 
                            \@source_scripts, \%workstamp_envset_minors);

        # write out modules.mk file
        dump_modules_mk("$scriptdir/modules.mk", $main_workstamp, @bases);

        # and finally log the use of the "product" switch
        # no logging for release engineers
        if ( !defined($ENV{'UPDATER'}) || $ENV{'UPDATER'} ne 'YES' ) {
            my $log;
            if ( $^O eq 'MSWin32' ) {
                $log = "$main::log_dir_wnt/" . 'vpwstats.log';
            }
            else {
                $log = "$main::log_dir_unx/" . 'vpwstats.log';
            }
            # do not complain if log file is not writable
            if ( open(LOG_PRODUCT, ">>$log") ) {
                my ($sec, $min, $hour, $mday, $mon, $year) = localtime(time());
                $year = substr($year,1);
                my $login_name = getlogin() || getpwuid($<) || "unkown";
                $format_login_name = "$login_name";
                $format_date  .= sprintf('%02d.%02d.%02d-%02d:%02d:%02d', 
                                                $mday, $mon+1, $year, $hour, $min, $sec);
                $format_product = $product;
                write LOG_PRODUCT;
                close(LOG_PRODUCT);
            }
        }
    }
    else {
        # 'classic' mode
        my %workstamp_hash = ();
        for (@workstamps) {
            $workstamp_hash{lc($_)}++;
        }

        $workstamp = match_args_with_hash(\@ARGV, \%workstamp_hash);

        if ( !$workstamp ) {
            # Get default workstamp.
            # We have to go over all workstamps to
            # find one with the 'now' flag set to _TRUE.
            for (@workstamps) {
                if ( $workstamp_db->get_value("$_/settings/now") =~ /true/i ) {
                    $workstamp = $_;
                    last;
                }
            }
            if ( !$workstamp ) {
                common::print_error("PANIC: no default workstamp in database", 2);
            }
        }
        parse_setsolar_args(\@ARGV, $workstamp, $mode, $product);
    }
}

format LOG_PRODUCT =
@<<<<<<<<< @<<<<<<<<<<<<<          @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$format_login_name, $format_date, $format_product
.

sub parse_setsolar_args {
    # Determine which arguments are allowed for this particular
    # workstamp and check the rest of the commandline against
    # these and the fixed command line arguments.
    my $setsolar_args_ref   = shift;
    my $workstamp           = shift;
    my $mode                = shift;
    my $product             = shift;

    local $common_db = GenInfoParser->new(); # common database 'ssolar.cmn'
    local $ini_db    = GenInfoParser->new(); # initialisation database 'ssrcxxx.ini'
    my $verified_args_ref;

    # get initialisation database for workstamp and load it
    my $ini_db_name = $workstamp_db->get_value("$workstamp/settings/ssolarini");
    $ini_db_name =~ s#\\#/#g; # might contain backslashes
    $ini_db_name = main::basename($ini_db_name);
    common::load_database($ini_db, "$main::localini/$ini_db_name");
    print "set workstamp '$workstamp' using '$ini_db_name' ...\n";

    # determine platform
    my @platforms = $ini_db->get_keys();
    my %platform_hash = ();
    for (@platforms) {
        $platform_hash{lc($_)}++;
    }

    $platform = match_args_with_hash($setsolar_args_ref, \%platform_hash);
    
    common::print_error("no valid platform specified", 2) unless $platform;
    print "PLATFORM: $platform\n" if $main::is_debug;

    # load the common database
    common::load_database($common_db, "$main::localini/$main::ssolarcmn");

    # get all arguments which are valid for this workstamp
    my @valid_args = ();
    foreach (@fixed_args) {
        my $arg = $_;
        $arg =~ s/://;
        push(@valid_args, $arg);
    }
    push(@valid_args, (
                        $common_db->get_keys('common/switches'),
                        $common_db->get_keys('$platform/switches'),
                        $common_db->get_keys('finish/switches'),
                        $ini_db->get_keys('common/switches'),
                        $ini_db->get_keys("$platform/switches"),
                        $ini_db->get_keys("finish/switches")
                      ));

    $verified_args_ref = verify_args($setsolar_args_ref, \@valid_args, $workstamp);
    print "ARGS_TO_BE_PROCESSED: " . join(" ", keys %$verified_args_ref) 
            . "\n" if $main::is_debug;

    process_args($verified_args_ref, $workstamp, $mode, $product);
    return;
}

sub verify_args 
{
    # Verifies args, removes already processed args and
    # places the remaining args/values pairs in the hashref
    # given by first parameter.
    my $args_ref            = shift;
    my $valid_args_ref      = shift;
    my $workstamp           = shift;
    my %hash = ();
    my $verified_args_ref;
    my @fixed_args_with_value;

    foreach ( @$valid_args_ref ) {
        $hash{$_}++;
    }

    # get fixed arguments with mandatory values
    foreach my $arg (@fixed_args) {
        push(@fixed_args_with_value, $1) if $arg =~ /^(\w+):/;
    }

    while ( @$args_ref ) {
        my $arg = shift @$args_ref;
        $arg =~ s/^-//;
        $arg = lc($arg); # the args itselfs are case insensitiv, the values not
        next if $arg =~ /$workstamp/;
        next if $arg =~ /$platform/;
        if ( exists $hash{$arg} ) {
            my $value;
            my $fixed_pattern = join('|', @fixed_args_with_value);
            if ( $arg =~ /$fixed_pattern/oi
                || $common_db->get_value("common/switches/$arg") 
                || $common_db->get_value("$platform/switches/$arg")
                || $ini_db->get_value("common/switches/$arg") 
                || $ini_db->get_value("$platform/switches/$arg") ) {
                # argument requires value
                $value = shift @$args_ref;
                if ( !$value || $value =~ /^-/ ) {
                    common::print_error("'$value' is not a valid argument to '-$arg'", 3);
                }
             }
             else {
                $value = undef;
             }
             $$verified_args_ref{$arg} = $value;
        }
        else {
            common::print_error("invalid command line argument $arg", 4);
        }
    }
    return $verified_args_ref;
}

sub match_args_with_hash 
{
    # determine if any arg in args_ref matches with any element
    # in hash_ref. 
    my $args_ref     = shift;
    my $hash_ref     = shift;

    foreach my $arg (@$args_ref) {
        my $stripped_arg = ( $arg =~ /^-/ ) ? lc(substr($arg,1)) : lc($arg);
        if ( exists $$hash_ref{$stripped_arg} ) {
            return $stripped_arg;
         }
    }
    return 0;
}

sub process_args 
{
    my $verified_args_ref = shift;
    my $workstamp         = shift;
    my $mode              = shift;
    my $product           = shift;

    my ($upd, @pre_script, @post_script, $file);
    
    local ($dir_sep, $search_sep, $quote, $command_sep, $param_marker); 
    ($dir_sep, $search_sep, $quote, $command_sep, $param_marker) 
            = get_shell_properties();

    # complain about obsolete -map switch
    if ( exists $$verified_args_ref{'map'} ) {
        common::print_error("the '-map' switch is obsolete", 6);
    }

    # set output file
    if ( exists $$verified_args_ref{'file'} ) {
        $file = $$verified_args_ref{'file'};
        if ( !open(OUT, ">$file") ){
            common::print_error("can't open file '$file' for writing: $!", 6);
        }
    }
    else {
        common::print_error("obligatory '-file' command line argument is missing!", 4);
    }

    my $ver = ( exists $$verified_args_ref{'ver'} ) ? lc($$verified_args_ref{'ver'}) : 0;
    $upd = substr($workstamp, 3);

    my %env_settings = ();

    # insert 'trivial' envionment settings which are not set via databases
    $env_settings{'UPD'}            = $upd;
    $env_settings{'WORK_STAMP'}     = uc($workstamp);
    $env_settings{'UPDMINOR'}       = undef;
    $env_settings{'UPDMINOREXT'}    = undef;
    $env_settings{'UPDMINOR'}       = $ver if $ver;
    $env_settings{'UPDMINOREXT'}    = '.' . $ver if $ver;

    # fill in the environment settings from the databases
    foreach my $db ($common_db, $ini_db) {
        foreach my $plat ('common', $platform, 'finish') {
            walk_database(\%env_settings, \@pre_script, \@post_script, 
                            $verified_args_ref, $db, $plat);
        }
    }
    # finally these are needed for 'product' mode
    if ( $mode eq 'product' ) {
        $env_settings{'PRODUCTNAME'} = $product;
        $env_settings{'PRODUCTENVCACHE'} = common::cleanup_path($scriptdir);
    }

    # sanity check: make certain that no env_setting appears twice with
    # different case, this is especially important for Win32
    my %normalized_settings = ();
    foreach my $setting ( sort keys %env_settings ) {
        # compare normalized keys
        my $normalized_key = lc($setting);
        if ( exists $normalized_settings{$normalized_key} ) {
            common::print_error("invalid entry: key '$setting' appears twice with different case!", 5);
        }
        $normalized_settings{$normalized_key}++;
    }
    
    my @output = ();
    # dump pre scripts
    push(@output, @pre_script);
    # dump env settings
    write_env_settings(\%env_settings, \@output);
    # dump post scripts
    push(@output, @post_script);
    
    # dump complete script
    dump_script(\*OUT, \@output);
    close(OUT);

    # we call it success if we arrive here
    $file = common::cleanup_path($file);
    print("SUCCESS: wrote script '$file'.\n");
    
    # log setsolar command
    # no logging for release engineers
    if ( !defined($ENV{'UPDATER'}) || $ENV{'UPDATER'} ne 'YES' ) {
        my $log;
        # log file name is upper case for historic reasons
        if ( $^O eq 'MSWin32' ) {
            $log = "$main::log_dir_wnt/" . uc($workstamp) . ".SSLOG";
        }
        else {
            $log = "$main::log_dir_unx/" . uc($workstamp) . ".SSLOG";
        }
        # do not complain if log file is not writable
        if ( open(LOG_WORKSTAMP, ">>$log") ){
            my ($sec, $min, $hour, $mday, $mon, $year) = localtime(time());
            $year = substr($year,1);
            my $login_name = getlogin() || getpwuid($<) || "unkown";
            $format_login_name = "$login_name";
            $format_platform = "$platform";
            $format_platform .= defined($env_settings{'PROEXT'}) ? $env_settings{'PROEXT'} : "";
            $format_minor = "minor:";
            $format_minor .= $ver ? $ver : "flat";
            $format_date  .= sprintf('%02d.%02d.%02d-%02d:%02d:%02d', 
                                            $mday, $mon+1, $year, $hour, $min, $sec);
            write LOG_WORKSTAMP;
            close(LOG_WORKSTAMP);
        }
    }
}

format LOG_WORKSTAMP = 
@<<<<<<<<< @<<<<<<<<<<<<<< @<<<<<<<<< @<<<<<<<<<<<<<
$format_login_name, $format_platform, $format_minor, $format_date
.

sub walk_database 
{
    my $env_settings_ref    = shift;
    my $pre_script_ref      = shift;
    my $post_script_ref     = shift;
    my $verified_args_ref   = shift;
    my $db                  = shift;
    my $platform            = shift;

    # historically setsolar allowed certain incorrect settings 
    # in the 'common' and 'finish' platform sections
    local $ignore_errors = ($platform =~ /(common|finish)/) ? 1 : 0;

    # switches section
    my @switch_list;
    @switch_list = $db->get_keys("$platform/switches");
    foreach my $arg (keys %$verified_args_ref) {
        foreach my $switch (@switch_list) {
            if ( lc($arg) eq lc($switch) ) {
                my $set = $db->get_value("$platform/switches/$arg");
                if ( $set ) {
                    insert_expand_setting($env_settings_ref, $set, $$verified_args_ref{$arg});
                }
            }
        }
    }
    # extern section (import external envrironment variables)
    my @extern_list;
    @extern_list = $db->get_keys("$platform/extern");
    foreach my $extern (@extern_list) {
        insert_expand_setting($env_settings_ref, $extern, $ENV{$extern});
    }
    # reset section (unset environment variables)
    my @reset_list;
    @reset_list = $db->get_keys("$platform/reset");
    foreach my $reset (@reset_list) {
        my $val = $db->get_value("$platform/reset/$reset");
        if ( $val ) {
            insert_expand_setting($env_settings_ref, $reset, $val);
        }
        else {
            insert_expand_setting($env_settings_ref, $reset, undef);
        }
    }
    # restore section (restore certain env. vars to value before last setsolar)
    my @restore_list;
    @restore_list = $db->get_keys("$platform/restore");
    foreach my $restore (@restore_list) {
        my $ssx_restore = "SSX_" . $restore;
        my $ssx_val = $ENV{$ssx_restore};
        if ( $ssx_val ) {
            insert_expand_setting($env_settings_ref, $restore, $ssx_val);
        }
        else {
            insert_expand_setting($env_settings_ref, $ssx_restore, "%$restore%");
        }
    }
    # standlst section
    my @standlst_list;
    @standlst_list = $db->get_keys("$platform/standlst");
    foreach my $standlst (@standlst_list) {
        my $key = $db->get_value("$platform/standlst/$standlst");
        $key = expand_value($env_settings_ref, $key);
        my $path = $workstamp_db->get_value($key);
        if ( !$path ) {
            common::print_error('workspace location not set in stand.lst', 0); 
        }
        else {
            print "$standlst is '$path' ...\n";
            insert_expand_setting($env_settings_ref, $standlst, $path);
        }
    }
    # environment section
    my ($environment, @environment_list, $block, @order_list,);
    @environment_list = $db->get_keys("$platform/environment");

    if ( $#environment_list > -1 ) {
        # fetch order section
        $block = $db->get_value("$platform/order");
        if ( !$block ) {
            common::print_error("'order' section empty or not specified", 0);
        }
        $block = lc($block);
        @order_list = split(" ",$block);
        foreach $block (@order_list) {
            # sanity checks
            my $block_key = "$platform/environment/$block";
            if ( !defined($db->get_key($block_key)) ) {
                common::print_error("unknown block $block_key", 0) unless $ignore_errors;
                next;
            }
            
            # an IF conditional could be a block value
            my $block_value = $db->get_value($block_key);

            # 'common' and 'finish' blocks must always be executed
            my $execute_block = 0;
            if ( $block =~ /^common/ || $block =~ /^finish/ ) {
                if ( $block =~ /:/ ) {
                    $execute_block = 
                        check_conditional($env_settings_ref, $block_key, $block_value); }
                else {
                    $execute_block = 1;
                }
            }
            # check block against command line args
            foreach my $arg (keys %$verified_args_ref) {
                if ( $block =~ /^$arg:/ ) {
                    $execute_block 
                        = check_conditional($env_settings_ref, $block_key, $block_value);
                }
                elsif ( $block eq $arg ) {
                    $execute_block = 1;
                }
            }
            if ( $execute_block ) {
                my @sub_keys = $db->get_keys($block_key);
                foreach my $sub_key (@sub_keys) {
                    my $sub_key_value = $db->get_value("$block_key/$sub_key");
                    insert_expand_setting($env_settings_ref, $sub_key, $sub_key_value);
                }
            }
        }
    }
    # script section
    my @script_list;
    @script_list = $db->get_keys("$platform/script");
    foreach my $script (@script_list) {
        my $script_ref;
        $script_ref = $pre_script_ref if $script eq 'pre';
        $script_ref = $post_script_ref if $script eq 'post';
        if ( !$script_ref ) {
            common::print_error("can not handle script $script in $platform/script section", 0);
            next;
        }
        my @lines;
        @lines = $db->get_keys("$platform/script/$script");
        foreach my $line (sort @lines) {
             push(@$script_ref, $db->get_value("$platform/script/$script/$line"));
        }
    }
}

sub check_conditional
{
    my $env_settings_ref = shift;
    my $key              = shift;
    my $value            = shift;

    if ( $value !~ /\bif\b/i ) {
        common::print_error("$key requires a following IF clause", 0) unless $ignore_errors;
        return 0;
    }

    my @token_field;
    if ( $value =~ /\"/ ) {
        # historical: \" as separator
        my @token_field = split(/\"/, $value);
        # trim any remaining whitespace
        for (my $i = 0; $i <= $#token_field; $i++) {
            $token_field[$i] =~ s/\s//g;
        }
    }
    else {
        # whitespace as seperator
        @token_field = split(" ", $value);
    }

    my $left_side   = lc(expand_value($env_settings_ref, $token_field[1]));
    my $operator    = $token_field[2];
    my $right_side  = lc(expand_value($env_settings_ref, $token_field[3]));

    my $expr = 0;
    SWITCH: {
        # these are string comparisons for historic reasons
        $operator eq '==' and $left_side eq $right_side and $expr = 1, next;
        $operator eq '!=' and $left_side ne $right_side and $expr = 1, next;
        $operator eq '>'  and $left_side gt $right_side and $expr = 1, next;
        $operator eq '>=' and $left_side ge $right_side and $expr = 1, next;
        $operator eq '<'  and $left_side lt $right_side and $expr = 1, next;
        $operator eq '<=' and $left_side le $right_side and $expr = 1, next;
    }
    
    return $expr;
}
    

sub insert_expand_setting 
{
    my $env_settings_ref    = shift;
    my $env_setting         = shift;
    my $env_value           = shift;
    my $value = $env_value;
    # insert new $env_setting in the env_settings hash

    # handle the undef case
    $value = "" if !defined($value);

    $value = expand_value($env_settings_ref, $value);
        
    # $value could still contain an unmatched %
    if ( $value =~ /%/ ) {
        common::print_error("found unmatched % in entry: $env_setting $env_value\n", 0);
    }

    if ( $env_setting =~ /^\*(.*)$/ ) {
        # special handling for alias settings
        my $ch1 = chr(hex('15'));
        my $ch2 = chr(hex('a7'));
        my $pat = "[$ch1$ch2]";
   
        # old method of quoting environment variables (0x15 or 0x7A)
        while ( $value =~ /$pat(.+?)$pat/o ) { # don't recompile pattern
            my $quoted_param = $1;
            my $replace = $param_marker . $quoted_param;
            $value =~ s/$pat$quoted_param$pat/$replace/;
        }
        if ( $value =~ /$pat/o ) { # don't recompile pattern
            common::print_error("found unmatched quote in entry: $env_setting $env_value\n", 0);
        }
        # new method of quoting environment variables (#)
        $value =~ s/#/$param_marker/g;
    }
    # handle the empty case
    $value = undef if !$value;
    # insert all environment variables in env_settings hash
    $$env_settings_ref{$env_setting} = $value;
}

sub expand_value 
{
    my $env_settings_ref    = shift;
    my $value               = shift;

    # macro expansion of $env_value: expand any %other_env_setting% occurrence 
    # with the value of other_env_setting if other_env_setting already in hash, 
    # otherwise replace with empty string

    # handle the undef case
    $value = "" if !defined($value);

    while ( $value =~ /%(.+?)%/ ) {
        my $setting = $1;
        if ( defined $$env_settings_ref{$setting} ) {
            $value =~ s/%$setting%/$$env_settings_ref{$setting}/;
        }
        else {
            $value =~ s/%$setting%//;
        }
    }
    # replace $/ and $: with platform depend value
    $value =~ s/\$\//$dir_sep/g;
    $value =~ s/\$:/$search_sep/g;
    return $value;
}
    

sub write_env_settings 
{
    my $env_settings_ref    = shift;
    my $output_ref          = shift;

    foreach my $setting (sort keys %{$env_settings_ref}) {
        my $value   = $$env_settings_ref{$setting};
        my $string;

        if ( $setting =~ /^\*(.*)$/ ) {
            # alias
            my $alias = $1;
            $string = alias_unset($alias);
            if ( defined($value) ) {
                $string .= $command_sep . alias_set($alias, $value);
            }
        }
        else {
            # environment variable 
            $string  = env_unset($setting);
            if ( defined($value) ) {
                $string .= $command_sep . env_set($setting, $value);
            }
        }
        push(@{$output_ref}, $string);
    }
}

sub dump_script 
{
    my $glob_ref     = shift;
    my $output_ref   = shift;

    my $banner = shell_banner();
    
    print $glob_ref $banner;
    
    foreach my $line (@{$output_ref}) {
        print $glob_ref "$line\n";
    }
}    

sub get_prerequisites
{
    # check for a view prerequistes we'll need if we run setsolar
    # in product mode
    my $login;
    my $temp;
    my $shell_pid;

    $login = getlogin();
    # MSWin32
    if ( $^O eq 'MSWin32' ) {
        $temp = $ENV{TMP} 
                    or common::print_error("environment variable %TEMP not set", 1);
        $shell_pid = $ENV{SHELL_PID} 
                    or common::print_error("environment variable %SHELL_PID not set", 1);
    }
    else {
        $temp = '/tmp';
        $shell_pid = getppid();
        # fall back to getpwuid() if getlogin() does not return anything
        $login = getpwuid($<) if !defined($login)

    }
    common::print_error("can't determine login name", 1) if !defined($login);
    return ($login, $temp, $shell_pid);
}

sub cleanup_script_cache 
{
    # Clean up cachedir. Executed once on startup if -product switch is used.
    # We'll throw away all files which are assiociated with
    # no longer existent processes. The cache_dir has to be on a local volume.
    my $cache_dir = shift;;
    my @dirs = glob("$cache_dir/*");

    foreach my $dir (@dirs) {
        my $pid = main::basename($dir);
        if ( !check_pid($pid) ) {
            main::rmtree($dir, $main::is_debug);
       }
    }
}

sub check_pid 
{
    # check if process pid is still running
    # surprisingly this works under MSWin32, too
    my $pid = shift;

    return kill(0, $pid);
}

sub get_bases
{
    # Fill @{$base_ref} with bases. This is done recursive
    # to allow for bases of a base
    my $bases_ref           = shift;
    my $base_list_ref       = shift;
    my $products_hash_ref   = shift;

    foreach my $base_product_name (@{$base_list_ref}) {
        my $bkey = common::normalize_pr_key($base_product_name);
        my $be_ref = $$products_hash_ref{$bkey};
        if ( !defined($be_ref) ) {
            common::print_error("can't determine base of product '$product'", 3);
        }
        push(@{$bases_ref}, $$be_ref[1]);
        # recurse for bases of base
        get_bases($bases_ref, $$be_ref[3], $products_hash_ref)
    }
    return;
}

sub get_main_workstamp_minor
{
    # returns a command line specified minor
    for (my $i=0; $i<=$#ARGV; $i++) {
        if ( $ARGV[$i] =~ /^-ver$/i ) {
            return $ARGV[++$i];
        }
    }
    return undef;
}

sub get_base_workstamp_minor 
{
    # returns the base minor[s] for the specified main_workstamp and minor
    my $base_workstamp = shift;
    my $main_workstamp = shift;
    my $main_minor = shift;

    # FIXME: this function must not be called before we are once through with the 
    # setsolar mechanism for the $main_workstamp because $platform is not set
    # otherwise
    print_error("internal error, platform not yet set",99) if !defined($platform);

    my ($rscversion, $rscrevision, $build, $last_minor);
    
    ($rscversion, $rscrevision, $build, $last_minor) =
        common::read_minor_mk($workstamp_db, $main_workstamp, 
                    substr($base_workstamp, 3), $platform, $main_minor);
    return $last_minor;
}

sub response_argv
{
    #search for response file in argument : @filename

    my $argv_ref = shift;
    my $filename;

    for ( $i = 0; $i <= $#$argv_ref; $i++ ) {
         if ( $$argv_ref[$i] =~ /^\@/ ) {
	       $filename = $$argv_ref[$i];
               $filename =~ s/^\@//g;

	       # remove response file from args
               splice(@$argv_ref, $i, 1);
         }
    }

    # insert content of response file into args
    if ( $filename ne "" ) {
      open( INFILE, $filename ) or die "can't open responsefile $filename";
      while (<INFILE>) {
	  $line = $_;
          chomp($line);
	  my @new_args = split(/ /, $line);
	  unshift( @$argv_ref, @new_args );
	  print "$line\n";
      }
      close ( INFILE );
    }
}

sub patch_argv
{
    # Search and set the value of a given arg in a given ARGV 
    # like argument vector returns old value or undef on failure
    # If value is undefined than search and remove any arg in argv 
    # and it's value
    my $argv_ref = shift;
    my $arg      = shift;
    my $value    = shift;
    
    
    my $i;
    my $old_value = undef;
    for ( $i = 0; $i <= $#$argv_ref; $i++ ) {
       if ( $$argv_ref[$i] eq "-$arg" ) {
           if ( !defined($value) ) {
               # remove argument and argument value
               splice(@$argv_ref, $i, 2);
               last;
           }
           if ( defined($$argv_ref[++$i]) ) {
               $old_value = $$argv_ref[$i];
               $$argv_ref[$i] = $value;
           }
           last;
       }
   }
   return $old_value;
}

sub get_local_environment 
{
    my $argv_ref = shift;

    my $ca  = 0;
    my $cax = 0;
    foreach (@{$argv_ref}) {
        /^-cax$/ && $cax++;
        /^-ca$/ && $ca++;
    }
    if ( $cax && $ca ) {
        common::print_error("switches '-ca' and '-cax' are mutually exclusive");
    }
    return 'ca'  if $ca;
    return 'cax' if $cax;
    return 0;
}
    

sub dump_modules_mk
{
    my $modules_mk = shift;
    my @workstamps = @_;
    my %modules_hash = ();  # needed for sanity checks

    open(MODULES_MK, ">$modules_mk") or print_error("can't write to '$modules_mk'!", 21);
    foreach my $workstamp (@workstamps) {
        my @modules = $workstamp_db->get_keys("$workstamp/drives/o:/projects");
        foreach my $module (@modules) {
            if ( exists $modules_hash{$module} ) {
                my $other_workstamp = $modules_hash{$module};
                # solenv is sepcial case ,,,
                common::print_error("module '$module' appears in two workspaces:\n\t$other_workstamp and $workstamp", 0) if $module !~ /solenv/;
            }
            $modules_hash{$module} = $workstamp;
            print MODULES_MK "module_$module=$workstamp\n";
        }
    }
    close(MODULES_MK);
}

sub dump_source_script
{
    my $file               = shift;
    my $ca_mode            = shift;
    my $source_scripts_ref = shift;
    my $minor_hash_ref     = shift; 
    
    my $rc = open(SOURCE_SCRIPT, ">$file");
    common::print_error("can't write script to '$file'", 20) unless $rc;
    if ( $ca_mode ) {
        if ( $ca_mode eq 'ca' ) {
            my @ca_scripts = ();
            my $ext = batch_ext();
            $ext =~ s/\./\./;
            foreach ( reverse @{$source_scripts_ref} ) {
                s/$ext$/.ca$ext/o;
                push(@ca_scripts, $_);
            }
            foreach (@ca_scripts) {
                print SOURCE_SCRIPT source_file($_) . "\n";
            }
            foreach (@ca_scripts) {
                print SOURCE_SCRIPT unlink_file($_) . "\n";
            }
        }
        else {
            foreach ( reverse @{$source_scripts_ref} ) {
                print SOURCE_SCRIPT source_file($_) . "\n";
            }
        }
    }
    else {
        # we need only the main workspace
        print SOURCE_SCRIPT source_file($$source_scripts_ref[0]) . "\n";
    }
    # dump minor for each involved workspace
    foreach my $workstamp ( sort keys %{$minor_hash_ref} ) {
        my $envvarname = uc($workstamp) . 'MINOR';
        print SOURCE_SCRIPT env_set("$envvarname", $$minor_hash_ref{$workstamp}) . "\n";
    }
    close (SOURCE_SCRIPT);
}
               
#### subroutines for flexible shell handling ####

sub init_shell
{
    # Initialize shell, either from command line or platform default shell
    my $argv_ref = shift;

    $shell = 0;
    for (my $i = 0; $i <= $#$argv_ref; $i++) {
        if ( $$argv_ref[$i] =~ /^-shell$/ ) {
            $shell = $$argv_ref[++$i];
            last;
        }
    }
    set_shell($shell);
}

sub set_shell 
{
    $shell = shift;

    my (@sh, @csh, @nt);
    
    if ( !$shell ) {
        # set default shell
        if ( $^O eq 'MSWin32' ) {
            $shell = '4nt';
        }
        else {
            $shell = 'csh';
        }
    }

    ($shell eq 'sh'  || $shell eq 'bash') and $shell = 'sh',  return;
    ($shell eq 'csh' || $shell eq 'tcsh') and $shell = 'csh', return;
    ($shell eq '4nt' || $shell eq '4dos') and $shell = '4nt', return;
    common::print_error("shell '$shell' not supported", 5);
}

sub get_shell_properties
{
    set_shell(0) if !$shell;

    # ( $dirsep, $search_sep, $quote, $commandsep. $param_marker )
    @sh     = ( '/',  ':', '\\', '; ',  '$'); 
    @csh    = ( '/',  ':', '\\', '; ',  '$');
    @nt     = ( '\\', ';', '\'', ' ^ ', '%');
    
    ($shell eq 'sh')  and return @sh;
    ($shell eq 'csh') and return @csh;
    ($shell eq '4nt') and return @nt;
    common::print_error("shell '$shell' not supported", 5);
}

sub batch_ext
{
    set_shell(0) if !$shell;

    ($shell eq 'sh')  and return '';
    ($shell eq 'csh') and return '';
    ($shell eq '4nt') and return '.btm';
    common::print_error("shell '$shell' not supported", 5);
}

sub shell_banner 
{
    
    set_shell(0) if !$shell;
    
    ($shell eq 'sh')  and return "";
    ($shell eq 'csh') and return "";
    ($shell eq '4nt') and return "\@echo off\n"; # shut off noise
    common::print_error("shell '$shell' not supported", 5);
}

sub env_set 
{
    my $variable    = shift;
    my $value       = shift;

    set_shell(0) if !$shell;

    $value = '' if !defined $value;
    ($shell eq 'sh')  and return "$variable=$value; export '$variable'";
    ($shell eq 'csh') and return "setenv $variable '$value'";
    ($shell eq '4nt') and return "set $variable=$value";

    common::print_error("shell '$shell' not supported", 5);
}

sub env_unset 
{
    my $variable    = shift;

    set_shell(0) if !$shell;

    ($shell eq 'sh')  and return "unset $variable > /dev/null 2>&1";
    ($shell eq 'csh') and return "unsetenv $variable >& /dev/null";
    ($shell eq '4nt') and return "unset $variable >& NUL";
    common::print_error("shell '$shell' not supported", 5);
}

sub alias_set 
{
    my $command = shift;
    my $action  = shift;  

    set_shell(0) if !$shell;

    ($shell eq 'sh')  and return "alias $command='$action'";
    ($shell eq 'csh') and return "alias $command '$action'";
    ($shell eq '4nt') and return "alias $command=`$action`";
    common::print_error("shell '$shell' not supported", 5);
}

sub alias_unset 
{
    my $command    = shift;

    set_shell(0) if !$shell;

    ($shell eq 'sh')  and return "unalias $command > /dev/null 2>&1";
    ($shell eq 'csh') and return "unalias $command >& /dev/null";
    ($shell eq '4nt') and return "unalias $command >& NUL";
    common::print_error("shell '$shell' not supported", 5);
}

sub source_file
{
    my $file       = shift;

    set_shell(0) if !$shell;

    $file = common::cleanup_path($file);
    ($shell eq 'sh')  and return ". $file";
    ($shell eq 'csh') and return "source $file";
    ($shell eq '4nt') and return "call $file";
    common::print_error("shell '$shell' not supported", 5);
}
    
sub unlink_file
{
    my $file       = shift;

    set_shell(0) if !$shell;

    ($shell eq 'sh')  and return "rm $file";
    ($shell eq 'csh') and return "rm $file";
    ($shell eq '4nt') and return "del $file";
    common::print_error("shell '$shell' not supported", 5);
}

#### getsolar subroutines #####

package getsolar;
# subroutines for 'getsolar' mode

sub getsolar
{   
    # print information about products
    my $opt_all = 0;
    my $opt_m   = 0;

    local $workstamp_db = GenInfoParser->new(); # list of workstamps 'stand.lst'
    
    my ($product, $platform);

    getsolar_usage() if !defined($ARGV[0]);

    if ( $ARGV[0] =~ /-all/i ) {
        $opt_all++;
        getsolar_usage() if $ARGV[1];
    }
    elsif ( $ARGV[0] =~ /-m/i ) {
        $opt_m++;
        getsolar_usage() if !$ARGV[1];
        $product = $ARGV[1];
        $platform = defined($ARGV[2]) ? $ARGV[2] : undef;
    }
    else {
        $product = $ARGV[0];
        getsolar_usage() if $ARGV[1];
    }

    # retrieve product information
    common::load_database($workstamp_db, "$main::localini/$main::standlst");
    my $products_hash_ref = common::get_products($workstamp_db);

    # switch -all
    if ( $opt_all ) {
        foreach my $product (sort keys %$products_hash_ref) {
            my $entry_ref = $$products_hash_ref{$product};
            print "$$entry_ref[0] ($$entry_ref[1])\n";
        }
        return;
    }

    # product specified
    my $product_key = common::normalize_pr_key($product);
    # sanity check
    if ( !exists $$products_hash_ref{$product_key} ) {
        common::print_error("there is no such product '$product'!", 2);
    }

    # switch -m
    if ( $opt_m ) {
        my $entry_ref = $$products_hash_ref{$product_key};
        my @product_and_bases = ();
        push(@product_and_bases, $$entry_ref[1]);
        print "\nProduct '$$entry_ref[0] ($$entry_ref[1])' is based on ";
        # get bases
        my $bases_ref = $$entry_ref[3];
        if ( $#$bases_ref > -1 ) {
            foreach ( @{$bases_ref} ) {
                my $base_ref = $$products_hash_ref{common::normalize_pr_key($_)};
                push(@product_and_bases, $$base_ref[1]);
                print "'$$base_ref[0] ($$base_ref[1])', "
            }
            print "\b\b.\n" 
        }
        else {
            print "no other products.\n";
        }

        print_available_minors(\@product_and_bases, $platform); 
        return;
    }
            
    # default case: print product information and dependencies
    print_dependent_products($products_hash_ref, $product, 0);

    # print 'based on' information
    my $bases_ref = $$products_hash_ref{$product_key}[3];
    if ( $#$bases_ref > -1 ) {
        print "\nBased on:\n";
        foreach ( @{$bases_ref} ) {
            print "$_\n";
        }
    }
    
    return;
}

sub print_dependent_products
{
    # scan all products if they are dependent on the given product,
    # print according to given indent level, recurse
    #
    # note: we need a not normalized $product string here for better
    # error messages
    my $products_hash_ref = shift;
    my $product = shift;
    my $level = shift;
    
    my $product_key = common::normalize_pr_key($product);
    my $entry_ref = $$products_hash_ref{$product_key};
    # sanity check
    if ( !defined($entry_ref) ) {
        common::print_error("can't determine dependents of product '$product'", 3);
    }
        
    print "    " x $level if $level > 0; 
    print "$$entry_ref[0] ($$entry_ref[1])\n";
    foreach my $candidate_key (sort keys %$products_hash_ref) {
        next if $product_key eq $candidate_key;
        my $dependent_ref = $$products_hash_ref{$candidate_key};
        foreach my $dependent (@{$$dependent_ref[2]}) {
            if ( $product_key eq common::normalize_pr_key($dependent) ) {
                print_dependent_products($products_hash_ref, 
                        $$dependent_ref[0], ++$level);
            }
        }
    }
}

sub print_available_minors
{
    # print availbale minors
    #
    # @product_bases = ( product_workstamp, base1_workstamp, base2_workstamp, ... )
    my $product_and_bases_ref =  shift;
    my $platform = shift;

    my @platforms = ();

    my $product_workstamp = $$product_and_bases_ref[0];
    # no platform given, search workspace_db for available platforms
    if ( !defined($platform) ) {
        @platforms = $workstamp_db->get_keys("$product_workstamp/environments");
    }
    else {
        push(@platforms, $platform);
    }

    print "\n";
    foreach my $platform (@platforms) {
        my $missing_minor = 0;
        my @output = ();
        my @minors = common::get_minors($workstamp_db, $product_workstamp, $platform);
        push(@minors, undef); # add undef entry for flat (non minor)
        foreach $minor (@minors) {
            foreach my $workstamp (@{$product_and_bases_ref}) {
                my ($rscversion, $rscrevision, $build, $last_minor);
                ($rscversion, $rscrevision, $build, $last_minor) 
                    = common::read_minor_mk($workstamp_db, $product_workstamp, 
                                            substr($workstamp, 3), $platform, $minor);
                if ( !defined($last_minor) ) {
                    last if $workstamp eq $product_workstamp; # no build found for this platform
                    $last_minor = '!';
                    $build = '';
                    $missing_minor++;
                }
                if ( $workstamp eq $product_workstamp ) {
                    if ( !defined($minor) ) {
                        push(@output, 'flat: ');
                    }
                    else {
                        push(@output, '      ');
                    }
                }
                push(@output, "$workstamp.$last_minor($build) ");
            }
            push(@output, "\n") if $#output > -1;
        }
        if ( $#output > -1 ) {
            print "Available builds on $platform:\n";
            print @output;
            if ( $missing_minor ) {
                print "Symbol ! indcates that at least one minor could not be found\n";
            }
            print "\n";
        }
    }
}
    
sub getsolar_usage()
{
    print STDERR "Getsolar shows information about targeted products, workspaces and base products\n";
    print STDERR "usage:\n";
    print STDERR "$main::script_name -all                        shows all current products\n";
    print STDERR "$main::script_name <ProductName>               shows all information for given product\n";
    print STDERR "$main::script_name -m <ProductName> [platform] shows all current products\n";

    exit(1);
}

#### common subroutines #####

package common;
# common subroutines for both: 'setsolar' and 'getsolar' mode

sub update_localini
{
    # Update databases from the directory pointed to by GLOBALINI 
    # (or the default directory if GLOBALINI is not set) into the 
    # localini directory. That's either $HOME/localini (Unix) 
    # or $TEMP/localini (WNT).

    # Copying the whole stuff into the home directory is probably not 
    # necessary anymore, we do it just for being compatible with 
    # the old way ...
    
    my ($home, $globalini, @files);

    $globalini = get_globalini();
    if ( $^O eq 'MSWin32' ) {
        $home = $ENV{TEMP};
        if ( !defined($home) ) {
            common::print_error('environment variable %TEMP not defined', 1);
        }
    }
    else {
        $home = $ENV{HOME};
        if ( !defined($home) ) {
            common::print_error('environment variable $HOME not defined', 1);
        }
    }
    $main::localini = "$home/localini";
    if ( ! -d $main::localini ) {
        if ( !mkdir($main::localini, 0755) ) {
            common::print_error("can't create directory '$main::localini': $!", 1);
        }
    }
    
    $globalini = cleanup_path($globalini);
    $main::localini = cleanup_path($main::localini);
    print "GLOBALINI is set to `$globalini' ...\n";
    print "LOCALINI is set to $main::localini ...\n";

    # collect files to be copied
    @files = glob("$globalini/*");

    print "updating '$main::localini' ...\n\n";
    foreach my $file (@files) {
        copy_if_newer($file, "$main::localini/" . main::basename($file));
    }
}

sub get_globalini
{
    my $globalini;

    $globalini = $ENV{GLOBALINI};

    # default place
    if ( !defined($globalini) ) {
        $globalini = ( $^O eq 'MSWin32' ) 
            ?  $main::b_server_wnt : $main::b_server_unx;
    }
    return $globalini;
}

sub copy_if_newer 
{
    my $from = shift;
    my $to = shift;
    my $from_stat_ref;
    
    return unless ( $from_stat_ref = is_newer($from, $to) );

    print "copying $from -> $to\n" if $main::is_debug; 
    my $rc = main::copy($from, $to);
    if ( $rc) {
        utime($$from_stat_ref[9], $$from_stat_ref[9], $to);
        # fix permissions
        chmod($$from_stat_ref[2], $to);
    }
}

sub is_newer 
{
    # returns whole stat buffer if newer
    my $from = shift;
    my $to = shift;
    my (@from_stat, @to_stat);

    @from_stat = stat($from);
    return 0 unless -f _;

    # adjust timestamps to even seconds
    # this is necessary since NT platforms have a
    # 2s modified time granularity while the timestamps 
    # on Samba volumes have a 1s granularity

    $from_stat[9]-- if $from_stat[9] % 2;

    @to_stat = stat($to);
    return \@from_stat unless -f _;
    return ($from_stat[9] > $to_stat[9]) ? \@from_stat : 0;
}

sub load_database 
{
    my $giparser = shift;
    my $database = shift;
    my $success;

    print "LOADING DATABASE '$database' ... " if $main::is_debug;
    $success = $giparser->load_list($database);
    if ( !$success ) {
        print "failed!\n" if $main::is_debug;
        common::print_error("can't open database $database\n", 1);
    }
    print "ok!\n" if $main::is_debug;
    return;
}

sub get_mode
{
    # determine operation mode
    # 'getsolar' -> provide getsolar funktionality
    # 'product'  -> new style 'don't need to know anything about the workspace' mode
    # 'classic'  -> old style mode, determine workspace via commandline or
    #               'now' flag in 'stand.lst'
    return 'getsolar' if  $0 =~ /getsolar/;
    for (my $i=0; $i<=$#ARGV; $i++) {
        if ( $ARGV[$i] =~ /^-product$/ ) {
            return ('product', $ARGV[++$i]);
        }
    }
    # default mode is 'classic'
    return 'classic';
}

sub get_products
{
    # retrieves products information from workstamp_db
    # creates a hash with the following data structure
    # $products_hash{normalized_product_key} = 
    #     [$product,$workstamp,[BasedOn_products ...]. [DependsOn_products ...]]
    my $workstamp_db  = shift;
    my %products_hash = ();

    my $tgd = 'targetdescription/products';
    my $tgd_don = 'targetdescription/dependson';
    my $tgd_bon = 'targetdescription/basedon';

    my @workstamps = $workstamp_db->get_keys();
    foreach my $workstamp (@workstamps) {
        my $products_str = $workstamp_db->get_value("$workstamp/$tgd");
        next if !defined($products_str);
        my @products = split(/;/, $products_str);
        foreach my $product (@products) {
            my $dependson_str = $workstamp_db->get_value("$workstamp/$tgd_don");
            my $basedon_str = $workstamp_db->get_value("$workstamp/$tgd_bon");
            my @depends_on = defined($dependson_str) ? split(/;/, $dependson_str) : ();
            my @based_on = defined($basedon_str) ? split(/;/, $basedon_str) : ();
            $products_hash{normalize_pr_key($product)} =
                [$product, $workstamp, \@depends_on, \@based_on];
        }
    }
    return \%products_hash;
}

sub get_minors
{
    # returns a list of available minors on given workspace
    my $workstamp_db = shift;
    my $workstamp    = shift;
    my $platform     = shift;

    my $path = get_workstamp_path($workstamp_db, $workstamp) . "/$platform";
    
    # glob for minors
    @list = glob("$path/inc.*");
    foreach (@list) {
        $_ = substr($_,-1);
    }

    return @list;
}

sub read_minor_mk {
    # Read xxxminor.mk for given parameters,
    # returns rscversion, rscrevision, build and last minor
    my $workstamp_db = shift;
    my $workstamp    = shift;
    my $upd          = shift;
    my $platform     = shift;
    my $minor        = shift;

    my $rscversion   = undef;
    my $rscrevision  = undef
    my $build        = undef;
    my $last_minor   = undef;

    my $inc = 'inc' . (defined($minor) ? ".$minor" : '');
    my $workstamp_path = get_workstamp_path($workstamp_db, $workstamp);
    my $fullpath = "$workstamp_path/$platform/$inc/$upd";
    $fullpath .= 'minor.mk';

    open(MINORMK, "<$fullpath") or return (undef, undef, undef, undef) ;
    while (<MINORMK>) {
        tr/\r\n//d; 
        if ( /^RSCVERSION=(.+)$/ ) {
            $rscversion = $1;
        }
        if ( /^RSCREVISION=(.+)$/ ) {
            $rscrevision = $1;
        }
        if ( /^BUILD=(.+)$/ ) {
            $build = $1;
        }
        if ( /^LAST_MINOR=(.+)$/ ) {
            $last_minor = $1;
        }
    }
    return ($rscversion, $rscrevision, $build, $last_minor);
}
        
sub get_workstamp_path
{
    # retrieve path to workstamp
    my $workstamp_db = shift;
    my $workstamp    = shift;

    my $path;
    if ( $^O eq 'MSWin32' ) {
        $path = 'o:';
    }
    else {
        $path = $workstamp_db->get_value("$workstamp/drives/o:/unixvolume");
    }
   
    $path .= '/';
    my $settings_path = $workstamp_db->get_value("$workstamp/settings/path");
    my @field = split(/[\\\/]/, $settings_path);
    $path .= "$field[0]";
    
    # clean up any backslashes
    $path =~ s#\\#/#g;
    return $path;
}

sub normalize_pr_key
{
    my $key = shift;
    # trim whitespace and convert all characters to lower case
    $key =~ s/\s//g;
    return lc($key);
}

sub cleanup_path
{
    # Clean path according to platform conventions.
    # Note: this is usually not neccessay. All perl calls
    # work with back- and forward-slashes on MSWin32.
    # Should only be used for pretty printing path information
    # or stuff which is exported to external tools
    my $path = shift;
    if ( $^O eq 'MSWin32' ) {
        $path =~ s#/#\\#g;
    }
    else {
        $path =~ s#\\#/#g;
    }
    return $path;
}

sub print_error 
{
    my $message     = shift;
    my $error_code  = shift;
 
    print STDERR "$main::script_name: ";
    print STDERR "ERROR: $message\n";

    if ( $error_code ) {
        print STDERR "\nFAILURE: $main::script_name aborted.\n";
        exit($error_code);
    }
}
