/*************************************************************************
 *
 *  $RCSfile: AccessibleBrowseBoxHeaderCell.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/19 13:00:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVTOOLS_ACCESSIBLEBROWSEBOXHEADERCELL_HXX
#define _SVTOOLS_ACCESSIBLEBROWSEBOXHEADERCELL_HXX

#ifndef _SVTOOLS_ACCESSIBLEBROWSEBOXBASE_HXX
#include "AccessibleBrowseBoxBase.hxx"
#endif

namespace svt
{
	class AccessibleBrowseBoxHeaderCell : public BrowseBoxAccessibleElement
	{
		sal_Int32	m_nColumnRowId;
	public:
		AccessibleBrowseBoxHeaderCell(sal_Int32 _nColumnRowId,
										  const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& rxParent,
										  IAccessibleTableProvider&                  _rBrowseBox,
										  const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >& _xFocusWindow,
										  AccessibleBrowseBoxObjType  _eObjType);
		/** @return  The count of visible children. */
		virtual sal_Int32 SAL_CALL getAccessibleChildCount() throw ( ::com::sun::star::uno::RuntimeException );

		/** @return  The XAccessible interface of the specified child. */
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL
			getAccessibleChild( sal_Int32 nChildIndex ) throw ( ::com::sun::star::lang::IndexOutOfBoundsException,::com::sun::star::uno::RuntimeException );

		/** @return  The index of this object among the parent's children. */
		virtual sal_Int32 SAL_CALL getAccessibleIndexInParent() throw ( ::com::sun::star::uno::RuntimeException );

		/** Grabs the focus to the BrowseBox. */
		virtual void SAL_CALL grabFocus() throw ( ::com::sun::star::uno::RuntimeException );

		inline sal_Bool isRowBarCell() const
		{
			return getType() == BBTYPE_ROWHEADERCELL;
		}

		/** @return
				The name of this class.
		*/
		virtual ::rtl::OUString SAL_CALL getImplementationName() throw ( ::com::sun::star::uno::RuntimeException );

		/** Creates a new AccessibleStateSetHelper and fills it with states of the
			current object.
			@return
				A filled AccessibleStateSetHelper.
		*/
		::utl::AccessibleStateSetHelper* implCreateStateSetHelper();

	protected:
		virtual Rectangle implGetBoundingBox();

		virtual Rectangle implGetBoundingBoxOnScreen();
	};
}

#endif // _SVTOOLS_ACCESSIBLEBROWSEBOXHEADERCELL_HXX

