/*************************************************************************
 *
 *  $RCSfile: cstitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:25:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CSTITEM_HXX
#define _CSTITEM_HXX

#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif

#include "poolitem.hxx"

class SvStream;

enum CrawlStatus
{
	CSTAT_NEVER_UPD			= 0,	    /* noch nie ueberprueft 						*/
	CSTAT_IN_UPD			= 1,		/* Ueberpruefung laeuft 						*/
	CSTAT_UPD_NEWER			= 2,		/* wurde ueberprueft und ist neuer 				*/
	CSTAT_UPD_NOT_NEWER		= 3,		/* wurde ueberprueft und ist nicht neuer 		*/
	CSTAT_UPD_CANCEL		= 4,		/* Ueberpruefung vom Benutzer abgebrochen 		*/
	CSTAT_ERR_GENERAL		= 5,		/* allgemeiner Fehler							*/
	CSTAT_ERR_NOTEXISTS		= 6,		/* Server existiert nicht						*/
	CSTAT_ERR_NOTREACHED	= 7,		/* Server nicht ereicht							*/
	CSTAT_UPD_IMMEDIATELY	= 8,		/* es wird gleich ueberprueftt 					*/
	CSTAT_ERR_OFFLINE		= 9			/* Ueberpruefung nicht mglich, da Offline		*/
};


DBG_NAMEEX(SfxCrawlStatusItem);

// class SfxDateTimeRangeItem -------------------------------------------------

class SfxCrawlStatusItem : public SfxPoolItem
{
private:
			CrawlStatus		eStatus;
public:
			TYPEINFO();

			SfxCrawlStatusItem( const SfxCrawlStatusItem& rCpy );
			SfxCrawlStatusItem( USHORT nWhich );
			SfxCrawlStatusItem( USHORT nWhich, CrawlStatus eStat );
			~SfxCrawlStatusItem() { DBG_DTOR(SfxCrawlStatusItem, 0); }

	virtual	int				operator==( const SfxPoolItem& )			const;
	virtual int				Compare( const SfxPoolItem &rWith )			const;
	virtual SfxPoolItem*	Create( SvStream&, USHORT nItemVersion )	const;
	virtual SvStream&		Store( SvStream&, USHORT nItemVersion )		const;
	virtual SfxPoolItem*	Clone( SfxItemPool* pPool = 0 )				const;

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									XubString &rText,
                                    const IntlWrapper * pIntlWrapper = 0 )
		const;

	CrawlStatus				GetStatus() const { return eStatus; }
	void					SetStatus(CrawlStatus eNew) { eStatus = eNew; }

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

#endif

