/*************************************************************************
 *
 *  $RCSfile: xout.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 15:05:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <math.h>
#include <stdlib.h>
#include <vcl/wrkwin.hxx>
#include <vcl/svapp.hxx>
#include <vcl/poly.hxx>
#include <vcl/window.hxx>
#include <vcl/gradient.hxx>
#include <svtools/itemset.hxx>
#include <goodies/grfmgr.hxx>
#include "xattr.hxx"
#include "xpool.hxx"
#include "xpoly.hxx"
#include "xoutx.hxx"
#include "xoutbmp.hxx"

#define ITEMVALUE(ItemSet,Id,Cast)	((const Cast&)(ItemSet).Get(Id)).GetValue()
#define	MTF_DIVISOR 2

/*************************************************************************
|*
|*	  XOutputDevice::XOutputDevice()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

XOutputDevice::XOutputDevice(OutputDevice* pOutDev) :
	pImpData			( new ImpData ),
	pLinePattern		( NULL ),
	nLinePatternCnt		( 0 ),
	eLineStyle			( XLINE_SOLID ),
	nLineTransparence	( 0 ),
	nLineWidth			( 0 ),
	aLineStartPoly		( 0 ),
	aLineEndPoly		( 0 ),
	nLineStartSqLen		( 0 ),
	nLineEndSqLen		( 0 ),
	bLineStart			( FALSE ),
	bLineEnd			( FALSE ),
	bHair				( FALSE ),
	eFillStyle			( XFILL_SOLID ),
	nFillTransparence   ( 0 ),
    mpFillGraphicObject ( new GraphicObject ),
	mnBmpPerCentX		( 0 ),
	mnBmpPerCentY		( 0 ),
	mnBmpOffX			( 0 ),
	mnBmpOffY			( 0 ),
	mnBmpOffPosX		( 0 ),
	mnBmpOffPosY		( 0 ),
	meLastOutDevType	( OUTDEV_WINDOW ),
	meBmpRectPoint		( RP_MM ),
	mbBmpTile			( FALSE ),
	mbBmpStretch		( TRUE ),
	mbBmpLogSize		( FALSE ),
	mbRecalc			( TRUE ),
	aGradient			( COL_BLACK, COL_WHITE ),
	aHatch				( COL_BLACK, XHATCH_SINGLE ),
	bDither				( ( pOutDev ? pOutDev : Application::GetDefaultDevice() )->GetColorCount() <= 256 ),
	bIgnoreLineAttr		( FALSE ),
	bIgnoreLineStyle	( FALSE ),
	bIgnoreFillAttr     ( FALSE ),
	eFormTextStyle		( XFT_UPRIGHT ),
	eFormTextAdjust		( XFT_AUTOSIZE ),
	nFormTextDistance	( 0 ),
	nFormTextStart		( 0 ),
	bFormTextMirror		( FALSE ),
	bFormTextOutline	( FALSE ),
	eFormTextShadow		( XFTSHADOW_NONE ),
	aFormTextShdwColor	( COL_LIGHTGRAY ),
	nFormTextShdwTransp	( 0 ),
	nFormTextShdwXVal	( 0 ),
	nFormTextShdwYVal	( 0 ),
	eFormTextStdForm	( XFTFORM_NONE ),
	bFormTextHideForm	( FALSE ),
	nFtAutoHeightSave	( 0 ),
	pOut				( pOutDev )
{
	iRotTransGradient() = NULL;
	iSolidHatch() = FALSE;
}

/*************************************************************************
|*
|*	  XOutputDevice::~XOutputDevice()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

XOutputDevice::~XOutputDevice()
{
	delete[] pLinePattern;
    delete mpFillGraphicObject;

    delete iRotTransGradient();
	delete static_cast< ImpData* >( pImpData );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawLine()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	02.02.94 ESO
|*
*************************************************************************/

void XOutputDevice::DrawLine( const Point& rStart, const Point& rEnd )
{
	Polygon aPoly(2);

	aPoly[0] = rStart;
	aPoly[1] = rEnd;
	DrawLinePolygon( aPoly, FALSE );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawPolyLine()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

void XOutputDevice::DrawPolyLine( const Polygon& rPoly )
{
	DrawLinePolygon( rPoly, FALSE );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawXPolyLine()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	29.11.94 ESO
|*
*************************************************************************/

void XOutputDevice::DrawXPolyLine( const XPolygon& rXPoly )
{
	if ( rXPoly.GetPointCount() > 0 )
	{
        // #100127# Too much hassle below this method
		// const Polygon aPoly( XOutCreatePolygonBezier(rXPoly, pOut) );
		const Polygon aPoly( XOutCreatePolygon(rXPoly, pOut) );
		DrawLinePolygon(aPoly, FALSE);
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawRect()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	29.11.94 ESO
|*
*************************************************************************/

void XOutputDevice::DrawRect( const Rectangle& rRect, ULONG nXRound,
							  ULONG nYRound )
{
	const Polygon aPoly( rRect, nXRound, nYRound );
	
	DrawFillPolyPolygon( aPoly, TRUE );
	DrawLinePolygon( aPoly, TRUE );
}


/*************************************************************************
|*
|*	  XOutputDevice::DrawEllipse()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

void XOutputDevice::DrawEllipse( const Rectangle& rRect )
{
	const Polygon aPoly( rRect.Center(), rRect.GetWidth() >> 1, rRect.GetHeight() >> 1 );
	
	DrawFillPolyPolygon( aPoly );
	DrawLinePolygon( aPoly, TRUE );
}


/*************************************************************************
|*
|*	  XOutputDevice::DrawArc()
|*
|*	  Beschreibung
|*	  Ersterstellung	09.11.94
|*	  Letzte Aenderung	09.11.94
|*
*************************************************************************/

void XOutputDevice::DrawArc( const Rectangle& rRect, const Point& rStart,
							 const Point& rEnd )
{
	const Polygon aPoly( rRect, rStart, rEnd, POLY_ARC );
	
	DrawFillPolyPolygon( aPoly );
	DrawLinePolygon( aPoly, TRUE );
}


/*************************************************************************
|*
|*	  XOutputDevice::DrawPie()
|*
|*	  Beschreibung
|*	  Ersterstellung	09.11.94
|*	  Letzte Aenderung	09.11.94
|*
*************************************************************************/

void XOutputDevice::DrawPie( const Rectangle& rRect, const Point& rStart,
							 const Point& rEnd )
{
	const Polygon aPoly( rRect, rStart, rEnd, POLY_PIE );
	
	DrawFillPolyPolygon( aPoly );
	DrawLinePolygon( aPoly, TRUE );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawPolygon()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

void XOutputDevice::DrawPolygon( const Polygon& rPoly )
{
	DrawFillPolyPolygon( rPoly );
	DrawLinePolygon( rPoly, TRUE );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawXPolygon()
|*
|*	  Beschreibung		Polygon mit Linien- und Fuellstilen zeichnen
|*	  Ersterstellung	28.11.94 ESO
|*	  Letzte Aenderung	29.11.94 ESO
|*
\************************************************************************/

void XOutputDevice::DrawXPolygon(const XPolygon& rXPoly)
{
	if ( rXPoly.GetPointCount() > 0 )
	{
        // #100127# Too much hassle below this method
		// const Polygon aPoly( XOutCreatePolygonBezier(rXPoly, pOut) );
		const Polygon aPoly( XOutCreatePolygon(rXPoly, pOut) );

		DrawFillPolyPolygon( aPoly );
		DrawLinePolygon(aPoly, TRUE);
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawPolyPolygon()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

void XOutputDevice::DrawPolyPolygon( const PolyPolygon& rPolyPoly )
{
	DrawFillPolyPolygon( rPolyPoly );

	if( eLineStyle != XLINE_NONE )
	{
		const USHORT nCount = rPolyPoly.Count();
		USHORT i;

		for( i = 0; i < nCount; i++ )
			DrawLinePolygon( rPolyPoly.GetObject(i), TRUE );
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawXPolyPolygon()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	29.11.94 ESO
|*
*************************************************************************/

void XOutputDevice::DrawXPolyPolygon( const XPolyPolygon& rXPolyPoly )
{
	PolyPolygon aPolyPoly;

	USHORT	nCount = rXPolyPoly.Count(), i;

	for( i = 0; i < nCount; i++ )
	{
		if( rXPolyPoly[i].GetPointCount() > 0 )
        {
            // #100127# Too much hassle below this method
			// aPolyPoly.Insert(XOutCreatePolygonBezier(rXPolyPoly[i], pOut));
			aPolyPoly.Insert(XOutCreatePolygon(rXPolyPoly[i], pOut));
        }
	}

	DrawFillPolyPolygon( aPolyPoly );

	if( eLineStyle != XLINE_NONE )
	{
		nCount = aPolyPoly.Count();

		for (i = 0; i < nCount; i++ )
			DrawLinePolygon(aPolyPoly.GetObject(i), TRUE);
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::InitLineStartEnd()
|*
|*	  Polygon fuer Linienanfang bzw. -ende initialisieren; gibt die
|*	  Entfernung vom Polygon-Fixpunkt zum Linienansatz zurueck
|*	  Ersterstellung	16.01.95 ESO
|*	  Letzte Aenderung	28.07.95 SOH
|*
\************************************************************************/

long XOutputDevice::InitLineStartEnd(XPolygon& rXPoly, long nNewWidth,
									 BOOL bCenter)
{
	Point			aTranslation;
	const Rectangle	aRect(rXPoly.GetBoundRect());
	const long		nWidth = Max( (long)(aRect.GetWidth() - 1), 1L );

	if ( bCenter )
		aTranslation = aRect.Center();
	else
		aTranslation = aRect.TopCenter();

	// Punkte verschieben und Skalieren
	for (USHORT i = 0; i < rXPoly.GetPointCount(); i++)
		rXPoly[i] = (rXPoly[i] - aTranslation) * nNewWidth / nWidth;

	long nHeight = aRect.GetHeight() * nNewWidth / nWidth;

	if ( bCenter )
		nHeight >>= 1;

	return nHeight;
}

/*************************************************************************
|*
|*	  XOutputDevice::SetLineAttr()
|*
|*	  Linienattribute aus ItemSet auslesen und am OutputDevice setzen
|*	  Ersterstellung	17.11.94 ESO
|*	  Letzte Aenderung	09.10.95 ESO
|*
\************************************************************************/

//-/void XOutputDevice::SetLineAttr(const XLineAttrSetItem& rAttr)
void XOutputDevice::SetLineAttr(const SfxItemSet& rSet)
{
//-/	const SfxItemSet&	rSet = rAttr.GetItemSet();
	const BOOL			bPureMtf = ( pOut->GetOutDevType() != OUTDEV_PRINTER ) && ( pOut->GetConnectMetaFile() != NULL );

	aLineColor = ITEMVALUE( rSet, XATTR_LINECOLOR, XLineColorItem );
	nLineTransparence = ITEMVALUE( rSet, XATTR_LINETRANSPARENCE, XLineTransparenceItem );

	delete[] pLinePattern;
	pLinePattern = NULL;
	bLineStart = FALSE;
	bLineEnd = FALSE;
	bHair = TRUE;
	nLineWidth = ITEMVALUE( rSet, XATTR_LINEWIDTH, XLineWidthItem );

	if( bIgnoreLineAttr )
	{
		// fuer Linien mit Staerke Null wird im "Nur Haarlinienmodus" ein Hellgrau-Pen benutzt
		if( nLineWidth == 0 )
			pOut->SetLineColor( COL_LIGHTGRAY );
		else
		{
			nLineWidth = 0;
			pOut->SetLineColor( aLineColor );
		}
	}
	else
	{
		long nMinLineWidth = Max( nLineWidth, pOut->PixelToLogic( Size( 2, 2 ) ) .Width() );

		eLineStyle = ITEMVALUE( rSet, XATTR_LINESTYLE, XLineStyleItem );

		// Falls wir Linienstil ignorieren, setzen wir Linienstil auf Solid
		if ( bIgnoreLineStyle )
		{
			eLineStyle = XLINE_SOLID;
			pOut->SetLineColor( COL_BLACK );
		}

		// bei reinen Metafiles auch sehr duenne Linien als Polygone ausgeben,
		// damit wir hier eine hoehere Genauigkeit wegen der Systemunabhaegigkeit erreichen
		// SB: aber nicht, wenn gedruckt wird (dabei wird immer ein Metafile aufgezeichnet)
		if ( bPureMtf )
			nMinLineWidth /= MTF_DIVISOR;

		if ( eLineStyle == XLINE_DASH )
		{
			USHORT	i, nCnt, nDotCnt;
			long	nDotLen, nDashLen, nDistance;
			long	nMinLength = nMinLineWidth;

			const XDash& rDash = ITEMVALUE( rSet, XATTR_LINEDASH, XLineDashItem );

			// Sonderbehandlung fuer Haarlinien
			if ( nLineWidth < nMinLineWidth )
				nMinLength = 30;

			nDotCnt = rDash.GetDots() << 1;
			nLinePatternCnt = nDotCnt + ( rDash.GetDashes() << 1 ) + 1;
			pLinePattern = new long[nLinePatternCnt];
			nCnt = 0;
			nDotLen = rDash.GetDotLen();
			nDashLen = rDash.GetDashLen();
			nDistance = rDash.GetDistance();

			if ( rDash.GetDashStyle() == XDASH_RECTRELATIVE || rDash.GetDashStyle() == XDASH_ROUNDRELATIVE )
			{
				// Der Teilungsfaktor ist abhaengig davon,
				// ob wir uns in einer reinen Mtf-Aufzeichnung
				// befinden oder nicht. Wenn ja, muessen
				// wir dieses bei der Laengenberechn. beruecks.,
				// um gleiche Ergebnisse zu bekommen; die hoehere
				// Genauigkeit im Mtf bezieht sich nur auf die Breite
				// (KA 29.09.96)
				const long nFactor = nMinLength * ( bPureMtf ? MTF_DIVISOR : 1 );

				nDotLen = nDotLen * nFactor / 100;
				nDashLen = nDashLen * nFactor / 100;
				nDistance = nDistance * nFactor / 100;
			}

			if ( nDotLen == 0 )
				nDotLen = nMinLength;
			if ( nDashLen == 0 )
				nDashLen = nMinLength;

			for (i = 0; i < nDotCnt; i += 2)
			{
				if ( nDotLen )
				{
					pLinePattern[nCnt++] = nDotLen;
					pLinePattern[nCnt++] = nDistance;
				}
			}
			for ( ; i < nLinePatternCnt - 1; i += 2)
			{
				if ( nDashLen )
				{
					pLinePattern[nCnt++] = nDashLen;
					pLinePattern[nCnt++] = nDistance;
				}
			}
			if ( !nCnt )
			{
				eLineStyle = XLINE_SOLID;
				delete pLinePattern;
				pLinePattern = NULL;
			}
			else
				pLinePattern[nCnt] = 0;
		}


		if ( nLineWidth < nMinLineWidth && eLineStyle == XLINE_SOLID )
		{
			nLineWidth = 0;
			pOut->SetLineColor( aLineColor );
		}
		else
		{
			bHair = FALSE;
			pOut->SetLineColor();
			
			if( nLineWidth < nMinLineWidth )
				nLineWidth = 0;
		}
		const SfxPoolItem* pPoolItem;

		// Polygon und Daten fuer Linienanfang und -ende initialisieren
		if ( rSet.GetItemState(XATTR_LINESTART, TRUE, &pPoolItem) == SFX_ITEM_SET )
		{
			long nWidth = ITEMVALUE( rSet, XATTR_LINESTARTWIDTH, XLineStartWidthItem );

			aLineStartPoly = ((XLineStartItem*) pPoolItem)->GetValue();

			// Nur aktivieren, wenn Polygonbreite > 0
			if ( nWidth )
			{
				// Breite negativ: Prozentwert
				if ( nWidth < 0 )
				{
					nWidth = - nMinLineWidth * nWidth / 100;
					if ( nWidth == 0 ) nWidth = nMinLineWidth;
				}
				BOOL bCenter = ITEMVALUE( rSet, XATTR_LINESTARTCENTER, XLineStartCenterItem );
				nLineStartSqLen = InitLineStartEnd(aLineStartPoly, nWidth, bCenter);
				// 4/5, um Ueberschneidung zu Gewaehrleisten
				nLineStartSqLen = nLineStartSqLen * 4 / 5;
				nLineStartSqLen = nLineStartSqLen * nLineStartSqLen;
				bLineStart = TRUE;
			}
		}
		if ( rSet.GetItemState(XATTR_LINEEND, TRUE, &pPoolItem) == SFX_ITEM_SET )
		{
			long nWidth = ITEMVALUE( rSet, XATTR_LINEENDWIDTH, XLineEndWidthItem );

			aLineEndPoly = ((XLineStartItem*) pPoolItem)->GetValue();

			if ( nWidth )
			{
				// Breite negativ: Prozentwert
				if ( nWidth < 0 )
				{
					nWidth = - nMinLineWidth * nWidth / 100;
					if ( nWidth == 0 ) nWidth = nMinLineWidth;
				}
				BOOL bCenter = ITEMVALUE( rSet, XATTR_LINEENDCENTER, XLineEndCenterItem );
				nLineEndSqLen = InitLineStartEnd(aLineEndPoly, nWidth, bCenter);
				nLineEndSqLen = nLineEndSqLen * 4 / 5;
				nLineEndSqLen = nLineEndSqLen * nLineEndSqLen;
				bLineEnd = TRUE;
			}
		}
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::SetFillAttr()
|*
|*	  Fuellattribute aus ItemSet auslesen und am OutputDevice setzen
|*	  Ersterstellung	17.11.94 ESO
|*	  Letzte Aenderung	26.06.95 ESO
|*
\************************************************************************/

//-/void XOutputDevice::SetFillAttr(const XFillAttrSetItem& rAttr)
void XOutputDevice::SetFillAttr(const SfxItemSet& rSet)
{
//-/	const SfxItemSet&					rSet = rAttr.GetItemSet();
	const XFillFloatTransparenceItem&	rFloatTransItem =  (const XFillFloatTransparenceItem&) rSet.Get( XATTR_FILLFLOATTRANSPARENCE );
	
	eFillStyle = bIgnoreFillAttr ? XFILL_NONE : ITEMVALUE( rSet, XATTR_FILLSTYLE, XFillStyleItem );
	nFillTransparence = ITEMVALUE( rSet, XATTR_FILLTRANSPARENCE, XFillTransparenceItem );

	// clear bitmap
	if( eFillStyle != XFILL_BITMAP )
	{
        maFillBitmap.SetEmpty();
		maFillBitmapSize.Width() = maFillBitmapSize.Height() = 0L;
	}

	// assign transparent gradient?
	if( ( eFillStyle != XFILL_NONE ) && ( rFloatTransItem.IsEnabled() || nFillTransparence ) )
	{
		XGradient aXGrad;

		if( rFloatTransItem.IsEnabled() )
			aXGrad = rFloatTransItem.GetValue();
		else
		{
			const BYTE	cTrans = (BYTE) ( nFillTransparence * 255 / 100 );
			const Color aTransCol( cTrans, cTrans, cTrans );

			aXGrad.SetGradientStyle( XGRAD_LINEAR );
			aXGrad.SetStartColor( aTransCol );
			aXGrad.SetEndColor( aTransCol );
			aXGrad.SetAngle( 0 );
			aXGrad.SetBorder( 0 );
			aXGrad.SetXOffset( 0 );
			aXGrad.SetYOffset( 0 );
			aXGrad.SetStartIntens( 100 );
			aXGrad.SetEndIntens( 100 );
			aXGrad.SetSteps( 3 );
		}

		if( iRotTransGradient() )
			*iRotTransGradient() = aXGrad;
		else
			iRotTransGradient()	= new XGradient( aXGrad );
	}
	else if( iRotTransGradient() )
	{
		delete iRotTransGradient();
		iRotTransGradient() = NULL;
	}

	if( eFillStyle != XFILL_NONE )
	{
		pOut->SetFillColor( aFillColor = ITEMVALUE( rSet, XATTR_FILLCOLOR, XFillColorItem ) );

		if( eFillStyle == XFILL_BITMAP )
		{
			MapMode		aMapMode( pOut->GetMapMode() );
			Bitmap		aBmp( ITEMVALUE( rSet, XATTR_FILLBITMAP, XFillBitmapItem ).GetBitmap() );
			USHORT		nOffX = ITEMVALUE( rSet, XATTR_FILLBMP_TILEOFFSETX, SfxUInt16Item );
			USHORT		nOffY = ITEMVALUE( rSet, XATTR_FILLBMP_TILEOFFSETY, SfxUInt16Item );
			USHORT		nOffPosX = ITEMVALUE( rSet, XATTR_FILLBMP_POSOFFSETX, SfxUInt16Item );
			USHORT		nOffPosY = ITEMVALUE( rSet, XATTR_FILLBMP_POSOFFSETY, SfxUInt16Item );
			RECT_POINT	eRectPoint = (RECT_POINT) ITEMVALUE( rSet, XATTR_FILLBMP_POS, SfxEnumItem );
			BOOL		bTile = ITEMVALUE( rSet, XATTR_FILLBMP_TILE, SfxBoolItem );
			BOOL		bStretch = ITEMVALUE( rSet, XATTR_FILLBMP_STRETCH, SfxBoolItem );
			BOOL		bLogSize = ITEMVALUE( rSet, XATTR_FILLBMP_SIZELOG, SfxBoolItem );
			Size		aSize( labs( ITEMVALUE( rSet, XATTR_FILLBMP_SIZEX, SfxMetricItem ) ),
                               labs( ITEMVALUE( rSet, XATTR_FILLBMP_SIZEY, SfxMetricItem ) ) );

			if( !mbRecalc && !pOut->GetConnectMetaFile() &&
                ( aBmp == maFillBitmap ) && 
                ( pOut->GetOutDevType() == meLastOutDevType ) &&
			    ( maLastMapMode.GetMapUnit() == aMapMode.GetMapUnit() ) &&
				( maLastMapMode.GetScaleX() == aMapMode.GetScaleX() ) &&
				( maLastMapMode.GetScaleY() == aMapMode.GetScaleY() ) &&
			    ( bTile == mbBmpTile ) &&
				( bStretch == mbBmpStretch ) &&
				( bLogSize == mbBmpLogSize ) &&
				( aSize == maBmpSize ) &&
				( eRectPoint == meBmpRectPoint ) &&
				( nOffX == mnBmpOffX ) &&
				( nOffY == mnBmpOffY ) &&
				( nOffPosX == mnBmpOffPosX ) &&
				( nOffPosY == mnBmpOffPosY ) )
			{
				return;
			}
			else
			{
				maFillBitmap = aBmp;
				maLastMapMode = aMapMode;
				meLastOutDevType = pOut->GetOutDevType();

				mbBmpTile = bTile;
				mbBmpStretch = bStretch;
				mbBmpLogSize = bLogSize;
				mnBmpOffX = nOffX;
				mnBmpOffY = nOffY;
				meBmpRectPoint = eRectPoint;
				mnBmpOffPosX = nOffPosX;
				mnBmpOffPosY = nOffPosY;

				if( bLogSize )
					maBmpSize = aSize;
				else
				{
					mnBmpPerCentX = (USHORT) aSize.Width();
					mnBmpPerCentY = (USHORT) aSize.Height();
				}

				mbRecalc = TRUE;
			}
		}
		else if (eFillStyle == XFILL_GRADIENT)
		{
			aGradient = ITEMVALUE( rSet, XATTR_FILLGRADIENT, XFillGradientItem );
			aGradient.SetSteps( ITEMVALUE( rSet, XATTR_GRADIENTSTEPCOUNT, XGradientStepCountItem ) );
		}
		else if( eFillStyle == XFILL_HATCH )
		{
			iSolidHatch() = ITEMVALUE( rSet, XATTR_FILLBACKGROUND, XFillBackgroundItem );
			aHatch = ITEMVALUE( rSet, XATTR_FILLHATCH, XFillHatchItem );
		}
	}
	else
		pOut->SetFillColor();
}


/*************************************************************************
|*
|*	  XOutputDevice::SetTextAttr()
|*
|*	  Textattribute aus ItemSet auslesen und am OutputDevice setzen
|*	  Ersterstellung	02.02.95 ESO
|*	  Letzte Aenderung	27.06.95 ESO
|*
\************************************************************************/

//-/void XOutputDevice::SetTextAttr(const XTextAttrSetItem& rAttr)
void XOutputDevice::SetTextAttr(const SfxItemSet& rSet)
{
//-/	const SfxItemSet& rSet = rAttr.GetItemSet();

	eFormTextStyle = ITEMVALUE( rSet, XATTR_FORMTXTSTYLE, XFormTextStyleItem );
	eFormTextAdjust = ITEMVALUE( rSet, XATTR_FORMTXTADJUST, XFormTextAdjustItem );
	nFormTextDistance = ITEMVALUE( rSet, XATTR_FORMTXTDISTANCE, XFormTextDistanceItem );
	nFormTextStart = ITEMVALUE( rSet, XATTR_FORMTXTSTART, XFormTextStartItem );
	bFormTextMirror = ITEMVALUE( rSet, XATTR_FORMTXTMIRROR, XFormTextMirrorItem );

	// Neu ab 27.06.95 ESO
	bFormTextOutline = ITEMVALUE( rSet, XATTR_FORMTXTOUTLINE, XFormTextOutlineItem );
	eFormTextShadow = ITEMVALUE( rSet, XATTR_FORMTXTSHADOW, XFormTextShadowItem );
	aFormTextShdwColor = ITEMVALUE( rSet, XATTR_FORMTXTSHDWCOLOR, XFormTextShadowColorItem );

	// Neu ab 09.11.95 KA
	nFormTextShdwTransp	= ITEMVALUE( rSet, XATTR_FORMTXTSHDWTRANSP, XFormTextShadowTranspItem );
	nFormTextShdwXVal = ITEMVALUE( rSet, XATTR_FORMTXTSHDWXVAL, XFormTextShadowXValItem );
	nFormTextShdwYVal = ITEMVALUE( rSet, XATTR_FORMTXTSHDWYVAL, XFormTextShadowYValItem );
	eFormTextStdForm = ITEMVALUE( rSet, XATTR_FORMTXTSTDFORM, XFormTextStdFormItem );
	bFormTextHideForm = ITEMVALUE( rSet, XATTR_FORMTXTHIDEFORM, XFormTextHideFormItem );
}

/*************************************************************************
|*
|*	  XOutputDevice::OverridePen()
|*
|*	  StarView-Pen temporaer ueberschreiben, wenn SetLineAttr zu
|*	  zeitkritisch ist. !ACHTUNG! Vor weiteren XOut-Ausgaben muessen
|*	  die Attribute mit SetLineAttr neu gesetzt werden
|*	  Ersterstellung	26.06.95 ESO
|*	  Letzte Aenderung	26.06.95 ESO
|*
\************************************************************************/

#ifndef NOOLDSV

void XOutputDevice::OverridePen(const Pen& rPen)
{
	nLineWidth = 0;
	bHair = TRUE;
	bLineStart = FALSE;
	bLineEnd = FALSE;
	eLineStyle = ( rPen.GetStyle() == PEN_NULL  ) ? XLINE_NONE : XLINE_SOLID;
	pOut->SetLineColor( rPen.GetColor() );
}

#endif

/*************************************************************************
|*
|*	  XOutputDevice::OverrideFillInBrush()
|*
|*	  StarView-Brush temporaer ueberschreiben, wenn SetFillAttr zu
|*	  zeitkritisch ist. !ACHTUNG! Vor weiteren XOut-Ausgaben muessen
|*	  die Attribute mit SetFillAttr neu gesetzt werden
|*	  Ersterstellung	26.06.95 ESO
|*	  Letzte Aenderung	26.06.95 ESO
|*
\************************************************************************/

#ifndef NOOLDSV

void XOutputDevice::OverrideFillInBrush( const Brush& rBrush )
{
	eFillStyle = ( rBrush.GetStyle() == BRUSH_NULL ) ? 	XFILL_NONE : XFILL_SOLID;
	pOut->SetFillColor( rBrush.GetColor() );
}

#endif

/*************************************************************************
|*
|*	  XOutputDevice:OverrideLineColor()
|*
|*	  StarView-Linecolor temporaer ueberschreiben, wenn SetLineAttr zu
|*	  zeitkritisch ist. !ACHTUNG! Vor weiteren XOut-Ausgaben muessen
|*	  die Attribute mit SetLineAttr neu gesetzt werden
|*	  Ersterstellung	26.06.95 ESO
|*	  Letzte Aenderung	26.06.95 ESO
|*
\************************************************************************/

void XOutputDevice::OverrideLineColor(const Color& rColor )
{
	nLineWidth = 0;
	bHair = TRUE;
	bLineStart = FALSE;
	bLineEnd = FALSE;
	eLineStyle = ( rColor.GetColor() == COL_TRANSPARENT ) ? XLINE_NONE : XLINE_SOLID;
	pOut->SetLineColor( rColor );
}

/*************************************************************************
|*
|*	  XOutputDevice::OverrideFillColor()
|*
|*	  StarView-Brush temporaer ueberschreiben, wenn SetFillAttr zu
|*	  zeitkritisch ist. !ACHTUNG! Vor weiteren XOut-Ausgaben muessen
|*	  die Attribute mit SetFillAttr neu gesetzt werden
|*	  Ersterstellung	26.06.95 ESO
|*	  Letzte Aenderung	26.06.95 ESO
|*
\************************************************************************/

void XOutputDevice::OverrideFillColor( const Color& rColor )
{
	eFillStyle = ( rColor.GetColor() == COL_TRANSPARENT ) ? XFILL_NONE : XFILL_SOLID;
	pOut->SetFillColor( rColor );
}
