/*************************************************************************
 *
 *  $RCSfile: wrt_undo.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:51:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifdef __MWERKS__
#define private public
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif


#include "doc.hxx"
#include "wrt_undo.hxx"
#include "undobj.hxx"
#include "docary.hxx"




SwUndoWriter::SwUndoWriter()  {}



__EXPORT SwUndoWriter::~SwUndoWriter() {}



ULONG SwUndoWriter::WriteStream()
{
	// keine Daten ??
	if( !pDoc->pUndos->Count() )
		return 0;

	//$ long nFlags = rStrm().setf( ios::fixed, ios::floatfield );
	//$ rStrm().precision( 3 );

	// Undo-Aktionen vorhanden
	if( pDoc->nUndoPos )
	{
		Strm() << "======= Undo-Aktionen =========\n";
		SwUndo* pUndo;
		for( USHORT n = pDoc->nUndoPos; n; )
		{
			pUndo = pDoc->pUndos->operator[](--n);
			(*aUndoFnTab[ pUndo->GetId() - UNDO_STD_BEGIN ])( *this, *pUndo );
		}
	}
	// Redo-Aktionen vorhanden
	if( pDoc->nUndoPos < pDoc->pUndos->Count()  )
	{
		Strm() << "======= Redo-Aktionen =========\n";
		SwUndo* pUndo;
		for( USHORT n = pDoc->nUndoPos; n < pDoc->pUndos->Count(); ++n )
		{
			pUndo = pDoc->pUndos->operator[](n);
			(*aUndoFnTab[ pUndo->GetId() - UNDO_STD_BEGIN ])( *this, *pUndo );
		}
	}

//     Out_SwDoc( pDebug, *pDoc->GetUndoNds() );

	Strm() << '\0';

	return 0;
}


#ifndef PRODUCT

void GetUndoWriter( const String&, WriterRef& xRet )
{
	xRet = new SwUndoWriter;
}

#endif



