/*************************************************************************
 *
 *  $RCSfile: rmtimap.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:55:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTIMAP_HXX_
#define _UCPRMT_RMTIMAP_HXX_

#include <deque>

#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERMAPPING_HPP_
#include <com/sun/star/ucb/XContentIdentifierMapping.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_ 
#include <com/sun/star/uno/Sequence.h>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_ 
#include <cppuhelper/weak.hxx>
#endif
#ifndef _RTL_REF_HXX_ 
#include <rtl/ref.hxx>
#endif
#ifndef _SAL_TYPES_H_ 
#include <sal/types.h>
#endif

namespace com { namespace sun { namespace star { namespace beans {
    struct Property;
} } } }

namespace ucprmt {

class Connection;

//============================================================================
class ContentIdentifierMapping:
        public cppu::OWeakObject,
        public com::sun::star::ucb::XContentIdentifierMapping
{
public:
    ContentIdentifierMapping(rtl::Reference< Connection > const &
                                 rTheConnection,
                             com::sun::star::uno::Sequence<
                                     com::sun::star::beans::Property > const &
                                 rProperties);

    //========================================================================
    // com::sun::star::uno::XInterface:

    virtual com::sun::star::uno::Any SAL_CALL
    queryInterface(com::sun::star::uno::Type const & rType)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw ();

    virtual void SAL_CALL release() throw ();

    //========================================================================
    // com::sun::star::ucb::XContentIdentifierMapping:

    virtual rtl::OUString SAL_CALL
    mapContentIdentifierString(rtl::OUString const & rSource)
        throw (com::sun::star::uno::RuntimeException);

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
    SAL_CALL
    mapContentIdentifier(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rSource)
        throw (com::sun::star::uno::RuntimeException);

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL
    mapContent(com::sun::star::uno::Reference<
                       com::sun::star::ucb::XContent > const &
                   rSource)
        throw (com::sun::star::uno::RuntimeException);

    virtual sal_Bool SAL_CALL
    mapRow(com::sun::star::uno::Sequence< com::sun::star::uno::Any > & rValue)
        throw (com::sun::star::uno::RuntimeException);

private:
    typedef std::deque< sal_Int32 > Indices;

    rtl::Reference< Connection > m_xConnection;
    Indices m_aIndices;
};

}

#endif // _UCPRMT_RMTIMAP_HXX_
