/*************************************************************************
 *
 *  $RCSfile: salgdi2.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#include <string.h>

#include <svmac.h>



#define _SV_SALGDI2_CXX



#ifndef _DEBUG_HXX

#include <tools/debug.hxx>

#endif

#ifndef _SV_SALBTYPE_HXX

#include <salbtype.hxx>

#endif

#ifndef _SV_SALBMP_HXX

#include <salbmp.hxx>

#endif

#ifndef _SV_SALGDI_HXX

#include <salgdi.hxx>

#endif



// =======================================================================

// Hilfsfunktion zum Beschneiden des SourceRects damit nicht von

// undefiniertem Speicher gelesen wird

// last changed:	dv	26.09.97



static void CheckRects( Rect& rSource, Rect& rDest, const Rect& rBounds )

{

	if (rSource.top < rBounds.top)

	{

		rDest.top  += (rBounds.top - rSource.top);

		rSource.top = rBounds.top;

	}

	if (rSource.left < rBounds.left)

	{

		rDest.left  += (rBounds.left - rSource.left);

		rSource.left = rBounds.left;

	}

	if (rSource.bottom > rBounds.bottom)

	{

		rDest.bottom  += (rBounds.bottom - rSource.bottom);

		rSource.bottom = rBounds.bottom;

	}

	if (rSource.right > rBounds.right)

	{

		rDest.right  += (rBounds.right - rSource.right);

		rSource.right = rBounds.right;

	}

}



// -----------------------------------------------------------------------

// last changed:	dv	27.09.97



static void ImplCheckMask( PixMapHandle hMask )

{

	CTabHandle hCTab = (**hMask).pmTable;

	

	// Wenn die Maske eine zweifarbe Bitmap ist, dann muessen wir

	// sicherstellen, dass die erste Farbe weiss ist.

	if ( ( (**hCTab).ctSize == 1 ) &&

		 ( (**hCTab).ctTable[0].rgb.red == 0 ) )

	{

		(**hCTab).ctSeed = GetCTSeed();

		(**hCTab).ctTable[0].rgb.red   = 0xffff;

		(**hCTab).ctTable[0].rgb.green = 0xffff;

		(**hCTab).ctTable[0].rgb.blue  = 0xffff;

		(**hCTab).ctTable[1].rgb.red   = 0;

		(**hCTab).ctTable[1].rgb.green = 0;

		(**hCTab).ctTable[1].rgb.blue  = 0;

		

		long nByteAnz = ( (**hMask).rowBytes & 0x7fff ) *

						( (**hMask).bounds.bottom - (**hMask).bounds.top );

		char *pBuf = (**hMask).baseAddr;

		while ( nByteAnz-- )

			*pBuf++ ^= 0xff;

	}

}



// -----------------------------------------------------------------------

// last changed:	dv	27.09.97



PixMapHandle SalGraphicsData::GetPixmapHandle()

{

	PixMapHandle hPixmap;



	// Set the image

	if ( mbVirDev ) {

		hPixmap = GetGWorldPixMap( (GWorldPtr) mpGrafPort );

		HLock((Handle) hPixmap);

		LockPixels( hPixmap );

	}

	else

	{

		hPixmap = mpGrafPort->portPixMap;

		HLock((Handle) hPixmap );

		LockPixels( hPixmap );

	}



	DBG_ASSERT( hPixmap, "GetPixmapHandle: keine Pixmap bekommen!" );



	return hPixmap;

}



// -----------------------------------------------------------------------

// last changed:	dv	27.09.97



void SalGraphicsData::ReleasePixmapHandle( PixMapHandle hPixmap )

{

	if ( mbVirDev )

	{

		UnlockPixels( hPixmap );

		HUnlock((Handle) hPixmap);

	}

	else

	{

		UnlockPixels( hPixmap );

		HUnlock((Handle) hPixmap);

	}

}



// -----------------------------------------------------------------------

// last changed:	dv	27.09.97



void SalGraphicsData::CreatePalette( BitmapPalette& rPalette,

									 const PixMapHandle hPixmap )

{

	CTabHandle hCTab = (**hPixmap).pmTable;

	

	DBG_ASSERT( hCTab, "CreatePalette: Keine Color Table !" );



	rPalette.SetEntryCount( (**hCTab).ctSize + 1 );



	for ( USHORT i = 0; i < rPalette.GetEntryCount(); i++)

	{

		rPalette[ i ] = BitmapColor(

					BYTE( (**hCTab).ctTable[i].rgb.red   >> 8 ),

					BYTE( (**hCTab).ctTable[i].rgb.green >> 8 ),

					BYTE( (**hCTab).ctTable[i].rgb.blue  >> 8 ) );

	}

}



// =======================================================================

// last changed:	dv	29.09.97



void SalGraphics::CopyBits( const SalTwoRect* pPosAry, SalGraphics* pSrcGraphics )

{

	DBG_ASSERT( maGraphicsData.mpGrafPort, "Kein Port fuer Ausgabe!" );



	Rect			aSrcRect, aDstRect;

	PixMapHandle	hSrcPixMap;

	PixMapHandle	hDstPixMap = maGraphicsData.GetPixmapHandle();

	short			nMode;



	if ( pSrcGraphics )

		hSrcPixMap = pSrcGraphics->maGraphicsData.GetPixmapHandle();

	else

		hSrcPixMap = hDstPixMap;

		

	SetRect( &aSrcRect, (short) pPosAry->mnSrcX, (short) pPosAry->mnSrcY,

			(short) pPosAry->mnSrcX + (short) pPosAry->mnSrcWidth,

			(short) pPosAry->mnSrcY + (short) pPosAry->mnSrcHeight );

	SetRect( &aDstRect, (short) pPosAry->mnDestX, (short) pPosAry->mnDestY,

			(short) pPosAry->mnDestX + (short) pPosAry->mnDestWidth,

			(short) pPosAry->mnDestY + (short) pPosAry->mnDestHeight );



	CheckRects( aSrcRect, aDstRect, (**hSrcPixMap).bounds );



	maGraphicsData.CheckDrawMode( DRAW_BITS );



	if ( maGraphicsData.mnPenMode == patCopy )

		nMode	= srcCopy;

	else

		nMode	= srcXor;



	// und die Bits kopieren

	::CopyBits( *(BitMapHandle) hSrcPixMap,

				*(BitMapHandle) hDstPixMap,

				&aSrcRect, &aDstRect,

				nMode, nil );



	// Aufraeumen

	if ( pSrcGraphics )

		pSrcGraphics->maGraphicsData.ReleasePixmapHandle( hSrcPixMap );



	maGraphicsData.ReleasePixmapHandle( hDstPixMap );

}



// =======================================================================

// last changed:	dv	27.09.97



void SalGraphics::DrawBitmap( const SalTwoRect* pPosAry,

							  const SalBitmap& rSrcBitmap )

{

	DBG_ASSERT( maGraphicsData.mpGrafPort, "Kein Port fuer Ausgabe!" );



	Rect			aSrcRect, aDstRect;

	PixMapHandle	hSrcPixMap = rSrcBitmap.ImplGethPixMap();

	PixMapHandle	hDstPixMap = maGraphicsData.GetPixmapHandle();

	short			nMode;

		

	HLock( (Handle) hSrcPixMap );



	// Ausgabe Rechtecke bestimmen

	SetRect( &aSrcRect, (short) pPosAry->mnSrcX, (short) pPosAry->mnSrcY,

			(short) pPosAry->mnSrcX + (short) pPosAry->mnSrcWidth,

			(short) pPosAry->mnSrcY + (short) pPosAry->mnSrcHeight );

	SetRect( &aDstRect, (short) pPosAry->mnDestX, (short) pPosAry->mnDestY,

			(short) pPosAry->mnDestX + (short) pPosAry->mnDestWidth,

			(short) pPosAry->mnDestY + (short) pPosAry->mnDestHeight );

	CheckRects( aSrcRect, aDstRect, (**hSrcPixMap).bounds );

	

	// Environment setzen

	maGraphicsData.CheckDrawMode( DRAW_BITS );



	if ( maGraphicsData.mnPenMode == patCopy )

		nMode	= srcCopy;

	else

		nMode	= srcXor;



	// und die Bits kopieren

	::CopyBits( *(BitMapHandle) hSrcPixMap,

				*(BitMapHandle) hDstPixMap,

				&aSrcRect, &aDstRect,

				nMode, nil );



	// Aufraeumen

	HUnlock( (Handle) hSrcPixMap );

	maGraphicsData.ReleasePixmapHandle( hDstPixMap );

}



// -----------------------------------------------------------------------

// last changed:	dv	29.09.97



void SalGraphics::DrawBitmap( const SalTwoRect* pPosAry,

							  const SalBitmap& rSalBitmap,

							  SalColor nTransparentColor )

{

	DBG_ASSERT( maGraphicsData.mpGrafPort, "Kein Port fuer Ausgabe!" );



	Rect			aSrcRect, aDstRect;

	PixMapHandle	hSrcPixMap = rSalBitmap.ImplGethPixMap();

	PixMapHandle	hDstPixMap = maGraphicsData.GetPixmapHandle();

		

	HLock( (Handle) hSrcPixMap );



	// Ausgabe Rechtecke bestimmen

	SetRect( &aSrcRect, (short) pPosAry->mnSrcX, (short) pPosAry->mnSrcY,

			(short) pPosAry->mnSrcX + (short) pPosAry->mnSrcWidth,

			(short) pPosAry->mnSrcY + (short) pPosAry->mnSrcHeight );

	SetRect( &aDstRect, (short) pPosAry->mnDestX, (short) pPosAry->mnDestY,

			(short) pPosAry->mnDestX + (short) pPosAry->mnDestWidth,

			(short) pPosAry->mnDestY + (short) pPosAry->mnDestHeight );

	CheckRects( aSrcRect, aDstRect, (**hSrcPixMap).bounds );

	

	// Environment setzen

	maGraphicsData.CheckDrawMode( DRAW_BITS );



	MacColor aRGB( SALCOLOR_RED  ( nTransparentColor ),

				   SALCOLOR_GREEN( nTransparentColor ),

				   SALCOLOR_BLUE ( nTransparentColor ) );

	RGBBackColor( aRGB );



	DBG_ASSERT( maGraphicsData.mnPenMode == patCopy,

				"DrawBitmap mit transparent Farbe geht nur mit Overpaint" );



	// und die Bits kopieren

	::CopyBits( *(BitMapHandle) hSrcPixMap,

				*(BitMapHandle) hDstPixMap,

				&aSrcRect, &aDstRect,

				transparent, nil );



	// Aufraeumen

	HUnlock( (Handle) hSrcPixMap );

	maGraphicsData.ReleasePixmapHandle( hDstPixMap );

	BackColor( whiteColor );

}



// -----------------------------------------------------------------------

// last changed:	dv	28.09.97



void SalGraphics::DrawBitmap( const SalTwoRect* pPosAry,

							  const SalBitmap& rSrcBitmap,

							  const SalBitmap& rMaskBitmap )

{

	DBG_ASSERT( maGraphicsData.mpGrafPort, "Kein Port fuer Ausgabe!" );



	Rect			aSrcRect, aDstRect;

	PixMapHandle	hSrcPixMap = rSrcBitmap.ImplGethPixMap();

	PixMapHandle	hMskPixMap = rMaskBitmap.ImplGethPixMap();

	PixMapHandle	hDstPixMap = maGraphicsData.GetPixmapHandle();

	short			nMode;

		

	HLock( (Handle) hSrcPixMap );

	HLock( (Handle) hMskPixMap );



	ImplCheckMask( hMskPixMap );



	// Ausgabe Rechtecke bestimmen

	SetRect( &aSrcRect, (short) pPosAry->mnSrcX, (short) pPosAry->mnSrcY,

			(short) pPosAry->mnSrcX + (short) pPosAry->mnSrcWidth,

			(short) pPosAry->mnSrcY + (short) pPosAry->mnSrcHeight );

	SetRect( &aDstRect, (short) pPosAry->mnDestX, (short) pPosAry->mnDestY,

			(short) pPosAry->mnDestX + (short) pPosAry->mnDestWidth,

			(short) pPosAry->mnDestY + (short) pPosAry->mnDestHeight );

	CheckRects( aSrcRect, aDstRect, (**hSrcPixMap).bounds );

	

	// Environment setzen

	maGraphicsData.CheckDrawMode( DRAW_BITS );



	if ( maGraphicsData.mnPenMode == patCopy )

		nMode	= srcCopy;

	else

		nMode	= srcXor;



	// und die Bits kopieren

	CopyDeepMask( *(BitMapHandle) hSrcPixMap,

				  *(BitMapHandle) hMskPixMap,

				  *(BitMapHandle) hDstPixMap,

				  &aSrcRect, &aSrcRect, &aDstRect,

				  nMode, nil );



	// Aufraeumen

	HUnlock( (Handle) hMskPixMap );

	HUnlock( (Handle) hSrcPixMap );

	maGraphicsData.ReleasePixmapHandle( hDstPixMap );

}



// -----------------------------------------------------------------------

// last changed:	dv	28.09.97



void SalGraphics::DrawMask( const SalTwoRect* pPosAry,

							const SalBitmap& rSalBitmap,

							SalColor nMaskColor )

{

	DBG_ASSERT( maGraphicsData.mpGrafPort, "Kein Port fuer Ausgabe!" );



	Rect			aSrcRect, aDstRect;

	PixMapHandle	hSrcPixMap = rSalBitmap.ImplGethPixMap();

	PixMapHandle	hDstPixMap = maGraphicsData.GetPixmapHandle();

	short			nMode;

		

	HLock( (Handle) hSrcPixMap );



	ImplCheckMask( hSrcPixMap );



	// Ausgabe Rechtecke bestimmen

	SetRect( &aSrcRect, (short) pPosAry->mnSrcX, (short) pPosAry->mnSrcY,

			(short) pPosAry->mnSrcX + (short) pPosAry->mnSrcWidth,

			(short) pPosAry->mnSrcY + (short) pPosAry->mnSrcHeight );

	SetRect( &aDstRect, (short) pPosAry->mnDestX, (short) pPosAry->mnDestY,

			(short) pPosAry->mnDestX + (short) pPosAry->mnDestWidth,

			(short) pPosAry->mnDestY + (short) pPosAry->mnDestHeight );

	CheckRects( aSrcRect, aDstRect, (**hSrcPixMap).bounds );

	

	// Environment setzen

	maGraphicsData.CheckDrawMode( DRAW_BITS );



	MacColor aRGB( SALCOLOR_RED  ( nMaskColor ),

				   SALCOLOR_GREEN( nMaskColor ),

				   SALCOLOR_BLUE ( nMaskColor ) );

	RGBForeColor( aRGB );



	if ( maGraphicsData.mnPenMode == patCopy )

		nMode	= srcCopy;

	else

		nMode	= srcXor;



	// und die Bits kopieren

	CopyDeepMask( *(BitMapHandle) hSrcPixMap,

				  *(BitMapHandle) hSrcPixMap,

				  *(BitMapHandle) hDstPixMap,

				  &aSrcRect, &aSrcRect, &aDstRect,

				  nMode, nil );



	// Aufraeumen

	HUnlock( (Handle) hSrcPixMap );

	maGraphicsData.ReleasePixmapHandle( hDstPixMap );

	ForeColor( blackColor );

}



// -----------------------------------------------------------------------

// last changed:	dv	27.09.97



SalBitmap* SalGraphics::GetBitmap( long nX, long nY, long nDX, long nDY )

{

	BitMap			*pSource, *pDest;

	PixMapHandle	hSrcPixMap, hDstPixMap;

	Rect			aDstRect, aSrcRect;

	BitmapPalette	aPalette;

	SalBitmap		*pBitmap = NULL;



	DBG_ASSERT( maGraphicsData.mpGrafPort, "Kein Port fuer Ausgabe!" );



	hSrcPixMap = maGraphicsData.GetPixmapHandle();



	// Pict-Rechtecke setzen

	SetRect( &aDstRect, 0, 0, (short) nDX, (short) nDY );

	SetRect( &aSrcRect, (short) nX, (short ) nY,

			 (short) (nX + nDX ), (short) (nY + nDY) );



	CheckRects( aSrcRect, aDstRect, (**hSrcPixMap).bounds );



	// leere Bitmap erzeugen

	if ( (**hSrcPixMap).pixelSize <= 8 )

		maGraphicsData.CreatePalette( aPalette, hSrcPixMap );



	hDstPixMap = SalBitmap::ImplCreatePixMap( Size( nDX, nDY ),

											  (**hSrcPixMap).pixelSize,

											  aPalette );

	// neue Bitmap initialisieren

	if ( hDstPixMap )

	{

		HLock( (Handle) hDstPixMap );

		pDest = *(BitMapHandle) hDstPixMap;

		pSource = *(BitMapHandle) hSrcPixMap;

		

		maGraphicsData.CheckDrawMode( DRAW_BITS );



		::CopyBits( pSource, pDest, &aSrcRect, &aDstRect,

					srcCopy, nil );

		HUnlock( (Handle) hDstPixMap );

		

		pBitmap = new SalBitmap;

		pBitmap->ImplCreate( hDstPixMap, FALSE );

	}

	

	maGraphicsData.ReleasePixmapHandle( hSrcPixMap );



	return pBitmap;

}



// -----------------------------------------------------------------------

// last changed:	dv	26.09.97



SalColor SalGraphics::GetPixel( long nX, long nY )

{

	RGBColor	aMacColor;



	GetCPixel( (short) nX, (short) nY, &aMacColor );



	return MAKE_SALCOLOR( aMacColor.red, aMacColor.green, aMacColor.blue ); 

}



// -----------------------------------------------------------------------

// last changed:	dv	31.10.97



void SalGraphics::Invert( long nX, long nY, long nWidth,

						  long nHeight, SalInvert nFlags )

{

	MacRect aMacRect( nY, nX, nY + nHeight, nX + nWidth );

	

	maGraphicsData.CheckDrawMode( DRAW_INVERT );



	switch ( nFlags )

	{

		case SAL_INVERT_HIGHLIGHT:

				LMSetHiliteMode( pHiliteBit );

				// KEIN BREAK !!!

		case 0:	::InvertRect( aMacRect );

			break;

		case SAL_INVERT_50:

			{

				PenState aOldPen;

				GetPenState( &aOldPen );

				PenPat( (ConstPatternParam)&qd.gray );

				PenMode( srcXor );



				PaintRect( aMacRect );



				SetPenState( &aOldPen );

			}

			break;

	}

}






