/*************************************************************************
 *
 *  $RCSfile: salsound2.cxx,v $
 *
 *  $Revision: 1.3.136.1 $
 *
 *  last change: $Author: vg $ $Date: 2005/04/29 14:26:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>

#include <salunx.h>
#include <saldata.hxx>
#include <salframe.hxx>
#include <saldisp.hxx>

#include <salsound.hxx>
#include <salstype.hxx>
#include <salimpsound.hxx>

using namespace vcl_sal;


ULONG SalSound::s_nSoundState = SOUND_STATE_UNLOADED;


SalSound::SalSound() :
		m_pInst( NULL ),
		m_aPROC( NULL ),
		m_pVSound( NULL ),
		m_pFrame( NULL ),
		m_bLoop( FALSE ),
		m_bPlaying( FALSE ),
		m_bPaused( FALSE ),
		m_nStartTime( 0 ),
		m_nPlayTime( SOUND_PLAYALL )
{
	SalDbgAssert( "SalSound::SalSound()\n" );
}


SalSound::~SalSound()
{
	m_aPROC = NULL;
	SalDbgAssert( "SalSound::~SalSound()\n" );
	if( m_pVSound )
		delete m_pVSound;
}


BOOL SalSound::Create()
{
#ifdef USE_PASF
        // initialize the portaudio library (typically just once)
        if (s_nSoundState != SOUND_STATE_VALID) 
        {
              PaError err = Pa_Initialize();  
              if( err == paNoError ) s_nSoundState = SOUND_STATE_VALID;
        }
        if (s_nSoundState == SOUND_STATE_VALID ) return TRUE;
        s_nSoundState = SOUND_STATE_INVALID;
        return FALSE;
#else
        s_nSoundState = SOUND_STATE_VALID;
        return TRUE;
#endif
}


void SalSound::Release()
{
#ifdef USE_PASF
        // terminate the portaudio library
        if ( s_nSoundState == SOUND_STATE_VALID ) Pa_Terminate();
#endif
        s_nSoundState = SOUND_STATE_UNLOADED;
}


BOOL SalSound::IsValid()
{
  return (SalSound::s_nSoundState == SOUND_STATE_VALID);
}


BOOL SalSound::Init( SalFrame* pFrame,
					 const String& rSoundName,
					 ULONG& rSoundLen )
{
    
    // FIXME: NULL file names are passed in
    // This can happen before play of previous sound has completed and this disrupts things
    // simpy ignore this for now
    if (! (rSoundName.Len()))
        return FALSE;
    
	if( m_pVSound )
		delete m_pVSound;
    
    #ifdef MACOSX
	m_aSoundFile = ByteString( rSoundName, RTL_TEXTENCODING_UTF8 );
    #else
	m_aSoundFile = ByteString( rSoundName, gsl_getSystemTextEncoding() );
    #endif
    
	SalDbgAssert( "SalSound::Init( %p, \"%s\", %d )\n",
    pFrame, m_aSoundFile.GetBuffer(), rSoundLen );
	m_pFrame = pFrame;
	if( ! m_pFrame )
		m_pFrame = GetSalData()->pFirstFrame_;
    
	m_pVSound = ( !m_aSoundFile.Len() || access( m_aSoundFile.GetBuffer(), R_OK ) ) ? NULL : VSound::createVSound( this );
    
	return m_pVSound ? TRUE : FALSE;
}


BOOL SalSound::Init( SalFrame* pFrame,
					 const BYTE* pSound,
					 ULONG nDataLen,
					 ULONG& rSoundLen )
{
	return FALSE;
}


void SalSound::Play( ULONG nStartTime, ULONG nPlayTime, BOOL bLoop )
{
	SalDbgAssert( "SalSound::Play( %d, %d, %s )\n", nStartTime, nPlayTime, bLoop ? "TRUE" : "FALSE" );
	if( m_bPlaying && m_pVSound )
		m_pVSound->stop();

	m_bLoop			= bLoop;
	m_nStartTime	= nStartTime;
	m_nPlayTime		= nPlayTime;

	if( m_pVSound )
		m_pVSound->play();
}


void SalSound::Stop()
{
	SalDbgAssert( "SalSound::Stop()\n" );
	if( m_bPlaying && m_pVSound )
		m_pVSound->stop();
}


void SalSound::Pause()
{
	if( m_bPlaying && m_pVSound )
		m_pVSound->pause();
}


void SalSound::Continue()
{
	if( m_bPaused && m_pVSound )
		m_pVSound->cont();
}


// --------------------------------------------------

void VSound::initBuffer()
{
	if( stat( m_pSalSound->m_aSoundFile.GetBuffer(), &m_aStat ) )
	{
		SalDbgAssert( "could not stat \"%s\"\n", m_pSalSound->m_aSoundFile.GetBuffer() );
		return;
	}
	int nFile;
	if( ( nFile = ::open( m_pSalSound->m_aSoundFile.GetBuffer(), O_RDONLY ) ) == -1 )
	{
		SalDbgAssert( "could not open %s\n", m_pSalSound->m_aSoundFile.GetBuffer() );
		return;
	}

	m_pBuffer = (char *)mmap( NULL, m_aStat.st_size, PROT_READ, MAP_SHARED, nFile, 0 );
	::close( nFile );
	if( m_pBuffer == MAP_FAILED )
	{
		SalDbgAssert( "could not mmap %s\n", m_pSalSound->m_aSoundFile.GetBuffer() );
		m_pBuffer = NULL;
		return;
	}
}

void VSound::releaseBuffer()
{
	if( m_pBuffer )
	{
		munmap( m_pBuffer, m_aStat.st_size );
		m_pBuffer = NULL;
	}
}


VSound* VSound::createVSound( SalSound* pSalSound )
{
	struct stat aStat;
	if( stat( pSalSound->m_aSoundFile.GetBuffer(), & aStat ) )
		return NULL;

	VSound* pRet = NULL;


	if( ! pSalSound->m_pFrame || pSalSound->m_pFrame->maFrameData.GetDisplay()->IsLocal() )
    {
        #ifdef USE_PASF
        {
            pRet = new PASFSound( pSalSound );
            if( pRet && ! pRet->isValid() )
            {
                delete pRet;
                pRet = NULL;
            }
            else
                SalDbgAssert( "got an PASFSound\n" );
        }
        #endif

        #ifdef USE_OSS
        if( ! pRet )
        {
            pRet = new OSSSound( pSalSound );
            if( pRet && ! pRet->isValid() )
            {
                delete pRet;
                pRet = NULL;
            }
            else
                SalDbgAssert( "got an OSSSound\n" );
        }
        #endif

        #ifdef USE_DEVAUDIO
        if( ! pRet )
        {
            pRet = new DevAudioSound( pSalSound );
            if( pRet && ! pRet->isValid() )
            {
                delete pRet;
                pRet = NULL;
            }
            else
                SalDbgAssert( "got an DevAudioSound\n" );
        }
        #endif
    }
    
	if( ! pRet )
	{
		pRet = new RPTPSound( pSalSound );
		if( pRet && ! pRet->isValid() )
		{
			delete pRet;
			pRet = NULL;
		}
		else
			SalDbgAssert( "got an RPTPSound\n" );
	}

#ifdef USE_NAS
	if( ! pRet )
	{
		pRet = new NASSound( pSalSound );
		if( pRet && ! pRet->isValid() )
		{
			delete pRet;
			pRet = NULL;
		}
		else
			SalDbgAssert( "got an AUSound\n" );
	}
#endif

	return pRet;
}


void SalSound::changeStatePlay()
{
	SalDbgAssert( "SalSound(%p)::changeStatePlay()\n", this );

	m_bPlaying	= TRUE;
	m_bPaused 	= FALSE;

	if( m_aPROC )
		m_aPROC( m_pInst, SOUND_NOTIFY_SUCCESS, SOUNDERR_SUCCESS );
}


void SalSound::changeStateStop()
{
	SalDbgAssert( "SalSound(%p)::changeStateStop()\n", this );

	m_bPlaying	= FALSE;
	m_bPaused 	= FALSE;

	if( m_aPROC )
		m_aPROC( m_pInst, SOUND_NOTIFY_SUCCESS, SOUNDERR_SUCCESS );
}


void SalSound::changeStatePause()
{
	SalDbgAssert( "SalSound(%p)::changeStatePause()\n", this );

	m_bPlaying	= TRUE;
	m_bPaused	= TRUE;

	if( m_aPROC )
		m_aPROC( m_pInst, SOUND_NOTIFY_SUCCESS, SOUNDERR_SUCCESS );
}


void SalSound::changeStateCont()
{
	SalDbgAssert( "SalSound(%p)::changeStateCont()\n", this );

	m_bPlaying	= TRUE;
	m_bPaused	= FALSE;
	if( m_aPROC )
		m_aPROC( m_pInst, SOUND_NOTIFY_SUCCESS, SOUNDERR_SUCCESS );
}


void SalSound::setError( ULONG nError )
{
	if( m_aPROC )
		m_aPROC( m_pInst, SOUND_NOTIFY_ERROR, nError );
}


void SalSound::SetNotifyProc( void* pInst, SALSOUNDPROC pProc )
{
	SalDbgAssert( "SalSound::SetNotifyProc( %p, %p )\n", pInst, pProc );
	m_pInst = pInst;
	m_aPROC = pProc;
}

