/*************************************************************************
 *
 *  $RCSfile: profile.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obr $ $Date: 2001/06/07 13:46:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vos/profile.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
#endif



/////////////////////////////////////////////////////////////////////////////
//
//  class Profile
//

OProfile::OProfile() :
    m_hProfile(0)
{
    
}

OProfile::OProfile(const rtl::OUString& ustrProfileName, TProfileOption Options) :
    m_hProfile(0)
{
    open(ustrProfileName, Options);
}

OProfile::~OProfile()
{
	if (m_hProfile != 0)
		close();
}

sal_Bool OProfile::open(const rtl::OUString& ustrProfileName, TProfileOption Options)
{
	if (m_hProfile != 0)
		close();

	return ((m_hProfile = osl_openProfile(ustrProfileName.pData, 
	                                      (oslProfileOption)Options)) != NULL);
}

void OProfile::close()
{
    if ( m_hProfile != 0 )
    {
        osl_closeProfile(m_hProfile);
        m_hProfile = 0;
    }    
}

sal_Bool OProfile::flush()
{
	return osl_flushProfile(m_hProfile);
}

sal_Bool OProfile::readString(const sal_Char* pszSection, const sal_Char* pszEntry, 
                             sal_Char* pszString, sal_uInt32 MaxLen, 
                             const sal_Char* pszDefault)
{
	return (osl_readProfileString(m_hProfile, pszSection, pszEntry, 
                                  pszString, MaxLen, pszDefault));
}

sal_Bool OProfile::readBool(const sal_Char* pszSection, const sal_Char* pszEntry, 
					       sal_Bool Default)
{
	return (osl_readProfileBool(m_hProfile, pszSection, pszEntry, Default));
}

sal_uInt32 OProfile::readIdent(const sal_Char* pszSection, const sal_Char* pszEntry, 
				 	   sal_uInt32 FirstId, const sal_Char* Strings[],
					   sal_uInt32 Default)
{
	return (osl_readProfileIdent(m_hProfile, pszSection, pszEntry, 
				 	             FirstId, Strings, Default));
}

sal_Bool OProfile::writeString(const sal_Char* pszSection, const sal_Char* pszEntry, 
						const sal_Char* pszString)
{
	return (osl_writeProfileString(m_hProfile, pszSection, pszEntry, pszString));
}

sal_Bool OProfile::writeBool(const sal_Char* pszSection, const sal_Char* pszEntry, 
					        sal_Bool Value)
{
	return (osl_writeProfileBool(m_hProfile, pszSection, pszEntry, Value));
}

sal_Bool OProfile::writeIdent(const sal_Char* pszSection, const sal_Char* pszEntry, 
					         sal_uInt32 FirstId, const sal_Char* Strings[], 
					         sal_uInt32 Value)
{
	return (osl_writeProfileIdent(m_hProfile, pszSection, pszEntry, FirstId, Strings, Value));
}

sal_Bool OProfile::removeEntry(const sal_Char *pszSection, const sal_Char *pszEntry)
{
	return (osl_removeProfileEntry(m_hProfile, pszSection, pszEntry));
}

sal_uInt32 OProfile::getSectionEntries(const sal_Char *pszSection, sal_Char* pszBuffer, sal_uInt32 MaxLen)
{
	return (osl_getProfileSectionEntries(m_hProfile, pszSection, pszBuffer, MaxLen));
}

sal_uInt32 OProfile::getSections(const sal_Char *pszSection, sal_Char* pszBuffer, sal_uInt32 MaxLen)
{
	return (osl_getProfileSections(m_hProfile, pszBuffer, MaxLen));
}

