'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_004c.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:38 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Check the toolbar resources for menuitem Insert - Part 3
'*
'*************************************************************************************************
'*
' #1 C_004C ' Initial routine
' #1 calcFormular
' #1 tControltype
' #1 tControlProperties
' #1 tFormularProperties
' #1 tTabOrder
' #1 tAddfield
'*
'\************************************************************************************************

sub C_004C

Printlog "--------- C_004c ---------"

    call calcFormular
 '   call tControlProperties
 '   call tFormularProperties
 '   call tTabOrder
 '   call tAddfield

end sub
'
'---------------------------------------------------------------------------
'
'---------------------------------------------------------------------------

sub calcFormular

    call tControltype("Pushbutton")
    call tControltype("Radiobutton")
    call tControltype("Checkbox")
    call tControltype("FormattedField")
    call tControltype("Label")
    call tControltype("Edit")
    call tControltype("Listbox")
    call tControltype("Combobox")

end sub
'
'---------------------------------------------------------------------------
'
testcase tControltype(Controltype as string)
    printlog "- " + Controltype
    call hNewDocument
    Kontext "FormControls"
    if Not FormControls.Exists then
        Call hToolbarSelect("CONTROLS", true)
    end if
    sleep(2)

    Kontext "FormControls"
'*FormControls          .HelpId:formcontrols
'SelectObject           .uno:SelectObject
'SwitchControlDesignMode   .uno:SwitchControlDesignMode
'ControlProperties      .uno:ControlProperties
'FormProperties         .uno:FormProperties
'FormDesignTools        .uno:FormDesignTools
'MoreControls           .uno:MoreControls
'UseWizards             .uno:UseWizards

select case Controltype
    case "Pushbutton" : Pushbutton.click
    case "Radiobutton" : RadioButton.click
    case "Checkbox" : Checkbox.click
    case "FormattedField" : FormattedField.click
    case "Label" : Label.click
    case "Edit" : Edit.click
    case "Listbox" : Listbox.click
    case "Combobox" : Combobox.click
    end select

    call subCalcDrawControl(20,20,40,40,Controltype)

    if allnsklor (Controltype,30,30) = true then
        Kontext "DocumentCalc"
        DocumentCalc.Typekeys "<DELETE>"
        call isseswech (Controltype,30,30)
    else
        Warnlog " Ohne Selektion ist nichts mehr testbar"
    end if
'    Kontext "Formsbar"
'    if Formsbar.Exists then Formsbar.Close
    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tControlProperties

    call hNewDocument
    Kontext "Toolbar"
    ShowFormFunctions.TearOff
    Kontext "Formsbar"
    Formsbar.Move 20, 20
    Edit.Click
    call subCalcDrawControl(20,20,40,40,"Edit")
    '**********
    Kontext "Formsbar"
    _ControlEigenschaften.Click    
    Kontext "ControlPropertiesDialog"
    TabControl.SetPage TabGeneralControl
    Kontext "TabGeneralControl"
    printlog "TabGeneralControl"
    Call DialogTest ( TabGeneralControl )
    Kontext "ControlPropertiesDialog"
    try
        TabControl.SetPage TabDataControl
        Kontext "TabDataControl"
        If TabDataControl.Exists then
                Printlog "TabDataControl"
                call Dialogtest ( TabDataControl )
                else
                warnlog "TabDaten existiert auch im try nicht!!!"
        end if
    catch
        Printlog "Keine TabDaten vorhanden!"
    endcatch
    Kontext "ControlPropertiesDialog"
    TabControl.SetPage TabEventsControl
    Kontext "TabEventsControl"
        Printlog "TabEventsControl"
    Call DialogTest ( TabEventsControl )
    Kontext "ControlPropertiesDialog"
    ControlPropertiesDialog.close
    '**********
    Kontext "Formsbar"
    if Formsbar.Exists then Formsbar.Close
    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormularProperties

    call hNewDocument
    Kontext "Toolbar"
    ShowFormFunctions.TearOff
    Kontext "Formsbar"
    Formsbar.Move 20, 20
    Edit.Click
    call subCalcDrawControl(20,20,40,40,"Edit")
    '****
    Printlog "FormatFormular "
    Kontext "Formsbar"
    _FormularEigenschaften.Click
    Kontext "TabGeneralForm"
    TabControl.SetPage TabGeneralForm
    Kontext "TabGeneralForm"
    printlog "TabGeneralForm"
    Call DialogTest ( TabGeneralForm )
    Kontext "FormularProperties"
    TabControl.SetPage TabDataForm
    Kontext "TabDataForm"
    Printlog "TabDataForm"
    call Dialogtest ( TabDataForm )
    Kontext "FormularProperties"
    TabControl.SetPage TabEventsForm
    Kontext "TabEventsForm"
    Printlog "TabEventsForm"
    Call DialogTest ( TabEventsForm )
    Kontext "FormularProperties"
    FormularProperties.close
    '****
    Kontext "Formsbar"
    if Formsbar.Exists then Formsbar.Close
    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tAddfield

    call hNewDocument
    Kontext "Toolbar"
    ShowFormFunctions.TearOff
    Kontext "Formsbar"
    Formsbar.Move 20, 20
    Edit.Click
    call subCalcDrawControl(20,20,40,40,"Edit")
    Kontext "Formsbar"
    FeldHinzufuegen.Click
    Kontext "Feldauswahl"
    Call DialogTest ( FeldAuswahl )
    Feldauswahl.Close
    Kontext "Formsbar"
    if Formsbar.Exists then Formsbar.Close
        call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tTabOrder

    call hNewDocument
    Kontext "Toolbar"
    ShowFormFunctions.TearOff
    Kontext "Formsbar"
    Formsbar.Move 20, 20
    Edit.Click
    call subCalcDrawControl(20,20,40,40,"Edit")
    Kontext "Formsbar"
    _Aktivierungsreihenfolge.Click
    Kontext "Aktivierungsreihenfolge"
    Call DialogTest ( Aktivierungsreihenfolge )
    Aktivierungsreihenfolge.Close
    Kontext "Formsbar"
    if Formsbar.Exists then Formsbar.Close
    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'


