'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_java_upgrade.bas,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/06 12:49:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : Joerg.Skottke@Sun.Com
'*
'*  short description : Collection of all Java related testcases
'*
'\******************************************************************************

sub main

    ' This test collects all testcases from the update and basic branch
    ' that for some reason touch java functionality.
    ' It is intended to be the single test that has to be run each time a
    ' new Java version is introduced into the product.

    use "framework\basic\inc\f_java_load_applets.inc"

    use "framework\update\inc\f_updt_letterwizard.inc"
    use "framework\update\inc\f_updt_agendawizard.inc"
    use "framework\update\inc\f_updt_faxwizard.inc"
    use "framework\update\inc\f_updt_wizard_webpage.inc"
    
    use "framework\basic\inc\f_scripting_addpkg.inc"     '(tDeployScript)
    use "framework\basic\inc\f_scripting_basics.inc"     '(tScripting)
    use "framework\basic\inc\f_scripting_organizers.inc" '(tScriptingOrganizers)
    
    use "framework\tools\inc\pkgmgr_tools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\stringtools.inc"
    use "framework\tools\inc\treelist_tools.inc"
    use "framework\tools\inc\scriptorganizer_tools.inc"
    use "framework\tools\inc\control_objects.inc"
    use "framework\tools\inc\wizards.inc"
    use "framework\tools\inc\template_tools.inc"
    use "framework\tools\inc\key_tools.inc"
    use "framework\tools\inc\javatools.inc"
    
    dim iDialog as integer ' allowed: 1 (BeanShell) and/or 2 (JavaScript)
    dim iApp as integer    ' Numeric expr. for Doc-Type: Writer, Calc, Draw...
    dim cApp as string   
    
    hDeleteUserTemplates()    

    call hStatusIn( "framework" , "f_java_upgrade.bas" )
    
    call tLoadJavaApplets()
    
    call ExitRestartTheOffice()
    
    call tUpdtLetterWizard()
    call tUpdtFaxWizard()
    call tUpdtAgendawizard()
    call tUpdateWizardWebpage()
    
    call ExitRestartTheOffice()

    call tScripting()
    call tDeployScript()
    
    call exitRestartTheOffice
    
    ' cycle through the main applications
    for iApp = 1 to 6
        cApp = hNumericDocType( iApp )
        printlog( "" )
        printlog( iapp & ". " & cApp )
        
        ' 1 = beanshell, 2 = javascript
        for iDialog = 1 to 2
            call tScriptingOrganizers( iDialog )
        next iDialog
    next iApp
    
    hCloseNavigator()
    
    call hStatusOut()
    
    hDeleteUserTemplates()    

end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles

    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication = "WRITER"
    call GetUseFiles()

end sub

