'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_2.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:57 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check macro-dialogs / BASIC-IDE (2. part)
'*
'*******************************************************************************
' **
' #1 tBasic_IDE_Toolbar_Module        ' update-test for Toolbar in Basic-IDE
' #1 tBasic_IDE_Toolbar_Dialogs       ' check macro bar for a new dialog
' #1 tMore_Modules_Dialogs            ' create 10 modules, 10 dialogs, delete all new modules/dialogs and delete the last one
' #1 tDeleteModulesAtRunningBasic     ' try to reproduce #99400
' #0 tWatch_Calls                     ' run a script and have a look at watches and calls
' **
'\******************************************************************************


testcase tBasic_IDE_Toolbar_Module
    '///Work with Toolbar on Basic-IDE
    '///<li>Open a new writer-doc</li>
    printlog "open a new writer-doc"
    gApplication = "Writer"
    Call hNewDocument
    '///create a new module for the new document (named TTModule)
    Call CreateNewModuleForDoc
    printlog "create a new module "
    '///<li> now the basic-IDE is open</li>

    kontext "macrobar"
    '///<li>activate "Compile" on Toolbar</li>
    printlog "- compile"
    Compile.Click
    sleep(1)
    '///<li>activate "Run Basic" on Toolbar</li>
    printlog "- Run Basic"
    BasicRun.Click
    sleep(1)
    '///<li>activate "Step Procedure" on Toolbar</li>
    printlog "- Step Procedure"
    ProcedureStep.Click
    sleep(1)
    '///<li>activate "Stop Basic" on Toolbar</li>
    printlog "- Stop Basic"
    BasicStop.Click
    sleep(1)
    '///<li>activate "Single Step" on Toolbar</li>
    printlog "- Single Step"
    SingleStep.Click
    sleep(1)
    '///<li>activate "Step Back" on Toolbar</li>
    printlog "- Step Back"
    StepBack.Click
    sleep(1)
    '///<li>activate "Breakpoint" on Toolbar</li>
    printlog "- Breakpoint => activate"
    Breakpoint.Click
    sleep(1)
    '///<li>deactivate "Breakpoint" on Toolbar</li>
    printlog "- Breakpoint => deactivate"
    Breakpoint.Click
    sleep(1)
    '///<li>activate "Add Watch" on Toolbar</li>
    printlog "- Add Watch => deactivate"
    AddWatch.Click
    sleep(1)
    '///<li>activate "Object Catalog" on Toolbar => close 'Object'-Dialog</li>
    printlog "- Object Catalog => deactivate"
    ObjectCatalog.Click
    sleep(1)

    kontext "objekte"
    Call DialogTest (Objekte)
    Objekte.Close
    '///<li>activate "Macros" on Toolbar => close 'Macro'-Dialog</li>
    printlog "- Macros"

    kontext "macrobar"
    Macros.Click
    sleep(1)

    kontext "makro"
    Makro.Close
    '///<li>activate "Modules" on Toolbar => close 'Modules'-TabDialog</li>

    kontext "macrobar"
    printlog "- Modules"
    Modules.Click
    sleep(1)

    kontext
    Active.SetPage TabModule
    sleep(1)
    Active.SetPage TabBibliotheken

    kontext "tabbibliotheken"
    TabBibliotheken.Close
    '///<li>activate "Find Paranthese" on Toolbar</li>
    printlog "- Find Paranthese"

    kontext "macrobar"
    FindParanthese.Click
    sleep(1)
    '///<li>"Controls" should be disabled when a module is open</li>
    printlog "- 'controls'-button must be disabled for modules"

    try
        Controls.TearOff
        warnlog "Controls are active in a module window => bug!"
    catch
    endcatch

    sleep(1)
    printlog "- Insert Source Text ([TesttoolPath]\framework\basic\input\resetregistration.bas)"
    '///<li>activate "Insert Source Text" on Toolbar</li>
    '///<li>- insert [TesttoolPath]\framework\update\input\basic\resetregistration.bas</li>
    InsertSourceText.Click
    sleep(1)

    kontext "oeffnendlg"
    Dateiname.SetText ConvertPath (gTesttoolpath + "framework\basic\input\resetregistration.bas")
    Oeffnen.CLick
    sleep(1)

    ' possible 'could not read from file' error-message -> this is a bug"
    kontext "Active"
    if ( Active.exists() ) then
        warnlog( "Unexpected active: " & active.gettext() )
        active.ok()
    endif    
    

    kontext "macrobar"
    printlog "- Save Source Test "
    '///<li>activate "Save Source Test" on Toolbar</li>
    '///<li>- save it as bas-file</li>
    SaveSourceTest.Click
    sleep(1)

    kontext "speicherndlg"
    Dateiname.SetText ConvertPath (gOfficepath + "user\work\global_test.bas")
    Speichern.CLick
    sleep(1)

    kontext "active"
    if Active.Exists then
        Active.Yes
    endif
    sleep(1)
    '///<li>file/close for Basic-IDE and Document</li></ul>
    Call hCloseDocument   ' for Basic-IDE
    Call hCloseDocument   ' the new writer-doc
endcase

'*******************************************************************************

testcase tBasic_IDE_Toolbar_Dialogs

    dim bIsOpen as boolean

    '///work with Toolbar on Basic-IDE
    '///<li>open a new writer-doc</li>
    printlog "open a new writer-doc"
    gApplication = "WRITER"
    Call hNewDocument
    '///<li>create a new module for the new document (named TTModule)</li>
    printlog "create a new module "
    Call CreateNewModuleForDoc
    '///<li>create a new dialog in BasicIDE</li>

    kontext "basicide"
    Tabbar.OpenContextMenu
    hMenuSelectNr (1)
    sleep(1)
    hMenuSelectNr (2)
    sleep(2)

    if DialogWindow.Exists (2) <> TRUE then
        warnlog "No dialog window is shown!"
    end if

    '///<li>=> now the basic-IDE is open</li>

    kontext "macrobar"
    '///<li>"Compile" (disabled)</li>
    printlog "- compile (disabled)"

    try
        Compile.Click
        warnlog "Compile : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Run Basic" (disabled)</li>
    printlog "- Run Basic (disabled)"

    try
        BasicRun.Click
        warnlog "Run : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Step Procedure" (disabled)</li>
    printlog "- Step Procedure (disabled)"

    try
        ProcedureStep.Click
        warnlog "Step Procedure : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Stop Basic" (disabled)</li>
    printlog "- Stop Basic (disabled)"

    try
        BasicStop.Click
        warnlog "Stop Basic : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Single Step" (disabled)</li>
    printlog "- Single Step (disabled)"

    try
        SingleStep.Click
        warnlog "Single Step : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Step Back" (disabled)</li>
    printlog "- Step Back (disabled)"

    try
        StepBack.Click
        warnlog "Single Step : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Breakpoint" (disabled)</li>
    printlog "- Breakpoint  (disabled)"

    try
        Breakpoint.Click
        warnlog "Breakpoint : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Add Watch" (disabled)</li>
    printlog "- Add Watch  (disabled)"

    try
        AddWatch.Click
        warnlog "Add Watch : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>activate "Object Catalog" on Toolbar => close 'Object'-Dialog</li>
    printlog "- Object Catalog => deactivate"
    ObjectCatalog.Click
    sleep(1)

    kontext "objekte"
    Call DialogTest (Objekte)
    Objekte.Close
    '///<li>activate "Macros" on Toolbar => close 'Macro'-Dialog</li>
    printlog "- Macros"

    kontext "macrobar"
    Macros.Click
    sleep(1)

    kontext "makro"
    Makro.Close
    '///<li>activate "Modules" on Toolbar => close 'Modules'-TabDialog</li>
    printlog "- Modules"

    kontext "macrobar"
    Modules.Click
    sleep(1)

    kontext
    Active.SetPage TabModule
    sleep(1)
    Active.SetPage TabBibliotheken

    kontext "tabbibliotheken"
    TabBibliotheken.Close

    kontext "macrobar"
    printlog "- Find Paranthese (disabled)"
    '///<li>"Find Paranthese" (disabled)</li>

    try
        FindParanthese.Click
        warnlog "Find Paranthese : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>tear off controls</li>

    bIsOpen = hShowMacroControls()
    if ( bIsOpen ) then
        ToolsCollectionBar.Close
    end if

    sleep(1)

    kontext "macrobar"
    printlog "- Insert Source Text  (disabled))"
    '///<li>"Insert Source Text" (disabled)</li>

    try
        InsertSourceText.Click
        warnlog "Insert Source Text : is not disabled"
        sleep(1)

        kontext "oeffnendlg"
        Dateiname.SetText ConvertPath (gTesttoolpath + "framework\basic\input\resetregistration.bas")
        Oeffnen.Click
    catch
    endcatch

    sleep(1)

    kontext "macrobar"
    printlog "- Save Source Test  (disabled)"
    '///<li>"Save Source Text" (disabled)</li>
    '///<li>save it as bas-file</li>

    try
        SaveSourceTest.Click
        warnlog "Save Source Text : is not disabled"
        sleep(1)

        kontext "speicherndlg"
        Dateiname.SetText ConvertPath (gOfficepath + "user\work\global_test.bas")
        Speichern.Click
        sleep(1)

        kontext "active"
        if Active.Exists then
            Active.Yes
        endif
        sleep(1)
    catch
    endcatch

    '///<li>file/close for Basic-IDE and Document</li></ul>
    Call hCloseDocument   ' for Basic-IDE
    Call hCloseDocument   ' the new writer-doc
endcase

'*******************************************************************************

testcase tMore_Modules_Dialogs
    Dim i as Integer
    'const icTen is the number of dialogs and modules.
    'If icTen = 10 then 20 tabs (+ the first one!) = 21 should be created.
    const icTen as Integer = 10
    '///<h2>Work with macros - create multiple modules</h2>
    '///<li>Create a new Writer document.</li>
    printlog "open a new writer-doc"
    gApplication = "WRITER"
    Call hNewDocument
    '///<li>Create a new module for the new document (named TTModule)</li>
    printlog "create a new module "
    Call CreateNewModuleForDoc
    '///<li>Insert 10 modules.</li>
    printlog "insert 10 modules"

    for i=1 to icTen
        printlog "   - insert new module : " & i

        kontext "basicide"
        Tabbar.OpenContextMenu
        hMenuSelectNr(1)
        sleep(1)
        hMenuSelectNr(1)
        sleep(2)
        EditWindow.TypeKeys "<Up>", 20
        EditWindow.TypeKeys "<Mod1 a>"
        EditWindow.TypeKeys "<Delete>"
        EditWindow.TypeKeys "'# " & (i+1) & ". module in this document"
    next i

    '///<li>Insert 10 dialogs</li>
    printlog "insert 10 dialogs"

    for i=1 to icTen
        printlog "   - insert new dialog : " & i
        Tabbar.OpenContextMenu
        hMenuSelectNr(1)
        sleep(1)
        hMenuSelectNr (2)
        sleep(2)

        if DialogWindow.Exists (2) <> TRUE then
            warnlog "No dialog window is shown!"
        end if

    next i

    '///<li>Close the BasicIDE.</li>
    printlog Chr(13) + "- close the BasicIDE"
    Call hCloseDocument
    '///<li>Save the document.</li>
    printlog Chr(13) + "- save the document"
    Call hSpeichernUnterKill(gOfficePath & "user\work\basic" & hGetSuffix() )
    '///<li>Close the document</li>
    printlog Chr(13) + "- close the document"
    Call hCloseDocument
    '///<li>Open the saved document</li>
    printlog Chr(13) + "- open the saved document"
    Call hDateiOeffnen (gOfficePath + "user\work\basic" & hGetSuffix() , TRUE)
    ' new security dialog for scripting
    printlog( "- accept to run macro" )

    kontext "SecurityWarning"
    if SecurityWarning.Exists() then
        SecurityWarning.OK
    endif
    sleep( 1 )
    
    
    Call SelectTheLastModule (TRUE, FALSE)
    '///<li>Select the last module and open the BASIC IDE.</li>
    Bearbeiten.Click
    '///<li>Delete all modules dialogs.</li></ul>
    printlog "delete all modules and dialogs"

    for i=1 to ((2 * icTen)+1)

        try
            printlog "delete  - " & i & "/" & ((2 * icTen)+1)
            UseBindings

            kontext "basicide"
            Tabbar.OpenContextMenu
            sleep(2)
            hMenuSelectNr(2)
            sleep(1)

            kontext "active"

            if Active.Exists then
                Active.Yes
            else
                warnlog "No warning after deleting a dialog!"
            end if

        catch
            QAErrorLog "Deleting  - " & i & "/" & ((2 * icTen)+1) & " failed."
        endcatch

    next i

    Call hCloseDocument
    Call hCloseDocument
endcase

'*******************************************************************************

testcase tDeleteModulesAtRunningBasic
    Dim i as Integer
    Dim iSel as Integer
    '///<h2>Work with macros - delete Modules while BASIC-IDE is running</h2>
    '///<ul><li>open a new writer-doc</li>
    printlog "open a new writer-doc"
    gApplication = "Writer"
    Call hNewDocument
    '///<li>create a new module for the new document (named TTModule)</li>
    printlog "create a new module "
    Call CreateNewModuleForDoc
    '///<li>insert a short script (1. page)</li>
    printlog "insert a short script (1. page)"

    kontext "basicide"
    EditWindow.TypeKeys "<Mod1 a>"
    EditWindow.TypeKeys "<Delete>"
    EditWindow.TypeKeys "'# This is a short testscript for automated testing!<return><return>"
    EditWindow.TypeKeys "sub main<return><return>"
    EditWindow.TypeKeys "print " + Chr (34) + "hallo" + Chr (34) + "<Return><Return>"
    EditWindow.TypeKeys "<Home>end sub<return>"

    kontext "macrobar"
    printlog "- Click button:  Step Procedure"
    '///<li>activate "Step Procedure" on Toolbar</li>
    ProcedureStep.Click
    sleep(3)
    '///<li>check if disabled menu-items are shown and delete is not shown</li>

    kontext "basicide"
    printlog "check if disabled menu items are shown in context menu and 'delete' is not shown"
    Tabbar.OpenContextMenu

    try

        if hMenuItemGetCount = 5 then
            warnlog "Disabled entries are shown in context menu on tab bar => bugID 101972"
        end if


        if hMenuItemGetCount = 3 then
            warnlog "Delete is active in context menu for a running macro => BUG!"
        end if

    catch
        warnlog "Unable to retrieve the number of menuitems"
    endcatch

    hMenuClose
    '///<li>stop the running script</li>
    printlog "Stop the running script"

    kontext "macrobar"
    BasicStop.Click
    sleep(1)
    '///<li>close the BasicIDE and the document</li></ul>
    printlog "close the documents"
    Call hCloseDocument
    Call hCloseDocument
endcase

'*******************************************************************************

testcase tWatch_Calls
    Dim i as Integer
    Dim iCut as Integer
    Dim sTemp as String
    '///<h2>run a short script and have a look at watches and calls</h2>
    '///<ul><li>open a new writer-doc</li>
    printlog "open a new writer-doc"
    gApplication = "Writer"
    Call hNewDocument
    '///<li>create a new module for the new document (named TTModule)</li>
    printlog "create a new module "
    Call CreateNewModuleForDoc
    '///<li>insert a short script
    '///+(with 'sub main' which calls another sub-routine, and a for-next-loop)</li>
    printlog "insert a short script (with 'sub main' which calls another sub-routine)"

    kontext "basicide"
    EditWindow.TypeKeys "<Mod1 a>"
    EditWindow.TypeKeys "<Delete>"
    EditWindow.TypeKeys "'# This is a short testscript for automated testing!<return><return>"
    EditWindow.TypeKeys "sub main<return><return>"
    EditWindow.TypeKeys "call PrintHello<return><return>"
    EditWindow.TypeKeys "<Home>end sub<return><return><return>"
    EditWindow.TypeKeys "sub PrintHello<Return>"
    EditWindow.TypeKeys "dim i as Integer<Return><Return>"
    EditWindow.TypeKeys "for i=1 to 10<Return>"
    EditWindow.TypeKeys "if i=5 OR i=10 then<Return>"
    EditWindow.TypeKeys "print " + Chr (34) + "hallo" + Chr (34) + "<Return>"
    EditWindow.TypeKeys "end if<Return>"
    EditWindow.TypeKeys "next i<Return>"
    EditWindow.TypeKeys "<Home>end sub<Return>"
    '///<li>insert a breakpoint</li>
    printlog "insert a breakpoint in the for-next loop"

    for i=20 to 50
        EditWindow.MouseDoubleClick (1, 2*i)

        try
            EditCopy
        catch
            SetClipboard ("")
        endcatch


        if lcase (GetClipboardText) = "if" then
            BreakPointsWindow.MouseDoubleClick (50, 2*i)
            i=50
        end if

    next i

    '///<li>add 2 variables to watch (1. a unused and undefined variable / 2. the variable of the counter for for-next-loop)</li>
    printlog "add 2 variables to watch (1. a unused and undefined variable / 2. the variable of the counter for for-next-loop)"

    kontext "basicide"
    WatchEdit.TypeKeys("hello<Return>", TRUE)
    WatchEdit.TypeKeys("i<Return>", TRUE)
    WatchList.Select(1)

    if WatchList.GetSelText() <> "hello = " then
        warnlog("Watch entry mismatch:")
        printlog("Should be: 'hello = '")
        printlog("Is.......: '" + WatchList.getSelText() + "'")
    end if

    WatchList.Select(2)

    if WatchList.GetSelText() <> "i = " then
        warnlog("Watch entry mismatch:")
        printlog("Should be: 'i = '")
        printlog("Is.......: '" + WatchList.getSelText() + "'")
    end if

    '///<li>start the script (click on run on the object bar)</li>
    printlog "start the script"

    kontext "macrobar"
    BasicRun.Click()
    sleep(1)
    '///<li>check the variables in watch-window
    '///+ - the unused and undefined variable must have an error/undefined message (will be checked for each language)</li>
    printlog "check te variables in watch"
    printlog "    1. unused and undefinded variable 'hello' must have an error/undefined message"

    kontext "basicide"
    WatchList.Select(1)
    sTemp = WatchList.GetSelText()
    iCut = Instr (sTemp, "hello =")

    if iCut = 0 then
        Warnlog "1. watch is not 'hello'!"
    else

        if Instr (sTemp, "<") = 0 or Instr (sTemp, ">") = 0 then
            Warnlog "no correct error-message for the unused variable 'hello'"
        else
            'printlog "      comparison of the message"
            'nobody knows what the following stement does.
            'hAppendCompareLanguageEntryToList (gTesttoolPath + "framework\basic\input\watch_err.txt", Mid (sTemp, iCut, Len (sTemp)-iCut))
        end if

    end if

    '///<li> - the 2. variable must be '1' (first run in the for-next-loop)</li></ul>
    printlog "    2. variable 'i' must be '1' for the first loop!"
    WatchList.Select(2)
    sTemp = WatchList.GetSelText()
    iCut = Instr (sTemp, "i =")

    if iCut = 0 then
        warnlog "2. watch is not 'i'!"
    else
        if Right (sTemp, 1) <> "1" then
            Warnlog "'i' is not '= 1'!"
        endif
    end if

    '///<b>check the variables in watch-window</b>
    '///<ul><li>- first entry must be 'PrintHello'</li>
    '///<li>- second entry must be 'Main'</li></ul>
    printlog "check the Calls"
    CallsList.Select(1)

    if CallsList.GetSelText <> " 0: PrintHello" then
        warnlog "The first call must be ' 0: PrintHello' but it is '" + CallsList.GetSelText + "'"
    end if

    CallsList.Select(2)

    if CallsList.GetSelText() <> " 1: Main" then
        warnlog "The second call must be ' 1: Main' but it is '" + CallsList.GetSelText + "'"
    end if

    '///<b>check the variables in watch-window for the next runs</b>
    '///<ul><li>click on run in object toolbar (4 times)</li>
    printlog "click on run in object toolbar (4 times)"

    kontext "macrobar"

    for i=1 to 4
        BasicRun.Click()
        sleep(1)
    next i

    '///<li> - the 2. variable must be '5'</li>
    printlog "    2. variable 'i' must be '5'"

    kontext "basicide"
    WatchList.Select(2)
    sTemp = WatchList.GetSelText()
    iCut = Instr (sTemp, "i =")

    if iCut = 0 then
        warnlog "2. watch is not 'i'!"
    else
        if Right (sTemp, 1) <> "5" then
            Warnlog "'i' is not '= 1'!"
        endif
    end if

    '///<li> - break the test, if you click on run in toolbar and cancel the print-box</li>
    printlog "    break the test, if you click on run in toolbar and cancel the print-box"

    kontext "macrobar"
    BasicRun.Click

    kontext "messagebox"

    if MessageBox.Exists() then
        MessageBox.cancel()
        sleep(1)

        kontext "messagebox"
        MessageBox.OK()
    else
        warnlog "The print-command does not call a messagebox => Bug!"

        kontext "macrobar"
        BasicStop.Click()
    end if

    '///<li>close the open BasicIDE and the new document</li></ul>
    printlog "close the open BasicIDE and the new document"
    Call hCloseDocument
    Call hCloseDocument
endcase

