'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg3.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'************************************************************************
'**
' #1  tFileSpecialLoad             ' load non existed files, load file from readonly directory and file out of no entry directory
' #1  tFileSpecialSave   'wrn:1    ' save a file in a non-existed dir, save a file in a dir without any rights for the user
'**
'\***************************************************************************

testcase tFileSpecialLoad

   ' This test tries to load files with special attributes to the directories
   ' or the files themselves
   ' 1. Load a file that does not exist 
   ' 2. Load a file from an unaccessible directory
   ' 3. Load a file from a read-only directory (not the files!)

   dim NONEXISTINGFILE as String
   NONEXISTINGFILE = gTesttoolPath + "framework\filedlg\input\nonexist.sxw"
       
   dim UNACCESSIBLEFILE as String
   UNACCESSIBLEFILE = gTesttoolPath + "framework\filedlg\input\noentry\dead.sxw"

   dim READONLYFILE as String
   READONLYFILE = gTesttoolPath + "framework\filedlg\input\readentry\fdlg.sxw"
   
   printlog( "Test: Try to load a file that does not exist" )
   
   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   
   '///try to load a non-existing file
   FileOpen
   
   Kontext "Active"
   if Active.Exists() then
      warnlog( "An unexpected messagebox came up and will be closed" )
      printlog( "Text: " + Active.getText() )
      Active.OK()
   endif
   
   '///+open [TesttoolPath]\input\desktop\filedlg\nonexist.sxw
   printlog( " - Try to open a non-existing file" )
   Kontext "OeffnenDlg"
   Dateiname.SetText ( convertpath( NONEXISTINGFILE ))
   Oeffnen.Click()
   Sleep (2)

   printlog( " - Handle the (expected) errormessage" )
   Kontext "Active"
   if Active.Exists(2) then
      Active.OK
      Sleep (1)
   else
      Warnlog "No warning for non existing file! Bugid #104869#"
   end if
    
   printlog( " - check for second errormessage" )
   Kontext "Active"
   if Active.Exists(2) then
      Warnlog "A second messagebox is active"
      printlog( "This might be a testtool issue, please check manually" )
      Active.OK
   end if

   '///+- after the error message the file-dialog must be opened
   printlog( " - ckeck for (unexpected) filter-dialog" )
   Kontext "Filterauswahl"
   If FilterAuswahl.Exists then
      Warnlog "Filterbox is also active!"
      FilterAuswahl.Cancel
   end if
   
   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument
   
   printlog( "Test: Load a file file that is not accessible by permissions" )

   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   
   '///try to load file out of directory, with no right to enter ( 700 for root )
   printlog "- load a file out of directory, with no right to enter ( 700 for root )"
   Kontext "OeffnenDlg"

   '///+open [TesttoolPath]\input\desktop\filedlg\noentry\fdlg.sxw
   Dateiname.SetText ( convertpath( UNACCESSIBLEFILE ))
   Oeffnen.Click
   Sleep (2)

   '///+close the "unable to open ..." dialog
   printlog( " - handle the (expected) 'unable to open...' dialog" )
   Kontext "Active"
   if Active.Exists(2) then
      Active.OK()
      Sleep (1)
   else
      Warnlog "No warning for non existing file! Bugid #104869#"
      ' hCloseDocument() crash if filedialog is open !!!!
   end if

   printlog( " - check for a second errormessage" ) 
   Kontext "Active"
   if Active.Exists(2) then
      Warnlog ( "A second messagebox is active" )
      printlog( "This might be a testtool issue, please check manually" )      
      Active.OK()
      end if

   printlog( " - check for (unexpected) filter-dialog" )
   Kontext "Filterauswahl"
   If FilterAuswahl.Exists then
      Warnlog "Filterbox is also active!"
      FilterAuswahl.Cancel()
      end if

   '///+- after the error message the file-dialog must be opened
   Kontext "OeffnenDlg"
   if OeffnenDlg.Exists() then
      printlog( " - closing File-Open dialog" )
      OeffnenDlg.cancel()
      endif
   
   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument
   
   printlog( "Test: Load a file from a read-only directory" )
   
   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   
   printlog( " - Open the file-open dialog" )
   FileOpen
   
   '///try to load files out of read only directories
   printlog " - load a file out of a read only directory"
   Kontext "OeffnenDlg"
   if ( OeffnenDlg.exists = FALSE ) then
      FileOpen
      Kontext "OeffnenDlg"
      endif
      
   Sleep (2)

   '///+open [TesttoolPath]\filedlg\input\readentry\fdlg.sxw
   Dateiname.SetText ( ConvertPath ( READONLYFILE ) )
   Oeffnen.Click()

   printlog( " - check for (unexpected) file-open error" )
   
   Kontext "Active"
   
   if Active.Exists(2) then
   
      Warnlog "File can't be opened! The error was :"
      printlog Active.GetText()
      Active.OK()
      Sleep (1)
      
      if Active.Exists( 2 ) then
         Warnlog "A second messagebox is active"
         printlog( "This might be a testtool issue, please check manually" )
         Active.OK()
      end if

      printlog( " - check for (unexpected) filter-dialog" )
      Kontext "Filterauswahl"
      
      If FilterAuswahl.Exists() then
         Warnlog( "Filterbox is active, this is not expected" )
         FilterAuswahl.Cancel()
      end if
      
   else
   
      Kontext "OeffnenDlg"
      
      if OeffnenDlg.Exists() then
         printlog( " - close the file-open dialog" )
         OeffnenDlg.cancel()
      endif
      
   end if

   '///+Close the documents
   printlog( "Close the documents" )
   hCloseDocument
   hCloseDocument

endcase

'*******************************************************************************

testcase tFileSpecialSave

   ' This test tries to save files with special attributes to the directories
   ' or the files themselves
   ' 1. Save a file to a directory that does not exist 
   ' 2. Save a file to an unaccessible directory
   ' 3. Load a file from a read-only directory (not the file!)

   const TGT_NOEXIST as String = "framework\filedlg\output\noexists\fdlg.sxw"
   const TGT_NORIGHT as String = "framework\filedlg\input\noentry\fdlg.sxw"
   const TGT_WORKDIR as String = "framework\filedlg\input\readentry\fdlg.sxw"

   '///try to save a file in a non-existed directory
   printlog "Test: Save a file in a non-existing directory (writer only)"

   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   
   '///+file/save as
   printlog( " - Open the file-save dialog" )
   FileSaveAs
   
   '///+save it as [TesttoolPath]\output\desktop\filedlg\noexists\fdlg.sxw
   printlog( " - name the file and try to save it" )
   Kontext "SpeichernDlg"
   Dateiname.SetText ( ConvertPath ( gTesttoolPath + TGT_NOEXIST ) )
   Speichern.Click()

   printlog( " - handle the (expected) errormessage" )
   Kontext "Active"
   If Active.Exists then
      Active.OK()
   else
      Warnlog "No error-message at saving"
   end if
   
   Kontext "SpeichernDlg"
   SpeichernDlg.Cancel()

   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument

   printlog "Test: save a file in a directory with no rights ( 700 for root ) "

   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   
   '///try to save a file in a directory with no rights ( 700 for root )
   '///+normaly the save-dialog must be opened, but if not => file/save as
   printlog( " - open the file-save dialog" )
   FileSaveAs
   
   Kontext "Active"
   if Active.Exists() then
      warnlog( "There is an unexpected 'Active' dialog" )
      printlog( "Text: " + Active.getText())
      Active.OK()
   endif

   '///+save it as [TesttoolPath]\input\desktop\filedlg\noentry\fdlg.sxw
   printlog( " - name the file and try to save it" )
   Kontext "SpeichernDlg"
   If SpeichernDlg.Exists(2) = FALSE then FileSaveAs
   Dateiname.SetText( ConvertPath ( gTesttoolPath + TGT_NORIGHT ) )
   Speichern.Click()

   ' A warning is expected, that the file cannot be saved. If an overwrite-
   ' warning is shown, this usually means you are running on a local work-
   ' space
   Kontext "Active"
   if Active.Exists() then
      printlog( "Text: " + Active.getText())
      try
         Active.Ok()
      catch
         warnlog( "Probably this is an overwrite warning." )
         printlog( "Are you testing in a local environment?" )
         Active.Yes()
      endcatch
   endif

   Kontext "SpeichernDlg"
   If SpeichernDlg.Exists() then SpeichernDlg.Cancel()

   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument
   
   printlog( "Test: Check for changed default-directory" )
   
   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   
   '///Check if File/open has changed the default-directory 
   ' although the saving-process is broken ( an old bug )
   printlog( " - Check if File/open has changed the default-directory," ) 
   printlog( "   although the saving-process is broken" )
   FileOpen

   Kontext "Active"
   If Active.Exists(2) then
      Warnlog( "   The default-dir was changed #93187#" )
      Active.OK()
   end if

   printlog( " - Change the default-dir to a normal working-dir " )
   printlog( "   without warning at file/open" )

   printlog( " - Continue working with the file-open dialog" )
   Kontext "OeffnenDlg"
   Dateiname.SetText( ConvertPath ( gTesttoolPath + TGT_WORKDIR ) )
   Oeffnen.Click()
   Sleep (4)
   
   Kontext "Active"
   if Active.Exists() then
      warnlog( "Unexpected errormessage before closing document" )
      printlog( "Text: " + Active.getText() )
      Active.OK()
   endif

   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument

endcase

